untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFiqY6P4gNyOKaLM0f8KDTwyF0GLHvJBrhoWHnRjF62Uzzg3BuveY7t7XHMcOCrOswwEmOxGPlvQIwQEh/pD+kQc=

OpenBSD 7.3 errata 004, May 26, 2023:

A double free or use after free could occur after SSL_clear(3).

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub -x 004_ssl.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libssl:
    cd /usr/src/lib/libssl
    make obj
    make
    make install

Index: lib/libssl/s3_lib.c
===================================================================
RCS file: /cvs/src/lib/libssl/s3_lib.c,v
diff -u -p -r1.242 s3_lib.c
--- lib/libssl/s3_lib.c	26 Nov 2022 16:08:55 -0000	1.242
+++ lib/libssl/s3_lib.c	15 May 2023 04:49:41 -0000
@@ -1580,6 +1580,7 @@ ssl3_free(SSL *s)
 
 	sk_X509_NAME_pop_free(s->s3->hs.tls12.ca_names, X509_NAME_free);
 	sk_X509_pop_free(s->verified_chain, X509_free);
+	s->verified_chain = NULL;
 
 	tls1_transcript_free(s);
 	tls1_transcript_hash_free(s);
