untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24OXlWSG55Axw0ZdrnX3vPt3YQMUOZoREU1eFNiqxDlG1V8vzIotBB9rHO4sshFtyg1+TrciRxXVKRKOaQUbm4Q8=

OpenBSD 6.6 errata 023, March 13, 2020:

Local outbound UDP broadcast or multicast packets sent by a spliced
socket can crash the kernel.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 023_sosplice.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/uipc_socket.c
===================================================================
RCS file: /cvs/src/sys/kern/uipc_socket.c,v
retrieving revision 1.234
diff -u -p -r1.234 uipc_socket.c
--- sys/kern/uipc_socket.c	22 Jul 2019 15:34:07 -0000	1.234
+++ sys/kern/uipc_socket.c	11 Mar 2020 23:28:10 -0000
@@ -1404,9 +1404,15 @@ somove(struct socket *so, int wait)
 	/*
 	 * By splicing sockets connected to localhost, userland might create a
 	 * loop.  Dissolve splicing with error if loop is detected by counter.
+	 *
+	 * If we deal with looped broadcast/multicast packet we bail out with
+	 * no error to suppress splice termination.
 	 */
-	if ((m->m_flags & M_PKTHDR) && m->m_pkthdr.ph_loopcnt++ >= M_MAXLOOP) {
-		error = ELOOP;
+	if ((m->m_flags & M_PKTHDR) &&
+	    ((m->m_pkthdr.ph_loopcnt++ >= M_MAXLOOP) ||
+	    ((m->m_flags & M_LOOP) && (m->m_flags & (M_BCAST|M_MCAST))))) {
+		if (m->m_pkthdr.ph_loopcnt >= M_MAXLOOP)
+			error = ELOOP;
 		goto release;
 	}
 
