"""Generated client library for storagetransfer version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.storagetransfer.v1 import storagetransfer_v1_messages as messages


class StoragetransferV1(base_api.BaseApiClient):
  """Generated client library for service storagetransfer version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://storagetransfer.googleapis.com/'
  MTLS_BASE_URL = 'https://storagetransfer.mtls.googleapis.com/'

  _PACKAGE = 'storagetransfer'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'StoragetransferV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new storagetransfer handle."""
    url = url or self.BASE_URL
    super(StoragetransferV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.googleServiceAccounts = self.GoogleServiceAccountsService(self)
    self.projects_agentPools = self.ProjectsAgentPoolsService(self)
    self.projects = self.ProjectsService(self)
    self.transferJobs = self.TransferJobsService(self)
    self.transferOperations = self.TransferOperationsService(self)

  class GoogleServiceAccountsService(base_api.BaseApiService):
    """Service class for the googleServiceAccounts resource."""

    _NAME = 'googleServiceAccounts'

    def __init__(self, client):
      super(StoragetransferV1.GoogleServiceAccountsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Returns the Google service account that is used by Storage Transfer Service to access buckets in the project where transfers run or in other projects. Each Google service account is associated with one Google Cloud project. Users should add this service account to the Google Cloud Storage bucket ACLs to grant access to Storage Transfer Service. This service account is created and owned by Storage Transfer Service and can only be used by Storage Transfer Service.

      Args:
        request: (StoragetransferGoogleServiceAccountsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GoogleServiceAccount) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storagetransfer.googleServiceAccounts.get',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=[],
        relative_path='v1/googleServiceAccounts/{projectId}',
        request_field='',
        request_type_name='StoragetransferGoogleServiceAccountsGetRequest',
        response_type_name='GoogleServiceAccount',
        supports_download=False,
    )

  class ProjectsAgentPoolsService(base_api.BaseApiService):
    """Service class for the projects_agentPools resource."""

    _NAME = 'projects_agentPools'

    def __init__(self, client):
      super(StoragetransferV1.ProjectsAgentPoolsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an agent pool resource.

      Args:
        request: (StoragetransferProjectsAgentPoolsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AgentPool) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/agentPools',
        http_method='POST',
        method_id='storagetransfer.projects.agentPools.create',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=['agentPoolId'],
        relative_path='v1/projects/{+projectId}/agentPools',
        request_field='agentPool',
        request_type_name='StoragetransferProjectsAgentPoolsCreateRequest',
        response_type_name='AgentPool',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an agent pool.

      Args:
        request: (StoragetransferProjectsAgentPoolsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/agentPools/{agentPoolsId}',
        http_method='DELETE',
        method_id='storagetransfer.projects.agentPools.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='StoragetransferProjectsAgentPoolsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an agent pool.

      Args:
        request: (StoragetransferProjectsAgentPoolsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AgentPool) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/agentPools/{agentPoolsId}',
        http_method='GET',
        method_id='storagetransfer.projects.agentPools.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='StoragetransferProjectsAgentPoolsGetRequest',
        response_type_name='AgentPool',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists agent pools.

      Args:
        request: (StoragetransferProjectsAgentPoolsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAgentPoolsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/agentPools',
        http_method='GET',
        method_id='storagetransfer.projects.agentPools.list',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/projects/{+projectId}/agentPools',
        request_field='',
        request_type_name='StoragetransferProjectsAgentPoolsListRequest',
        response_type_name='ListAgentPoolsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing agent pool resource.

      Args:
        request: (StoragetransferProjectsAgentPoolsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AgentPool) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/agentPools/{agentPoolsId}',
        http_method='PATCH',
        method_id='storagetransfer.projects.agentPools.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='agentPool',
        request_type_name='StoragetransferProjectsAgentPoolsPatchRequest',
        response_type_name='AgentPool',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(StoragetransferV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class TransferJobsService(base_api.BaseApiService):
    """Service class for the transferJobs resource."""

    _NAME = 'transferJobs'

    def __init__(self, client):
      super(StoragetransferV1.TransferJobsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a transfer job that runs periodically.

      Args:
        request: (TransferJob) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferJob) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='storagetransfer.transferJobs.create',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v1/transferJobs',
        request_field='<request>',
        request_type_name='TransferJob',
        response_type_name='TransferJob',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a transfer job. Deleting a transfer job sets its status to DELETED.

      Args:
        request: (StoragetransferTransferJobsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/transferJobs/{transferJobsId}',
        http_method='DELETE',
        method_id='storagetransfer.transferJobs.delete',
        ordered_params=['jobName', 'projectId'],
        path_params=['jobName'],
        query_params=['projectId'],
        relative_path='v1/{+jobName}',
        request_field='',
        request_type_name='StoragetransferTransferJobsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a transfer job.

      Args:
        request: (StoragetransferTransferJobsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferJob) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/transferJobs/{transferJobsId}',
        http_method='GET',
        method_id='storagetransfer.transferJobs.get',
        ordered_params=['jobName', 'projectId'],
        path_params=['jobName'],
        query_params=['projectId'],
        relative_path='v1/{+jobName}',
        request_field='',
        request_type_name='StoragetransferTransferJobsGetRequest',
        response_type_name='TransferJob',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists transfer jobs.

      Args:
        request: (StoragetransferTransferJobsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTransferJobsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storagetransfer.transferJobs.list',
        ordered_params=['filter'],
        path_params=[],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/transferJobs',
        request_field='',
        request_type_name='StoragetransferTransferJobsListRequest',
        response_type_name='ListTransferJobsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a transfer job. Updating a job's transfer spec does not affect transfer operations that are running already. **Note:** The job's status field can be modified using this RPC (for example, to set a job's status to DELETED, DISABLED, or ENABLED).

      Args:
        request: (StoragetransferTransferJobsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TransferJob) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/transferJobs/{transferJobsId}',
        http_method='PATCH',
        method_id='storagetransfer.transferJobs.patch',
        ordered_params=['jobName'],
        path_params=['jobName'],
        query_params=[],
        relative_path='v1/{+jobName}',
        request_field='updateTransferJobRequest',
        request_type_name='StoragetransferTransferJobsPatchRequest',
        response_type_name='TransferJob',
        supports_download=False,
    )

    def Run(self, request, global_params=None):
      r"""Starts a new operation for the specified transfer job. A `TransferJob` has a maximum of one active `TransferOperation`. If this method is called while a `TransferOperation` is active, an error is returned.

      Args:
        request: (StoragetransferTransferJobsRunRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Run')
      return self._RunMethod(
          config, request, global_params=global_params)

    Run.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/transferJobs/{transferJobsId}:run',
        http_method='POST',
        method_id='storagetransfer.transferJobs.run',
        ordered_params=['jobName'],
        path_params=['jobName'],
        query_params=[],
        relative_path='v1/{+jobName}:run',
        request_field='runTransferJobRequest',
        request_type_name='StoragetransferTransferJobsRunRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class TransferOperationsService(base_api.BaseApiService):
    """Service class for the transferOperations resource."""

    _NAME = 'transferOperations'

    def __init__(self, client):
      super(StoragetransferV1.TransferOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Cancels a transfer. Use the transferOperations.get method to check if the cancellation succeeded or if the operation completed despite the `cancel` request. When you cancel an operation, the currently running transfer is interrupted. For recurring transfer jobs, the next instance of the transfer job will still run. For example, if your job is configured to run every day at 1pm and you cancel Monday's operation at 1:05pm, Monday's transfer will stop. However, a transfer job will still be attempted on Tuesday. This applies only to currently running operations. If an operation is not currently running, `cancel` does nothing. *Caution:* Canceling a transfer job can leave your data in an unknown state. We recommend that you restore the state at both the destination and the source after the `cancel` request completes so that your data is in a consistent state. When you cancel a job, the next job computes a delta of files and may repair any inconsistent state. For instance, if you run a job every day, and today's job found 10 new files and transferred five files before you canceled the job, tomorrow's transfer operation will compute a new delta with the five files that were not copied today plus any new files discovered tomorrow.

      Args:
        request: (StoragetransferTransferOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/transferOperations/{transferOperationsId}:cancel',
        http_method='POST',
        method_id='storagetransfer.transferOperations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='StoragetransferTransferOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (StoragetransferTransferOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/transferOperations/{transferOperationsId}',
        http_method='GET',
        method_id='storagetransfer.transferOperations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='StoragetransferTransferOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists transfer operations. Operations are ordered by their creation time in reverse chronological order.

      Args:
        request: (StoragetransferTransferOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/transferOperations',
        http_method='GET',
        method_id='storagetransfer.transferOperations.list',
        ordered_params=['name', 'filter'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken', 'returnPartialSuccess'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='StoragetransferTransferOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

    def Pause(self, request, global_params=None):
      r"""Pauses a transfer operation.

      Args:
        request: (StoragetransferTransferOperationsPauseRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Pause')
      return self._RunMethod(
          config, request, global_params=global_params)

    Pause.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/transferOperations/{transferOperationsId}:pause',
        http_method='POST',
        method_id='storagetransfer.transferOperations.pause',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:pause',
        request_field='pauseTransferOperationRequest',
        request_type_name='StoragetransferTransferOperationsPauseRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Resume(self, request, global_params=None):
      r"""Resumes a transfer operation that is paused.

      Args:
        request: (StoragetransferTransferOperationsResumeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Resume')
      return self._RunMethod(
          config, request, global_params=global_params)

    Resume.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/transferOperations/{transferOperationsId}:resume',
        http_method='POST',
        method_id='storagetransfer.transferOperations.resume',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:resume',
        request_field='resumeTransferOperationRequest',
        request_type_name='StoragetransferTransferOperationsResumeRequest',
        response_type_name='Empty',
        supports_download=False,
    )
