/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class CancelConversionTask
extends BaseCmd {
    public CancelConversionTask(String[] args) {
        super("ec2cct", "ec2-cancel-conversion-task");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    @Override
    protected String getOptionString() {
        return "Task-ID";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Deletes a conversion task. Any resources associated with this task,");
        System.out.println("     including partially transferred volumes or instances, will be");
        System.out.println("     permanently deleted.");
        System.out.println("     The Task-ID parameter identifies the (active) task to be deleted");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String taskId = null;
        try {
            taskId = this.getNonOptions()[0];
            this.warnIfTooManyNonOptions();
        }
        catch (ArrayIndexOutOfBoundsException ax) {
            throw new GeneralError("Required Argument 'Task-UD' missing (-h for usage). ");
        }
        RequestResultPair rsp = jec2.deleteConversionTask(taskId);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputConversionTask(System.out, taskId);
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new CancelConversionTask(args).invoke();
    }
}

