'\"
'\" Generated from file 'idx_import\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009-2019 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "doctools::idx::import" n 0\&.2\&.2 tcllib "Documentation tools"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
doctools::idx::import \- Importing keyword indices
.SH SYNOPSIS
package require \fBdoctools::idx::import ?0\&.2\&.2?\fR
.sp
package require \fBTcl 8\&.5 9\fR
.sp
package require \fBstruct::map\fR
.sp
package require \fBdoctools::idx::structure\fR
.sp
package require \fBsnit\fR
.sp
package require \fBpluginmgr\fR
.sp
\fB::doctools::idx::import\fR \fIobjectName\fR
.sp
\fBobjectName\fR \fBmethod\fR ?\fIarg arg \&.\&.\&.\fR?
.sp
\fIobjectName\fR \fBdestroy\fR
.sp
\fIobjectName\fR \fBimport text\fR \fItext\fR ?\fIformat\fR?
.sp
\fIobjectName\fR \fBimport file\fR \fIpath\fR ?\fIformat\fR?
.sp
\fIobjectName\fR \fBimport object text\fR \fIobject\fR \fItext\fR ?\fIformat\fR?
.sp
\fIobjectName\fR \fBimport object file\fR \fIobject\fR \fIpath\fR ?\fIformat\fR?
.sp
\fIobjectName\fR \fBconfig names\fR
.sp
\fIobjectName\fR \fBconfig get\fR
.sp
\fIobjectName\fR \fBconfig set\fR \fIname\fR ?\fIvalue\fR?
.sp
\fIobjectName\fR \fBconfig unset\fR \fIpattern\fR\&.\&.\&.
.sp
\fIobjectName\fR \fBincludes\fR
.sp
\fIobjectName\fR \fBinclude add\fR \fIpath\fR
.sp
\fIobjectName\fR \fBinclude remove\fR \fIpath\fR
.sp
\fIobjectName\fR \fBinclude clear\fR
.sp
\fBIncludeFile\fR \fIcurrentfile\fR \fIpath\fR
.sp
\fBimport\fR \fItext\fR \fIconfiguration\fR
.sp
.BE
.SH DESCRIPTION
This package provides a class to manage the plugins for the import of
keyword indices from other formats, i\&.e\&. their conversion from, for
example \fIdocidx\fR, \fIjson\fR, etc\&.
.PP
This is one of the three public pillars the management of keyword
indices resides on\&. The other two pillars are
.IP [1]
\fIExporting keyword indices\fR, and
.IP [2]
\fIHolding keyword indices\fR
.PP
.PP
For information about the \fBConcepts\fR of keyword indices, and
their parts, see the same-named section\&.
For information about the data structure which is the major output of
the manager objects provided by this package see the section
\fBKeyword index serialization format\fR\&.
.PP
The plugin system of our class is based on the package
\fBpluginmgr\fR, and configured to look for plugins using
.IP [1]
the environment variable \fBDOCTOOLS_IDX_IMPORT_PLUGINS\fR,
.IP [2]
the environment variable \fBDOCTOOLS_IDX_PLUGINS\fR,
.IP [3]
the environment variable \fBDOCTOOLS_PLUGINS\fR,
.IP [4]
the path "\fI~/\&.doctools/idx/import/plugin\fR"
.IP [5]
the path "\fI~/\&.doctools/idx/plugin\fR"
.IP [6]
the path "\fI~/\&.doctools/plugin\fR"
.IP [7]
the path "\fI~/\&.doctools/idx/import/plugins\fR"
.IP [8]
the path "\fI~/\&.doctools/idx/plugins\fR"
.IP [9]
the path "\fI~/\&.doctools/plugins\fR"
.IP [10]
the registry entry "HKEY_CURRENT_USER\\SOFTWARE\\DOCTOOLS\\IDX\\IMPORT\\PLUGINS"
.IP [11]
the registry entry "HKEY_CURRENT_USER\\SOFTWARE\\DOCTOOLS\\IDX\\PLUGINS"
.IP [12]
the registry entry "HKEY_CURRENT_USER\\SOFTWARE\\DOCTOOLS\\PLUGINS"
.PP
The last three are used only when the package is run on a machine
using Windows(tm) operating system\&.
.PP
The whole system is delivered with two predefined import plugins,
namely
.TP
docidx
See \fIdocidx import plugin\fR for details\&.
.TP
json
See \fIjson import plugin\fR for details\&.
.PP
.PP
Readers wishing to write their own import plugin for some format, i\&.e\&.
\fIplugin writer\fRs reading and understanding the section
containing the \fBImport plugin API v2 reference\fR is an
absolute necessity, as it specifies the interaction between this
package and its plugins in detail\&.
.SH CONCEPTS
.IP [1]
A \fIkeyword index\fR consists of a (possibly empty) set of \fIkeywords\fR\&.
.IP [2]
Each keyword in the set is identified by its name\&.
.IP [3]
Each keyword has a (possibly empty) set of \fIreferences\fR\&.
.IP [4]
A reference can be associated with more than one keyword\&.
.IP [5]
A reference not associated with at least one keyword is not possible
however\&.
.IP [6]
Each reference is identified by its target, specified as either an url
or symbolic filename, depending on the type of reference (\fBurl\fR,
or \fBmanpage\fR)\&.
.IP [7]
The type of a reference (url, or manpage) depends only on the
reference itself, and not the keywords it is associated with\&.
.IP [8]
In addition to a type each reference has a descriptive label as
well\&. This label depends only on the reference itself, and not the
keywords it is associated with\&.
.PP
A few notes
.IP [1]
Manpage references are intended to be used for references to the
documents the index is made for\&. Their target is a symbolic file name
identifying the document, and export plugins may replace symbolic with
actual file names, if specified\&.
.IP [2]
Url references are intended on the othre hand are inteded to be used
for links to anything else, like websites\&. Their target is an url\&.
.IP [3]
While url and manpage references share a namespace for their
identifiers, this should be no problem, given that manpage identifiers
are symbolic filenames and as such they should never look like urls,
the identifiers for url references\&.
.PP
.SH API
.SS "PACKAGE COMMANDS"
.TP
\fB::doctools::idx::import\fR \fIobjectName\fR
This command creates a new import manager object with an associated
Tcl command whose name is \fIobjectName\fR\&. This \fIobject\fR command
is explained in full detail in the sections \fBObject command\fR
and \fBObject methods\fR\&. The object command will be created
under the current namespace if the \fIobjectName\fR is not fully
qualified, and in the specified namespace otherwise\&.
.PP
.SS "OBJECT COMMAND"
All objects created by the \fB::doctools::idx::import\fR command have
the following general form:
.TP
\fBobjectName\fR \fBmethod\fR ?\fIarg arg \&.\&.\&.\fR?
The method \fBmethod\fR and its \fIarg\fR'uments determine the
exact behavior of the command\&.
See section \fBObject methods\fR for the detailed
specifications\&.
.PP
.SS "OBJECT METHODS"
.TP
\fIobjectName\fR \fBdestroy\fR
This method destroys the object it is invoked for\&.
.TP
\fIobjectName\fR \fBimport text\fR \fItext\fR ?\fIformat\fR?
This method takes the \fItext\fR and converts it from the specified
\fIformat\fR to the canonical serialization of a keyword index using
the import plugin for the format\&. An error is thrown if no plugin
could be found for the format\&.
The serialization generated by the conversion process is returned as
the result of this method\&.
.sp
If no format is specified the method defaults to \fBdocidx\fR\&.
.sp
The specification of what a \fIcanonical\fR serialization is can be
found in the section \fBKeyword index serialization format\fR\&.
.sp
The plugin has to conform to the interface specified in section
\fBImport plugin API v2 reference\fR\&.
.TP
\fIobjectName\fR \fBimport file\fR \fIpath\fR ?\fIformat\fR?
This method is a convenient wrapper around the \fBimport text\fR
method described by the previous item\&.
It reads the contents of the specified file into memory, feeds the
result into \fBimport text\fR and returns the resulting
serialization as its own result\&.
.TP
\fIobjectName\fR \fBimport object text\fR \fIobject\fR \fItext\fR ?\fIformat\fR?
This method is a convenient wrapper around the \fBimport text\fR
method described by the previous item\&.
It expects that \fIobject\fR is an object command supporting a
\fBdeserialize\fR method expecting the canonical serialization of a
keyword index\&.
It imports the text using \fBimport text\fR and then feeds the
resulting serialization into the \fIobject\fR via \fBdeserialize\fR\&.
This method returns the empty string as it result\&.
.TP
\fIobjectName\fR \fBimport object file\fR \fIobject\fR \fIpath\fR ?\fIformat\fR?
This method behaves like \fBimport object text\fR, except that it
reads the text to convert from the specified file instead of being
given it as argument\&.
.TP
\fIobjectName\fR \fBconfig names\fR
This method returns a list containing the names of all configuration
variables currently known to the object\&.
.TP
\fIobjectName\fR \fBconfig get\fR
This method returns a dictionary containing the names and values of
all configuration variables currently known to the object\&.
.TP
\fIobjectName\fR \fBconfig set\fR \fIname\fR ?\fIvalue\fR?
This method sets the configuration variable \fIname\fR to the
specified \fIvalue\fR and returns the new value of the variable\&.
.sp
If no value is specified it simply returns the current value, without
changing it\&.
.sp
Note that while the user can set the predefined configuration
variables \fBuser\fR and \fBformat\fR doing so will have no
effect, these values will be internally overridden when invoking an
import plugin\&.
.TP
\fIobjectName\fR \fBconfig unset\fR \fIpattern\fR\&.\&.\&.
This method unsets all configuration variables matching the specified
glob \fIpattern\fRs\&. If no pattern is specified it will unset all
currently defined configuration variables\&.
.TP
\fIobjectName\fR \fBincludes\fR
This method returns a list containing the currently specified paths to
use to search for include files when processing input\&.
The order of paths in the list corresponds to the order in which they
are used, from first to last, and also corresponds to the order in
which they were added to the object\&.
.TP
\fIobjectName\fR \fBinclude add\fR \fIpath\fR
This methods adds the specified \fIpath\fR to the list of paths to use
to search for include files when processing input\&. The path is added
to the end of the list, causing it to be searched after all previously
added paths\&. The result of the command is the empty string\&.
.sp
The method does nothing if the path is already known\&.
.TP
\fIobjectName\fR \fBinclude remove\fR \fIpath\fR
This methods removes the specified \fIpath\fR from the list of paths
to use to search for include files when processing input\&. The result
of the command is the empty string\&.
.sp
The method does nothing if the path is not known\&.
.TP
\fIobjectName\fR \fBinclude clear\fR
This method clears the list of paths to use to search for include
files when processing input\&. The result of the command is the empty
string\&.
.PP
.SH "IMPORT PLUGIN API V2 REFERENCE"
Plugins are what this package uses to manage the support for any input
format beyond the \fBKeyword index serialization format\fR\&. Here
we specify the API the objects created by this package use to interact
with their plugins\&.
.PP
A plugin for this package has to follow the rules listed below:
.IP [1]
A plugin is a package\&.
.IP [2]
The name of a plugin package has the form
doctools::idx::import::\fBFOO\fR,
where \fBFOO\fR is the name of the format the plugin will
generate output for\&. This name is also the argument to provide
to the various \fBimport\fR methods of import manager
objects to get a string encoding a keyword index in that
format\&.
.IP [3]
The plugin can expect that the package
\fBdoctools::idx::export::plugin\fR is present, as
indicator that it was invoked from a genuine plugin manager\&.
.IP [4]
The plugin can expect that a command named \fBIncludeFile\fR is
present, with the signature
.RS
.TP
\fBIncludeFile\fR \fIcurrentfile\fR \fIpath\fR
This command has to be invoked by the plugin when it has to process an
included file, if the format has the concept of such\&. An example of
such a format would be \fIdocidx\fR\&.
.sp
The plugin has to supply the following arguments
.RS
.TP
string \fIcurrentfile\fR
The path of the file it is currently processing\&. This may be the empty
string if no such is known\&.
.TP
string \fIpath\fR
The path of the include file as specified in the include directive
being processed\&.
.RE
.IP
The result of the command will be a 5-element list containing
.RS
.IP [1]
A boolean flag indicating the success (\fBTrue\fR) or failure
(\fBFalse\fR) of the operation\&.
.IP [2]
In case of success the contents of the included file, and the
empty string otherwise\&.
.IP [3]
The resolved, i\&.e\&. absolute path of the included file, if
possible, or the unchanged \fIpath\fR argument\&. This is for
display in an error message, or as the \fIcurrentfile\fR
argument of another call to \fBIncludeFile\fR should this file
contain more files\&.
.IP [4]
In case of success an empty string, and for failure a code
indicating the reason for it, one of
.RS
.TP
notfound
The specified file could not be found\&.
.TP
notread
The specified file was found, but not be read into memory\&.
.RE
.IP [5]
An empty string in case of success of a \fBnotfound\fR
failure, and an additional error message describing the reason
for a \fBnotread\fR error in more detail\&.
.RE
.RE
.IP [5]
A plugin has to provide one command, with the signature shown
below\&.
.RS
.TP
\fBimport\fR \fItext\fR \fIconfiguration\fR
Whenever an import manager of \fBdoctools::idx\fR has to parse
input for an index it will invoke this command\&.
.RS
.TP
string \fItext\fR
This argument will contain the text encoding the index per the format
the plugin is for\&.
.TP
dictionary \fIconfiguration\fR
This argument will contain the current configuration to apply to the
parsing, as a dictionary mapping from variable names to values\&.
.sp
The following configuration variables have a predefined meaning all
plugins have to obey, although they can ignore this information at
their discretion\&. Any other other configuration variables recognized
by a plugin will be described in the manpage for that plugin\&.
.RS
.TP
user
This variable is expected to contain the name of the user
owning the process invoking the plugin\&.
.TP
format
This variable is expected to contain the name of the
format whose plugin is invoked\&.
.RE
.RE
.RE
.IP [6]
A single usage cycle of a plugin consists of the invokations of
the command \fBimport\fR\&. This call has to leave the plugin in
a state where another usage cycle can be run without problems\&.
.PP
.SH "KEYWORD INDEX SERIALIZATION FORMAT"
Here we specify the format used by the doctools v2 packages to
serialize keyword indices as immutable values for transport,
comparison, etc\&.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations\&. While a keyword index may have more than one regular
serialization only exactly one of them will be \fIcanonical\fR\&.
.PP
.TP
regular serialization
.RS
.IP [1]
An index serialization is a nested Tcl dictionary\&.
.IP [2]
This dictionary holds a single key, \fBdoctools::idx\fR, and its
value\&. This value holds the contents of the index\&.
.IP [3]
The contents of the index are a Tcl dictionary holding the title of
the index, a label, and the keywords and references\&. The relevant keys
and their values are
.RS
.TP
\fBtitle\fR
The value is a string containing the title of the index\&.
.TP
\fBlabel\fR
The value is a string containing a label for the index\&.
.TP
\fBkeywords\fR
The value is a Tcl dictionary, using the keywords known to the index
as keys\&. The associated values are lists containing the identifiers of
the references associated with that particular keyword\&.
.sp
Any reference identifier used in these lists has to exist as a key in
the \fBreferences\fR dictionary, see the next item for its
definition\&.
.TP
\fBreferences\fR
The value is a Tcl dictionary, using the identifiers for the
references known to the index as keys\&. The associated values are
2-element lists containing the type and label of the reference, in
this order\&.
.sp
Any key here has to be associated with at least one keyword,
i\&.e\&. occur in at least one of the reference lists which are the values
in the \fBkeywords\fR dictionary, see previous item for its
definition\&.
.RE
.IP [4]
The \fItype\fR of a reference can be one of two values,
.RS
.TP
\fBmanpage\fR
The identifier of the reference is interpreted as symbolic file name,
referring to one of the documents the index was made for\&.
.TP
\fBurl\fR
The identifier of the reference is interpreted as an url, referring to
some external location, like a website, etc\&.
.RE
.RE
.TP
canonical serialization
The canonical serialization of a keyword index has the format as
specified in the previous item, and then additionally satisfies the
constraints below, which make it unique among all the possible
serializations of the keyword index\&.
.RS
.IP [1]
The keys found in all the nested Tcl dictionaries are sorted in
ascending dictionary order, as generated by Tcl's builtin command
\fBlsort -increasing -dict\fR\&.
.IP [2]
The references listed for each keyword of the index, if any, are
listed in ascending dictionary order of their \fIlabels\fR, as
generated by Tcl's builtin command \fBlsort -increasing -dict\fR\&.
.RE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIdoctools\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
conversion, docidx, documentation, import, index, json, keyword index, manpage, markup, parsing, plugin, reference, url
.SH CATEGORY
Documentation tools
.SH COPYRIGHT
.nf
Copyright (c) 2009-2019 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi
