/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.dom;

import nu.validator.htmlparser.common.DocumentMode;
import nu.validator.htmlparser.impl.CoalescingTreeBuilder;
import nu.validator.htmlparser.impl.HtmlAttributes;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

class DOMTreeBuilder
extends CoalescingTreeBuilder<Element> {
    private DOMImplementation implementation;
    private Document document;

    protected DOMTreeBuilder(DOMImplementation implementation) {
        this.implementation = implementation;
    }

    @Override
    protected void addAttributesToElement(Element element, HtmlAttributes attributes) throws SAXException {
        try {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String localName = attributes.getLocalNameNoBoundsCheck(i);
                String uri = attributes.getURINoBoundsCheck(i);
                if (element.hasAttributeNS(uri, localName)) continue;
                element.setAttributeNS(uri, localName, attributes.getValueNoBoundsCheck(i));
            }
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void appendCharacters(Element parent, String text) throws SAXException {
        try {
            Node lastChild = parent.getLastChild();
            if (lastChild != null && lastChild.getNodeType() == 3) {
                Text lastAsText = (Text)lastChild;
                lastAsText.setData(lastAsText.getData() + text);
                return;
            }
            parent.appendChild(this.document.createTextNode(text));
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void appendChildrenToNewParent(Element oldParent, Element newParent) throws SAXException {
        try {
            while (oldParent.hasChildNodes()) {
                newParent.appendChild(oldParent.getFirstChild());
            }
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void appendComment(Element parent, String comment) throws SAXException {
        try {
            parent.appendChild(this.document.createComment(comment));
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void appendCommentToDocument(String comment) throws SAXException {
        try {
            this.document.appendChild(this.document.createComment(comment));
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected Element createElement(String ns, String name, HtmlAttributes attributes, Element intendedParent) throws SAXException {
        try {
            Element rv = this.document.createElementNS(ns, name);
            for (int i = 0; i < attributes.getLength(); ++i) {
                rv.setAttributeNS(attributes.getURINoBoundsCheck(i), attributes.getLocalNameNoBoundsCheck(i), attributes.getValueNoBoundsCheck(i));
                if (attributes.getTypeNoBoundsCheck(i) != "ID") continue;
                rv.setIdAttributeNS(null, attributes.getLocalName(i), true);
            }
            return rv;
        }
        catch (DOMException e) {
            this.fatal(e);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected Element createHtmlElementSetAsRoot(HtmlAttributes attributes) throws SAXException {
        try {
            Element rv = this.document.createElementNS("http://www.w3.org/1999/xhtml", "html");
            for (int i = 0; i < attributes.getLength(); ++i) {
                rv.setAttributeNS(attributes.getURINoBoundsCheck(i), attributes.getLocalNameNoBoundsCheck(i), attributes.getValueNoBoundsCheck(i));
            }
            this.document.appendChild(rv);
            return rv;
        }
        catch (DOMException e) {
            this.fatal(e);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected void appendElement(Element child, Element newParent) throws SAXException {
        try {
            newParent.appendChild(child);
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected boolean hasChildren(Element element) throws SAXException {
        try {
            return element.hasChildNodes();
        }
        catch (DOMException e) {
            this.fatal(e);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected Element createElement(String ns, String name, HtmlAttributes attributes, Element form, Element intendedParent) throws SAXException {
        try {
            Element rv = this.createElement(ns, name, attributes, intendedParent);
            rv.setUserData("nu.validator.form-pointer", form, null);
            return rv;
        }
        catch (DOMException e) {
            this.fatal(e);
            return null;
        }
    }

    @Override
    protected void start(boolean fragment) throws SAXException {
        this.document = this.implementation.createDocument(null, null, null);
    }

    @Override
    protected void documentMode(DocumentMode mode, String publicIdentifier, String systemIdentifier) throws SAXException {
        this.document.setUserData("nu.validator.document-mode", (Object)mode, null);
    }

    Document getDocument() {
        Document rv = this.document;
        this.document = null;
        return rv;
    }

    DocumentFragment getDocumentFragment() {
        DocumentFragment rv = this.document.createDocumentFragment();
        Node rootElt = this.document.getFirstChild();
        while (rootElt.hasChildNodes()) {
            rv.appendChild(rootElt.getFirstChild());
        }
        this.document = null;
        return rv;
    }

    @Override
    protected Element createAndInsertFosterParentedElement(String ns, String name, HtmlAttributes attributes, Element table, Element stackParent) throws SAXException {
        try {
            Node parent = table.getParentNode();
            Element child = this.createElement(ns, name, attributes, parent != null ? (Element)parent : stackParent);
            if (parent != null) {
                parent.insertBefore(child, table);
            } else {
                stackParent.appendChild(child);
            }
            return child;
        }
        catch (DOMException e) {
            this.fatal(e);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected void insertFosterParentedCharacters(String text, Element table, Element stackParent) throws SAXException {
        try {
            Node parent = table.getParentNode();
            if (parent != null) {
                Node previousSibling = table.getPreviousSibling();
                if (previousSibling != null && previousSibling.getNodeType() == 3) {
                    Text lastAsText = (Text)previousSibling;
                    lastAsText.setData(lastAsText.getData() + text);
                    return;
                }
                parent.insertBefore(this.document.createTextNode(text), table);
                return;
            }
            Node lastChild = stackParent.getLastChild();
            if (lastChild != null && lastChild.getNodeType() == 3) {
                Text lastAsText = (Text)lastChild;
                lastAsText.setData(lastAsText.getData() + text);
                return;
            }
            stackParent.appendChild(this.document.createTextNode(text));
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void insertFosterParentedChild(Element child, Element table, Element stackParent) throws SAXException {
        try {
            Node parent = table.getParentNode();
            if (parent != null) {
                parent.insertBefore(child, table);
            } else {
                stackParent.appendChild(child);
            }
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void detachFromParent(Element element) throws SAXException {
        try {
            Node parent = element.getParentNode();
            if (parent != null) {
                parent.removeChild(element);
            }
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }
}

