/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.email.prefs;

import au.com.trgtd.email.prefs.EmailOptionsPanelController;
import au.com.trgtd.email.prefs.EmailPrefs;
import au.com.trgtd.email.task.FetchEmailScheduler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;

public class EmailPanel
extends JPanel {
    private final EmailOptionsPanelController controller;
    private JLabel addressLabel;
    private JTextField addressField;
    private JLabel daysLabel;
    private JSpinner daysField;
    private JLabel descrLabel;
    private JTextField descrField;
    private JCheckBox fetchAtStartupCheck;
    private JCheckBox fetchScheduleCheck;
    private JLabel hoursLabel;
    private JSpinner hoursField;
    private JLabel minsLabel;
    private JSpinner minsField;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JFormattedTextField portField;
    private JLabel portLabel;
    private JLabel serverLabel;
    private JTextField serverField;
    private JCheckBox sslCheck;
    private JLabel usernameLabel;
    private JTextField usernameField;

    EmailPanel(EmailOptionsPanelController controller) {
        this.controller = controller;
        this.initForm();
    }

    void load() {
        this.descrField.setText(EmailPrefs.getEmailDescription());
        this.addressField.setText(EmailPrefs.getEmailAddress());
        this.usernameField.setText(EmailPrefs.getEmailUsername());
        this.passwordField.setText(EmailPrefs.getEmailPassword());
        this.serverField.setText(EmailPrefs.getEmailServer());
        this.portField.setValue(EmailPrefs.getPort());
        this.sslCheck.setSelected(EmailPrefs.isSSL());
        this.fetchAtStartupCheck.setSelected(EmailPrefs.isEmailFetchAtStartup());
        this.fetchScheduleCheck.setSelected(EmailPrefs.isEmailFetchSchedule());
        long ms = EmailPrefs.getEmailFetchIntervalMS();
        this.daysField.setValue(EmailPrefs.getDays(ms));
        this.hoursField.setValue(EmailPrefs.getHrs(ms));
        this.minsField.setValue(EmailPrefs.getMins(ms));
        this.enableDisableFields();
    }

    void store() {
        long interval;
        EmailPrefs.setEmailDescription(this.descrField.getText());
        EmailPrefs.setEmailAddress(this.addressField.getText());
        EmailPrefs.setEmailUsername(this.usernameField.getText());
        EmailPrefs.setEmailPassword(new String(this.passwordField.getPassword()));
        EmailPrefs.setEmailServer(this.serverField.getText());
        try {
            EmailPrefs.setPort(Integer.parseInt(this.portField.getText()));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        EmailPrefs.setSSL(this.sslCheck.isSelected());
        EmailPrefs.setEmailFetchAtStartup(this.fetchAtStartupCheck.isSelected());
        EmailPrefs.setEmailFetchSchedule(this.fetchScheduleCheck.isSelected());
        long days = this.getValue(this.daysField);
        long hrs = this.getValue(this.hoursField);
        long mins = this.getValue(this.minsField);
        long ms = EmailPrefs.getMilliseconds(days, hrs, mins, 0L);
        EmailPrefs.setEmailFetchIntervalMS(ms);
        FetchEmailScheduler.instance().cancel();
        if (EmailPrefs.isEmailFetchSchedule() && (interval = EmailPrefs.getEmailFetchIntervalMS()) > 0L) {
            FetchEmailScheduler.instance().schedule(interval, interval);
        }
    }

    private long getValue(JSpinner spinner) {
        return spinner.getValue() instanceof Long ? (Long)spinner.getValue() : 0L;
    }

    boolean valid() {
        return true;
    }

    private void enableDisableFields() {
        boolean schedule = this.fetchScheduleCheck.isSelected();
        this.daysField.setEnabled(schedule);
        this.hoursField.setEnabled(schedule);
        this.minsField.setEnabled(schedule);
    }

    private void initForm() {
        this.initComponents();
        this.initFields();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]2[grow]0", "0[]2[]2[]2[]2[]2[]2[]2[]2[]0"));
        panel.add((Component)this.descrLabel, "align right");
        panel.add((Component)this.descrField, "align left, growx, wrap");
        panel.add((Component)this.addressLabel, "align right");
        panel.add((Component)this.addressField, "align left, growx, wrap");
        panel.add((Component)this.serverLabel, "align right");
        panel.add((Component)this.serverField, "align left, growx, wrap");
        panel.add((Component)this.usernameLabel, "align right");
        panel.add((Component)this.usernameField, "align left, growx, wrap");
        panel.add((Component)this.passwordLabel, "align right");
        panel.add((Component)this.passwordField, "align left, growx, wrap");
        panel.add((Component)this.portLabel, "align right");
        panel.add((Component)this.portField, "align left, span, split 2");
        panel.add((Component)this.sslCheck, "align right, wrap");
        panel.add((Component)this.fetchAtStartupCheck, "align left, span, wrap");
        panel.add((Component)this.fetchScheduleCheck, "align left, span, wrap");
        panel.add((Component)this.daysLabel, "align right");
        panel.add((Component)this.daysField, "align left, span, split 5");
        panel.add((Component)this.hoursLabel, "align left");
        panel.add((Component)this.hoursField, "align left");
        panel.add((Component)this.minsLabel, "align left");
        panel.add((Component)this.minsField, "align left, wrap");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    private String getMsg(String key) {
        return NbBundle.getMessage(EmailPanel.class, (String)key);
    }

    private void initFields() {
        this.descrLabel = new JLabel(this.getMsg("email-account-descr"));
        this.addressLabel = new JLabel(this.getMsg("email-account-address"));
        this.serverLabel = new JLabel(this.getMsg("email-account-server"));
        this.usernameLabel = new JLabel(this.getMsg("email-account-username"));
        this.passwordLabel = new JLabel(this.getMsg("email-account-password"));
        this.portLabel = new JLabel(this.getMsg("email-account-port"));
        this.portField = new JFormattedTextField();
        this.sslCheck = new JCheckBox(this.getMsg("email-account-ssl"));
        this.passwordField = new JPasswordField();
        this.usernameField = new JTextField();
        this.serverField = new JTextField();
        this.addressField = new JTextField();
        this.descrField = new JTextField();
        this.fetchAtStartupCheck = new JCheckBox(this.getMsg("fetch.at.startup"));
        this.fetchScheduleCheck = new JCheckBox(this.getMsg("fetch.schedule"));
        this.fetchScheduleCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EmailPanel.this.enableDisableFields();
            }
        });
        this.daysField = new JSpinner();
        this.daysField.setModel(new SpinnerNumberModel((Number)0L, Long.valueOf(0L), Long.valueOf(99L), (Number)1L));
        this.daysLabel = new JLabel(this.getMsg("fetch.days"));
        this.hoursLabel = new JLabel(this.getMsg("fetch.hours"));
        this.hoursField = new JSpinner();
        this.hoursField.setModel(new SpinnerNumberModel((Number)0L, Long.valueOf(0L), Long.valueOf(23L), (Number)1L));
        this.minsLabel = new JLabel(this.getMsg("fetch.mins"));
        this.minsField = new JSpinner();
        this.minsField.setModel(new SpinnerNumberModel((Number)0L, Long.valueOf(0L), Long.valueOf(59L), (Number)1L));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

