/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.AccessToken;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class CompoundAccessToken
extends AccessToken {
    private final List<AccessToken> myTokens;

    CompoundAccessToken(@NotNull List<AccessToken> tokens) {
        if (tokens == null) {
            CompoundAccessToken.$$$reportNull$$$0(0);
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("tokens must not be empty");
        }
        this.myTokens = tokens;
    }

    @Override
    public void finish() {
        SmartList<Throwable> throwables = null;
        for (AccessToken token : this.myTokens) {
            try {
                token.finish();
            }
            catch (Throwable t) {
                if (throwables == null) {
                    throwables = new SmartList<Throwable>();
                }
                throwables.add(t);
            }
        }
        if (throwables != null) {
            Throwable throwable = (Throwable)throwables.get(0);
            for (int i = 1; i < throwables.size(); ++i) {
                throwable.addSuppressed((Throwable)throwables.get(i));
            }
            ExceptionUtil.rethrow(throwable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/intellij/openapi/application/CompoundAccessToken", "<init>"));
    }
}

