/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec4(-1.65, 1.33, 1.93, 0.76) != vec4(-1.65, 1.33, 1.93, 0.76)) => false
 * (vec4(-1.65, 1.33, 1.93, 0.76) != vec4(0.8, -0.15, -0.51, 0.0)) => true
 * (vec4(0.8, -0.15, -0.51, 0.0) != vec4(-1.65, 1.33, 1.93, 0.76)) => true
 * (vec4(0.8, -0.15, -0.51, 0.0) != vec4(0.8, -0.15, -0.51, 0.0)) => false
 */
#version 150

void main()
{
  float[(vec4(-1.65, 1.33, 1.93, 0.76) != vec4(-1.65, 1.33, 1.93, 0.76)) == false ? 1 : -1] array0;
  float[(vec4(-1.65, 1.33, 1.93, 0.76) != vec4(0.8, -0.15, -0.51, 0.0)) == true ? 1 : -1] array1;
  float[(vec4(0.8, -0.15, -0.51, 0.0) != vec4(-1.65, 1.33, 1.93, 0.76)) == true ? 1 : -1] array2;
  float[(vec4(0.8, -0.15, -0.51, 0.0) != vec4(0.8, -0.15, -0.51, 0.0)) == false ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
