/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.util.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.node.NodeClient;

public abstract class AbstractSearchWorkflowAction<T extends ToXContentObject>
extends BaseRestHandler {
    protected final List<String> urlPaths;
    protected final String index;
    protected final Class<T> clazz;
    protected final ActionType<SearchResponse> actionType;
    protected final FlowFrameworkSettings flowFrameworkSettings;

    public AbstractSearchWorkflowAction(List<String> urlPaths, String index, Class<T> clazz, ActionType<SearchResponse> actionType, FlowFrameworkSettings flowFrameworkSettings) {
        this.urlPaths = urlPaths;
        this.index = index;
        this.clazz = clazz;
        this.actionType = actionType;
        this.flowFrameworkSettings = flowFrameworkSettings;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        try {
            if (!this.flowFrameworkSettings.isFlowFrameworkEnabled()) {
                FlowFrameworkException ffe = new FlowFrameworkException("This API is disabled. To enable it, update the setting [" + FlowFrameworkSettings.FLOW_FRAMEWORK_ENABLED.getKey() + "] to true.", RestStatus.FORBIDDEN);
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(ffe.getRestStatus(), ffe.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS)));
            }
            String tenantId = TenantAwareHelper.getTenantID(this.flowFrameworkSettings.isMultiTenancyEnabled(), request);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
            searchSourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true));
            searchSourceBuilder.timeout(this.flowFrameworkSettings.getRequestTimeout());
            SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{this.index}).preference(tenantId);
            return channel -> client.execute(this.actionType, (ActionRequest)searchRequest, this.search((RestChannel)channel));
        }
        catch (FlowFrameworkException ex) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(ex.getRestStatus(), ex.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS)));
        }
    }

    protected RestResponseListener<SearchResponse> search(RestChannel channel) {
        return new RestResponseListener<SearchResponse>(this, channel){

            public RestResponse buildResponse(SearchResponse response) throws Exception {
                if (response.isTimedOut()) {
                    return new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, response.toString());
                }
                return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }

    public List<RestHandler.Route> routes() {
        ArrayList<RestHandler.Route> routes = new ArrayList<RestHandler.Route>();
        for (String path : this.urlPaths) {
            routes.add(new RestHandler.Route(RestRequest.Method.POST, path));
            routes.add(new RestHandler.Route(RestRequest.Method.GET, path));
        }
        return routes;
    }
}

