/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.inject.Singleton;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.protobufs.QueryContainer;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverter;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;

@Singleton
public class QueryBuilderProtoConverterSpiRegistry {
    private static final Logger logger = LogManager.getLogger(QueryBuilderProtoConverterSpiRegistry.class);
    private final Map<QueryContainer.QueryContainerCase, QueryBuilderProtoConverter> converterMap = new HashMap<QueryContainer.QueryContainerCase, QueryBuilderProtoConverter>();

    @Inject
    public QueryBuilderProtoConverterSpiRegistry() {
    }

    public QueryBuilder fromProto(QueryContainer queryContainer) {
        if (queryContainer == null) {
            throw new IllegalArgumentException("Query container cannot be null");
        }
        QueryContainer.QueryContainerCase queryCase = queryContainer.getQueryContainerCase();
        QueryBuilderProtoConverter converter = this.converterMap.get(queryCase);
        if (converter != null) {
            logger.debug("Using converter for {}: {}", (Object)queryCase, (Object)converter.getClass().getName());
            return converter.fromProto(queryContainer);
        }
        throw new IllegalArgumentException("Unsupported query type in container: " + String.valueOf(queryContainer) + " (case: " + String.valueOf(queryCase) + ")");
    }

    public int size() {
        return this.converterMap.size();
    }

    public void setRegistryOnAllConverters(QueryBuilderProtoConverterRegistry registry) {
        for (QueryBuilderProtoConverter converter : this.converterMap.values()) {
            converter.setRegistry(registry);
        }
        logger.info("Set registry on {} converters", (Object)this.converterMap.size());
    }

    public void registerConverter(QueryBuilderProtoConverter converter) {
        if (converter == null) {
            throw new IllegalArgumentException("Converter cannot be null");
        }
        QueryContainer.QueryContainerCase queryCase = converter.getHandledQueryCase();
        if (queryCase == null) {
            throw new IllegalArgumentException("Handled query case cannot be null for converter: " + converter.getClass().getName());
        }
        if (queryCase == QueryContainer.QueryContainerCase.QUERYCONTAINER_NOT_SET) {
            throw new IllegalArgumentException("Cannot register converter for QUERYCONTAINER_NOT_SET case: " + converter.getClass().getName());
        }
        QueryBuilderProtoConverter existingConverter = this.converterMap.put(queryCase, converter);
        if (existingConverter != null) {
            logger.warn("Replacing existing converter for query type {}: {} -> {}", (Object)queryCase, (Object)existingConverter.getClass().getName(), (Object)converter.getClass().getName());
        }
        logger.info("Registered query converter for {}: {}", (Object)queryCase, (Object)converter.getClass().getName());
    }
}

