/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.MappingTransformer;
import org.opensearch.plugins.MapperPlugin;
import reactor.util.annotation.NonNull;

public class MappingTransformerRegistry {
    private final List<MappingTransformer> transformers;
    private final NamedXContentRegistry xContentRegistry;
    protected final Logger logger = LogManager.getLogger(this.getClass());

    public MappingTransformerRegistry(@NonNull List<MapperPlugin> mapperPlugins, @NonNull NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
        this.transformers = new ArrayList<MappingTransformer>();
        for (MapperPlugin plugin : mapperPlugins) {
            this.transformers.addAll(plugin.getMappingTransformers());
        }
    }

    private void applyNext(final @NonNull Map<String, Object> mapping, final MappingTransformer.TransformContext context, final @NonNull AtomicInteger index, final @NonNull ActionListener<String> listener) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(mapping);
            String mappingString = builder.toString();
            if (index.get() == this.transformers.size()) {
                listener.onResponse((Object)mappingString);
                return;
            }
        }
        catch (IOException e) {
            if (index.get() == 0) {
                listener.onFailure((Exception)new RuntimeException("Failed to transform the mapping due to the mapping is not a valid json string [" + String.valueOf(mapping) + "]", e));
            }
            listener.onFailure((Exception)new RuntimeException("Failed to parse the mapping [" + String.valueOf(mapping) + "] transformed by the transformer [" + this.transformers.get(index.get() - 1).getClass().getName() + "]", e));
        }
        final MappingTransformer transformer = this.transformers.get(index.getAndIncrement());
        this.logger.debug("Applying mapping transformer: {}", (Object)transformer.getClass().getName());
        transformer.transform(mapping, context, new ActionListener<Void>(this){
            final /* synthetic */ MappingTransformerRegistry this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(Void unused) {
                this.this$0.logger.debug("Completed transformation: {}", (Object)transformer.getClass().getName());
                this.this$0.applyNext(mapping, context, index, (ActionListener<String>)listener);
            }

            public void onFailure(Exception e) {
                this.this$0.logger.error("Transformer {} failed: {}", (Object)transformer.getClass().getName(), (Object)e.getMessage());
                listener.onFailure(e);
            }
        });
    }

    public void applyTransformers(String mappingString, MappingTransformer.TransformContext context, @NonNull ActionListener<String> mappingTransformListener) {
        Map<String, Object> mappingMap;
        if (this.transformers.isEmpty() || mappingString == null) {
            mappingTransformListener.onResponse((Object)mappingString);
            return;
        }
        try {
            mappingMap = MapperService.parseMapping(this.xContentRegistry, mappingString);
        }
        catch (IOException e) {
            mappingTransformListener.onFailure((Exception)new IllegalArgumentException("Failed to transform the mappings because failed to parse the mappings [" + mappingString + "]", e));
            return;
        }
        AtomicInteger index = new AtomicInteger(0);
        this.applyNext(mappingMap, context, index, mappingTransformListener);
    }
}

