/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.stats.info;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.searchrelevance.stats.common.StatName;
import org.opensearch.searchrelevance.stats.info.InfoStatType;

public enum InfoStatName implements StatName
{
    CLUSTER_VERSION("cluster_version", "", InfoStatType.INFO_STRING, Version.V_3_1_0);

    private final String nameString;
    private final String path;
    private final InfoStatType statType;
    private final Version version;
    private static final Map<String, InfoStatName> BY_NAME;

    private InfoStatName(String nameString, String path, InfoStatType statType, Version version) {
        this.nameString = nameString;
        this.path = path;
        this.statType = statType;
        this.version = version;
    }

    public static InfoStatName from(String name) {
        if (!InfoStatName.isValidName(name)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Info stat not found: %s", name));
        }
        return BY_NAME.get(name);
    }

    @Override
    public String getFullPath() {
        if (this.path == null || this.path.isBlank()) {
            return this.nameString;
        }
        return String.join((CharSequence)".", this.path, this.nameString);
    }

    public static boolean isValidName(String name) {
        return BY_NAME.containsKey(name);
    }

    @Override
    public Version version() {
        return this.version;
    }

    public String toString() {
        return this.getNameString();
    }

    @Override
    @Generated
    public String getNameString() {
        return this.nameString;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Override
    @Generated
    public InfoStatType getStatType() {
        return this.statType;
    }

    @Generated
    public Version getVersion() {
        return this.version;
    }

    static {
        BY_NAME = Arrays.stream(InfoStatName.values()).collect(Collectors.toMap(stat -> stat.nameString, stat -> stat));
    }
}

