/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.model;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class QueryWithReference
implements Writeable {
    private final String queryText;
    private final String referenceAnswer;
    public static final String DELIMITER = "#";

    public QueryWithReference(String queryText, String referenceAnswer) {
        this.queryText = queryText;
        this.referenceAnswer = referenceAnswer;
    }

    public QueryWithReference(StreamInput in) throws IOException {
        this.queryText = in.readString();
        this.referenceAnswer = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.queryText);
        out.writeString(this.referenceAnswer);
    }

    public String getQueryText() {
        return this.queryText;
    }

    public String getReferenceAnswer() {
        return this.referenceAnswer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryWithReference that = (QueryWithReference)o;
        return Objects.equals(this.queryText, that.queryText) && Objects.equals(this.referenceAnswer, that.referenceAnswer);
    }

    public int hashCode() {
        return Objects.hash(this.queryText, this.referenceAnswer);
    }

    public String toString() {
        return "QueryWithReference{queryText='" + this.queryText + "', referenceAnswer='" + this.referenceAnswer + "'}";
    }
}

