/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.common;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.core.common.Strings;

public class ParameterValidator {
    private static final int MAX_TIFJOB_NAME_BYTES = 127;

    public List<String> validateTIFJobName(String tifJobName) {
        int byteCount;
        ArrayList<String> errorMsgs = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)tifJobName)) {
            errorMsgs.add("threat intel feed job name must not be empty");
            return errorMsgs;
        }
        if (!Strings.validFileName((String)tifJobName)) {
            errorMsgs.add(String.format(Locale.ROOT, "threat intel feed job name must not contain the following characters %s", Strings.INVALID_FILENAME_CHARS));
        }
        if (tifJobName.contains("#") || tifJobName.contains(":")) {
            errorMsgs.add("threat intel feed job name must not contain '#'");
        }
        if (tifJobName.charAt(0) == '_' || tifJobName.charAt(0) == '-' || tifJobName.charAt(0) == '+') {
            errorMsgs.add("threat intel feed job name must not start with '_', '-', or '+'");
        }
        if ((byteCount = tifJobName.getBytes(StandardCharsets.UTF_8).length) > 127) {
            errorMsgs.add(String.format(Locale.ROOT, "threat intel feed job name is too long, (%d > %d)", byteCount, 127));
        }
        if (tifJobName.equals(".") || tifJobName.equals("..")) {
            errorMsgs.add("threat intel feed job name must not be '.' or '..'");
        }
        return errorMsgs;
    }
}

