/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.commons.model.STIX2;
import org.opensearch.securityanalytics.model.STIX2IOCDto;
import org.opensearch.securityanalytics.util.XContentUtils;

public class STIX2IOC
extends STIX2
implements Writeable,
ToXContentObject {
    private static final Logger logger = LogManager.getLogger(STIX2IOC.class);
    public static final String NO_ID = "";
    public static final long NO_VERSION = 1L;
    public static final String VERSION_FIELD = "version";
    private long version = 1L;

    public STIX2IOC() {
    }

    public STIX2IOC(String id, String name, String type, String value, String severity, Instant created, Instant modified, String description, List<String> labels, String specVersion, String feedId, String feedName, Long version) {
        super(StringUtils.isBlank((CharSequence)id) ? UUID.randomUUID().toString() : id, name, type, value, severity, created, modified, description, labels, specVersion, feedId, feedName);
        this.version = version;
        this.validate();
    }

    public STIX2IOC(STIX2 ioc, String feedId, String feedName) {
        this(ioc.getId(), ioc.getName(), ioc.getType(), ioc.getValue(), ioc.getSeverity(), ioc.getCreated(), ioc.getModified(), ioc.getDescription(), ioc.getLabels(), ioc.getSpecVersion(), feedId, feedName, 1L);
    }

    public STIX2IOC(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString(), sin.readString(), sin.readString(), sin.readString(), sin.readInstant(), sin.readInstant(), sin.readString(), sin.readStringList(), sin.readString(), sin.readString(), sin.readString(), sin.readLong());
    }

    public STIX2IOC(STIX2IOCDto iocDto) {
        this(iocDto.getId(), iocDto.getName(), iocDto.getType(), iocDto.getValue(), iocDto.getSeverity(), iocDto.getCreated(), iocDto.getModified(), iocDto.getDescription(), iocDto.getLabels(), iocDto.getSpecVersion(), iocDto.getFeedId(), iocDto.getFeedName(), iocDto.getVersion());
    }

    public STIX2IOC(STIX2IOCDto ioc, String feedId, String feedName) {
        this(ioc.getId(), ioc.getName(), ioc.getType(), ioc.getValue(), ioc.getSeverity(), ioc.getCreated(), ioc.getModified(), ioc.getDescription(), ioc.getLabels(), ioc.getSpecVersion(), feedId, feedName, 1L);
    }

    public static STIX2IOC readFrom(StreamInput sin) throws IOException {
        return new STIX2IOC(sin);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(super.getId());
        out.writeString(super.getName());
        out.writeString(super.getType().toString());
        out.writeString(super.getValue());
        out.writeString(super.getSeverity());
        out.writeInstant(super.getCreated());
        out.writeInstant(super.getModified());
        out.writeString(super.getDescription());
        out.writeStringCollection((Collection)super.getLabels());
        out.writeString(super.getSpecVersion());
        out.writeString(super.getFeedId());
        out.writeString(super.getFeedName());
        out.writeLong(this.version);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("id", super.getId()).field("name", super.getName()).field("type", super.getType().toString()).field("value", super.getValue()).field("severity", super.getSeverity());
        XContentUtils.buildInstantAsField(builder, super.getCreated(), "created");
        XContentUtils.buildInstantAsField(builder, super.getModified(), "modified");
        return builder.field("description", super.getDescription()).field("labels", (Iterable)super.getLabels()).field("spec_version", super.getSpecVersion()).field("feed_id", super.getFeedId()).field("feed_name", super.getFeedName()).field(VERSION_FIELD, this.version).endObject();
    }

    public static STIX2IOC parse(XContentParser xcp, String id, Long version) throws IOException {
        if (id == null) {
            id = NO_ID;
        }
        if (version == null) {
            version = 1L;
        }
        String name = null;
        String type = null;
        String value = null;
        String severity = null;
        Instant created = null;
        Instant modified = null;
        String description = null;
        ArrayList<String> labels = new ArrayList<String>();
        String specVersion = null;
        String feedId = null;
        String feedName = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block26: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "name": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) break;
                    name = xcp.text();
                    break;
                }
                case "type": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) break;
                    type = xcp.text();
                    break;
                }
                case "value": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) break;
                    value = xcp.text();
                    break;
                }
                case "severity": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) break;
                    severity = xcp.text();
                    break;
                }
                case "created": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        created = null;
                        break;
                    }
                    if (xcp.currentToken().isValue()) {
                        if (xcp.currentToken() == XContentParser.Token.VALUE_STRING) {
                            created = Instant.parse(xcp.text());
                            break;
                        }
                        if (xcp.currentToken() != XContentParser.Token.VALUE_NUMBER) continue block26;
                        created = Instant.ofEpochMilli(xcp.longValue());
                        break;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    created = null;
                    break;
                }
                case "modified": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        modified = null;
                        break;
                    }
                    if (xcp.currentToken().isValue()) {
                        if (xcp.currentToken() == XContentParser.Token.VALUE_STRING) {
                            modified = Instant.parse(xcp.text());
                            break;
                        }
                        if (xcp.currentToken() != XContentParser.Token.VALUE_NUMBER) continue block26;
                        modified = Instant.ofEpochMilli(xcp.longValue());
                        break;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    modified = null;
                    break;
                }
                case "description": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) break;
                    description = xcp.text();
                    break;
                }
                case "labels": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        String entry = xcp.textOrNull();
                        if (entry == null) continue;
                        labels.add(entry);
                    }
                    continue block26;
                }
                case "spec_version": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) break;
                    specVersion = xcp.text();
                    break;
                }
                case "feed_id": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) break;
                    feedId = xcp.text();
                    break;
                }
                case "feed_name": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) break;
                    feedName = xcp.text();
                    break;
                }
                default: {
                    xcp.skipChildren();
                }
            }
        }
        return new STIX2IOC(id, name, type, value, severity, created, modified, description, labels, specVersion, feedId, feedName, version);
    }

    public void validate() throws IllegalArgumentException {
        if (super.getType() == null) {
            throw new IllegalArgumentException(String.format("[%s] is required.", "type"));
        }
        if (super.getValue() == null || super.getValue().isEmpty()) {
            throw new IllegalArgumentException(String.format("[%s] is required.", "value"));
        }
        if (super.getFeedId() == null || super.getFeedId().isEmpty()) {
            throw new IllegalArgumentException(String.format("[%s] is required.", "feed_id"));
        }
    }

    public Long getVersion() {
        return this.version;
    }
}

