/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterInfo;
import org.opensearch.cluster.DiskUsage;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.RoutingPool;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.DiskThresholdEvaluator;
import org.opensearch.cluster.routing.allocation.DiskThresholdSettings;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.WarmNodeDiskThresholdEvaluator;
import org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.index.store.remote.filecache.AggregateFileCacheStats;
import org.opensearch.index.store.remote.filecache.FileCacheSettings;

public class WarmDiskThresholdDecider
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(WarmDiskThresholdDecider.class);
    public static final String NAME = "warm_disk_threshold";
    private final FileCacheSettings fileCacheSettings;
    private final DiskThresholdSettings diskThresholdSettings;
    private final boolean enableForSingleDataNode;
    private final DiskThresholdEvaluator diskThresholdEvaluator;

    public WarmDiskThresholdDecider(Settings settings, ClusterSettings clusterSettings) {
        this.fileCacheSettings = new FileCacheSettings(settings, clusterSettings);
        this.diskThresholdSettings = new DiskThresholdSettings(settings, clusterSettings);
        assert (Version.CURRENT.major < 9) : "remove enable_for_single_data_node in 9";
        this.enableForSingleDataNode = DiskThresholdSettings.ENABLE_FOR_SINGLE_DATA_NODE.get(settings);
        this.diskThresholdEvaluator = new WarmNodeDiskThresholdEvaluator(this.diskThresholdSettings, this.fileCacheSettings::getRemoteDataRatio);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        RoutingPool nodeRoutingPool = RoutingPool.getNodePool(node);
        RoutingPool shardRoutingPool = RoutingPool.getShardPool(shardRouting, allocation);
        if (nodeRoutingPool != RoutingPool.REMOTE_CAPABLE || shardRoutingPool != RoutingPool.REMOTE_CAPABLE) {
            return Decision.ALWAYS;
        }
        ClusterInfo clusterInfo = allocation.clusterInfo();
        Map<String, DiskUsage> usages = clusterInfo.getNodeMostAvailableDiskUsages();
        Decision decision = this.earlyTerminate(node, allocation, usages);
        if (decision != null) {
            return decision;
        }
        DiskUsage usage = usages.get(node.nodeId());
        long shardSize = DiskThresholdDecider.getExpectedShardSize(shardRouting, 0L, allocation.clusterInfo(), allocation.snapshotShardSizeInfo(), allocation.metadata(), allocation.routingTable());
        DiskUsage usageAfterShardAssigned = new DiskUsage(usage.getNodeId(), usage.getNodeName(), usage.getPath(), usage.getTotalBytes(), Math.max(0L, usage.getFreeBytes() - shardSize));
        long freeSpaceLowThreshold = this.diskThresholdEvaluator.getFreeSpaceLowThreshold(usage.getTotalBytes());
        ByteSizeValue freeSpaceLowThresholdInByteSize = new ByteSizeValue(freeSpaceLowThreshold);
        ByteSizeValue freeSpaceInByteSize = new ByteSizeValue(usage.getFreeBytes());
        ByteSizeValue freeSpaceAfterAllocationInByteSize = new ByteSizeValue(usageAfterShardAssigned.getFreeBytes());
        ByteSizeValue shardSizeInByteSize = new ByteSizeValue(shardSize);
        if (this.diskThresholdEvaluator.isNodeExceedingLowWatermark(usageAfterShardAssigned)) {
            logger.warn("after allocating [{}] node [{}] would have less than the required threshold of {} free (currently {} free, estimated shard size is {}), preventing allocation", (Object)shardRouting, (Object)node.nodeId(), (Object)freeSpaceLowThresholdInByteSize, (Object)freeSpaceInByteSize, (Object)shardSizeInByteSize);
            return allocation.decision(Decision.NO, NAME, "allocating the shard to this node will bring the node above the low watermark cluster setting [%s] and cause it to have less than the minimum required [%s] of addressable remote free space (free: [%s], estimated remote shard size: [%s])", DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), freeSpaceLowThresholdInByteSize, freeSpaceInByteSize, shardSizeInByteSize);
        }
        return allocation.decision(Decision.YES, NAME, "enough available remote addressable space for shard on node, free: [%s], shard size: [%s], free after allocating shard: [%s]", freeSpaceInByteSize, shardSizeInByteSize, freeSpaceAfterAllocationInByteSize);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (!shardRouting.currentNodeId().equals(node.nodeId())) {
            throw new IllegalArgumentException("Shard [" + String.valueOf(shardRouting) + "] is not allocated on node: [" + node.nodeId() + "]");
        }
        RoutingPool nodeRoutingPool = RoutingPool.getNodePool(node);
        RoutingPool shardRoutingPool = RoutingPool.getShardPool(shardRouting, allocation);
        if (nodeRoutingPool != RoutingPool.REMOTE_CAPABLE || shardRoutingPool != RoutingPool.REMOTE_CAPABLE) {
            return Decision.ALWAYS;
        }
        ClusterInfo clusterInfo = allocation.clusterInfo();
        Map<String, DiskUsage> usages = clusterInfo.getNodeMostAvailableDiskUsages();
        Decision decision = this.earlyTerminate(node, allocation, usages);
        if (decision != null) {
            return decision;
        }
        long leavingRemoteShardSize = this.calculateCurrentNodeLeavingRemoteShardSize(node, allocation);
        DiskUsage usage = usages.get(node.nodeId());
        DiskUsage usageAfterSubtractingLeavingShard = new DiskUsage(usage.getNodeId(), usage.getNodeName(), usage.getPath(), usage.getTotalBytes(), Math.min(usage.getFreeBytes() + leavingRemoteShardSize, usage.getTotalBytes()));
        long freeSpaceHighThreshold = this.diskThresholdEvaluator.getFreeSpaceHighThreshold(usage.getTotalBytes());
        ByteSizeValue freeSpaceHighThresholdInByteSize = new ByteSizeValue(freeSpaceHighThreshold);
        ByteSizeValue freeSpaceInByteSize = new ByteSizeValue(usageAfterSubtractingLeavingShard.getFreeBytes());
        if (this.diskThresholdEvaluator.isNodeExceedingHighWatermark(usageAfterSubtractingLeavingShard)) {
            logger.warn("less than the required {} of free remote addressable space threshold left ({} free) on node [{}], shard cannot remain", (Object)freeSpaceHighThresholdInByteSize, (Object)freeSpaceInByteSize, (Object)node.nodeId());
            return allocation.decision(Decision.NO, NAME, "the shard cannot remain on this node because it is above the high watermark cluster setting [%s] and there is less than the required [%s] free remote addressable space on node, actual free: [%s]", DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), freeSpaceHighThresholdInByteSize, freeSpaceInByteSize);
        }
        return allocation.decision(Decision.YES, NAME, "there is enough remote addressable space on this node for the shard to remain, free: [%s]", freeSpaceInByteSize);
    }

    private long calculateCurrentNodeLeavingRemoteShardSize(RoutingNode node, RoutingAllocation allocation) {
        List leavingRemoteShardsOnNode = StreamSupport.stream(node.spliterator(), false).filter(shard -> shard.primary() && RoutingPool.REMOTE_CAPABLE.equals((Object)RoutingPool.getShardPool(shard, allocation)) && shard.relocating()).collect(Collectors.toList());
        long leavingRemoteShardSize = 0L;
        for (ShardRouting shard2 : leavingRemoteShardsOnNode) {
            leavingRemoteShardSize += DiskThresholdDecider.getExpectedShardSize(shard2, 0L, allocation.clusterInfo(), allocation.snapshotShardSizeInfo(), allocation.metadata(), allocation.routingTable());
        }
        return leavingRemoteShardSize;
    }

    private Decision earlyTerminate(RoutingNode node, RoutingAllocation allocation, Map<String, DiskUsage> usages) {
        if (!this.diskThresholdSettings.isWarmThresholdEnabled()) {
            return allocation.decision(Decision.YES, NAME, "the warm disk threshold decider is disabled", new Object[0]);
        }
        if (!this.enableForSingleDataNode && allocation.nodes().getDataNodes().size() <= 1) {
            if (logger.isTraceEnabled()) {
                logger.trace("only a single data node is present, allowing allocation");
            }
            return allocation.decision(Decision.YES, NAME, "there is only a single data node present", new Object[0]);
        }
        ClusterInfo clusterInfo = allocation.clusterInfo();
        if (clusterInfo == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("cluster info unavailable for file cache threshold decider, allowing allocation.");
            }
            return allocation.decision(Decision.YES, NAME, "the cluster info is unavailable", new Object[0]);
        }
        AggregateFileCacheStats fileCacheStats = clusterInfo.getNodeFileCacheStats().getOrDefault(node.nodeId(), null);
        if (fileCacheStats == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("unable to get file cache stats for node [{}], allowing allocation", (Object)node.nodeId());
            }
            return allocation.decision(Decision.YES, NAME, "File Cache Stat is unavailable", new Object[0]);
        }
        if (usages.isEmpty() || !usages.containsKey(node.nodeId())) {
            if (logger.isTraceEnabled()) {
                logger.trace("unable to determine disk usages for disk-aware allocation, allowing allocation");
            }
            return allocation.decision(Decision.YES, NAME, "disk usages are unavailable", new Object[0]);
        }
        return null;
    }
}

