/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.config;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigDescription;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.config.core.dto.ConfigDescriptionDTO;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.io.rest.core.config.EnrichedConfigDescriptionDTOMapper;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="config-descriptions")
@RolesAllowed(value={"administrator"})
@SecurityRequirement(name="oauth2", scopes={"admin"})
@Tag(name="config-descriptions")
@Component
@JaxrsResource
@JaxrsName(value="config-descriptions")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class ConfigDescriptionResource
implements RESTResource {
    public static final String PATH_CONFIG_DESCRIPTIONS = "config-descriptions";
    private final ConfigDescriptionRegistry configDescriptionRegistry;
    private final LocaleService localeService;

    @Activate
    public ConfigDescriptionResource(@Reference ConfigDescriptionRegistry configDescriptionRegistry, @Reference LocaleService localeService) {
        this.configDescriptionRegistry = configDescriptionRegistry;
        this.localeService = localeService;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getConfigDescriptions", summary="Gets all available config descriptions.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConfigDescriptionDTO.class)))})})
    public Response getAll(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @QueryParam(value="scheme") @Parameter(description="scheme filter") @Nullable String scheme) {
        Locale locale = this.localeService.getLocale(language);
        Collection configDescriptions = this.configDescriptionRegistry.getConfigDescriptions(locale);
        return Response.ok((Object)new Stream2JSONInputStream(configDescriptions.stream().filter(configDescription -> scheme == null || scheme.equals(configDescription.getUID().getScheme())).map(EnrichedConfigDescriptionDTOMapper::map))).build();
    }

    @GET
    @Path(value="/{uri}")
    @Produces(value={"application/json"})
    @Operation(operationId="getConfigDescriptionByURI", summary="Gets a config description by URI.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ConfigDescriptionDTO.class))}), @ApiResponse(responseCode="400", description="Invalid URI syntax"), @ApiResponse(responseCode="404", description="Not found")})
    public Response getByURI(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="uri") @Parameter(description="uri") String uri) {
        Locale locale = this.localeService.getLocale(language);
        URI uriObject = UriBuilder.fromPath((String)uri).build(new Object[0]);
        ConfigDescription configDescription = this.configDescriptionRegistry.getConfigDescription(uriObject, locale);
        return configDescription != null ? JSONResponse.createResponse((Response.StatusType)Response.Status.OK, (Object)EnrichedConfigDescriptionDTOMapper.map(configDescription), null) : JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)("Configuration not found: " + uri));
    }
}

