/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of France by department (with DOM/TOM)
* Equirectangular projection

* @author CCM Benchmark Group
* @source http://fr.m.wikipedia.org/wiki/Fichier:France_location_map-Departements.svg
* @source http://commons.wikimedia.org/wiki/File:Guadeloupe_department_location_map.svg
* @source http://commons.wikimedia.org/wiki/File:Martinique_department_location_map.svg
* @source http://commons.wikimedia.org/wiki/File:Guyane_department_location_map.svg
* @source http://commons.wikimedia.org/wiki/File:La_R%C3%A9union_arrondissement_commune_map.svg
* @source http://commons.wikimedia.org/wiki/File:Mayotte_blank_map.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_departments_domtom : {
					width : 641.85596,
					height : 627.08588,
					getCoords : function (lat, lon) {
						if (lat < 43.213183 && lat > 40.780541 && lon > 7.611694 && lon < 11.21521) {
							// Corse
							var xfactor = 43.64246;
							var xoffset = 223.2912;
							var x = (lon * xfactor) + xoffset;
							
							var yfactor = -65.77758;
							var yoffset = 3346.37839;
							var y = (lat * yfactor) + yoffset;
						} else if (lat < 16.623033 && lat > 15.710307 && lon > -62.273712 && lon < -60.565338) {
							// Guadeloupe
							var xfactor = 86.761658287969;
							var xoffset = 5362.7633969916;
							var x = (lon * xfactor) + xoffset;
							
							var yfactor = -82.266584089643;
							var yoffset = 1657.41182763;
							var y = (lat * yfactor) + yoffset;
						} else if (lat < 15.060189 && lat > 14.263052 && lon > -61.699448 && lon < -60.455246) {
							// Martinique
							var xfactor = 108.86848400636;
							var xoffset = 6667.8264;
							var x = (lon * xfactor) + xoffset;
							
							var yfactor = -102.17420080747;
							var yoffset = 1888.497;
							var y = (lat * yfactor) + yoffset;
						} else if (lat < 6.479067 && lat > 1.241358 && lon > -55.823364 && lon < -49.308472) {
							// Guyane
							var xfactor = 14.877907532954;
							var xoffset = 811.95256630287;
							var x = (lon * xfactor) + xoffset;
							
							var yfactor = -13.494388491278;
							var yoffset = 512.14159;
							var y = (lat * yfactor) + yoffset;
						} else if (lat < -20.713731 && lat > -21.587212 && lon > 54.879227 && lon < 56.109695) {
							// La Reunion
							var xfactor = 81.213304068446;
							var xoffset = -4482.39787;
							var x = (lon * xfactor) + xoffset;
							
							var yfactor = -78.260903254801;
							var yoffset = -1124.8169;
							var y = (lat * yfactor) + yoffset;
						} else if (lat < -12.504962 && lat > -13.134316 && lon > 44.806137 && lon < 45.5793) {
							// Mayotte
							var xfactor = 193.03305111901;
							var xoffset = -8691.6961;
							var x = (lon * xfactor) + xoffset;
							
							var yfactor = -180.02792269821;
							var yoffset = -1714.16093;
							var y = (lat * yfactor) + yoffset;
						} else {
							var xfactor = 45.48385;
							var xoffset = 264.2620;
							var x = (lon * xfactor) + xoffset;
							
							var yfactor = -65.97284;
							var yoffset = 3371.10748;
							var y = (lat * yfactor) + yoffset;
						}
						return {x : x, y : y};
					},
					elems : {
						"department-29" : "m 79.08,156.06 c -1.58,0.96 -3.52,1.65 -4.18,3.32 -1.54,-1.47 -4.04,-0.62 -5.71,0.27 -1.47,0.32 -0.49,2.1 -0.47,1.93 -1.6,-0.37 -3.54,0.37 -4.65,0.74 1.4,-2.77 -2.5,-2.88 -3.96,-1.37 -0.64,0.11 -2,0.43 -1.03,1.29 -2.04,0.5 -3.83,0.84 -5.86,0.44 -2.03,0.42 1.54,3.29 -1.29,2.23 -2.56,-1.01 -1.43,1.5 -0.77,2.4 -1.28,-1.21 -3.93,-1.36 -5.32,-0.04 -1.98,0.41 -3.21,2.67 -3.29,4.58 0.74,1.03 1.43,1.8 -0.13,2.56 -1.57,2.24 1.62,4.41 -0.2,6.49 0.53,2.34 3.91,1.84 4.59,0.07 2.27,0.52 4.47,1.24 6.57,-0.42 2.6,-1.34 5.4,-2.14 8.2,-2.97 0.92,-0.31 4.11,-1.69 1.9,-0.23 -2.02,1.28 -5.21,1.77 -5.82,4.45 -0.04,1.77 1.95,-0.57 2.58,1.07 1.06,-1.01 2.42,-1.71 3.83,-1.44 1.47,-1.28 1.25,0.06 0.1,0.7 -1.8,1.75 1.83,1.26 2.72,1.94 0.36,-0.17 1.78,0.86 1.97,0.78 -1.65,0.15 -3.09,1.29 -4.38,-0.02 -2.31,0.21 -4.59,1.92 -6.68,-0.07 -1.48,0.7 -3.22,0.52 -4.59,0.14 -0.84,-0.95 1.41,-3.74 -0.99,-2.46 -1.64,0.71 0.56,4.29 -2.09,3.1 -1.86,1.31 1.58,2.51 2.68,1.96 0.19,1.21 -0.96,2.2 -0.02,3.55 0.11,1.13 -0.35,2.83 1.08,1.3 1.1,-1.67 1.83,-4.91 4.48,-3.39 1.97,1.62 5,1.13 6.02,3.61 1.13,1.38 1.67,5.92 -1.14,5.14 -2.19,-1.24 -4.56,0.15 -6.78,0.55 -3.6,0.94 -7.29,1.38 -10.96,1.98 -1.02,2.79 2.19,2.33 3.92,2.71 1.57,0.58 2.73,2.11 4.29,0.42 2.87,1.58 5.44,3.83 6.96,6.79 0.75,1.87 2.58,4.37 0.57,6.01 -0.49,2.41 3.46,1.3 4.97,1.91 1.77,0.5 6.3,-1.57 3.63,-3.11 -1.14,-1.39 0.13,-3.23 0.98,-1.08 2.15,0.54 2.07,-1.76 0.86,-2.78 -0.21,-2.37 1.06,2.22 2.48,2.04 1.3,-0.04 1.93,1.22 3.27,0.76 2.3,0.96 0.54,-4.28 3.09,-2.05 2.11,1.57 2.68,4.19 4.55,5.98 1.48,0.03 3.57,0.98 5.05,-0.31 1.53,-0.27 2.75,1.8 4.57,1.56 1.67,0.39 5.37,1.79 5.28,-1.08 -0.33,-0.95 -1.12,-4.41 0.67,-3.05 1.11,1.89 3,-0.89 3.37,-1.73 2.88,-0.06 0.29,-2.91 2.01,-4.24 -0.06,-1.23 -0.55,-3.52 -2.28,-2.02 -0.84,0.44 -1.59,1.51 -1.96,-0.17 -1.78,-2.26 -4.64,-1.49 -7.03,-1.61 -1.14,-1.47 -0.96,-3.67 -2.41,-4.88 -0.89,-0.99 -0.11,-2.5 -1.91,-2.72 -0.05,-3.01 2.9,-3.42 5,-4.43 1.33,-1.1 3.65,-1.15 4.52,-2.27 -2.34,-0.91 -0.87,-3.28 0.07,-4.45 0.11,-1.39 -2.08,-1.36 -0.72,-2.68 -1.8,-1.52 0.39,-4.93 -2.74,-5.09 -1.31,-1.84 1.47,-3.01 1.62,-4.29 -2.76,-0.9 -1.61,-3.9 0.3,-5.01 1,-1.97 -2.66,-1.17 -1.57,-3.2 -0.83,-0.98 -2.97,-1.21 -2.88,-3.24 -1.32,-1.42 2.01,-4.62 -0.58,-4.47 -2.05,-0.25 -3.74,-1.51 -5.9,-1.36 -3.15,-1.06 -2.02,4.36 -3.08,5.4 -1.21,-0.52 -1.97,-1.72 -2.2,-2.81 -1.19,0.54 -2.05,1.99 -2.27,-0.03 -0.68,-1.05 -0.41,-2.7 -0.9,-3.59 z m -9.89,28.67 0,0.02 0,-0.02 z",
						"department-22" : "m 119.49,146.68 c -2.18,0.97 -4.27,2.12 -5.29,4.34 -0.95,0.92 1.16,-5.14 -1.45,-3.45 -1.04,2.53 -4.54,0.81 -6.21,2.7 -2.17,3.05 -3.41,-2.37 -6.09,-0.78 -1.84,0.33 -1.12,2.45 -3.06,2.86 -0.93,1.49 3.49,3.66 0.09,3.84 -0.99,0.94 1.05,4.8 -1.59,3.12 -2.86,0.14 -2.28,4.13 -0.76,5.67 1.58,0.31 2.02,1.18 2.25,2.58 3.59,0.89 -0.69,2.85 -0.8,4.74 -0.19,1.54 3.69,2.37 0.82,3.38 -1.64,1.35 -0.95,3.36 0.92,3.66 0.67,1.38 -0.55,4.29 1.76,3.98 -2.43,1.29 1.74,2.99 -0.69,4.57 -2.49,1.29 2.63,3.82 -0.3,3.71 -1.55,1.32 2.18,0.56 2.94,0.57 1.46,0.08 3.07,-0.19 2.24,1.85 1.74,0.87 4.15,-2.24 5.79,0.1 2.53,1.33 5.13,-0.76 7.44,-1.05 -0.07,-2.83 2.97,-2.96 4.98,-2.15 1.17,1.09 1.64,3.35 3.83,2.16 2.41,-0.65 4.03,2.42 6.48,1.68 1.33,0.86 1.42,4.74 2.85,1.76 1.5,0.7 4.53,-2.42 4.34,0.86 -0.55,1.52 -1.36,5.2 1.47,4.11 2.29,-1.68 4.77,-4.11 4.24,-7.07 -0.17,-0.91 2.97,-0.79 4.03,-1.62 2.78,-0.38 2.35,4.77 5.02,3.26 1.87,-1.4 5.42,-1.88 4.9,-5.32 -0.17,-0.92 2.03,0.15 1.54,-1.54 -0.42,-3.1 4.04,-1.09 4.2,-3.33 1.07,-1.09 2.16,-1.68 3.46,-0.28 1.24,-0.4 3.67,-1.83 2.59,-3.76 2.38,-0.48 0.29,-2.82 1.12,-4.55 -1.48,-2.62 1.94,-4.38 1.02,-7.26 0.43,-1.82 -1.5,-2.45 -1.71,-0.37 -2.2,2.26 -0.48,-3.02 -3.17,-2.1 -1.23,2.3 -1.14,-1.92 -3.17,-0.97 -0.98,-0.96 -3.18,-4.56 -3.47,-1.26 -0.31,1.86 -1.28,-1.15 -2.1,0.76 -0.55,-1.37 -1.3,-3.44 -2.14,-4.22 -1.05,0.87 -3.98,2.87 -2.31,0.2 1.61,-1.33 -0.2,-4.18 -1.41,-1.8 -1.59,0.73 -2.87,2.57 -4.49,1.08 -0.75,-0.13 -2.86,0.56 -1.21,1.2 -1.01,2 -3.59,2.03 -4.94,3.57 -1.37,1.74 -2.78,3.56 -4.87,3.33 0.31,3.1 -2.74,0.01 -2.05,-1.5 -2.07,-1.61 -5.2,-2.78 -4.5,-6.08 -1.5,-2.13 -3.93,-3.34 -5.36,-5.64 0.92,-3.22 -2.97,-1.88 -4.28,-3.51 -0.56,-0.74 2.55,-2.62 -0.07,-2.81 -2.8,-0.54 -2.3,3.78 -4.01,4.18 1.22,-1.79 2.13,-3.93 1.68,-6.2 0,-0.43 -0.03,-1 -0.5,-1.17 z",
						"department-56" : "m 120.81,190.73 c -1.94,-0.55 -3.02,1.19 -3.32,2.68 -1.36,0.16 -3.14,0.43 -3.54,1.23 -2.04,-0.06 -4.21,0.3 -5.45,-1.31 -1.54,-0.04 -5.06,2.86 -4.22,-0.53 -2.27,-0.66 -5.71,-0.77 -8.22,0.11 -1.43,1.23 -3.91,0.97 -4.77,2.7 -0.84,1.02 -0.63,2.42 0.72,2.49 -0.58,2.34 2.19,3.23 2.17,5.7 0.84,2.78 4.02,0.06 5.87,1.57 1.77,0.29 2.14,3.21 3.85,1.26 2.68,-1.57 2.52,3.03 1.49,4.17 0.4,1.45 0.63,2.93 -1.21,2.52 -0.78,1.78 -2.57,3.33 -4.35,1.63 -0.71,1.41 0.92,3.01 0.11,4.5 0.76,1.87 1.77,4.54 4.01,4.83 1.75,0.33 3.97,-0.87 2.47,-2.27 1.59,0.45 3.32,-2.79 4.09,-2.37 -0.13,1.59 -3.63,3.31 -2.06,4.2 2.47,-0.22 3.67,4.18 5.74,3.23 -0.25,-2.41 3.75,-3.2 1.33,-5.38 0.07,-0.51 1.47,0.54 1.96,-0.28 -0.65,1.5 2.26,1.64 0.61,3.25 -2.17,0.5 -5.1,2.65 -2.61,4.88 2.69,1.08 0.71,4.47 1.4,6.67 -0.22,1.75 3.13,1.92 1.43,0.18 -0.99,-0.96 -1.05,-6.53 1,-4.23 -0.06,1.32 4.39,0.76 3.58,-1.19 0.28,-0.25 1.22,3.04 1.35,0.83 0.45,1.07 3.39,2.67 1.94,0.64 -0.85,-1.47 -0.62,-3.47 -1.08,-4.88 1.67,1.06 0.92,3.21 2.79,3.74 1.19,1.24 2.49,-1.47 3.23,-1.75 1.74,0.54 4.21,-2.37 4.43,0.28 -1.13,0.56 2.4,2.04 2.02,0.22 -0.01,-1.02 0.09,-1.73 0.67,-0.31 -0.1,1.85 -1.64,4.06 -2.99,4.91 -2.01,-1.25 -3.9,0.55 -5.73,-1.08 -2.41,-0.75 -1.23,1.46 0.27,1.86 1.28,1.49 2.28,3.99 4.73,2.34 1.58,-1.19 4.62,1.03 4.88,-1.51 0.94,0.16 2.08,0.04 1.57,-1.04 1.32,-0.16 3.01,-0.7 1.13,0.69 0.65,1.62 3.99,-0.92 5.57,0.45 1.17,1.48 3.82,0.62 4.76,1.25 -2.04,0.45 -6.31,-0.64 -5.17,2.8 1.29,2.36 2.7,-3.37 4.07,-0.44 1.93,0.09 4.49,0.48 4.4,-2.28 0.26,-2.08 2.4,-0.85 3.02,-0.28 1.19,-0.72 2.6,-0.92 3.1,0.38 1.27,-0.55 0.89,-2.94 2.87,-2.59 0.95,-1.62 0.02,-3.71 0.99,-5.4 -0.91,-2.18 -1.29,-4.25 -1.75,-6.53 -0.64,-2.04 4.94,-1.69 1.45,-3.01 -1.42,-0.25 -1.8,-0.76 -0.26,-1.41 1.13,-1 2.5,-2.47 2.53,-3.97 -0.25,-2.26 -3.18,1.26 -2.71,-1.36 -1.41,-2.18 2.13,-3.43 0.21,-5.37 -1.04,-2.62 -4.04,-3.26 -6.5,-3.55 -4.1,1.1 -0.69,-5.19 2.03,-3.93 2.53,-0.7 0.03,-2.75 -1.3,-1.26 -2.26,2.07 -0.48,-3.18 -2.49,-3.62 -1.69,-1.18 -3.96,2.78 -4.45,-0.51 -0.88,-2.88 -3.64,-2.28 -5.73,-1.36 -1.71,-0.04 0.3,2.93 -1.75,3.57 -0.42,2.33 -2.84,4.02 -5.03,4.48 -2.2,-1.32 0.8,-4.04 -0.38,-5.84 -1.09,-0.89 -2.57,1.32 -3.95,0.8 -0.6,1.22 -1.74,1.77 -1.66,-0.05 -0.3,-3.08 -3.64,-1.2 -5.07,-3.18 -1.77,-1.8 -5.24,1.48 -5.72,-1.83 -0.48,-0.8 -1.44,-1.22 -2.36,-1.15 z",
						"department-35" : "m 176.38,157.73 c -1.79,1.11 -3.53,0.47 -5.19,1.2 -1.33,0.27 -1.62,2.1 -2.81,2.9 0.05,2.01 1.92,3.29 3.11,4.44 -2.04,-0.42 0.14,2.8 0.43,2.54 2.26,-2.29 2.37,3.63 1.27,4.57 -0.5,1.49 -1.35,2.63 -0.35,4.25 -0.22,1.3 -0.35,2.43 -0.04,3.74 -2.27,0.25 0.23,4.32 -2.54,3.36 -1.03,2.76 -3.3,-1.55 -4.2,1.09 -1.51,0.08 -0.56,2.43 -2.4,1.45 -2.56,-0.92 -2.09,2.28 -2.86,3.26 -2.02,-0.51 -0.51,2.87 -2.09,3.58 0.04,1.26 -2.85,-0.24 -1.51,1.77 1.39,0.87 0.52,3.5 1.66,3.85 0.8,-2.11 5.06,-0.09 2.03,1.01 -2.2,-0.18 -4.48,1.41 -3.9,3.81 2.13,-0.64 4.29,0.65 6.29,1.06 1.85,1.48 4.01,4.45 1.52,6.21 0.13,1.33 0.54,3.97 2.03,1.74 0.85,-0.96 0.83,1.66 1.14,2.27 -1.24,1.06 -1.98,3 -3.23,3.72 0.94,0.47 3.63,1.86 1.11,2.27 -2.85,-0.1 -1.41,3.34 -0.8,4.76 -0.52,2.39 2.69,0.12 3.61,-0.42 1.4,-0.12 2.45,-2.68 2.96,-0.31 1.34,-1.32 3.51,-1.25 5.03,-2.26 1.96,0.36 3.88,0.31 5.79,0.36 2.01,-0.47 4.26,-1.06 4.48,-3.58 1.78,-2.07 5.05,-1.88 7.04,-3.39 -1.35,-2.84 2.62,-1.47 3.98,-1.02 0.91,1.88 2.98,2.02 4.75,2.59 2.4,1.02 2.04,-2.45 2.93,-3.79 -0.25,-1.23 1.5,-1.55 1.12,-3.1 1.75,-1.44 0.61,-4.32 2.53,-5.67 1.37,-2.06 5.64,0.76 5.31,-2.94 -0.57,-1.85 -0.29,-3.8 -1.39,-5.46 -0.19,-2.53 -1.34,-4.78 -1.48,-7.32 -0.32,-1.92 -1.4,-4.44 0.52,-5.93 1.68,-1.62 0.43,-4.09 0.5,-6.03 -1.88,-2.34 0.5,-5.07 -0.86,-7.48 -1.44,-1.4 -3.63,-0.64 -5.26,-1.79 -1.79,-0.97 -3.66,-0.48 -4.02,1.73 -2.41,0.32 -3.04,3.65 -5.62,3.17 -1.6,-0.55 -2.09,-2.02 -3.85,-2.34 -1.66,-2.38 -1.58,-5.06 -2.82,-7.53 -0.67,-1.47 -1.99,-2.34 -3.32,-0.83 -2.14,1.06 -4.77,0.58 -7.1,1 -1.98,0.31 -4.48,-1.05 -4.07,-3.29 0.37,-0.95 1.79,-2.33 0.58,-3.23 z",
						"department-44" : "m 193.97,215.27 c 0.99,2.76 -2.35,2.73 -4.17,3.59 -2.66,0.16 -2.98,3.09 -4.31,4.45 -2.35,0.63 -4.44,0.91 -6.99,0.76 -2.15,-0.63 -4.35,0.65 -6.27,1.56 -1.04,1.56 -1.13,-2.45 -2.03,0.05 -1.72,0.93 -4.02,1.21 -4.59,3.23 0.34,1.88 -0.7,4.08 -0.4,6.22 -1.94,0.02 -2.39,1.78 -3.16,2.88 -1.2,-0.61 -1.59,-1.83 -3.09,-0.48 -1.16,0.3 -2.43,-2.13 -3.07,0.2 0.15,3.01 -3.49,2.72 -5.16,2.01 -2.61,-1.24 -2.16,4.49 0.53,3.28 1.03,1.2 -1.5,0.54 -1.86,1.31 -1.01,-2.17 -4.48,0.9 -4.56,1.77 1.63,1.36 3.43,2.66 4.67,4.42 0.14,3.2 -5.01,-1.24 -4.06,0.8 1.77,0.74 4.56,3.32 5.4,0.87 3.12,-0.51 5.01,4.79 7.98,1.46 2.43,-0.5 2.59,-4.23 5.46,-3.42 2.69,0.13 5.46,-1.43 7.72,0.94 2.25,0.07 4.05,1.31 5.34,3.11 0.91,1.4 2.8,2.14 4.02,2.64 -2.49,0.83 -3.92,-1.91 -6.16,-2.3 -1.91,-0.02 -1.26,-3.9 -3,-1.99 -2.34,-0.79 -4.38,-1.45 -6.74,-0.44 -2.98,-0.51 -4.67,2.22 -3.22,4.83 1.49,2.66 -2.14,3.15 -3.24,4.48 1.94,1.83 5.67,0.78 7.83,2.79 2.09,1.48 3.32,3.8 5.11,5.5 1.66,1.54 2.79,4.05 5.52,3.88 0.35,2.79 4.79,0.06 4.47,3.39 1.99,1.6 5.23,1.31 7.84,2.31 1.6,-0.41 3.78,-1.49 1.54,-2.9 -1.42,-1.19 1.14,-1.61 -0.43,-2.99 -1.51,-2.22 -0.37,-5.47 2.31,-5.69 1.86,1.6 0.6,4.38 1.14,6.37 -0.22,2.18 2.65,-0.64 3.7,-0.62 2.3,-1.33 -1.55,-5.92 2.19,-5.98 2.4,1.91 1.59,-4.35 4.02,-2.02 0.94,1.64 5.78,4.52 5.68,1.05 -1.69,-1.46 -2.97,-3.11 -5.44,-2.61 0.4,-0.85 0.08,-3.42 2.02,-3.62 2.34,-1.56 0.48,-4.38 0.12,-6.39 -1.48,1.02 -4.02,-0.18 -3.76,-2.44 -0.58,-1.73 -5.08,-0.47 -2.26,-2.49 1.59,-1.77 4.11,-1.11 6.05,-2.15 2.13,-1.07 4.56,-0.9 6.87,-0.88 1.82,0.31 4.88,-0.51 5.17,-2.35 -1.77,-1.59 -0.36,-5.48 -2.9,-5.73 -2.27,-1.43 -5.44,0.19 -7.54,-1.62 -0.08,-1.39 -2.02,-3.92 0.75,-3.77 1.88,0.21 5.06,1.38 5.8,-1.13 -1.57,-1.12 -3.79,-1.48 -5.63,-2.26 -2.02,-1.5 -1.01,-4.7 -3.08,-6.15 -1.29,-0.55 -2.96,-1.14 -1.48,-2.62 -0.72,-2.53 -3.85,-1.67 -5.57,-2.98 -1.28,-1.9 -2.96,-1.98 -5.08,-2.16 z",
						"department-50" : "m 172.97,90.24 c -2.07,1.53 -0.36,4.39 2.01,4.33 2.23,1.05 2.23,4.31 1.5,6.32 -2.49,1.68 -0.72,3.57 0.41,5.36 0.96,2.16 0.92,4.76 1.49,7.06 2.08,-0.34 2.6,2.06 4.31,2.99 0.39,-2.34 1.98,0.5 0.35,0.85 1.8,1.66 2.25,4.29 3.32,6.43 1.02,-0.52 2.91,-1.19 3.39,0.25 -3.06,-1.2 -2.52,3.87 -1.05,4.87 0.73,1.01 -2.3,2.18 -0.88,4 0.9,1.35 -0.83,3.99 1.23,4.78 -0.29,-1.98 3.59,-1.36 2.48,-0.96 -2.19,-0.32 -2.45,4.5 -0.96,5.53 -1.49,1.88 -0.8,4.78 -2.52,6.74 2.86,1.4 0.29,5.39 2.64,7.16 1.57,2.06 3.28,4.73 6.22,4.43 1.27,0.62 2.96,2.13 0.43,1.44 -2.01,-0.05 -4,1.31 -6.05,0.58 -1.76,-0.81 -2.44,0.6 -0.88,1.63 1.59,2.18 0.84,5.01 2.7,7.1 1.82,0.95 4.56,4.48 6.48,1.53 1.1,-1.94 3.7,-1.74 4.11,-4.23 2.92,-0.15 5.61,1.83 8.58,2.02 1.72,0.13 4.33,2.59 5.31,-0.25 1.6,-0.43 3.29,2.69 4.73,0.17 1.79,-2.33 5.26,-4.48 4.41,-7.86 -2.52,-1.41 2.5,-3.67 -0.56,-4.17 -1.01,-1.35 -2.54,-2.12 -3.75,-2.8 0.98,-1.88 0.32,-1.87 -1.3,-1.4 -1.86,-0.88 -3.53,-2.28 -5.52,-1.07 -1.72,-0.75 -4.29,1.03 -4.56,-1.88 -0.53,-1.15 -4.21,-1.56 -1.57,-2.94 0.85,-1.21 2.09,-2.09 3.13,-2.14 1.23,-0.88 3.6,-3.68 0.36,-2.84 -2.11,-0.29 0.71,-3.93 2.3,-2.27 2.97,0.56 5.15,-3.99 6.13,-5.23 -1.18,-1.18 1.35,-4.41 -1.04,-5.18 -1.33,0.99 -1.4,0.33 -0.12,-0.43 0.98,-1.5 -4.79,-2.72 -1.17,-3.43 1.97,-1.3 0.32,-4.53 -1.35,-2.1 -2.46,1.86 -4.81,-1.98 -6.83,-3.15 -1.71,-1.47 -2.01,-3.8 -0.68,-5.52 -1.44,-0.32 -1.37,-2.04 -3,-1.43 1.82,-3.14 -1.03,-5.44 -2.84,-7.69 -1.07,-2.07 -3.6,-4.17 -2.55,-6.7 1.49,-0.46 1.61,-1.78 2.84,-2.54 0.64,-1.58 -0.92,-6.17 -3.88,-5.59 -2.22,-0.46 -4.6,-0.58 -6.75,0.28 -0.7,2.48 -3.4,2.49 -5.44,2.63 -3.16,0.33 -5.74,-2.16 -9.07,-2.07 -1.72,-0.12 -2.64,-2.58 -4.49,-1.55 -0.68,-0.32 -1.12,-1.27 -2,-1.09 z",
						"department-53" : "m 250.43,167.05 c -1.48,0.64 0.52,2.25 -1.16,2.95 -0.62,1.58 -2.87,-1.26 -3.42,1.02 -1.11,2.61 -2.89,-1.22 -4.88,-0.62 -1.86,0.66 -3.75,0.55 -4.92,2.47 -1.67,0.11 -2.98,1.43 -4.56,1.7 -0,-0.93 -0.72,-2.83 -1.71,-1.31 -1.02,-0.25 -2.58,-0.07 -1.39,1.11 -0.7,1.44 -2.8,1.16 -2.97,-0.51 -0.93,-0.24 -1.58,0.59 -1.84,-0.91 -0.54,-2.95 -3.75,-0.28 -4.79,-2.55 -1.76,-0.88 -2.02,2.68 -4.05,1.2 -0.83,-1.53 -3.43,-1.06 -2.46,0.87 0.79,1.99 -1.24,3.98 0.58,5.81 0.03,1.6 0.47,3.25 0.35,4.84 -1.21,1.42 -2.79,3.36 -1.75,5.31 0.7,2.08 0.5,4.35 1.34,6.4 0.4,1.57 0.15,3.54 1.52,4.68 -0.23,1.58 0.13,3.02 0.41,4.5 -0.72,2.52 -3.82,0.3 -4.95,1.8 -1.68,0.68 -1.53,2.85 -1.98,4.42 -1.1,1.4 -0.71,2.99 -2.08,4.04 -0.63,1.85 -0.62,3.45 1.5,4.19 1.52,0.93 3.22,-0.53 4.89,0.59 1.77,-0.16 3.69,1.38 5.24,0.39 0.04,-0.44 -1.01,-1.58 0.4,-1.61 1.96,-0.16 3.71,3.93 5.34,1.69 1.66,-0.01 3,1.38 4.58,1.75 1.73,-0.17 3.38,0.48 5.08,0.41 1.39,-0.73 2.39,-1.68 4.12,-1.29 0.92,-0.52 0.37,-2.89 2.1,-1.58 1.13,1.17 2.48,1.5 3.75,0.31 1.86,1.33 1.39,-2.7 -0.35,-1.77 -2.77,-0.87 -0.56,-4.13 1.59,-3.91 1.26,-1.84 -2.98,-2.22 -0.87,-4.05 1.36,-1.46 4.26,-0.04 4.99,-2.24 -0.67,-1.37 -0.97,-3.06 -2.24,-4.19 -0.67,-2.38 2.11,-2.12 3.51,-2.95 1.43,0.64 1.89,-0.63 1.18,-1.71 1.08,-1.06 0.63,-2.14 -0.59,-2.92 -0.43,-1.86 1.41,-2.63 2.83,-3.42 1.68,-0.78 2.11,-2.73 1.01,-4.16 0.22,-1.71 1.79,-3.35 0.3,-4.93 -0.1,-1.37 1.2,-1.42 1.27,-2.7 1.03,-1.28 3.88,-0.1 3.47,-2.54 -0.24,-1.26 0.73,-4.38 -1.59,-2.94 -1.71,0.29 -3.1,-0.59 -3,-2.39 -0.79,-1.07 -0.58,-1.92 0.12,-2.77 -0.95,-1.08 -2.33,-2.44 -3.94,-2.47 z",
						"department-49" : "m 205.08,217.19 c -1.18,1.34 -0.17,3.69 -0.83,4.93 2.27,0.31 3.68,1.93 3.4,4.32 0.74,1.76 1.95,3.14 3.9,3.44 1.2,0.67 5.14,0.95 2.67,2.81 -1.93,1.61 -5.69,-1.32 -6.65,0.88 1.25,1.23 -0,3.54 2.56,3.58 2.25,-0.35 4.28,0.25 6.34,0.77 1.77,0.37 0.41,3.54 1.94,4.82 1.61,2.05 -1.56,3.22 -3.17,3.43 -2.32,0.16 -4.68,-0.31 -6.99,0.19 -2.41,1.91 -6.11,0.8 -8.14,3.29 -1.09,1.76 2.5,-0.27 2.68,1.66 0.14,2.12 2.06,3.62 3.86,2.62 0.8,1.57 1.34,3.82 1.06,5.38 -1.2,1.4 -3.34,1.88 -2.71,4.16 0.72,0.64 3.4,0.54 3.92,2.25 2.05,0.21 1.21,2.03 0.51,3.05 1.72,0.35 4,1.99 5.59,0.79 1.3,-0.91 2.55,1.31 4.05,0.67 1.14,1.3 2.62,2.86 4.09,0.94 1.5,-0.57 2.53,-1.38 4,-0.32 1.92,0.34 3.86,-0.6 5.93,-0.18 1.85,-0.7 3.4,-2.43 2.94,-4.29 1.33,-1.58 3.85,-1.83 5.2,-0.48 2.04,0.28 2.19,-2.53 4.47,-1.57 2.07,-0.07 3.9,-1.31 6.05,-0.45 0.98,-0.69 4.58,-0.52 2.23,0.97 -1.16,1.22 1.27,1.45 1.92,1.65 1.06,-1.12 0.89,-3.7 3.14,-2.26 1.72,-0.1 -0.18,-2.9 1.53,-3.76 0.74,-1.38 1.74,-1.63 3.04,-1.02 0.6,-1.69 0.8,-4.01 1.09,-5.98 0.39,-2.25 1.51,-4.37 3.05,-5.85 0.04,-1.46 2.67,-2.28 0.68,-3.7 2.11,-1.35 0.62,-4.46 2.53,-6.06 1.44,-1.95 -1.93,-3.05 0.09,-4.79 1.5,-1.31 0.7,-3.73 -1.17,-3 -0.47,1.97 -2.41,2.07 -3.44,0.58 -2.14,0.02 -4.28,-0.68 -5.29,-2.73 -1.9,0.31 -4.55,-2.19 -5.5,0.66 -2.13,0.1 -5.9,-3.02 -3.11,-4.67 0.74,-2.21 -1.66,-0.27 -2.52,-0.24 -1.73,-0.72 -3.69,-0.73 -5.37,-0.8 -0.12,-1.57 -1.06,-4.34 -3.07,-2.91 -1.54,1.26 -3.95,-3.41 -4.05,-0.15 -0.66,1.75 -3.44,-0.21 -4.19,1.85 -2.42,0.03 -5.18,0.03 -7.38,-0.82 -1.2,-0.54 -2.64,-2.05 -3.49,-0.32 -1.94,0.29 -3.57,-3.69 -5.22,-1.92 0.7,2.49 -3.33,0.71 -4.68,0.7 -2.12,-1.24 -4.45,0.62 -6.23,-1.32 -0.47,-0.18 -0.77,-0.77 -1.3,-0.8 z",
						"department-85" : "m 203.14,265.2 c -1.29,0.55 -0.63,4.25 -2.79,2.52 -3.72,-0.05 0.46,5.03 -2.32,6 -1.71,0.9 -4.92,2.71 -3.75,-0.74 -0.77,-1.25 0.63,-5.83 -2.21,-4.6 -2.25,0.79 -1.99,3.94 -0.77,5.59 0.49,1.21 -0.59,2.86 1.15,3.65 -0.7,2.16 -3.36,2.13 -5.21,1.21 -1.87,-0.4 -4.06,-0.39 -5.42,-1.59 0.72,-3.29 -4.07,-0.68 -4.27,-3.18 -1.48,-0.82 -3.82,-0.41 -4.2,-2.74 -1.34,-0.8 -2.63,-4.08 -4.33,-1.69 -1.04,2.02 -1.04,4.61 -3.57,5.42 -0.99,1.76 -2.24,3.32 -1.95,5.45 -0.02,2.5 2.59,3.67 4.25,5.05 1.48,1.04 2.73,2.47 3.2,4.25 1.93,0.88 2.87,2.41 3.95,4.13 1.35,1.69 2.62,3.66 2.78,5.77 0.54,1.46 0.09,4.8 1.7,4.95 0.11,-0.77 -0.23,-3.26 0.53,-1.26 0.82,1.68 2.7,2.29 4.06,3.41 1.2,0.95 3.56,-0.2 2.69,2.06 2,0.84 5.23,-0.67 6.76,1.65 0.84,1.71 0.96,5.42 3.81,3.73 2.06,-1.27 3.22,2.04 4.61,1.55 0.61,-0.76 2.33,3.53 3.44,2.54 -0.14,-2.55 2.59,-3.24 4.52,-2.45 0.96,-0.72 2.22,-0.11 2.9,-1.77 1.71,-1.01 4.12,-1.12 6.02,-1.8 -0.43,1.18 -1.66,4.19 0.87,3.32 1.55,-0.59 2.75,-0.38 3.68,-1.53 1.96,-0.54 1.66,1.98 3.78,2.11 1.38,0.67 2.24,-2.21 3.79,-0.61 1.88,-0.77 2.8,-3.16 5.12,-3.36 1.55,-1.43 -2.69,-3.8 -3.05,-1.73 -2.47,-0.7 0.99,-3.66 -0.04,-5.28 -0.62,-1.47 -1.63,-3.71 0.64,-4.05 -0.38,-1.92 -0.88,-3.69 -0.78,-5.74 -0.4,-1.4 -2.25,-0.42 -1.12,-2.18 0.1,-1.5 -1.88,-1.99 -0.63,-3.56 -1.5,-1.8 -4.17,-4.06 -2.14,-6.51 -0.53,-1.57 -3.62,-1.66 -4.26,-3.82 -2.25,-1.31 0.4,-4.46 -2.79,-5.12 -0.94,-0.55 -0.85,-1.56 -1.77,-2.27 0.29,-2.31 -3.25,-0.99 -4.2,-2.57 -2.18,1.69 -4.98,-0.18 -7.34,-0.86 -2.12,-0.58 -3.47,-2.41 -5.38,-3.38 z",
						"department-79" : "m 253.29,263.54 c -1.9,1.4 -4.42,-0.79 -6.39,0.88 -1.77,0.1 -3.37,-0.04 -4.52,1.59 -1.1,-0.38 -2.38,0.66 -3.13,0.43 0.43,-0.68 1.3,-1.98 -0.38,-1.35 -1.39,0.15 -3.84,1.42 -2.47,3.05 -1.35,1.52 -2.83,3.5 -5.18,2.53 -2.04,1.17 -4.12,-0.04 -6.24,-0.17 -1,1.07 -5.16,1.37 -3.16,3.19 0.99,1.24 3.17,1.93 1.88,3.78 0.61,2.43 2.8,3.99 5.04,4.95 0.97,0.91 -2.03,3.98 0.75,4.67 0.24,1.6 2.42,2.54 1.39,4.21 0.87,0.83 1.53,1.78 0.85,2.79 2.6,1.36 0.58,4.6 2.17,6.68 -0.35,1.33 -2.8,1.22 -1.28,3.06 1.15,1.77 0.54,3.41 -0.36,5.16 -0.03,1.27 0.82,2 1.29,0.48 1.8,0.1 4.49,2.13 1.79,3.39 -2.52,0.17 -3.23,4.03 -6.1,2.61 -0.62,0.88 -1.55,0.87 -2.21,1.69 1.44,1.37 -1.24,3.6 1.39,4.06 1.58,0.53 1.51,2.11 1.62,3.12 0.95,0.76 3.36,1.11 3.25,2.26 -0.36,1.35 3.34,-0.59 4.11,1.21 0.81,2.16 3.21,1.99 4.74,1.78 -0.07,2.22 2.52,-0.29 2.98,1.67 1.65,0.06 3.38,-0.76 4.01,1.29 1.23,1.5 3.45,0.03 4.05,2 1.38,0.14 2.11,5.42 4.96,3.43 1.32,-0.87 1.04,-2.55 1.89,-3.73 -1.18,-2.58 3.69,-0.48 3.95,-3.1 1.49,-1.66 3.43,-1.45 5.38,-0.4 1.09,-0.79 1.11,-2.8 1.8,-4.12 -0.51,-0.9 -2.39,1.06 -2.88,-0.91 -1.18,-1.14 -3,-2.03 -1.15,-3.7 1.11,-1.26 -0.75,-3.57 1.83,-3.49 -0.01,-1.18 -0.81,-2.23 0.27,-3.23 -0.16,-2.4 -3.66,-1.6 -3.63,0.54 -1.06,0.82 -3.12,-0.6 -3.44,-1.48 0.12,-1.63 0.92,-3.28 -1.29,-3.95 -1.11,-1.47 1.15,-4.73 -1.4,-5.24 -0.29,-1.91 0.73,-3.22 1.99,-4.37 -2.16,-1.96 2.84,-2.73 0.62,-4.49 -1.94,0.11 -0.17,-2.89 -2.06,-1.46 -1.23,1.34 -2.11,0.14 -0.85,-0.95 0.77,-1.61 1.86,-3.1 2.31,-4.74 2.63,-0.9 0.25,-2.24 -0.99,-3.11 -1.11,-1.46 2.59,-3.91 -0.63,-3.4 -1.65,-1.13 1.38,-2.76 2.34,-1.54 0.89,-1.96 -3.65,-1.7 -1.73,-3.96 1.2,-2.11 -2.1,-3.76 -0.83,-5.72 -0.94,-0.65 -3.3,0.24 -2.38,-1.85 0.26,-1.51 -0.38,-3.38 -2.01,-2.92 -0.87,-0.96 -2.94,-0.24 -1.18,-1.94 0.94,-0.85 -0.01,-1.13 -0.76,-1.15 z",
						"department-17" : "m 217.6,312.65 c -1.84,1.26 -4.74,0.43 -5.82,2.93 -3.26,0.02 0.75,5.13 -3.08,5.46 -1.82,1.05 -3.67,4.16 -2.16,5.83 3.16,-0.44 2.82,3.27 4.64,4.77 0.18,1.52 3.73,5.29 0.16,5.07 -2.63,-0.06 1.74,2.72 0.24,4.11 1.31,1.55 0.24,3.47 -1.37,3.28 -0.47,1.76 -2.35,1.77 -1.16,3.85 0.65,3.56 3.84,5.45 6.35,7.58 -3.27,-0.53 -4.85,-4.05 -7.2,-5.24 -3.39,-0.91 -3.86,2.38 -3.85,4.87 -0.67,3.03 2.88,0.23 3.7,2.81 2.22,1.16 4.24,2.78 6.34,4.1 1.78,2.01 2.94,4.4 5.81,5.18 3.78,3.01 6.99,7.1 7.78,11.99 0.56,3.54 5.81,1.95 6.95,1.47 0.01,4.14 4.06,2.06 6.41,3.27 2.17,2.13 0.33,5.42 2.08,7.81 0.55,1.04 2.15,-1.22 3.17,0.59 2.59,1.32 4.26,4.43 7.61,4.27 1.79,-0.22 2.73,-3.46 4.39,-0.78 1.6,0.17 0.61,-2.99 2.57,-3.42 -1.15,-1.7 2.02,-4.74 -1.4,-5.46 -1.72,-0.9 -4.82,0.24 -3.56,-2.92 -1.65,-1.15 -5.1,-2.98 -7.28,-1.18 -1.7,-1.21 -0.34,-3.33 1.01,-3.25 -1.01,-0.41 -4.35,-2.02 -1.41,-3.08 4.04,-0.74 -0.9,-3.55 0.29,-5.24 2.78,-1.4 -0.17,-3.49 -1.97,-3.85 0.54,-1.16 0.82,-3.06 -1.22,-3.75 -1.22,-0.97 -2.15,-2.45 -3.77,-2.12 -0.83,-2.06 2.94,-2.03 0.8,-3.75 -1.67,-1.68 1.38,-4.73 -2.1,-4.12 -1.14,-1.61 2.57,-2.09 3,-2.94 2.83,1.31 6.06,-3.85 7.55,0.37 2.5,-0.03 4.14,-1.65 3.95,-4.23 2.26,-1.56 -3,-6.08 1.31,-5.78 2.43,-1.76 -2.86,-4.22 -3.1,-6.4 -0.89,-1.13 -2.92,-1.22 -4.38,-2.07 -0.46,-2.85 -4.16,0.03 -5.16,-2.19 -1.77,1.38 -1.56,-1.91 -3.02,-0.26 -2.94,0.03 -3.68,-4.37 -6.95,-2.85 -1.79,0.23 -0.39,-2.12 -2.38,-2.04 -2.85,-0.5 -0.44,-3.57 -3.28,-4.13 -2.19,-1.12 0.4,-4.54 -2.49,-5.7 -1.04,-0.75 -2.84,-2.02 -3.29,0.09 -1.72,-0.29 -6.44,1.18 -4,-2.05 0.3,-0.52 -0.12,-1.19 -0.75,-0.9 z m -24.49,7.34 c -1.76,0.06 -3.91,0.97 -2.05,2.71 2.45,1.55 5.98,0.45 8.22,3 1.27,1.33 6.27,1.64 3.42,-0.9 -1.66,-2.42 -5.98,-1.21 -6.95,-3.15 -0.71,1.19 -4.31,0.67 -2.99,-0.41 1.53,0.61 1.74,-1.02 0.36,-1.25 z m 4.27,13.73 c -0.39,1.9 1.91,3.6 0.91,5.68 1.13,2.53 4.43,3.24 5.46,5.94 0.77,1.92 1.81,6.42 3.22,2.22 1.27,-2.59 -0.12,-4.72 -1.86,-6.47 0.15,-2.4 -0.84,-4.47 -3.47,-4.54 -1.38,-0.97 -2.47,-2.62 -4.26,-2.83 z",
						"department-33" : "m 212.23,365.55 c -2.25,1.99 -3.58,5.1 -3.5,8.15 -0.48,6.34 -0.21,12.79 -1.81,19.01 -1.2,6.71 -1.28,13.55 -2.24,20.29 -0.55,4.81 -1.07,9.63 -1.29,14.47 1.23,-0.88 0.55,-4.8 2.58,-6.25 0.81,-2.73 2.88,-3.44 4.55,-0.79 1.78,1.59 5.07,5.75 0.47,5.79 -1.94,0.32 -4.77,-1.94 -5.13,1.38 0.08,2.79 -3.04,4.55 -1.87,7.42 -0.19,1.92 0.44,3.68 2.54,2.07 1.96,-0.65 4.4,-1.08 5.25,-3.29 1.7,1.54 6.09,0.9 4.35,4.35 -1.31,1.72 -1.23,3.36 1.1,2.16 2.41,-1.65 4.54,1.54 7.07,0.66 2.04,-1.79 4.82,-1.37 7.2,-2.07 2.14,1.02 0.38,4.77 3.76,4.82 2.4,1.03 3.03,4.5 6.31,3.86 0.26,2.06 3.45,2.85 1.72,5.32 0.16,3.32 4.8,3.01 7.16,2.67 0.85,-1.14 -0.06,-5.96 2.72,-3.86 1.14,3.7 6.45,1.09 6.39,-2.06 -0.87,-1.75 -3.6,-4.5 0.23,-4.76 2.61,0.03 2.25,-2.07 1.2,-3.57 0.98,-2.48 -1.62,-4.82 0.6,-7.19 0.97,-0.41 -1.14,-2.07 0.8,-1.26 2.8,-0.36 2.94,-3.1 5.39,-4.18 0.75,-0.98 -0.87,-2.51 1.15,-1.83 2.03,-2.79 -3.17,-1.59 -2.89,-4.39 1.49,-0.65 2.39,-3.49 4.34,-2.47 0.8,2.3 0.77,-3.52 2.69,-0.93 3.55,0.05 -1.96,-5.21 2.07,-5.39 0.81,-2.71 -3.55,-2.43 -4.02,-0.2 -1.5,2.45 -4.94,-0.24 -6.43,1.16 -1.54,-0.78 -3.3,-1.57 -4.69,-2.31 2.46,-1.42 2.92,-4.21 1.62,-6.51 1.22,-2.79 2.27,-5.57 2.86,-8.49 -0.47,-3.29 -4.26,-2.07 -5.82,-1.24 -2.38,-2.83 -4.14,2.63 -6.96,0.15 -2.07,-0.72 -3.48,-3.21 -4.99,-3.39 -0.47,-1.38 -2.82,-1.38 -2.86,0.26 -2.21,-2.81 -0.45,-6.52 -2.48,-8.97 -2.12,-1.28 -6.84,0.93 -6.35,-3.12 -0.56,-0.81 -2.47,1.65 -3.9,0.51 -4.02,-1.34 -1.32,4.43 -1.47,6.61 0.58,4.02 0.27,9.07 3.89,11.76 1.46,0.51 5.57,1.77 4.45,3.1 -0.84,-1.43 -5.06,-1.9 -2.37,0.24 1.43,1.74 0.49,4.83 0.74,7.16 -1.4,-2.45 0.49,-6.18 -2.52,-7.82 -3.29,-2.45 -5.47,-6.22 -5.77,-10.32 -0.44,-5.63 -1.57,-11.98 -6.4,-15.58 -1.63,-2.01 -3.19,-4.12 -5.8,-4.87 -2.26,-1.42 -3.53,-3.7 -3.19,-6.14 l -0.44,-0.12 -1e-5,0 z",
						"department-40" : "m 211.63,434.01 c -0.88,2.78 -4.35,2.73 -6.63,3.62 -2.29,2.19 -1.4,6 -2.23,8.89 -1.09,9.88 -3.29,19.6 -4.84,29.41 -1.98,7.87 -2.8,16 -5.05,23.81 0.78,0.34 2.29,-0.61 2.4,0.94 1.77,2.15 4.21,1.4 6.52,1.13 2.72,0.08 5.34,-5.21 7.45,-1.24 0.66,1.02 -2.82,1.78 -0.23,1.71 1.62,-0.88 2.95,-2.22 4.61,-0.81 2.13,0.81 2.17,-1 2.51,-2.09 2.22,0.81 4.4,-1.16 6.48,-0.59 1.37,-0.53 2.73,-1.91 4.06,-1.6 0.71,1.02 1.88,2.78 2.65,0.96 1.37,-0.3 2.88,-1.9 2.52,0.17 1.29,1.75 2.72,0.05 3.91,0.22 1.75,0.81 3.22,-3.04 5.39,-2.7 1.1,0.82 -1.72,3.26 0.69,2.29 2.4,-1.36 5.37,1.52 7.01,-1.79 1.8,-0.28 0.89,-2.4 -0.38,-2.37 -0.4,-1.67 2.51,-2.23 1.29,-4.09 -0.26,-2.14 3.63,-3.05 1.8,-4.71 0.02,-1.67 -1.11,-3.61 0.81,-4.38 -0.22,-1.33 -0.28,-2.98 -0.1,-3.94 -1.71,-0.35 -2.36,-1.86 -0.35,-2.35 1.14,-1.91 4.01,-1.35 4.94,-1.5 1.19,-0.68 2.39,-2.18 3.2,-2.59 1.87,0.5 1.31,2.46 1.04,3.37 1.52,2.87 4.93,1.18 2.99,-1.52 0.64,-1.77 -0.12,-3.59 0.34,-5.4 0.9,-1.7 1.78,-4.03 2.74,-5.56 -1.79,-1.38 -4.54,-0.49 -6.35,-2.14 -1.77,-0.8 -5.3,0.84 -5.49,-1.72 0.43,-2.38 -1.12,-4.52 -2.82,-5.97 -3.27,-0.62 0.42,5.16 -3.41,4.58 -2.05,-0.55 -6.77,0.13 -5.8,-3.38 0.92,-3.14 -2.53,-5.21 -5.13,-5.8 -0.94,-2.8 -4.11,-3.04 -5.91,-4.73 1.49,-2.15 -1.37,-4.17 -3.17,-2.51 -2.51,-0.88 -3.72,1.98 -6.15,1.56 -2.14,-0.36 -4.17,-2.04 -6.33,-0.57 -1.46,0.77 -2.93,0.16 -1.14,-1.21 1.22,-1.85 1.02,-5.05 -1.81,-4.31 -0.68,-0.36 -1.21,-1.1 -2.05,-1.08 z",
						"department-64" : "m 253.08,495.83 c -2,1.04 -4.74,-0.18 -6.01,2.43 -1.83,0.83 -4.01,-1.78 -5.87,0.35 -2.14,-0.15 1.69,-3.43 -1.31,-2.29 -1.72,0.92 -3.2,3.27 -5.05,2.6 -1.93,1.79 -4.46,-2.9 -6.02,0.1 -1.21,0.67 -2.59,-3.58 -3.87,-0.99 -1.9,0.48 -3.02,1.48 -5.04,0.99 -1.22,1.54 -4.29,-0.35 -4.01,2.46 -2.05,1.04 -4.85,-1.67 -6.51,0.99 -2.62,0.87 -1.01,-1.51 -0.15,-1.65 -1.55,-3.22 -4.26,-0.34 -6.12,0.88 -2.56,0.13 -5.57,1.61 -7.61,-0.63 -1.28,-2.51 -3.58,-0.07 -4.93,1.39 -1.68,1.56 -1.95,4.32 -4.29,5.23 -1.69,1.55 -7.65,0.48 -5.65,3.85 1.87,0.86 1.46,4.39 4.19,2.52 2.6,-0.58 2.27,2.2 3.07,3.56 2.76,1.38 2.1,-3.66 4.79,-2 1.78,1.78 5.83,-0.05 5.9,3.24 0.24,2.43 -0.82,4.76 -1.66,6.98 -1.29,1.67 -3.56,3.41 -1.06,5.31 1.51,1.31 5.27,2.04 4.58,-1.17 -0.71,-1.55 2.39,-4.31 2.69,-2.51 -2.06,1.66 0.03,4.01 2.16,3.67 2.46,-0.03 4.04,2.64 6.26,2.53 1.72,1.34 4.05,1.09 5.39,2.88 1.73,1.93 4.52,0.85 6.74,1.66 1.99,-0.16 4.84,-2.29 5.07,1.23 -0.81,2.07 0.71,3.43 2.64,3.64 1.79,1.33 2.98,3.14 4.2,4.85 0.76,1.05 1.54,2.12 2.46,0.37 1.16,-3.48 4.69,1.83 6.98,-0.79 1.19,-1.54 3.59,-1.6 2.64,-4.14 -1.03,-1.8 -0.6,-3.29 1.27,-4.13 -0.06,-1.84 -0.98,-4.37 1.02,-5.5 -0.26,-2.35 3.4,-0.37 2.36,-2.95 -0.31,-2.04 0.54,-3.46 2.39,-4.54 0.43,-1.68 1.02,-3.07 2.85,-2.84 0.96,-1.29 0.1,-2.97 1.75,-3.52 1.05,-1.34 1.15,-3.03 0.08,-4.32 -0.45,-2.45 2.51,-1.81 2.96,-3.2 -2.11,-1.84 6.8e-4,-4.66 -1.62,-6.53 -0.58,1.27 -2.64,3.57 -2.38,0.71 -1.29,-2.3 2.87,-1.95 0.97,-3.91 0.18,-1.68 -0.41,-3.23 -2.26,-3.82 0.91,-3.32 -2.94,-1.29 -3.99,-2.95 z",
						"department-65" : "m 258.87,495.01 c -1.8,0.45 -2.71,3.79 -0.53,4.11 1.77,0.93 0.39,3.3 1.83,4.37 0.55,1.29 -2.73,1.07 -1.69,3.08 0.25,0.94 0.45,1.82 1.16,0.54 0.58,-2.18 2.68,-0.96 1.96,0.87 -0.78,1.76 0.67,3.31 0.88,4.8 -1.18,0.79 -3.45,1.09 -2.97,3.25 1.84,0.97 0.47,2.73 -0.2,4.04 -1.24,0.64 -1.12,1.93 -1.22,3.11 -0.94,1.24 -2.53,-0.25 -2.72,1.72 0.07,2.18 -3.15,2.41 -2.66,4.5 -0.68,1.38 0.99,2.95 -1.24,3.19 -1.81,-0.68 -0.82,2.19 -2.52,2.42 -0.96,1.75 1.62,4.4 -1.13,5.25 -1.17,1.23 0.36,3.01 0.21,4.58 0.8,1.85 3.23,1.8 4.32,3.39 0.8,1.59 2.23,-0.11 3.02,0.33 -0.62,1.62 1.47,2.52 1.69,4.01 0.86,0.9 2.31,1.15 2.69,2.42 1.83,1.45 3.74,-0.36 5.61,-0.57 1.93,-0.42 3.77,-1.28 5.69,-1.71 1.44,0.78 3.77,0.94 3.81,3.05 2.26,2.18 2.08,-2.59 4.38,-1.99 1.13,1.17 3.69,3.06 4.86,0.92 0.05,-1.39 -2.26,-1.55 -1.25,-3.19 -0.22,-2.37 -0.2,-4.87 0.34,-7.22 0.73,-2.56 2.86,1.18 4.3,-0.6 0.98,-1.36 0.62,-3.51 2.12,-4.58 1.31,-0.6 1.39,-2 -0.03,-2.4 0.03,-1.09 0.59,-3.36 -0.97,-3.56 -0.63,0.87 -1.91,1.13 -2.65,1.85 -1.08,-1.05 0.13,-2.67 1.04,-3.22 0.21,-2.09 -2.27,-2.58 -3.33,-3.84 -1.96,0.05 -2.5,-2.39 -0.65,-3.33 1.23,-0.71 1.83,-1.97 1.86,-3.25 1.21,-0.24 3.67,-0.39 1.95,-2.06 0.27,-1.44 2.07,-2.08 2.89,-3.27 0.91,-1.83 -2.55,-2 -3.76,-2.58 -1.99,0.18 -3.51,-0.82 -5.41,0.06 -1.34,-0.5 -1.51,-2.58 -3.28,-1.26 -1.44,0.45 -0.65,-1.85 -2.21,-1.81 -0.4,-2.08 -2.74,1.08 -4.13,0.33 -2.05,0.24 -1.11,-2.25 -2.96,-2.59 -1.61,-1.44 2.14,-2.79 -0.22,-3.78 -0.78,-1.39 -0.54,-3.64 -2.7,-3.29 -1.46,-0.69 -3.44,-1.95 -3.82,-3.87 -0.18,-1.35 -0.76,-2.57 -2.37,-2.22 z",
						"department-32" : "m 288.27,463.87 c -1.29,2.88 -5.54,-0.03 -6.53,2.83 -2.1,1.77 -4.73,1.22 -6.76,2.71 -2.08,0.01 -3.65,-3.12 -5.28,-0.69 -0.65,1.86 -1.87,2.55 -2.45,0.62 -2.23,0.44 -3.98,2.37 -2.44,4.62 0.2,3.15 -4.13,0.87 -4.04,-0.76 1.98,-1.15 -1.31,-3.92 -1.89,-1.48 -1.36,0.88 -2.15,2.45 -3.74,1.44 -1.57,0.41 -4.14,1.3 -4.17,2.91 0.97,-0.06 2.74,1.66 1.14,2.06 0.79,1.55 0.47,3.45 -0.69,4.12 -0.33,1.98 2.19,4.36 -0.39,5.45 -1.98,1.42 0.37,4.44 -2.43,5.48 -0.36,1.6 2.15,0.8 1.49,2.46 1.11,1.33 3.15,-0.5 4.55,0.81 2.47,0.88 3.36,-2.49 5.61,-1.44 1.48,1.25 1.16,3.81 3.05,4.84 1.38,1.57 4.44,0.46 4.1,3.43 0.41,1.3 2.59,2.38 0.49,3.44 -0.77,1.59 2.39,1.82 1.93,3.46 1.71,1.66 4.03,-1.49 5.43,-0.11 0.89,0.66 1.16,0.72 1.51,1.88 0.95,0.42 3.1,-1.28 2.93,0.92 1.2,1.27 2.65,-0.98 4.02,0.37 2.43,-0.64 4.57,1.51 7.02,0.99 2.24,-0.37 2,-4.01 4.18,-4.04 1.03,-0.83 0.9,-3.94 2.81,-1.95 1.67,-0.83 3.88,-0.75 5.67,0.16 0.91,0.99 2.37,1.43 2.94,2.48 1.63,-0.76 -0.23,-3.24 1.96,-3.58 -0.57,-1.08 1.48,-2.6 -0.18,-3.46 1.15,-0.97 1.84,-2.38 1.86,-3.53 -0.42,-0.91 -0.08,-1.57 1.15,-1.23 1.38,1.18 1.14,-1.56 2.7,-0.84 0.63,-1.52 3.1,-0.22 2.48,-2.27 -0.36,-1.83 -2.79,-0.23 -2.57,-2.49 -0.17,-1.58 -3,0.32 -2.23,-1.91 -0.65,-0.14 -2.95,-1.22 -1.53,-2.55 -1.72,-1.15 -3.17,-2.62 -4.32,-4.47 -0.48,-1.49 -1.52,-2.14 -3.01,-1.39 -0.71,-1.1 1.95,-3.14 -0.25,-3.59 0.81,-1.67 -1.08,-2.65 -0.29,-4.38 -0.98,-1.15 -2.92,-0.66 -3.92,-1.45 -1.92,0.99 -2.66,-1.19 -0.98,-2.08 1.33,-1.27 2.11,-2.83 1.82,-4.55 2.78,0.11 0.11,-2.62 -1.08,-1.05 -0.99,1.3 -2.3,0.73 -2.1,-0.79 -1.98,-1.77 -2.94,2.84 -4.5,1.59 -0.79,-1.18 -1.59,-2.56 -3.04,-2.99 z",
						"department-47" : "m 271.96,418.57 c -1.12,0.17 -0.25,3.43 -1.56,2.13 -0.12,-1.86 -1.95,-0.02 -2.75,0.4 0.3,1.16 -2.76,1.33 -0.91,2.6 1.11,0.19 1.02,1.52 2.48,1.01 1.44,0.91 -1.06,2.5 -1.16,2.87 0.87,2.1 -3.36,1.97 -3.04,4.31 -0.66,1.32 -2.9,0.04 -3.03,2.12 -1.51,1.15 -1.7,3.22 -0.57,4.79 -0.06,1.23 -0.68,3.09 0.66,4.34 0.53,2.27 -2.81,1.42 -4.05,2.53 -0.97,1.63 2.06,2.63 1.76,4.47 -0.3,1.56 -1.81,2.75 -3.19,3.37 -2.65,-0.34 -0.6,2.88 -1.03,4.38 0.2,1.7 3.06,0.37 4.41,0.96 1.72,-0.01 2.85,1.6 4.55,1.55 1.81,-0.34 4.32,0.7 1.99,2.38 -0.96,1.79 -1.89,3.83 -2.27,5.81 0.22,2.19 2.26,0.91 3.36,0.51 0.07,1.08 1.01,2.13 1.44,0.5 0.34,-1.77 2.69,-2.84 3.77,-1.09 1.32,0.59 2.76,1.15 3.51,-0.33 2.29,0.11 4.79,-0.64 5.96,-2.66 1.88,-1.17 4.15,0.6 5.62,-1.44 2.19,-1.4 2.89,4.16 4.68,2.54 0.43,-1.77 3.28,-1.53 2.93,-3.79 0.32,-1.72 2.95,-1.12 2.06,-3.19 1.14,-1.2 3.78,2.21 4.38,-0.3 1.24,-1.76 -3.16,-1.93 -0.81,-3.08 1.93,0.3 2.44,-1.55 2.52,-3.12 0.05,-1.54 1.51,-2.6 -0.28,-3.7 -1.98,0.07 -2.65,-1.77 -1.25,-3.07 -0.66,-1.59 0.89,-4.03 2.16,-1.84 1.2,1.74 3.18,-0.6 4.87,0.23 1.47,-0.35 0.02,-2.38 0.66,-3.42 -0.74,-1.17 -2.3,-1.84 -1.81,-3.5 -0.48,-1.52 -0.18,-3.09 -1.47,-4.38 -0.18,-1.56 2.07,0.06 2.6,-1.44 2.23,-0.92 0.96,-3 -0.85,-3.42 -1.18,-0.9 -2.23,-2.62 -3.97,-1.72 -1.77,0.61 -3.79,4.09 -5.24,1.39 -0.45,-1.44 1.52,-3.01 0.24,-4.21 -0.07,-1.53 -1.75,-1.43 -2.24,-0.4 -1.76,-0.02 -3.9,1.47 -5.57,0.14 -0.23,-1.37 -1.47,-1.6 -2.08,-0.75 -2.02,-0.91 -2.07,3.29 -4.06,1.27 -2.06,-0.28 -3.79,2.48 -6,1.62 -1.2,-0.36 -2.8,-0.51 -1.91,-2.17 -0.29,-1.56 -0.32,-3.45 -1.85,-4.63 -1.22,-0.69 -2.63,0.81 -3.68,-0.58 z",
						"department-31" : "m 331.94,474.41 c -0.68,0.65 -2.04,2.77 -2.82,1.13 -0.88,2.48 -3.19,1.97 -4.86,0.96 -1.55,0.64 0.14,3.12 -2.36,2.15 -2.62,1.13 3.36,0.73 1.4,2.64 -2.36,0.26 -4.4,3.11 -6.6,2.58 0.49,-1.28 -1.93,-1.55 -2.71,-2.73 -1.22,0.52 -1.81,1.77 -3.2,0.33 -1.05,1.35 -6.99,0.28 -4.9,3.26 0.78,2.42 4.54,2.76 3.97,5.34 -0.09,1.59 2.59,0.57 1.65,2.48 1.45,-0.15 2.71,0.29 2.75,2.12 2.32,-0.79 3.22,3.38 0.42,2.98 -1.39,0.96 -2.79,2.36 -4.28,1.51 0.22,1.09 -0.93,1.69 -0.19,2.71 -1.11,0.93 -2.4,1.92 -1.3,3.09 -0.14,2.56 -2.24,3.13 -1.86,5.78 -2.28,0.29 -4.39,-4.08 -7.67,-2.82 -1.04,1.59 -3.69,-1.72 -3.56,1.11 -0.58,1.85 -2.79,1.41 -3.13,3.65 -0.59,1.85 -3.45,1.26 -2.47,3.26 -1.18,1.3 -4.05,2.49 -2.64,4.6 -0.87,1.17 -3.36,0.31 -2.75,2.32 -1.12,1.46 -4.76,3.78 -1.19,4.89 1.76,1.02 4.67,2.8 3.25,4.87 -1.93,-0.23 -0.85,3.7 0.66,1.16 1.54,-2.36 3.15,1.07 2.12,2.64 2.91,2.01 -2.1,3.83 -1.61,6.44 -0.51,3.59 -5.61,-1.51 -4.9,2.82 -0.14,2.5 -0.78,5.34 0.25,7.58 1.24,3.62 5.19,1.02 7.98,1.92 3.26,1.27 1.96,-3.08 1.03,-4.36 0.62,-1.99 -0.29,-6.25 2.86,-6.17 1.7,0.86 4.26,1.66 5.76,1.11 -0.71,-2.27 -2.75,-5.86 1.03,-6.34 -1.09,-3.05 4.04,-1.13 4.86,-3.68 1.59,-2.04 -2.43,-4.11 0.13,-6.26 -0.81,-1.7 0.87,-1.98 1.83,-1.32 0.73,-1.18 0.32,-3.34 2.23,-2.27 1.75,-1.87 3.08,0.31 4.93,0.54 0.53,2.35 2.71,3.78 3.84,1.06 2.13,-2.4 -4.92,-1.82 -2.12,-4.62 2.26,-0.73 5.88,-0.6 6.67,-3.04 -2.12,-0.9 -5.62,-3.08 -2.33,-5.25 2.22,-1.02 3.41,2.55 4.45,3.89 -1.26,3.63 4.83,2.74 3.18,-0.17 -0.66,-2.09 0.67,-2.84 2.04,-1.38 0.62,-0.24 1.37,1.65 1.76,0.04 1.29,0.26 2.91,1.86 3.3,2 -0.08,-2.66 3.01,-1.81 3,-4.31 0.95,-0.61 0.18,-3.05 2.37,-2.38 3.88,1.33 0.45,-3.77 3.27,-4.97 0.71,-2.95 3.03,-0.09 2.95,1.61 0.84,-2.74 2.97,-1.34 4.82,-1.25 2.66,-0.87 -1.09,-3.1 1.33,-4.44 1.35,-1.72 -1.4,-1.69 -1.32,0.06 -3.27,-0.12 -6.63,-2.75 -7.58,-6.09 -2.53,-0.55 -4.6,-2.3 -6.81,-3.45 -0.35,-1.68 3.27,-3.34 0.1,-4.24 -2.17,-0.28 -1.16,-1.19 0.22,-1.63 -1.37,-1.37 -2.63,-3.29 -2.73,-5.55 -2.67,-0.65 -2.91,-3.64 -4.05,-5.72 -0.33,-0.56 0.35,-2.12 -0.45,-2.2 z",
						"department-09" : "m 322.92,514.38 c -1.77,0.4 -2.94,3.3 -0.65,3.69 0.7,1.03 3.58,1.14 1.86,3.03 -1.64,0.33 -2.71,1.95 -4.64,1.54 -1.89,-0.39 -3.09,2.26 -0.83,2.67 1.66,-0.15 3.01,2.02 0.99,2.72 -0.68,2.28 -3.15,1.38 -3.15,-0.7 -0.68,-1.52 -2.7,-0.7 -3.49,-2.07 -1.08,0.33 -2.25,1.04 -3.22,1.13 -0.35,1.11 -0.94,2.81 -2.25,1.6 -1.04,0.77 0.24,2.1 -1.03,2.67 0.22,1.6 -0.02,2.82 1.46,3.85 -1.2,1.52 -2.44,3.34 -4.76,3.2 -1.68,0.25 -0.31,2.63 -2.49,2.42 -1.74,0.55 -0.02,2.81 -0.14,4.1 0.4,1.71 1.5,2.9 3.14,3.63 1.28,1.78 3.03,-0.34 4.47,1.26 1.71,0.48 3.77,0.08 5.28,1.2 1.52,0.96 0.78,4.18 3.21,3.77 1.81,-0.79 3.72,-0.27 5.61,-0.23 2.02,-0.71 2.59,1.67 3.84,2.55 1.12,1.34 1.05,3.21 2.01,4.57 1.28,1.48 2.35,-0.4 1.84,-1.7 0.69,-1.31 2.63,-0.58 3.96,-1.11 1.28,1.07 2.71,2.2 4.62,1.91 1.34,0.06 3.85,0.03 3.23,1.91 1.39,1.64 3.87,0.78 5.6,0.4 0.57,-1.18 1.04,-2.03 2.43,-1.43 2.19,-0.08 1.97,-2.4 3.35,-3.3 1.93,0.29 3.8,-0.94 5.79,-0.67 2.41,1.1 1.93,-2.4 0.1,-2.73 -1.56,-0.61 -2.08,-3.47 -3.93,-2.56 -1.44,1.17 -3.66,1.47 -5.14,0.19 -1.07,-0.5 -1.37,-1.28 -0.85,-2.24 -0.1,-1.78 -3.17,-1.91 -2.42,-3.56 0.61,-1.93 2.84,-1.17 4.26,-1.83 1.6,-0.65 1.66,-3.22 0.62,-4.39 -0.97,-0.41 -2.71,-1.29 -0.83,-2 2.76,-0.51 0.39,-3.41 1.32,-5 -0.68,-0.84 -2.9,-1.37 -1.24,-2.6 -0.05,-1.47 -0.56,-4.85 -2.61,-3.33 -0.79,0.58 -0.86,-2.17 -2.27,-1.43 -2.03,-0.09 -3.76,-1.13 -5.2,-2.44 -2.44,-0.46 0.31,-2.65 -1.41,-3.86 0.06,-1.13 -1.42,-3.48 -2.14,-1.49 0.2,1.29 -1.12,2.4 -1.32,0.58 -1.06,-0.88 -2.39,-0.86 -3.16,-0.3 -0.26,-1.49 -2.18,-0.32 -2.38,-1.78 -1.84,1.01 1.46,4.57 -1.48,4.45 -1.21,1.62 -3.37,-0.84 -2.43,-2.29 -0.86,-1.43 -2.29,-3.16 -3.57,-4 z",
						"department-11" : "m 364.67,505.18 c -2.13,0.57 -0.5,5.91 -3.1,3.75 -1.18,-2.85 -4.84,2.36 -5.84,-1.19 -0.72,-2.31 -2.46,1.34 -4.11,0.01 -1.54,-1.46 -2.33,0.39 -3.24,1.32 -0.23,-2.27 -2.22,-3.92 -3.16,-1.34 -0.87,0.24 -0.11,1.72 -1.21,2.06 0.19,1.45 0.78,3.37 -1.49,2.79 -1.58,-0.53 -2.15,0.63 -2.04,1.83 -1.91,1.64 -1.47,4.24 -0.24,6.18 -1.51,2.59 2.3,3.14 3.91,4.46 1.21,1.16 1.88,-1.15 2.65,0.26 0.85,0.87 1.08,1.73 2.47,1.06 2.01,0.75 2.09,4.03 1.21,5.02 1.15,0.71 2.39,1.61 1.5,3.23 0.51,1.05 0.43,2.71 0.87,3.4 -0.81,-0.18 -3.39,-0.39 -2.43,1.11 2.63,0.22 2.7,4.54 0.47,5.37 -1.52,0.14 -4.84,0.47 -3.84,2.7 1.13,0.78 3.33,2.21 1.92,3.7 1.87,2.17 4.61,1.92 6.79,0.49 1.87,0.67 3.2,2.9 4.9,4.16 0.29,0.77 -0.16,3.39 1.45,1.94 1.38,-0.49 2.35,-2.61 3.38,-2.8 3.23,0.6 4.2,-2.76 3.22,-5.18 -1,-1.8 -1.38,-4.7 1.64,-4.23 2.53,0.91 4.78,-0.22 7.3,0 2.09,0.41 4.19,0.48 6.29,0.79 2.21,0.79 3.75,-1.13 4.22,-3.06 1.17,-1.13 3.59,-3.15 5.13,-1.71 1.3,1.3 3.27,1.87 4.83,2.84 2.13,1.52 2.74,-1 3.21,-2.43 1.53,0.97 2.52,-0.65 1.16,-1.76 -1.63,-0.06 -2.17,-3.46 -0.29,-3.05 -1.3,1.16 0.16,3.32 0.83,1.11 0.3,-2.15 1.05,-4.2 1.74,-6.14 -1.37,-0.71 -2.48,-2.26 -1.53,-4.08 1.34,-0.99 2.05,0.82 0.7,1.33 0.45,2.19 2.18,0.91 2.38,-0.59 1.25,-2.32 3.34,-4.41 3.85,-6.98 -1.33,-0.95 -2.17,-3.73 -4.1,-2.48 -1.39,-1.53 -3.64,-0.52 -5.08,-2.29 -1.5,0.01 -2.47,-0.48 -2.27,-2.29 -0.9,-0.95 -2.71,0.72 -3.86,-0.6 -1.23,0.03 -1.77,-2.07 -2.64,-0.37 -2.69,-0.21 -2.48,2.66 -3.84,4.4 -1.5,0.6 -4,-1.25 -3.43,-3.05 -1.03,-1.38 -1.67,1.6 -3.23,1.07 -1.96,0.44 -1.2,-3.61 -3.62,-3.11 -0.54,-1.58 0.14,-3.86 1.72,-4.64 -1.11,-1.36 -3.4,-0.89 -4.89,-1.84 -2.41,-0.21 -4.21,2.14 -6.37,0.2 -1.15,-1.01 -2.86,-0.43 -3.9,-1.36 z",
						"department-34" : "m 432.7,471.05 c -2.82,-0.14 -2.25,3.63 -4.4,4.07 -0.29,0.95 -1,-1.31 -1.64,0.37 -0.78,1.08 -1.92,2.21 -0.58,3.39 -2.08,0.97 -3.74,-1.02 -4.09,-2.84 -1.14,-0.13 -3.63,3.31 -3.65,1.04 1.22,-2.84 -3.28,-3.08 -4.4,-1.13 -1.75,0.05 -4.91,0.28 -4.14,3.06 0.95,2.61 -3.7,2.79 -5.44,1.81 -1.4,-1.16 -3.24,-1.07 -3.01,1.18 -0.18,1.32 1.24,2.87 -0.14,4.1 0.62,1.44 0.83,4.11 -1.5,2.93 -1.9,-1.31 -4.89,0.21 -4.99,2.34 -1.72,1.38 -4.21,1.07 -5.84,2.58 -2.33,1.39 -3.2,-2.96 -5.88,-1.82 -1.89,1.46 -1.49,4.46 -1.28,6.39 1.29,1.33 2.44,2.57 1.32,4.41 1.34,2.71 -4.55,3.16 -3.17,5.55 -2.06,0.53 -2.79,4.64 -0.22,4.68 0.67,1.57 1.43,3.54 3.44,2.14 0.87,-0.94 2.1,-1.99 2.01,0.2 -0.23,2.17 4.03,3.61 3.93,0.59 0.87,-1.62 1.23,-2.77 3.32,-2.78 0.52,-0.56 0.15,-1.94 1.19,-0.69 1.08,2.09 3.49,1.31 5.46,1.68 -0.68,2.83 2.73,2.14 4.22,3.63 1.57,-0.33 2.27,0.99 3.74,0.84 1.91,-0.49 2.74,4.36 5.08,2.19 1.74,-1.58 3.52,-3.11 5.56,-4.28 2.08,-1.06 5.06,1.34 5.96,-1.86 1.13,-1.74 2.55,-3.33 3.97,-4.83 1.92,-0.8 3.82,-1.56 5.35,-3.04 1.04,-0.77 4.27,-2.56 3.43,-3.18 -1.77,0.69 -2.9,2.96 -5.05,2.64 1.32,-1.08 3.94,-1.46 4.39,-3.59 0.26,-2.07 3.24,-1.87 3.8,-3.93 1.83,-0.89 3.79,-1.45 5.59,-2.45 1.64,-0.59 3.36,-1.29 4.82,-0.11 1.99,-0.35 3.46,-2.78 3.21,-4.68 -1.27,-1.69 -0.88,-4.7 -3.08,-5.47 -1.53,-1.23 -3.1,-2.35 -4.35,-4.13 -1.06,-0.92 -3.71,0.85 -2.61,-1.68 0.56,-1.97 -2.51,-1.31 -2.62,-3.3 -1.43,-0.22 -5.49,1.8 -4.76,-1.4 1.23,-1.42 0.75,-2.79 -0.76,-3.44 -0.43,-1 -1.11,-1.45 -2.17,-1.2 z",
						"department-81" : "m 359.19,455.89 c -1.24,0.24 -2.02,1.77 -3.38,0.73 -0.69,1.71 -3.3,3.28 -5.4,2.41 -0.74,-0.67 -2.67,-1.24 -1.55,0.37 0.82,2.02 -3.8,-1.25 -3.34,1.36 0.38,1.63 -0.72,1.03 -1.43,0.3 -0.84,0.63 -0.81,2.22 -2.19,0.95 -1.44,-1.04 -5.85,-1.1 -4.27,1.46 0.11,1.41 3.03,2.31 1.06,3.87 -1.23,1.12 -2.01,1.89 -2.86,3.1 0.34,2.74 -4.32,-0.4 -3.44,2.06 2.73,0.69 -1.07,2.95 0.38,4.74 0.88,1.51 1.48,3.18 2.48,4.54 2.88,0.12 0.73,4.16 3.26,4.85 1.98,0.94 -0.25,1.71 -0.44,2.57 2.04,-0.73 3.51,2.48 1.2,3.08 -1.14,2.35 3.3,2.73 4.5,4.17 2.38,0.09 2.85,2.45 4.03,4.06 0.87,1.61 2.98,1.66 4.45,2.53 1.8,0.75 0.62,-2.46 2.55,-1.47 1.25,1.58 -2.69,3.47 0.16,4.91 0.99,1.3 1.91,3.29 3.93,1.96 1.54,-1.93 2.44,0.44 3.73,0.95 0.93,-1.18 0.33,-4.6 2.6,-4.31 1.41,0.67 3.33,0.91 4.74,1.99 1.78,0.44 3.3,-1.4 5.17,-0.9 1.54,0.64 3.34,1.46 4.91,0.39 1.22,-0.65 2.59,-2.15 3.13,-2.65 -0.33,-1.9 0.49,-4.09 -1.57,-5.36 -0.53,-1.92 -0.32,-3.95 0.58,-5.89 -0.09,-1.86 1.73,-0.34 2.84,-0.57 1.58,0.89 2.61,3.14 4.45,1.26 1.61,-1.09 4.13,-1.06 5.32,-2.39 0.59,-1.44 0.99,-3.85 -0.49,-4.76 -1.98,0.54 -4.15,-2.78 -5.43,-0.2 -1.74,1.58 -4.42,0.13 -5.92,-1.2 -1.42,-1.69 -2.72,-3.5 -3.97,-5.32 -0.55,-1.32 0.7,-2.87 -0.75,-3.75 0.39,-1.89 -1.34,-2.52 -2.26,-3.46 1.77,-1.58 -0.69,-2.74 -0.77,-4.43 -0.71,-1.73 -1.99,-2.21 -3.41,-2.94 -0.34,-2.1 -2.74,-2.51 -3.91,-4.01 -1.94,0.92 -1.58,-2.85 -3.76,-1.03 -0.66,0.37 -4.1,-0.27 -1.82,-0.67 1.81,-0.19 1.01,-1.96 -0.39,-1.15 -1.14,-0.52 -1.76,-1.54 -2.72,-2.18 z",
						"department-82" : "m 312.42,443.09 c -1.85,0.35 -3.17,2.62 -5.25,1.73 -1.31,0.31 -3.12,1.69 -3.39,-0.58 -1.85,-1.31 -1.54,1.91 -1.84,2.96 -1.51,2.17 2.33,1.55 2.57,3.25 0.14,1.45 -1.01,2.7 -0.91,4.2 -0.18,1.5 -1.64,1.79 -2.73,1.91 -0.4,1.36 2.31,1.1 1.29,2.87 -0.69,2.88 -3.06,-1.07 -4.32,0.62 0.27,1.88 -2.73,1.75 -2.46,3.87 -0.08,1.54 1.73,3.67 2.9,1.71 1.59,-0.94 3.41,1.43 1.09,1.85 -0.3,1.55 -0.72,3.28 -2.18,4.36 -1.31,0.8 -0.5,2.46 0.88,1.8 1.48,0.54 4.3,0.38 4.37,2.38 -1.39,1.17 1.42,2.31 0.11,3.38 2.45,0.26 -1.28,3.57 1.16,3.57 1.53,-0.26 3.03,-0.4 4.54,-0.83 1.5,-0.03 2.94,-0.98 4.33,-0.39 1.72,-1.84 2.75,0.75 4.3,1.37 0.62,2.12 2.45,-0.75 3.6,-1.1 1.05,0.29 3.83,-1.05 2.33,-2.01 -1.07,0.24 -2.88,-1.04 -1.08,-1.54 1.5,0.63 1.84,-0.51 1.75,-1.66 1.52,-1.46 3.2,1.71 4.64,0 0.34,-0.97 0.79,-2.21 1.85,-0.92 1.01,-0.76 2.19,-1.88 3.44,-2.1 0.16,-1 -2.71,-1.99 -0.62,-2.44 1.42,0.34 3.08,0.13 3.26,-1.5 0.94,-1.43 3.31,-2.29 2.99,-4.29 -1.03,-0.91 -2.94,-3.11 -1.21,-4.28 1.76,-0.32 3.92,0.31 5.18,0.83 0.24,-0.94 1.53,-1.71 2.13,-0.62 0.26,-0.94 -0.03,-2.34 1.31,-1.95 1,0.01 3,0.87 2.07,-0.86 0.94,-1.23 3.05,1.85 3.73,-0.21 -0.48,-1.19 -1.31,-1.59 -2.38,-1.25 -1.19,-0.82 -2.47,-2.21 -0.73,-3.34 0.67,-0.96 3.24,-2.01 1.62,-3.28 -1.47,-0.16 -3.76,0.07 -3.85,-2.02 0.3,-1.67 -1.47,-1.72 -2.41,-1.39 -1.2,-0.06 -1.8,1.13 -3.07,0.52 -2.21,1.6e-4 -3.26,2.16 -4.91,3.07 -1.59,0.61 -1.69,-3.16 -3.08,-0.88 -0.64,1.32 1.69,3.08 -0.62,3.77 -2.48,0.74 -1.35,-3.54 -3.97,-2.95 -1.02,1.31 -2.31,2.59 -3.9,3.31 -0.62,1.21 -2.03,1.25 -2.75,0.08 -1.64,-0.11 -2.61,-1.41 -1.42,-2.74 0.53,-1.63 -1.23,-1.76 -1.97,-0.58 -1.85,0.92 -3.12,-1.07 -4.35,-2.05 -1.7,-0.39 -2.62,-2.06 -3.35,-3.41 0.21,-0.9 3.8,-1.37 1.31,-2.21 z",
						"department-12" : "m 386.76,407.29 c -2.14,1.63 -3.73,3.58 -5.5,5.09 -0.63,2.34 -1.06,4.46 -2.66,6.12 0.54,2.68 -1.96,3.67 -2.92,5.73 -0.72,3.27 -5.18,2.39 -7.34,1.7 -0.99,-2.01 -4.94,-0.46 -5.6,1.1 0.39,3.12 -3.63,4.97 -6.27,3.58 -1.56,0.66 -4.41,2.04 -5.81,4.16 -1.53,0.58 -1.54,2.78 -2.62,0.91 -0.33,1.64 -3.19,1.04 -1.91,3.21 0.19,2.54 2.65,4.88 2.26,7.04 -2.82,1.15 -0.92,5.48 1.94,4.37 2.33,0.28 0.7,3.17 -0.71,3.12 -2.55,2.45 0.53,3.56 2.39,3.84 0.67,3.04 3.2,-0.06 4.12,-0.85 1.68,0.29 3.86,-1.68 4.96,0.75 0.55,1.26 3.76,0.06 1.86,2.06 -0,1.48 4.12,-1.22 3.8,1.61 2.5,-0.26 4.41,2.77 5.65,4.29 2.67,0.65 3.79,4.29 4.36,6.18 -1.75,1.87 2.57,1.91 1.59,4.25 1.75,1.49 -0.67,4.06 1.98,5.4 1.38,2.41 3.12,5.08 6.11,5.48 2.37,0.69 3.45,-3.06 5.86,-0.86 2.02,0.51 3.14,1.01 3.48,3.29 1.46,0.07 3.05,-1.12 4.63,0.23 2.15,-0.16 -0.16,-3.5 1.42,-4.87 -2.07,-2.25 0.27,-5.84 2.84,-3.46 2.56,1.39 6.37,-0.16 5.06,-3.27 1.23,-2.77 5.86,-0.37 5.25,-4.54 0.37,-2.38 6.08,-3.9 3.11,-6.44 -1.72,-1.06 -3.87,-0.95 -4.75,-2.6 -2,1.51 -3.2,-2.5 -0.39,-2.14 0.69,-1.75 0.97,-3.65 2.65,-4.71 -0.85,-3.72 -6.54,0.53 -7.09,-1.33 1.8,-2.6 -2.67,-2.64 -2.93,-4.36 -3.22,0.42 1.6,-3.78 -0.91,-5 -1.34,-2.93 1.81,-5.95 -0.73,-8.46 -2.48,-1.5 -1.88,-4.02 -1.71,-6.29 -1.66,-2.01 -3.31,-4.07 -5.12,-5.98 -2.19,-1.65 -1.09,-4.87 -2.2,-6.82 1.11,-1.31 0.66,-2.22 -1.09,-2.03 -1.82,-1.66 -0.61,-6.97 -4.4,-5.13 -3.08,2.23 0.7,-4.51 -2.68,-4.38 z",
						"department-46" : "m 331.44,399.96 c -1.78,0.39 -2.93,2.06 -4.78,2.22 -1.23,1.62 0.08,3.6 0.59,5.24 -0.62,1.03 -1.17,1.95 0.02,3.07 0.18,1.1 -1.76,1.01 -1.92,2.28 -1.5,0.17 -1.62,1.3 -1.79,2.63 -1.56,-0.12 -3.74,1.66 -1.79,2.99 0.48,1.24 -1.16,2.21 -1.55,3.19 -1.79,0.31 -2.39,2.65 -4.57,2.36 -2.48,0.13 -0.92,2.86 -2.15,3.97 -1.67,0.34 -1.51,2.52 -2.1,3.21 -1.96,-0.06 -3.03,2.88 -4.61,1.79 0.3,1.56 1.42,3 1.29,4.74 0.12,1.32 0.67,2.66 1.83,3.4 -0.23,1.58 0.35,3.51 2.07,1.94 2.05,-0.44 1.46,1.94 -0.18,1.83 -1.22,0.88 0.7,1.96 1.17,2.95 1.11,0.91 2.68,0.4 2.82,2.11 1.72,1.87 3.42,-0.03 5.04,-0.22 1.19,1.4 -2.21,4.14 0.76,3.99 1.38,-0.04 1.68,2.38 2.73,0.72 1.96,-0.86 3.33,-2.7 4.76,-3.95 1.66,0.19 1.95,1.57 2.46,2.95 1.89,1.12 2.81,-1.68 1.58,-2.85 -0.39,-2.38 2.82,-1.6 2.72,0.27 1.76,0.56 -0.35,-2.18 1.38,-1.26 1.36,-0.27 2.54,-1.96 4.25,-2.02 0.76,0.53 1.85,0.71 1.98,-0.6 1.54,0.38 3.17,-0.08 4.64,-1.02 1.31,-1.08 -1.41,-2.59 -1.19,-4.22 -0.34,-1.78 -2.63,-4.88 0.45,-5.17 0.8,-1.45 3.46,-0.89 4.27,-2.93 1.34,-1.34 2.91,-2.41 4.64,-2.98 1.55,-0.08 3.53,1.36 4.52,-0.64 2.16,-0.01 1.68,-2.49 0.04,-3.09 -0.5,-1.43 0.84,-3.98 -1.69,-3.98 0.01,-1.34 1.12,-3.09 0.77,-4.77 2.27,-2.31 -1.48,-4.34 -2.43,-6.39 -1.64,-1.56 0.95,-3.21 -0.74,-4.49 0.04,-1.98 -1.53,-3.91 -3.65,-2.78 -1.3,0.58 -2.95,2.18 -3.41,-0.02 -1.69,-0.06 -2.54,2.17 -4.2,2.71 -0.83,0.81 -1.65,0.91 -2.35,0.29 -1.65,0.66 -1.79,-2.72 -3.46,-2.87 -0.92,-1.46 -2.13,-2.77 -3.54,-3.69 -1.38,-0.89 -3,0.05 -4.21,-0.32 -0.19,-0.27 -0.02,-0.7 -0.45,-0.56 z",
						"department-24" : "m 289.61,356.69 c -1.25,1.56 -2.08,5.45 -4.38,4 -1.12,2.06 0.62,6.2 -2.8,7.04 -0.72,1.93 -1.59,3.15 -3.65,3.23 -1.43,0.82 -1.89,2.66 -3.45,1.99 1.01,1.66 -2.34,1.58 -2.02,3.67 -1.23,2.3 1.53,4.83 -0.18,6.83 -2.94,0.32 -3.4,4.38 -6.04,5.33 -2.31,-2.11 -5.97,0.67 -6.23,3.21 1.69,0.92 -2.91,2.4 -0.21,3.22 2.95,-1.52 5.31,2.83 3.16,4.94 -0.57,2.04 -1.19,4.08 -2.04,5.92 1.78,2.39 0.17,4.51 -1.12,6.57 2.09,-0.31 3.16,2.8 5.12,1.39 2.59,0.39 5.59,0.53 6.7,-2.41 2.22,-1 4.77,2.45 1.37,3 -0.82,2.33 1.59,4.12 2.98,5.76 1.15,2.22 -0.16,5.57 3.23,5.57 2.21,0.34 4.26,-3.14 6.3,-1.15 1.19,-1.44 4.01,-3.86 5.28,-1.2 1.29,1.28 4.29,0.17 5.88,-0.53 1.34,-1.57 2.54,1.78 2.58,2.23 -1.82,1.7 0.1,5.78 1.92,2.77 1.57,-1.14 4.35,-2.7 5.66,-0.2 1.39,0.73 3.03,2.21 3.77,2.96 0.06,-2.42 3.41,-3.34 2.46,-6.14 2,-1.12 4.38,-1.43 5.85,-3.29 1.66,-0.91 2.36,-2.68 1,-4.38 -0.12,-2.03 4.05,-0.98 3,-3.63 1.33,-0.95 3.18,-1.68 3.32,-3.26 -2.18,-1.13 1.1,-2.92 -0.6,-4.4 -0.62,-1.56 -0.82,-3.42 0.73,-4.21 -0.86,-1.85 -2.52,-3.95 -2.31,-5.85 2.69,-1.69 -2.99,-1.92 -4.16,-2.15 -1.37,-0.3 -2.35,-1.77 -0.66,-2.37 0.85,-2.22 -4.2,-1 -1.82,-3.21 1.6,-0.51 1.97,-2.21 -0.05,-2.43 -1.52,-0.87 0.22,-2.69 -0.02,-4.02 1.56,-0.49 2.9,-2.46 3.59,-3.77 -0.89,-0.68 -4.18,-1.15 -2.03,-2.71 1.63,-1.41 -2.42,-0.92 -2.48,-2.48 -2.02,0.61 -2.38,-1.49 -4.37,-1.12 -1.27,-1.52 3.36,-3.71 0.05,-4.47 -2.98,1.52 -4.07,-1.99 -4.8,-4.21 -2.35,-1.05 -5.43,1.51 -6.95,-0.94 -0.7,1.49 -2.11,4.21 -3.42,1.81 -3.87,-0.26 0.38,-4.55 -2.09,-5.85 -1.62,-1.4 -4.43,0.29 -5.75,-1.44 l -0.34,0.38 5e-5,0 z",
						"department-16" : "m 294.44,327.68 c -2.25,0.3 -1.2,3.19 -3.51,2.81 -1.6,0.21 -2.49,2 -4.14,0.42 -1.77,-0.24 -2.25,-4.84 -4.19,-1.95 -0.91,0.98 -0.61,1.79 0.48,2.16 0.54,2.48 -2.91,2.73 -4.16,1.17 -2.46,0.41 -5.1,0.77 -6.89,-1.39 -1.51,-1.03 -3.06,0.88 -4.39,-0.81 -1.47,0.17 -3.53,0.5 -4,1.95 -0.93,1.49 -3.03,0.38 -3.78,1.41 0.82,1.49 -0.85,2.59 -0.89,4.14 -1.39,0.58 -2.72,1.31 -1.63,2.86 -0.63,1.62 -3.5,0.43 -2.25,2.7 0.14,0.98 1.9,2.93 0.11,3.93 -0.29,1.34 -0.14,4.78 -1.94,3.65 -1.62,1.12 -2.58,0.34 -3.4,-1.09 -2.11,-0.49 -3.38,2.22 -5.62,1.34 -1.21,0.6 -3.11,1.09 -3.84,2.21 0.65,0.94 3.5,0.24 1.85,2.24 -1,1.77 3.04,3.71 0.47,4.36 -1.47,0.73 -0.77,2.68 0.89,1.78 0.66,1.61 5.09,2.77 3.49,5 -0.6,1.89 3.05,0.85 2.86,2.88 1.27,1.46 -2.87,2.31 -0.6,3.66 1.03,1.41 1.77,3.22 -0.58,3.55 -3.03,0.85 0.29,2.52 1.37,2.9 -0.53,1.07 -2.84,1.21 -1.34,2.9 1.24,0.33 2.32,-1.62 3.69,-0.22 1.96,0.48 4.58,0.96 3.85,3.45 0.77,1.61 3.35,-0.2 4.34,1.78 1.2,0.21 0.68,2.6 2.34,1.36 1.12,-1.93 3.29,-0.2 4.76,-0.25 1.32,-1.28 1.59,-3.13 3.17,-3.94 0.74,-1.56 3.63,-1.1 2.59,-3.54 -0.91,-1.87 -0.74,-4.08 0.24,-5.89 0.83,-1.03 1.82,-1.28 1.72,-2.67 2.14,0.73 3,-3.09 5.35,-2.09 0.34,-1.94 2.41,-3.25 3.38,-4.4 1.34,-1.83 -0.87,-4.56 1.38,-5.62 2.01,1.43 2.16,-1.87 3.34,-3.02 1.3,-1.48 1.92,-3.56 3.65,-4.58 2.06,-0.54 0.28,-4.34 3.14,-3.18 1.8,1.51 1.2,-2.16 2.63,-2.69 0.9,-1.93 -0.04,-3.83 0.5,-5.66 1.77,0.89 4.2,0.32 5.03,-1.65 0.94,-1.41 -0.52,-4.76 -2.38,-4.51 -1.22,0.39 -3.6,-2.28 -2.44,-3.84 1.09,-3.07 -2.13,-4.13 -4.62,-3.6 l -3e-5,-5e-5 z",
						"department-86" : "m 262.08,259.01 c -1.83,1.36 -2.41,3.48 -2.12,5.45 -1.62,-0.38 -3.85,-0.7 -3.09,1.9 0.76,1.56 0.28,3.52 0.94,4.63 1.54,-0.64 2.43,0.5 1.66,2.02 1.1,1.45 1.99,3.51 0.77,5.28 0.74,0.68 3.84,2.78 1.47,2.68 -1.76,-1.16 -3.19,2.57 -0.53,1.41 1.15,1.13 -2.24,2.78 0.02,4.14 1.37,0.32 2.5,2.02 0.7,2.55 -1.03,1.96 -1.88,4.02 -3.27,5.73 0.54,1.36 3.57,-2.45 2.46,0.64 0.86,0.48 3.3,2.3 0.9,2.84 -1.95,1.07 0.75,3.1 -1.53,3.96 -1.36,1.18 -0.81,3.19 0.34,3.58 -0.02,2.31 -0.46,4.69 1.97,5.9 -0.98,1.99 -0.05,4.26 2.48,4.1 0.37,-1.94 3.78,-3.38 4.06,-0.57 -1.18,1.49 0.96,3.72 -1.64,4.05 0.29,1.45 -0.18,2.8 -1.21,4.08 0.79,1.45 2.87,3.75 4.6,2.75 0.97,1.5 -2.53,4.14 0.8,4.53 1.71,1.86 3.92,2.04 6.24,1.53 1.81,-0.12 4.03,2.44 4.83,-0.51 -0.17,-1.09 -2.04,-1.09 -0.75,-2.49 0.74,-1.66 2.72,-1.89 2.95,0.03 1.38,1.86 3.64,2.65 5.36,1.17 2.55,0.43 2.05,-3.61 4.94,-2.96 1.9,0.28 5.55,1.2 3.98,-1.91 -0.69,-1.69 -2.98,-3.99 0.39,-4.29 0.85,-1.96 2.74,-3.74 4.97,-3.81 3.08,1.68 3.13,-2.43 4.11,-4.24 1.66,-1.63 4.55,1.3 5.21,-1.8 1.49,-0.33 3.43,-2.92 1.12,-3.86 -2.84,-0.91 -0.56,-4.29 -2.72,-5.7 -1.55,-1.59 -4.62,0.54 -4.75,-2.47 -1.74,-0.37 -3.65,-1.14 -4.73,-2.77 -1.09,-1.83 0.1,-4.22 0.5,-6.07 -0.12,-2.37 -2.83,-3.34 -4.04,-5.13 -1.17,-2.49 -1.79,-5.28 -4.5,-6.69 -1.72,-1.44 -1.27,-3.78 -1.78,-5.71 -1.15,-1.45 -3.06,-1.62 -4.16,-2.96 -3.22,-0.24 0.17,1.99 -0.32,3.25 -2.34,0.38 -5.38,-0.55 -7.13,1.63 -1.89,-0.2 -3.77,-1.26 -5.42,-0.02 -1.93,-1.75 -0.89,-4.62 -0.82,-6.92 0.33,-1.71 -2.64,0.45 -2.05,-1.68 -0.96,-0.9 -3.58,1.73 -3.86,-0.44 1.52,-1.61 0.26,-3.15 -1.42,-2.17 -0.41,-1.64 -1.86,-1.38 -2.92,-1.47 -0.25,-1.89 -1.71,-2.38 -3.01,-3.19 z",
						"department-37" : "m 290.38,223.76 c -0.84,0.11 -0.47,1.14 -1.03,1.54 -0.49,0.61 -1.16,1.03 -1.95,0.94 -0.73,0.28 -1.16,1.18 -2.07,0.97 -0.78,0.12 -1.32,0.86 -2.19,0.71 -1.08,-0.1 -0.56,1.42 -1.46,1.55 -1.15,0.5 -1.59,-0.95 -2.39,-1.41 -0.58,0.14 -1.04,0.95 -1.12,1.45 0.83,0.58 1.52,1.61 1.58,2.58 -0.48,0.61 -1.22,1.02 -1.91,0.42 -0.98,-0.36 -1.46,-1.58 -2.63,-1.49 -0.84,0.07 -1.44,-0.46 -2.09,-0.89 -0.56,-0.34 -1.36,0.02 -1.1,0.76 0.12,0.69 0.06,1.42 -0.57,1.83 -0.39,0.67 -1.14,1.64 -0.66,2.41 0.32,0.32 1.1,0.31 0.82,0.96 -0.12,1.97 -2.06,3.42 -1.78,5.52 0.17,0.79 -0.18,1.47 -0.8,1.93 -0.35,0.52 0.2,1.28 0.63,1.52 -0.44,0.9 -1.77,1.38 -1.57,2.53 -0.28,0.83 -1.42,0.86 -1.59,1.8 -0.39,0.87 -1.3,1.58 -1.05,2.63 -0.79,1.23 -0.57,2.78 -0.76,4.16 -0.38,0.45 -0.96,1.17 -0.32,1.66 0.19,0.92 -0.86,2.02 0.09,2.81 0.5,0.04 0.61,0.47 0.63,0.92 -0.02,0.81 0.99,1.06 1.31,0.32 0.4,0.04 1.19,0.14 1.32,0.6 -0.27,0.86 0.83,1.2 1.37,0.68 0.37,-0.34 0.77,-0.45 0.84,0.18 0.3,0.63 0.66,1.39 -0.05,1.9 -0.47,0.31 -0.55,1.34 0.23,1.02 0.44,0.03 0.71,0.76 1.21,0.29 0.53,-0.55 1.37,-1.21 2.1,-0.65 0.09,0.45 -0.17,1.52 0.64,1.3 0.46,-0.17 1.15,-0.58 1.37,0.14 0.27,0.54 0.3,1.2 -0.11,1.64 -0.28,0.58 0.32,1.14 0.18,1.66 -0.7,0.61 0.02,1.44 -0.14,2.2 -0.13,0.77 0.32,2.22 1.33,1.88 0.74,-0.22 1.18,-1.34 2,-0.74 0.91,0.12 1.8,0.92 2.72,0.73 1.28,-1.37 3.3,-1.72 5.11,-1.53 0.69,-0.15 1.84,0.34 2.29,-0.36 0.16,-0.99 -1.5,-0.85 -1.29,-1.87 -0.03,-0.34 -0.62,-0.9 0.05,-0.91 0.68,0.02 1.64,-0.41 2.21,0.09 0.16,0.78 0.82,1.08 1.52,1.18 0.47,0.73 1.81,0.33 1.91,1.36 0.57,1.39 0.37,2.94 0.79,4.35 0.72,0.79 1.19,2.08 2.3,2.37 0.66,-0.13 0.05,0.95 0.77,0.88 0.33,-0.02 1.08,0.05 0.6,0.49 -0.28,0.75 0.96,0.74 0.83,1.5 0.13,0.88 0.24,1.79 0.82,2.46 0.16,0.88 1.05,1.5 1.75,1.97 0.95,0.14 2.1,-0.66 2.96,-0.02 0.31,0.38 0.73,1.47 1.31,0.8 0.53,-0.31 0.63,-1.17 1.19,-1.35 1,0.41 1.39,-0.08 0.74,-0.9 -0.15,-0.53 0.04,-1.21 -0.61,-1.49 -0.27,-0.63 0.94,-0.77 0.81,-1.47 -0.11,-0.86 0.63,-1.51 0.51,-2.36 0.33,-1.87 0.68,-3.75 0.87,-5.64 0.75,-0.38 1.45,-1.3 0.88,-2.14 -0.67,-0.85 0.43,-1.74 0.81,-2.44 0.32,-0.76 1.35,-1.17 2.15,-1.21 1,-0.03 1.98,-1.2 2.95,-0.65 0.55,0.72 1.53,0.74 2.17,1.32 0.81,0.1 1.34,-0.87 1.72,-1.46 0.24,-1.08 1.08,-1.98 1.95,-2.55 0.13,-0.49 -0.28,-1.51 0.45,-1.65 1.25,0.5 2.15,-1.06 1.74,-2.12 -0.52,-1.07 -0.67,-2.29 -1.46,-3.21 -1.1,-1.96 -1.95,-4.09 -3.66,-5.61 -0.48,-0.44 -0.4,-1.6 -1.33,-1.45 -0.56,0.88 -2.01,0.18 -2.53,1.18 -0.49,0.18 -1.05,-0.91 -1.64,-1.16 -0.42,-0.35 -1.14,-0.21 -1.19,-0.93 -0.13,-0.61 -0.71,-1.47 0.03,-1.92 0.52,-0.6 0.92,-1.58 0.17,-2.16 -0.2,-0.65 0.97,-0.98 0.49,-1.67 -0.28,-0.9 -1.09,-1.64 -1.39,-2.44 0.81,0.11 1.91,-0.31 1.82,-1.28 -0.19,-0.83 -1.04,-1.03 -1.75,-0.89 0.02,-1.36 -1.09,-2.47 -1.12,-3.84 -0.31,-0.32 -1.3,-0.65 -0.71,-1.24 0.19,-0.65 1.31,-0.98 1.07,-1.72 -1.09,-0.46 -1,-2.17 -2.04,-2.74 -0.88,-0.08 -0.63,1.23 -1.2,1.49 -0.79,-0.25 -0.91,-1.17 -0.72,-1.88 -0.23,-0.93 -1.41,-0.84 -2.17,-0.96 -0.99,-0.44 -1.66,0.71 -1.8,1.51 -0.48,0.16 -1.25,0.47 -1.67,0.17 -0.08,-0.56 -0.98,-0.94 -0.45,-1.52 0.75,-0.47 -0.4,-1.06 -0.35,-1.48 0.09,-0.76 0.88,-1.6 0.58,-2.35 -0.57,-0.11 -1.05,0.64 -1.68,0.29 -1.29,0 -2.44,-0.5 -3.65,-0.89 -0.56,-0.16 -1.07,0.33 -1.33,0.63 -0.84,-0.14 -1.49,-1.53 -2.27,-0.47 -0.28,0.32 -1.04,0.41 -0.8,-0.22 0.17,-0.41 -0.04,-0.94 -0.54,-0.89 z",
						"department-72" : "m 273.79,172.47 c -1.82,0.73 -4.09,0.78 -5.26,2.59 -1.02,0.75 -2.37,0.73 -2.95,2.22 -1.69,-0.06 -1.47,3.18 -3.5,1.61 -1.68,-1.56 -3.13,1.37 -5.22,0.75 -1.42,0.02 -1.66,1.24 -1.48,2.18 -2.6,-0.23 0.79,2.98 -0.95,4.16 -1.54,1.84 1.64,4.05 -0.74,5.43 -1.55,1.21 -5.08,2.58 -2.73,4.74 1.45,1.05 -1.08,2.09 0.15,3.42 -0.47,1.28 -2.72,0.25 -3.8,1.51 -2.55,-0.01 -0.61,2.65 -0.04,3.64 1.85,2.04 0.67,4.3 -2.01,4.06 -2.29,-0.31 -3.1,2.54 -0.95,3.39 0.72,2.29 -4.89,2.01 -2.55,4.82 3.09,-0.35 1.87,2.77 2.84,4.5 0.05,2.78 3.47,0.44 5.16,2.01 1.22,0.53 3.33,-2.36 3.41,0.13 -2.79,1.18 -0.55,4.56 1.79,4.53 1.49,0.25 1.75,-2.51 3.51,-0.93 1.85,0.53 3.27,0.36 4.2,2.21 1.78,1.33 4.11,0.48 5.74,2.17 1.48,-0.78 1.37,-2.46 3.29,-1.75 2.37,0.18 4.43,1.35 6.41,2.65 2.46,0.23 0.9,-2.41 0.06,-3.24 0.43,-2.12 2.06,-0.81 2.81,0.12 1.46,-0.48 1.8,-2.15 3.66,-2.02 1.24,-0.96 4.4,-0.87 4.27,-2.54 -2.08,-1.77 1.01,-3.59 2.35,-4.72 1.24,-0.44 2.26,-0.34 2.14,-1.92 1.51,-0.55 2.09,-2.62 3.24,-3.33 -0.56,-1.36 -1.12,-5.34 1.27,-4.27 1.16,1.48 -0.06,-2.47 1.66,-2.46 1.26,-1.13 -1.78,-3.22 0.09,-4.61 0.46,-1.77 -3.37,-1.82 -1.46,-3.92 1.34,0.27 2.44,-1.16 0.67,-1.64 1.71,-0.69 1.24,-3.37 3.57,-2.73 1.69,-1.55 -2.42,-1.69 -3.26,-2.45 -1.21,-1.93 -3.94,0.6 -4.83,-1.98 -1.01,-1.18 -1.91,-5.02 -3.87,-3.17 0.5,1.93 -2.56,0.03 -3.77,0.28 -1.39,-0.92 -2.76,-1.98 -2.77,-3.69 -2.14,0.23 -5.77,-0.97 -4.96,-3.72 -1.03,-2 0.44,-4.66 -1.45,-6.32 -0.97,-1 -2.34,-1.61 -3.72,-1.73 z",
						"department-61" : "m 278.79,140.17 c -1.14,2.43 -4.4,1.53 -5.55,0.43 -1.06,1.99 -2.85,1.01 -4.41,2.37 -0.96,-0.27 -1.3,-2.36 -2.56,-0.82 -2.08,0.46 -2.44,3.41 -4.89,3.53 -1.17,1.28 -2.93,2.77 -4.9,3.14 -2.19,-0.78 -0.23,2.68 -2.41,1.03 -2.09,-1.47 -5.65,-2.35 -7.68,-1.78 -0.1,2.18 -1.85,1.85 -2.46,0.21 -1.49,-2.04 -4.04,-1.93 -5.69,-0.08 -2.34,0.05 -4.45,2.03 -6.77,0.9 -1.08,-1.31 -2.66,0.1 -1.67,1.11 -1.5,1.87 -4.33,1.73 -5.64,3.83 -1.41,0.45 -2.39,2.03 -0.23,2.03 0.83,1.3 2.64,1.99 3.51,3.22 -2.05,0.98 -0.88,3.16 -0.16,4.06 -0.97,1.95 -1.27,4.39 -3.53,5.38 -2.42,1.3 -0.67,4.55 1.08,5.01 1.25,-0.81 1.36,2.97 3.03,0.95 -0.34,-1.52 0.42,-2.12 1.79,-1.57 1.44,-1.68 1.56,0.17 2.1,1.17 1.94,-0.76 4.31,-1.39 5.85,-3.11 1.96,-0.76 5.15,-1.34 7.29,0.59 0.86,-1.55 2.67,-2.24 3.87,-1.55 2.19,-0.69 -0.33,-3.61 2.39,-3.25 1.22,0.63 4.8,2.16 2.62,3.63 0.42,2.11 1.43,5.01 4.16,3.64 2.64,-0.54 -0.69,6.28 2.43,3.99 1.37,-0.32 3.43,2.2 3.94,-0.5 1.52,-1.02 2.55,-2.08 3.95,-2.86 0.13,-1.39 3.49,-1.73 5.06,-2.44 2.07,-0.26 4.6,1.15 5.29,3.14 -0.06,2.06 0.39,4.02 0.45,6.06 0.3,2.62 4.16,1.94 5.31,3.16 -0.15,2.4 3.74,4.17 5.78,2.94 2.1,-2.41 3.26,1.61 4.3,2.97 0.79,2.77 5.5,0.51 4.25,-1.68 -2.11,-1.04 0.15,-4.67 -2.46,-4.46 -0.11,-2.74 2.49,-3.47 4.63,-3.75 2.4,-0.8 4.71,-4.03 4.36,-5.88 -2.6,-1.75 2.04,-5.12 -1.26,-6.05 0.58,-2.87 -4.22,-1.7 -4.04,-4.62 -2.12,-0.59 0.31,-4.94 -2.99,-4.26 -0.97,-0.7 -0.34,-2.36 -2.11,-2.5 2.39,-1.14 1.58,-4.43 -0.72,-5.24 -1.46,-1.16 -4.49,-1.72 -4.58,-3.75 0.31,-1.19 -1.26,-2.21 -1.54,-3.08 -1.64,1.84 -3.89,0.06 -5.9,0.49 -1.87,-0.14 -3.78,-2.55 -2.3,-4.35 0.03,-0.59 -0.2,-1.47 -0.97,-1.38 z",
						"department-27" : "m 284.23,106.14 c -1.88,0.87 -3.31,2.64 -5.48,2.89 -1.89,0.2 -4.82,0.55 -3.33,3.18 -0.14,1.72 1,3.51 0.38,5.06 0.52,0.98 -0.46,2.95 1.2,1.55 2.41,-1.27 2.66,2.53 0.24,2.52 -2.27,1.97 3.93,2.2 1.98,4.88 -0.97,2.23 3.09,1.92 1.13,3.78 -1.21,1.17 1.47,3.53 -1.23,3.36 -1.58,2.01 1.41,2.54 2.48,3.25 -0.33,1.89 -0.36,4.06 -1.76,5.6 -1.7,1.69 0.84,3.09 2.37,3.4 1.86,0.07 4.14,1.29 5.68,-0.38 1.46,0.13 1.03,2.44 2.29,2.65 -1.79,2.14 2.29,2.84 3.49,4.05 1.89,0.35 4,3.22 2.24,4.79 -1.89,0.92 1.57,1.33 0.7,2.83 1.42,0.67 4.08,-0.26 4.59,-1.99 0.83,-1.86 3.09,0.74 4.28,-1.29 1.94,0.28 3.16,-1.22 4.74,-2.05 1.61,0.81 2.92,-0.26 2.44,-1.9 1.47,-0.48 2.13,1.45 3.87,1.18 2.24,-0.19 5.22,1.16 7.18,-0.96 1.37,-1.08 -1.65,-3.52 0.98,-4.19 1.41,-1.51 5.17,-1.7 3.32,-4.59 -1.33,-2.09 3.41,-1.12 1.86,-3.14 1.16,-1.54 -0.13,-0.87 -1.18,-1.03 -0.43,-1.14 0.79,-2.45 -0.65,-3.58 -0.98,-1.38 0.18,-2.29 1.42,-1.59 1.25,-0.64 0.95,-2.18 2.4,-1.05 2.27,-0.15 3.97,-1.16 4.7,-3.36 1.38,-2.46 0.92,-5.5 2.69,-7.82 -0.2,-2.14 2.81,-2.48 3.54,-0.75 1.77,-0.54 0.57,-2.61 -0.28,-3.25 -0.11,-2.2 -0.36,-4.55 -2.2,-6.06 -0.37,-1.75 -1.61,0.28 -2.59,-0.58 -2.28,0.1 -3.36,-1.73 -5.12,-2.48 -1.98,0.65 -4.34,-1.3 -6.72,-0.86 -1.86,-0.64 -3.25,1.37 -4.23,2.02 -0.26,1.65 -1.49,3.06 -1.89,4.62 -2.11,0.47 -4.24,0.4 -6.06,1.62 -0.34,2.25 -4.92,0.31 -3.73,3.41 0.36,1.88 -3.39,1.86 -3.87,0.25 -1.94,0.28 -0.39,-3.44 -2.67,-2.57 -1.1,1.93 -1.79,-1.46 -3.22,-1.11 -0.11,-2.68 4.5,0.55 3.35,-2.5 -0.12,-2.03 -1.93,0.42 -2.15,-1.48 -1,-0.74 -2.78,-0.03 -3.32,-1.74 -2.36,-0.72 -5.48,2.09 -7.12,-0.24 -1.29,-1.21 -3.65,-0.6 -4.47,-2.57 -0.59,-0.76 -1.24,-1.65 -2.28,-1.78 z",
						"department-14" : "m 273.12,109.84 c -2.27,0.34 -4.7,1.01 -6.5,2.46 -1.26,1.74 -2.9,3.08 -4.87,3.94 -2.67,1.45 -5.59,2.55 -8.65,2.7 -1.57,0.68 -2.47,1.15 -3.79,-0.13 -2.28,-0.63 -4.33,-1.8 -6.46,-2.8 -2.03,-0.27 -4.1,-0.36 -6.11,-0.91 -1.82,0.2 -3.72,0.62 -5.6,0.17 -3.59,-0.37 -7.32,-0.45 -10.7,-1.82 -1.79,-1.87 -4.46,-1.14 -6.76,-1.17 -1.97,-0.42 -3.96,1.4 -3.34,3.41 -0.49,1.66 -1.63,3.45 0.02,5.04 1.44,1.58 3.25,2.78 4.92,3.98 1.86,1.46 2.75,-0.79 3.84,-1.71 0.61,1.04 2.16,1.93 0.57,2.87 -1.24,1.38 -0.92,2.96 0.77,3.62 1.05,1.55 1.57,3.8 0.53,5.45 -0.04,0.87 1.55,0.99 0.16,1.82 -1.82,1.35 -2.54,4.13 -5.16,4.47 -1.34,-0.01 -3.09,-1.1 -3.46,1.11 -0.92,2.04 3.69,-0.41 2.05,1.85 -1.01,1.47 -2.2,2.41 -3.69,2.64 -1.25,1.51 -3.49,2.98 -0.36,3.53 1.21,0.77 0.54,3.25 2.83,2.35 1.62,0.12 3.12,0.14 4.72,-0.36 1.37,1.03 3.37,2.2 5.09,1.16 0.76,-0.64 0.34,1.7 1.3,0.04 1.11,-2.03 3.92,-1.46 5.06,-3.34 -0.06,-0.87 -0.78,-2.13 0.88,-1.81 1.47,0.48 2.5,1.54 4.07,0.5 1.35,0.11 2.7,-1.11 4.37,-1.22 1.27,-1.56 3.88,-1.49 4.81,0.23 1.49,-0.3 1.29,2.96 2.32,0.95 0.3,-2.56 3.66,-0.41 5.38,-0.56 1.51,-0.01 3.2,2.91 3.84,0.33 1.81,0.06 3.76,-0.48 4.93,-2.13 1.67,-1.45 4.14,-1.65 4.77,-4.06 1.35,-0.32 3.05,-2.05 3.61,0.27 1.22,0.29 2.11,-1.76 3.44,-0.94 0.63,-0.88 1.91,-2.2 2.45,-0.52 1.62,-0.01 3.15,1.13 4.06,-1.01 0.96,-0.62 2.41,2.07 2.47,-0.29 -0.17,-1.62 1.7,-3.91 -1.06,-4.02 -2.67,-0.46 -0.93,-3.17 0.39,-3.34 -1.98,-1.59 2.3,-4.06 -0.88,-4.55 -0.57,-1.85 0.62,-4.26 -2.08,-4.86 -1.63,-0.93 -0.9,-2.36 0.82,-2.36 1.89,-1.03 -0.49,-3.22 -1.68,-1.54 -1.75,1.03 0.46,-1.94 -1.27,-1.96 1.47,-2.14 -0.49,-4.57 -0.15,-6.98 -0.31,-0.85 -1.23,-0.51 -1.9,-0.5 z",
						"department-76" : "m 326.99,67.42 c -1.74,1.16 -3.92,-0.11 -5.27,2.14 -2.29,2.35 -4.86,4.57 -8.04,5.6 -2.34,1.39 -4.92,2.39 -7.67,2.22 -2.35,0.61 -4.56,1.66 -6.94,2.19 -3.55,1.43 -7.67,0.43 -11.08,2.41 -2.95,1.51 -5.56,3.65 -8.73,4.7 -1.51,1.33 -3.2,2.27 -5.16,2.72 -1.86,1 -4.4,1.34 -5.13,3.66 -0.75,3.04 -2.13,5.83 -3.55,8.61 -1.79,2.24 0.51,4.61 2.71,5.16 1.7,0.51 3.38,0.32 5.11,1.23 3.58,0.81 7.29,-0.27 10.44,-1.96 2.77,-0.55 3.44,4.69 6.22,3.14 1.43,-1.06 0.36,1.42 1.84,1.78 1.73,0.68 4.42,-0.65 6.06,-0.7 0.89,-0.54 1.08,2.89 2.88,1.52 1.17,0.46 1.58,1.18 2.7,1.23 0.96,1.71 0.56,3.15 -1.5,2.39 -2.61,0.13 -0.01,1.38 0.59,2.37 0.28,0.22 2.48,-1.61 2.57,0.52 0.55,2.18 3.9,4.34 4.78,1.19 -1.25,-2.71 3.66,-1.15 4.12,-3.6 1.18,-0.49 2.12,-0.4 2.87,-1.19 2.48,1.25 3.44,-1.19 4.07,-3.05 0.81,-0.77 0.23,-2.49 1.85,-2.77 2.43,-2.42 6.01,-0.26 8.93,0.12 2.48,-0.51 3.81,3.03 6.65,2.28 2.23,0.27 2.16,-3.78 4.12,-4.71 1.4,-1.6 -0.11,-2.96 -1.28,-1.26 -2.63,-0.14 1.26,-2.53 -0.87,-3.38 0.87,-1.65 -2.18,-1.68 -0.99,-2.98 -0.44,-1.5 1.53,-2.18 0.02,-3.67 0.3,-0.9 3.04,-3.09 1.4,-3.23 -0.65,1.38 -2.94,0.58 -1.37,-0.63 0.63,-1.59 1.37,-2.87 2.62,-3.77 1.98,-0.19 -1.75,-2.77 -1.54,-4.39 -0.55,-2.02 -0.53,-4.32 -2.48,-5.61 -1.72,-1.41 -3.86,-2.17 -5.05,-4.18 -1.56,-1.57 -3.42,-2.86 -4.98,-4.37 -0.11,-0.69 0.27,-1.96 -0.95,-1.72 z",
						"department-60" : "m 341.74,87.99 c -0.9,1.51 -2.04,2.89 -2.74,4.41 0.72,1.3 2.78,-1.95 2.47,0.53 -1.27,0.9 -2.24,2.66 -1.34,4.09 -0.91,0.95 -0.75,1.78 -0.03,2.45 -0.13,1.26 0.67,2.66 1.15,3.44 -0.63,0.67 -1.52,2.9 0.16,1.98 1.1,-1.62 2.87,0.58 1.22,1.44 -0.23,1.5 -3.8,3.6 -1.99,5.01 0.58,-0.31 -0.71,1.18 0.39,1.51 1.62,1.42 1.33,3.71 1.74,5.61 1.9,0.6 0.82,4.77 -0.74,2.42 -1.9,-1.54 -3.87,1.46 -1.31,2.28 0.51,0.93 -1.25,1.9 0.44,2.63 0.9,0.8 3.15,-0.28 4.49,0.9 2.36,0.62 4.71,-0.14 7.1,-0.48 1.69,-0.31 3.8,-3.13 5.13,-0.64 1.16,-0.16 2.36,0.23 2.79,1.49 0.86,-1.1 3.52,-0.87 2.75,0.86 2.24,1.07 3.6,-3.98 5.02,-0.88 1.77,1.37 4.47,0.83 6.41,2.37 1.05,0.95 1.89,2.92 2.81,0.71 0.99,0.53 1.93,3.81 3.34,1.69 1.96,-1.93 3.07,1.7 4.45,1.76 0.78,-1.34 2.01,1.92 2.89,-0.28 0.33,-2.65 3.12,-0.79 4.28,0.09 1.53,-0.88 3.16,-0.87 4.8,-1.03 0.35,1.73 1.89,-1.24 3.26,-0.1 1.13,-0.39 0.79,-2.25 2.06,-2.81 0.45,-1.14 3.17,-1.32 1.25,-2.49 -0.17,-0.77 -0.47,-2.34 -1.06,-0.65 0.06,0.85 -0.18,1.81 -0.46,0.43 0.27,-2.06 -1.87,-1.75 -2.95,-2.77 1.14,-1.29 0.95,-4.74 -1.23,-5.15 -2.27,-1.11 -0.25,-4.14 1.81,-2.75 1.95,-0.21 2.65,-2.82 2.87,-4.54 -0.33,-1.38 0.29,-3.2 1.9,-2.16 2.12,-0.3 0.48,-1.77 -0.73,-1.92 -1.2,-0.84 0.94,-1.6 -0.52,-2.5 -0.93,-1.46 1.79,-1.85 0.92,-3.67 0.89,-1.87 -0.93,-3.01 -1.19,-4.57 0.8,-0.97 -0.76,-2.5 0.9,-3.11 -0.1,-1.13 0.12,-3.06 -1.5,-1.53 -0.64,0.41 -0.45,-1.77 -1.25,-0.5 -0.94,2.19 -2.26,0.91 -3.49,-0.03 -1.17,0.33 -1.63,1.17 -1.53,2.36 -0.95,-0.98 -2.13,-2.83 -3.49,-2.24 0.35,0.62 1.21,2.75 -0.14,1.41 -1.1,0.17 -1.22,2.24 -2.79,1.4 -1.49,0.65 0.09,3.84 -2.37,2.83 -1.6,-0.89 -3.92,-0.72 -3.86,1.59 -0.34,2.15 -2.57,1.16 -2.37,-0.63 -0.89,-1.41 -2.34,1.51 -3.2,-0.54 -0.9,-1.16 -2.43,-1.91 -3.66,-0.72 -0.96,-1.8 -2.52,-2.9 -4.61,-2.42 -1.65,-0.62 -2.56,-2.04 -4.51,-1.97 -1.48,-1.13 -3.76,-1.04 -5.41,-0.62 -1.39,0.64 -3.4,0.74 -4.72,0.55 -0.61,-2.11 -4,-1.27 -4.95,-1.25 -1.45,-1.16 -2.94,1.84 -4.62,0.1 -1.53,-0.71 0.09,-2.53 -2,-2.93 -0.64,-0.36 -1.32,-0.5 -2.05,-0.46 z",
						"department-80" : "m 334.17,47.67 c -2.76,-0.03 -2.27,3.63 -2.65,5.5 1.19,2.06 4.27,3.75 5.46,5.15 1.3,3.21 -3.01,-0.19 -4.35,-0.49 -3.88,-0.07 -3.56,5.06 -5.42,7.36 -0.71,0.59 -3.75,3.11 -1.35,2.59 1.47,-1.5 2.51,0.61 2.54,1.63 1.88,1.27 3.39,2.99 5.07,4.48 0.98,2.07 3.34,2.37 4.83,3.88 1.75,1.4 1.74,3.64 2.33,5.6 0.73,2.51 2.58,4.56 4.76,5.91 -0.91,2.39 2.83,3.19 4.21,1.33 1.38,1.22 2.76,-0.54 4.57,0.59 2.05,2.13 4.79,0.74 7.35,0.45 3.03,-0.11 5.98,1.02 8.27,2.71 1.89,0.09 4.19,0.09 4.9,2.37 1.83,-2.22 3.74,1.66 5.11,1.27 1.62,-1.08 2.25,0.37 2.22,1.72 2.29,0.8 1.58,-4.84 4.91,-2.94 1.68,1.34 2.85,-0.29 2.28,-1.88 1.12,-0.78 2.71,-0.69 3.35,-2.07 1.57,-0.09 -0.84,-2.14 1.11,-1.65 0.04,1 1.99,-0.4 1.85,1.53 1.16,0.92 1.99,-2.68 3.62,-0.79 0.76,1.87 2.15,-0.14 2.29,-1 1.08,0.47 2.8,1.19 2.26,-0.92 -0.24,-1.72 -1.63,-2.34 -2.05,-3.74 2.7,-1.08 -1.78,-3.04 0.63,-4.02 -0.03,-2.1 2.52,-2.55 2.07,-4.94 0.63,-1.44 2.98,-3.56 2.95,-4.32 -2.23,-0.28 0.1,-2.65 -2.42,-2.65 -1.83,-1.56 -4.76,-2.7 -7.15,-1.39 -1.63,-0.91 -3.66,1.23 -5.3,1.48 -0.51,-0.79 1.23,-2.05 -0.42,-2.93 -0.98,-1.14 -4.78,3.68 -4.68,0.67 1.62,-1.44 1.72,-3.98 -0.88,-4.21 -1.44,-0.89 -1.05,1.88 -0.92,2.4 -1.98,-0.74 -4.51,-1.19 -6.31,-2.19 0.61,-1.3 -0.76,-2.03 -1.28,-0.53 -0.88,1.66 -1.65,-2.37 -3.21,-0.68 -1.76,0.6 -1.78,4.7 -3.76,1.86 -2.07,-1.49 1.23,-5.37 3.7,-5.37 1.77,-1.43 -2.79,-3.76 -4.17,-2.2 -0.97,2.36 -1.66,-1.19 -2.43,-0.22 -0.33,1.95 -3.12,-0.94 -4,0.91 -2.31,-1.06 -3.91,2.2 -5.6,0.42 -3.43,0.96 -1.19,-3.98 -4.22,-3.97 -2.08,-0.65 -5.34,-1.55 -3.24,-3.89 -1.24,0.25 -2.96,1.33 -4.16,-0.39 -1.88,-2 -4.87,-2.51 -7.1,-0.8 -2.62,2.08 -3.24,-1.93 -5.56,-1.66 z",
						"department-95" : "m 339.8,122.71 c -1.75,0.85 -1.88,3 -2.16,4.68 -0.25,1.42 -0.73,2.88 -1.8,3.9 -0.69,1.01 0.61,2.05 1.57,1.49 1.5,-0.16 1.5,1.98 2.85,2.11 1.02,-0.12 1.88,-0.91 2.92,-0.9 0.76,-1.07 2.09,-1.17 2.99,-0.2 1.21,0.66 -0.5,2.41 0.77,2.82 0.86,-0.1 1.34,-2.54 2.26,-1.1 0.59,1.26 2.08,0.84 3.14,1.21 0.89,0.92 2.25,1.66 3.52,0.88 0.81,-0.21 2.59,-1.05 2.82,0.15 -0.1,1.04 0.68,1.41 1.54,1.39 0.9,0.75 1,2.13 2.12,2.68 -0.33,0.59 -0.16,2.37 0.73,1.4 1.04,-1.05 2.57,-1.62 3.49,-2.71 1.14,0.17 2.21,0.21 3.06,-0.63 1.52,0.3 3.09,1.88 4.7,0.7 1.15,-0.75 2.19,-1.68 3.12,-2.68 0.07,-0.88 0.28,-1.69 1.3,-1.95 0.98,-0.78 0.44,-2.26 0.76,-3.23 -0.5,-0.75 -1.19,-1.8 -1.73,-2.24 -0.42,0.8 -1.45,1.59 -2.11,0.59 0.23,-1.63 -1.64,-1.69 -2.71,-2.2 -0.93,-0.75 -2.23,-0.98 -3.43,-0.88 -1.14,0.44 -1.14,-2.17 -2.51,-1.86 -0.93,0.67 -1.24,2.1 -2.67,1.96 -0.85,0.25 -1.61,-0.38 -1.04,-1.12 -0.93,-1.31 -2.75,1.07 -3.45,-0.84 -1.09,-0.54 -2.35,-0.31 -3.03,-1.41 -1.39,-0.44 -2.32,1.15 -3.56,1.49 -1.54,0.3 -3.07,0.53 -4.64,0.89 -1.02,0.55 -1.66,-0.7 -2.77,-0.13 -1.18,-0.12 -2.17,-1.37 -3.52,-0.68 -1.05,0.52 -2.62,-1.32 -1.91,-2.09 0.55,-0.51 0.15,-1.56 -0.62,-1.51 z",
						"department-78" : "m 334.24,132.78 c -1,0.54 -2.08,0.78 -3.19,0.77 -0.88,0.67 -1.8,1.4 -2.86,0.74 -1,1.18 0.68,2.18 0.89,3.3 0.23,0.75 -1.15,2.12 0.4,1.82 0.82,-0.44 1.69,0.17 0.74,0.87 -0.37,0.71 0.43,1.1 0.26,1.94 0.29,1.15 1.96,0.94 1.75,2.38 0.87,0.58 0.5,1.27 0.32,2.12 1.32,0.42 2.18,2.11 1.47,3.37 -0.42,1.39 -0.56,3.52 1.15,4.05 1.37,0.98 -0.49,2.25 -0.91,3.24 -0.68,1.18 1.57,1.26 0.68,2.6 -0.04,1.38 2.47,0.96 2.14,2.67 0.34,1.35 3.82,0.33 2.56,2.23 -0.54,1.64 1.41,1.29 2.25,1.55 1.15,0.87 1.41,2.05 0.95,3.37 0.17,1.23 0.65,2.41 1.19,3.52 1.78,-0.36 2.35,2.59 4.37,1.6 1.52,-0.41 0.09,-2.05 1.38,-2.9 0.19,-1.14 1.17,-2.09 1.24,-3.18 -1.18,-0.19 -1.48,-2.22 0.06,-1.66 1.31,0.46 2.98,0.35 3.03,-1.39 -0.03,-1.12 1.15,-1.58 1.21,-2.43 -0.36,-0.96 -2.66,-1.87 -1.39,-2.92 0.64,-1.04 1.38,-1.88 2.67,-1.93 1.28,-0.56 1.14,-2.12 1.14,-3.08 0.97,-0.1 1.69,-0.43 2.35,-1.07 0.87,-0.01 1.65,-0.29 1.55,-1.2 0.59,0.02 2.31,-0.07 1.09,-0.86 -1,-1 -2.1,-1.54 -3.05,-2.54 -0.18,-1.15 0.25,-2.28 0.31,-3.42 0.08,-1.36 1.65,-1.64 2,-2.76 0.17,-1.1 0.49,-2.29 -0.95,-2.41 0.11,-1.31 -0.96,-2.13 -2.21,-2.32 -0.52,-0.64 -0.11,-1.95 -1.35,-1.47 -1.36,0.22 -3.16,1.5 -4.33,0.19 -0.81,-1.28 -2.74,-0.39 -3.64,-1.46 -0.69,-1.48 -1.72,-0.45 -2.07,0.61 -1.24,1.19 -1.47,-1.46 -0.93,-2.15 -0.69,-1.01 -2.33,-2.23 -3.03,-0.48 -0.9,0.2 -1.81,0.37 -2.64,0.95 -1.77,0.38 -1.82,-1.98 -3.35,-2.1 -1.13,-0.34 -2.21,1.01 -3.04,-0.19 l -0.22,0.02 0,-3e-5 z",
						"department-28" : "m 329.02,142.26 c -2.37,0.57 1.22,3.97 -1.47,4.66 -1.92,0.36 -4.91,2.33 -3.35,4.49 -0.05,2.87 -3.4,2.18 -5.4,2.65 -0.67,-1.12 -2.1,0.54 -3.09,-0.61 -1.43,0.4 -3.07,-2.56 -3.03,0.22 0.1,2.49 -3.8,-0.64 -3.88,2.19 -2.05,0.03 -3.85,1.13 -5.66,1.42 -2.16,-1.19 -1.84,2.14 -3.9,2.25 -1.02,0.93 0.19,3.2 0.09,4.15 1.27,1.02 1.44,3.17 3.55,3.09 1.58,0.76 1.02,2.45 2.67,3.07 -0.63,1.17 -0.32,2.65 -1.29,3.54 0.28,1.18 2.62,1.9 0.83,3.01 -0.7,2.66 -3.31,4.77 -6.03,5.03 -2.13,-0.37 -3.51,3.03 -1.19,3.57 -1.23,2.13 1.28,3.54 1.2,5.46 -2.6,1.83 1.9,3.06 3.26,3.42 1.88,1.2 -0.08,1.78 -1.37,1.74 -2.18,1.97 1.82,2.1 2.99,1.32 1.75,1.43 2.58,-1.98 4.62,-1.4 2.22,1.15 -3.59,2.44 -0.28,3.01 1.41,0.41 4.53,-0.33 3.93,1.86 1.03,2.01 3.58,2.99 4.13,5.43 2.39,-0.61 4.13,1.51 6.26,1.12 1.73,0.58 1.89,-2 3.61,-0.82 1.39,-0.47 0.39,-3.96 2.51,-1.88 0.97,1.39 2.79,0.86 2.04,-0.97 0.08,-3.36 4.25,0.15 4.93,-2.95 0.79,-1.61 2.33,-0.18 3.44,-1.03 1.66,1.37 3.85,-0.42 5.32,-0.69 2.32,0.52 3.48,-1.68 4.41,-3.31 -0.35,-1.05 -0.45,-2.55 1.33,-2.43 1.67,0.07 0.73,-0.91 0.78,-1.73 1.38,-0.51 -0.98,-3.55 1.18,-4.38 0.8,-1.67 -2.26,-2.44 -0.29,-3.98 -0.54,-1.83 1.02,-5.17 -1.84,-5.28 -1.23,-0.49 1.23,-2.71 -0.91,-2.75 -2.16,1.54 -3.79,-1.06 -5.49,-1.87 -1.34,-1.71 -0.32,-3.91 -1.25,-5.67 -0.82,-1.34 -3.99,-0.34 -2.7,-2.8 -0.01,-0.99 -3.05,-0.4 -2.98,-2.29 -1.17,-0.9 -2.2,-2.17 -2.13,-3.38 -2.3,-1.28 3.11,-4.03 -0.34,-4.79 -1.59,-1.53 0.21,-3.83 -0.38,-5.49 0.09,-1.23 -2.39,-1.47 -1.2,-2.8 -0.68,-1.66 -1.82,-3.41 -3.63,-3.37 z",
						"department-75" : "m 533.65,37.59 c -0.56,0.01 -1.14,0.07 -1.69,0.09 l -0.47,0 -0.06,0 c -3.2,-0.16 -6.2,1.71 -8.25,3.88 -1.18,-0.38 -2.14,0.15 -3.09,0.66 -1.64,0.07 -4.2,2.99 -1.75,3.84 2.04,0.46 2.36,3 4.56,3.38 4.15,0.71 8.61,3.62 12.69,1 2.59,-2.23 5.56,1.56 8.38,0.72 1.37,-1.09 1.13,-4.27 -1.16,-3.72 -1.21,-0.03 -2,-1.04 -2.81,-0.38 -1.83,-2.4 -0.68,-4.78 -2.88,-7.06 -0.22,-2.16 -1.78,-2.45 -3.47,-2.41 z M 369.8,144.62 c -0.22,0.01 -0.47,0.02 -0.69,0.03 l -0.19,0 -0.03,0 c -1.27,-0.06 -2.44,0.7 -3.25,1.56 -0.47,-0.15 -0.87,0.05 -1.25,0.25 -0.65,0.03 -1.66,1.16 -0.69,1.5 0.81,0.18 0.94,1.23 1.81,1.38 1.65,0.28 3.41,1.41 5.03,0.38 1.03,-0.89 2.23,0.62 3.34,0.28 0.54,-0.43 0.44,-1.69 -0.47,-1.47 -0.48,-0.01 -0.86,-0.33 -1.19,-0.06 -0.56,-1.04 -0.22,-1.97 -1.09,-2.88 -0.09,-0.86 -0.67,-0.98 -1.34,-0.97 z",
						"department-93" : "m 555.46,19.68 c -1.17,0.84 -2.88,0.87 -3.59,2.44 -1.9,3.01 -5.42,4.31 -7.91,6.63 -2.07,-0.07 -4.34,-0.18 -6.38,-0.66 -1.61,-0.92 -3.27,-3.37 -5.22,-1.63 -1.51,0.76 -2.72,2.77 -4.56,1.5 -0.87,-0.48 -3.68,-1.04 -3,0.78 1.41,1.33 5.16,0.8 5.16,3.34 -0.15,1.75 -2.85,3.4 -1.72,5.09 2.66,1.08 5.98,-0.51 8.41,0.94 0.69,1.35 1.27,2.69 2.25,3.88 0.45,1.44 -0.32,4.34 2.19,3.88 2.69,-0.37 5.42,-2.64 8.13,-0.88 2.62,1.82 5.86,3.41 7.72,5.97 -0.27,1.87 3.54,2.36 2.59,0.13 -0.6,-1.79 -2.28,-3.9 -1.94,-5.69 1.69,-0.57 -0.12,-2.01 -1.03,-2.19 0.67,-1.09 -0.65,-2.02 -0.72,-2.84 1.04,-1.43 3.28,-1.82 3.09,-4 -0.23,-2.01 2.04,-3.53 0.91,-5.5 -0.58,-2.12 -2.68,-3.68 -3.16,-5.69 1.94,-1.54 1.14,-5.04 -1.22,-5.5 z M 378.43,137.53 c -0.46,0.33 -1.12,0.35 -1.41,0.97 -0.75,1.19 -2.17,1.71 -3.16,2.63 -0.82,-0.03 -1.72,-0.06 -2.53,-0.25 -0.64,-0.37 -1.29,-1.35 -2.06,-0.66 -0.6,0.3 -1.08,1.1 -1.81,0.59 -0.35,-0.19 -1.46,-0.41 -1.19,0.31 0.56,0.53 2.06,0.3 2.06,1.31 -0.06,0.69 -1.14,1.36 -0.69,2.03 1.05,0.43 2.38,-0.2 3.34,0.38 0.27,0.54 0.49,1.06 0.88,1.53 0.18,0.57 -0.12,1.72 0.88,1.53 1.07,-0.15 2.15,-1.04 3.22,-0.34 1.04,0.72 2.33,1.36 3.06,2.38 -0.11,0.74 1.41,0.95 1.03,0.06 -0.24,-0.71 -0.92,-1.57 -0.78,-2.28 0.67,-0.23 -0.05,-0.77 -0.41,-0.84 0.27,-0.43 -0.25,-0.83 -0.28,-1.16 0.41,-0.57 1.33,-0.7 1.25,-1.56 -0.09,-0.8 0.79,-1.4 0.34,-2.19 -0.23,-0.84 -1.06,-1.48 -1.25,-2.28 0.77,-0.61 0.44,-1.98 -0.5,-2.16 z",
						"department-94" : "m 546.24,44.68 c -1.24,0.18 -3.2,0.91 -4,1.88 0.78,0.52 3.1,0.45 2.97,1.97 0.06,1.47 -0.57,4.13 -2.63,2.91 -2.6,-0.4 -5.3,-2.53 -7.66,-0.34 -1.75,1.26 -3.99,0.51 -5.88,1.25 -1.01,2.81 0.03,6.21 -1.66,8.91 -0.58,2 2.17,1.1 2.78,2.5 1.06,1 2.52,0.31 3.38,-0.25 1.15,1.11 -0.28,4.4 2.09,4.25 1.49,-0.62 2.95,-0.96 4.5,-0.41 3.38,-0.13 6.65,-1.36 9.94,-1.78 1.28,1.58 1,4.04 2.91,5.31 0.79,0.48 1.5,0.76 1.88,1.69 1.48,0.79 3.19,-1.21 1.94,-2.53 -0.03,-2.34 3.94,-3.6 2.22,-6.13 1.25,-0.79 0.59,-2.79 2.13,-3.22 1.09,-1.47 -1.2,-1.54 -2.09,-1.81 -0.86,-1.32 1.66,-2.95 0.34,-4.25 0.31,-2.02 -2.79,-1.77 -3.03,-3.69 -2.59,-2.65 -5.67,-5.35 -9.34,-6.25 -0.26,-0.03 -0.53,-0.03 -0.78,0 z M 374.77,147.43 c -0.49,0.07 -1.35,0.46 -1.78,0.75 0.31,0.21 1.43,0.18 1.38,0.78 0.02,0.59 -0.22,1.64 -1.03,1.16 -1.03,-0.16 -2.1,-0.99 -3.03,-0.13 -0.7,0.5 -1.6,0.18 -2.34,0.47 -0.4,1.12 0.01,2.46 -0.66,3.53 -0.23,0.79 0.88,0.44 1.13,1 0.42,0.39 0.97,0.13 1.31,-0.09 0.46,0.44 -0.1,1.75 0.84,1.69 0.59,-0.25 1.17,-0.37 1.78,-0.16 1.34,-0.05 2.63,-0.55 3.94,-0.72 0.51,0.63 0.4,1.62 1.16,2.13 0.31,0.19 0.6,0.29 0.75,0.66 0.59,0.31 1.28,-0.48 0.78,-1 -0.01,-0.93 1.56,-1.44 0.88,-2.44 0.5,-0.32 0.24,-1.11 0.84,-1.28 0.43,-0.58 -0.49,-0.61 -0.84,-0.72 -0.34,-0.52 0.68,-1.17 0.16,-1.69 0.12,-0.8 -1.12,-0.68 -1.22,-1.44 -1.03,-1.05 -2.26,-2.14 -3.72,-2.5 -0.1,-0.01 -0.21,-0.01 -0.31,0 z",
						"department-92" : "m 524.52,29.65 c -5.04,1.32 -8.24,6.07 -12.78,8.38 -2.7,1.94 -2.77,5.54 -2.5,8.53 -1.01,1.01 -1.21,2.46 -0.63,3.84 0.03,1.79 1.85,1.34 2.91,1.66 0.41,1.64 1.69,2.54 3.22,2.88 0.63,0.83 1.26,1.68 2.19,2.13 0.82,1.82 1.8,3.98 4.19,3.88 1.95,-0.03 2.79,2.09 2.72,3.69 0.9,0.69 2.33,-0.53 2.97,0.75 1.85,-0.23 0.2,-2.5 0.25,-3.59 0.34,-1.82 1.76,-3.72 0.97,-5.59 -0.29,-1.57 0.68,-3.11 0.59,-4.47 -2.41,-2 -6.18,-0.84 -8.09,-3.59 -0.93,-1.19 -2.79,-1.7 -3.66,-2.72 0.56,-2.85 3.58,-4.62 6.31,-4.28 0.98,-1.78 4,-2.05 4.44,-4.22 -0.89,-2.25 3.44,-3.59 1.34,-5.81 -1.21,-0.99 -2.91,-1.4 -4.44,-1.44 z M 366.18,141.46 c -2,0.52 -3.29,2.43 -5.09,3.34 -1.07,0.77 -1.08,2.19 -0.97,3.38 -0.4,0.4 -0.48,0.98 -0.25,1.53 0.01,0.71 0.74,0.53 1.16,0.66 0.16,0.65 0.67,0.99 1.28,1.13 0.25,0.33 0.48,0.7 0.84,0.88 0.32,0.72 0.71,1.54 1.66,1.5 0.78,-0.01 1.12,0.84 1.09,1.47 0.36,0.27 0.93,-0.19 1.19,0.31 0.73,-0.09 0.08,-1 0.09,-1.44 0.14,-0.72 0.69,-1.48 0.38,-2.22 -0.12,-0.62 0.28,-1.24 0.25,-1.78 -0.96,-0.79 -2.46,-0.32 -3.22,-1.41 -0.37,-0.47 -1.09,-0.69 -1.44,-1.09 0.22,-1.13 1.42,-1.82 2.5,-1.69 0.39,-0.7 1.58,-0.83 1.75,-1.69 -0.35,-0.89 1.36,-1.4 0.53,-2.28 -0.48,-0.39 -1.14,-0.58 -1.75,-0.59 z",
						"department-91" : "m 362.18,153.27 c -0.56,0.4 -0.49,1.6 -1.49,1.11 -1.09,0.18 -1.56,1.23 -2.67,1.16 -0.41,0.64 0.34,1.67 -0.45,2.38 -0.45,1.11 -1.69,0.89 -2.58,1.28 -0.46,0.64 -0.99,1.47 -1.34,2.04 0.76,0.75 1.83,1.56 1.84,2.69 -1.22,0.28 -0.84,1.62 -1.39,2.42 -0.11,1.33 -1.62,1.27 -2.59,1.06 -1,-0.6 -1.96,0.52 -0.75,1.11 0.71,-0.03 1.72,0.98 0.49,1.03 -1.21,0.85 -1.06,2.64 -2,3.62 0.04,0.98 1.16,1.55 0.96,2.63 -0.14,0.69 -0.83,1.75 0.46,1.62 1.2,-0.21 1.25,0.9 1.18,1.77 1.04,0.89 -0.56,1.95 0.05,3 0.63,0.99 -0.75,1.44 -0.54,2.23 1.02,1.29 2.98,0.96 4.27,0.28 0.96,0.25 1.81,-0.9 2.53,-0.56 0.79,0.62 1.93,0.39 1.96,-0.65 1.21,0.12 1.32,-1.14 2.05,-1.77 0.86,0.29 2.19,0.62 2.06,1.69 0.29,1.34 0.94,-0.5 1.69,0.15 1.08,0.55 1.37,-2.33 2.43,-0.78 0.44,0.94 2.05,1.38 2.65,0.42 -0.17,-0.9 0.34,-1.32 1.19,-1.29 0.99,-0.51 0.11,-2.09 1.38,-2.34 1.2,-0.09 1.06,-1.93 2.38,-1.57 0.83,-0.27 2.19,-0.59 1.05,-1.45 -0.89,-0.45 -1.26,-1.36 -1.09,-2.33 -0.09,-0.98 0.15,-1.91 0.38,-2.85 -0.37,-1.1 -0.63,-2.32 -0.16,-3.48 0.59,-0.82 0.36,-1.92 1.05,-2.68 1.19,-0.79 -0.12,-1.5 -0.51,-2.26 0.38,-0.77 1.81,-1.19 0.8,-2.19 -0.08,-1.4 1.54,-0.57 1.98,-1.46 0.42,-1.29 -1.54,-0.05 -1.78,-1.14 -1.31,-0.4 -0.82,-3.07 -2.55,-2.09 -1,-1.6e-4 -1.51,1.28 -2.34,0.43 -0.86,0.17 -1.91,0.15 -2.79,0.1 -0.28,-0.56 -0.1,-1.72 -1.09,-1.22 -0.63,-0.37 -1.46,-0.6 -1.54,0.4 -0.48,0.27 -1.39,-0.05 -1.79,-0.36 0.62,-1.46 -1.25,-1.36 -2.1,-1.81 -0.43,-0.13 -0.84,-0.36 -1.3,-0.33 z",
						"department-45" : "m 362.36,181.88 c -1.65,1.48 -2.18,3.74 -4.78,2.39 -1.48,1.36 -4.34,0.35 -5.23,2.12 -1.82,1.67 -0.25,3.77 -0.95,5.64 0.75,1.65 -4.16,0.54 -2.21,3.02 -0.99,2.07 -2.46,4.58 -5.26,3.66 -2.02,1.97 -5.11,0.72 -7.33,0.91 -1.13,1.1 -2.17,3.49 -4.02,2.16 -2.61,0.08 -1.88,4.14 0.38,3.4 0.59,1.94 -3.26,3.07 -0.53,4.45 2.35,1.07 1.66,4.09 -0.3,5.19 -1.66,1.88 2.46,2.57 0.57,4.55 -0.11,1.31 2.93,3.23 3.2,1.04 2.6,0.66 4.81,2.02 4.75,4.99 0.25,1.36 2.21,2.47 3.05,2.46 1.56,-0.44 1.89,-1.93 2.51,-2.99 1.46,1.36 3.45,0.06 4.83,1.75 1.89,-0.68 3.95,-1.24 6.11,-1.16 2.11,1.02 4.88,-0.7 6.22,1.53 0.4,1.54 1.34,2.53 2.81,2.11 1.99,0.72 3.69,3.49 5.74,1.36 2.24,-1.27 2.64,3.3 5.16,2.14 1.93,-0.34 3.85,1.34 4.38,3.12 1.76,0.64 1.73,3.91 4.07,2.21 1.03,-0.74 -0.13,-4.08 1.87,-2.41 1.48,0.91 2.84,3.15 4.44,0.94 2.15,-0.41 -1.53,-2.35 0.99,-2.56 1.51,-0.53 2.68,-0.61 4.16,-0.88 -0.4,-1.72 -2.02,-3.65 -0.87,-5.78 -1.47,-1.35 -2.37,-3.99 -4.18,-4.29 -0.84,-2.52 1.23,-3.54 3.36,-3.26 1.7,-0.71 5.76,-1.19 3.99,-3.74 1.11,-1.31 0.68,-2.27 -0.61,-2.99 0.09,-2.52 2.76,-3.46 4.36,-5.16 2.49,-1.47 0.34,-4.36 0.52,-5.82 -2.16,-1.8 -3.41,-4.2 -4.19,-6.74 -2.19,-1.4 -4.91,-2.41 -7.26,-0.61 -1.4,1.83 -3.28,0.7 -2.71,-1.2 -2.2,-0.29 -2.55,2.6 -4.92,2.7 -1.57,0.29 -3.06,-1.32 -4.77,-0.63 -2.24,-0.9 -4.25,1.33 -6.48,0.31 0.78,-1.05 1.75,-2.43 2.86,-2.47 0.77,-2.05 0.75,-4.79 -1.8,-5.48 -2.81,0.03 -1.67,-2.9 -2.96,-4.35 -2.08,1.48 -3.78,-2.45 -5.12,0.4 -0.94,-0.72 -2.49,1.6 -2.25,-0.72 -0.16,-0.79 -1.01,-1.02 -1.65,-1.29 z",
						"department-41" : "m 308.2,195.6 c -1.7,-0.02 -2.6,2.84 -4.26,1.59 -1.63,0.48 -4.86,-0.54 -3.89,2.17 -1.55,-0.17 -2.96,1.3 -1.44,2.66 2.9,0.31 -0.84,3.64 1.49,5.12 0.09,1.68 -2.43,1.96 -1.45,4.05 -0.59,0.43 -2.04,-1.82 -2.47,0.23 -0.2,1.62 1.54,3.87 -0.55,4.72 -0.84,1.32 -2.23,2.4 -2.62,3.63 -2.15,0.21 -4.86,2.51 -4.44,4.45 1,1.2 2.16,-2.09 2.67,0.42 1.06,-0.38 2.82,0.77 4.02,-0.08 1.8,0.71 3.91,1.04 5.64,0.63 -0.53,1.91 -1.14,4.48 0.8,5.28 1.17,-0.97 2.47,-2.61 4.29,-1.35 1.11,0.26 0.41,4.03 1.73,1.52 1.24,-1.02 2.45,1.92 2.86,2.54 -2.01,1.95 0.17,4.12 1.12,6.11 1.25,0.8 2.24,2.15 0.27,2.99 -0.64,1.16 1.81,2.42 0.19,3.73 1.53,1.45 -1.95,3.95 0.84,4.94 1.57,2.45 5.13,-1.77 5.94,1.95 2.17,0.85 1.64,5.22 4.41,4.55 2.32,-0.64 4,-4.01 6.74,-2.46 2.19,1.43 0.34,-2.88 3.2,-1.82 1.32,-1.08 2.73,-1.28 4.3,-0.12 1.45,0.36 2.96,-1.63 3.7,0.68 1.56,1.46 4.12,1.72 6.16,2.64 1.98,0.09 1.23,-2.2 0.89,-2.68 1.05,-1.39 2.14,-3.2 3.8,-1.34 2.23,1.19 4.55,-1.54 6.83,-0.7 1.92,-1.73 -0.91,-3.32 -0.92,-5.29 -1.23,-0.89 -0.13,-4.35 1.44,-3.15 1.12,-0.94 2.48,-2.05 3.01,-0 2.52,0.52 1.39,-3.79 1.2,-5.16 -0.91,-0.72 -2.09,0.68 -1.39,-1.23 1.1,-2.73 -1.92,-2.54 -3.54,-3.07 -1.53,-3.49 3.6,-2.7 4.78,-4.72 0.72,-2.43 -2.2,-3.74 -4.22,-3.01 -2.49,-0.43 -5.42,-0.7 -7.94,0.83 -1.62,-1.12 -3.52,-0.72 -5.25,-1.78 -0.12,2.02 -2.68,4.15 -4.08,2.3 -2.49,-1.02 -1.09,-4.61 -3.32,-5.68 -1.6,-0.53 -2.94,-1.8 -3.91,0.31 -1.42,1.01 -0.2,-1.5 -1.95,-1.75 -1.47,-0.98 1.47,-2.62 -0.83,-3.53 -2.16,-1.91 3.3,-3.22 1.51,-5.8 -0.84,-1.2 -3.85,-2.47 -1.36,-3.8 1.57,-1.84 -0.36,-2.14 -1.8,-1.78 -1.31,-0.3 -3.34,-2.94 -3.24,-0.18 -0.34,2.1 -2.81,-0.09 -3.21,2.13 -2.32,0.31 -4.34,-1.02 -6.64,-1.35 -1.65,0.93 -1.6,-2.33 -2.85,-2.99 -1.69,-0.8 -2.33,-2.51 -2.91,-3.82 -1.22,-0.32 -4.55,0.17 -4.41,-1.48 0.52,-0.51 3.42,-1.68 1.05,-2.03 z",
						"department-36" : "m 334.67,252.31 c -0.07,2.25 -3.94,-0.13 -3.26,2.61 0.24,2.05 -2.47,-1.23 -3.67,-0.12 -1.7,0.75 -2.8,2.52 -4.72,2.89 -1.42,1.27 1.81,3.39 0.61,5.25 -0.54,1.03 -2.51,0.63 -2.09,2.36 -1.81,0.99 -2.56,5.87 -5.17,3.14 -1.93,-1.01 -4.4,0.13 -5.84,1.56 -1.53,1.34 0.17,3.67 -1.63,4.77 -0.27,2.41 -0.61,4.82 -1.18,7.18 -1.16,1.44 -0.19,2.91 -0.12,4.46 -1.54,-0.52 -2.72,2.83 -3.84,0.35 -1.47,-0.75 -3.17,0.9 -0.97,1.5 1.57,1.48 0.22,3.35 0.37,5.02 -1.08,1.82 -0.1,3.6 1.51,4.64 1.38,1.19 3.72,0.8 4.06,2.89 1.98,0.12 4.08,0.23 5.09,2.31 -0.26,1.88 -0.16,3.87 2.04,4.68 2.24,-0.13 -0.78,2.82 -0.04,3.5 1.32,-1.24 1.45,2.16 2.87,0.38 1.41,0.23 2.95,0.06 3.31,-1.4 2.3,-0.94 2.92,2.57 4.68,2.97 1.35,-1.69 3.15,-3.13 4.46,-4.82 1.27,0.09 0.91,2.98 2.47,1.19 1,-0.78 2.15,-1.34 1.98,0.42 1.06,2.68 2.67,-2.9 3.68,-0.05 1.94,1.77 2.65,-1.98 2.61,-3.21 2.22,-1.29 3.19,2.68 5.5,0.97 1.64,-0.66 3.21,0.26 4.93,-0.1 1.88,0.55 4.23,2.07 6.03,1.2 1.81,0.16 1.81,-1.04 1.6,-2.3 1.01,-0.91 3.27,-1.71 1.63,-3.38 -1.26,-2.3 -1.38,-4.87 -0.25,-7.2 1.21,-2.25 -3.31,-2.77 -1.54,-4.68 -0.45,-1.85 -3.32,-1.25 -3.54,-3.39 -0.53,-1.64 3.32,-2.16 1.02,-4.12 -1.37,-0.74 -2.78,-2.63 -0.59,-3.08 -0.13,-2.33 3.87,-2.38 2.77,-4.64 -2.22,0.66 -4.6,-1.93 -2.44,-3.7 1.78,-2.55 -1.13,-3.63 -2.64,-5.02 1.11,-1.35 1.56,-4.78 -0.93,-3.19 -0.37,-3.15 -3.21,-0.9 -4.96,-0.52 -2.01,0.15 -3.82,-1.24 -5.54,-1.72 0.85,-1.99 4.5,-4.63 1.54,-6.61 -2.27,0.27 -3.16,-1.98 -4.76,-2.7 -1.74,1.87 -3.11,-0.52 -5.01,-0.28 z",
						"department-18" : "m 365.8,229.05 c -2.37,0.5 -4.91,1.26 -6.83,2.71 -1.23,2.43 1.62,2.22 3,2.57 1.38,1.33 -0.5,3.88 1.99,3.54 0.06,1.57 1.23,5.47 -1.3,5.67 -0.61,-0.92 -1.88,-2.26 -2.76,-0.42 -2.93,-0 -2.32,3.05 -1.09,4.7 0.55,1.21 2.22,3.92 -0.58,4.02 -2.59,-0.47 -5.06,2.26 -7.42,-0.13 -1.15,-0.26 -2.25,1.99 -2.25,2.34 1.46,1.81 -1.33,3.49 -2.71,2.01 0.37,2.24 -1.72,3.57 -2.59,5.51 1.73,1.59 5.42,2.8 7.77,0.88 1.83,-1.38 1.98,1.05 2.89,1.53 2.48,-1.61 1.29,2.54 0.75,3.41 2.01,1.21 4.1,3.28 2.13,5.63 -1.81,2.29 1.76,3.11 3.07,3.25 -0.11,2.19 -3.08,2.61 -3.38,4.88 -3.04,1.22 4.54,3.66 0.5,5.41 -2.06,2.1 2.08,3.06 2.91,4.43 -1.69,2.31 3.02,2.81 1.48,5.43 -1.24,2.34 -0.79,5.01 0.61,7.16 1.41,1.98 -4.17,3.29 -1.02,4.79 2.26,0.05 5.32,0.82 5.35,-2.42 0.72,-1 2.02,-0.73 1.98,-2.55 1.67,-1.97 4.64,-0.99 6.78,-1.98 2.22,1.06 6.5,-0.36 5.37,-3.34 -1.23,-1.26 -1.47,-1.99 -0.46,-3.44 0.08,-1.16 -1.94,-1.57 0.05,-2.17 1.35,0.35 1.81,0.42 1.48,-1.25 2.2,-0.16 3.02,-3.78 5.01,-3.88 0.84,1.57 2.05,1.86 3.32,0.67 2.68,0.17 3.32,-3.14 5.63,-3.92 1.82,-1.28 5.03,0.86 5.64,-2.21 1.43,-2.02 -0.16,-4.15 0.14,-6.18 1.46,-1.86 0.01,-3.73 0.61,-5.75 0.92,-2.7 -3.55,-3.59 -1.91,-6.4 -0.1,-2.89 -1.24,-5.6 -2.13,-8.31 0.53,-2.38 -1.62,-3.79 -3.3,-5.05 -3.42,-1.42 -0.39,-4.4 0.28,-6.65 1.22,-2.05 -0.13,-4.05 -1.06,-5.89 -0.57,-3.64 -3.88,1.96 -4.89,-0.94 -0.76,-1.55 -3.62,-1.54 -2.67,0.63 -0.82,2.09 -3.74,0.97 -3.82,-0.81 -1.78,-1.38 -2.49,-4.25 -5.38,-3.92 -2.41,1.44 -3.29,-4.02 -5.67,-1.61 -2.01,1.66 -3.63,-1.75 -5.51,-1.95 z",
						"department-23" : "m 342.98,306.61 c -2.22,0.07 -0.3,3.63 -2.54,4.07 -1.32,0.27 -2.01,-2.73 -3.01,-0.55 -0.89,1.96 -2.59,0.09 -2.16,-1.38 -1.21,0.88 -3.38,2.72 -3.55,0.16 -1.42,-0.74 -1.84,2.26 -3.33,2.67 -0.94,0.96 -3.24,2.56 -0.95,3.15 0.74,1.49 -1.76,2.78 -0.46,3.98 -1.09,0.31 -1.25,0.88 -0.72,1.77 -2.02,0.4 -1.95,3.09 -0.35,3.98 1.37,0.23 2.96,0.38 2.56,2.15 1.44,0.58 1.84,1.91 1.46,3.13 1.17,1.01 2.36,1.92 1.96,3.6 0.5,1.5 -1.07,3.34 1.25,3.82 1.51,1.65 -1.51,2.25 -2.3,3.23 -0.13,1.16 2.58,2.24 3.2,0.75 1.91,-0.8 2.84,1.58 2.05,2.87 -2.65,-0.41 -0.83,3.15 0.96,2.99 1.54,0.31 3.93,0.23 4.71,-1.41 1.66,-0.73 0.3,2.53 1.99,2.52 0.76,1.37 1.69,-0.41 2.13,0.77 1.58,0.67 3.17,3.2 1.72,4.26 -0,1.15 -0,2.35 0.6,3.08 1.51,-0.4 3.02,-1.25 4.46,-1.73 0.2,-2.32 3.4,-2.83 4.29,-0.61 0.91,0.9 2.13,0.26 3.14,0.85 1.09,-1.23 2.63,1.9 4.19,2.13 1.55,0.07 0.97,2.57 2.72,1.41 2.03,-0.17 1.58,-3.8 4.15,-2.47 1.63,1.08 3.91,-0.54 3.81,-2.3 -2.17,-0.79 -2.32,-3.17 -3.83,-4.66 -1.26,-2.03 2.6,-0.9 2.25,-3.03 0.21,-1.29 2.68,0.21 2.69,-1.59 1.86,-0.73 1.65,-2.52 2.34,-3.94 0.66,-1.35 3.22,-1.27 1.78,-3.14 0.41,-1.56 0.1,-3.05 -1.27,-4.11 -1.25,-2.06 -0.75,-4.59 -0.2,-6.78 -0.66,-1.41 -2.33,-2.3 -2.06,-4.18 -0.44,-1.74 -1.9,-2.79 -2.47,-4.51 -0.93,-0.77 -2.54,0.96 -2.24,-1.15 -0.18,-1.3 -1.58,-1.85 -2.16,-0.55 -1.19,-0.72 -4.01,-1.5 -2.21,-3.33 1.61,-1.32 -2.49,-0.49 -1.83,-2.43 -0.35,-2.62 -3.98,-1.24 -5.86,-1.45 -1.93,0.7 -3.78,0.84 -5.65,-0.24 -1.44,-0.55 -3.09,-0.74 -4.55,-0.57 -1.66,-0.98 -3.67,1.46 -5.11,-0.03 -0.47,-0.46 -0.89,-1.1 -1.58,-1.2 z",
						"department-87" : "m 322.95,310.24 c -1.42,0.16 -1.79,2.73 -3.55,1.58 -1.2,0.66 -2.71,0.04 -3.05,-0.42 -1.3,-0.05 -2.56,-0.29 -3.03,1.52 -1.19,1 -3.76,-1.34 -4.72,1.11 -0.44,1.9 -0.84,4.74 -3.33,3.79 -1.9,-0.21 -3.25,0.52 -4.49,1.96 -0.02,1.86 -2.26,1.5 -2.78,2.8 1.14,1.36 1.75,3.09 2.03,4.83 -0.68,0.8 -1.8,1.33 -0.59,2.38 -0.3,1.93 -0.99,4 1.23,5.15 0.94,0.27 1.89,-0.69 2.61,0.8 1.7,1.94 1.35,4.78 -1.17,5.81 -1.21,0.95 -4.53,-1.24 -3.28,1.64 0.6,1.91 -0.35,3.84 -1.42,5.38 0.26,1.68 -1.13,2.51 -2.19,1.12 -2.49,-0.32 -0.1,2.96 -2.35,3.08 -1.43,0.77 -3.67,3.87 -0.84,4.34 1.89,-0.29 4.27,-0.2 4.79,2.11 -0.95,1.74 -0.88,4.29 1.4,4.49 2,2.75 2.36,-4.24 4.08,-0.99 1.82,-0.25 3.5,-0.55 5.3,-0.32 2.1,0.81 0.93,3.91 3.41,4.63 0.87,-0.16 3.26,-0.7 3.54,1.24 -1.52,0.83 -2.64,3.87 0.09,3.03 0.75,1.86 3.06,0.22 3.77,2.25 0.84,-1.21 1.61,-4.26 3.58,-2.37 2.08,1.27 2.75,-2.4 4.24,-3.4 2.02,0.94 1.65,-2.95 3.38,-2.04 0.86,1.21 1.4,-0.98 2.28,0.21 2.08,0.81 2.48,-1.96 4.5,-1.98 1.43,-1.73 2.7,-3.69 5.09,-4.12 1.21,-1.27 2.34,-3.1 3.99,-1.2 1.71,0.19 4.31,-1.3 1.99,-2.96 0.07,-1.25 -0.47,-2.97 0.67,-3.72 -0.3,-2.05 -2.19,-3.15 -4.06,-3.42 -2.02,-0.13 -0.89,-4.3 -2.9,-2.07 -1.73,1.32 -4.48,1.17 -6.08,-0.3 -1.12,-1.62 -0.55,-2.47 1.17,-2.93 -0.01,-1.71 -1.38,-2.86 -2.76,-1.32 -1.69,0.77 -4.3,-1.6 -1.64,-2.6 1.99,-0.15 1.87,-2.88 -0.16,-2.79 -0.11,-2.29 0.88,-5.13 -1.66,-6.42 -0.85,-1 0.74,-2.52 -1.23,-3 -1.15,-0.86 -0.34,-2.72 -2.61,-2.36 -2.05,-0.69 -2.23,-3.74 -0.01,-4.54 -1.18,-1.87 2.43,-4 0.45,-5.87 -1.08,-1.05 -1.66,-3.1 -3.26,-3.98 l -0.4,-0.12 -5e-5,-1.9e-4 z",
						"department-19" : "m 355.27,352.42 c -2.41,0.23 -2.49,3.1 -4.92,3.18 -1.99,0.44 -1.91,3.72 -4.48,3.19 -1.55,-0.65 -2.84,-0.92 -3.82,0.74 -1.56,1.31 -4.07,1.15 -4.69,3.53 -0.95,1.61 -3.2,1.41 -4.12,3.15 -1.64,-0.18 -3.14,0.03 -4.36,-0.35 -1.12,0.86 -1.11,2.83 -2.93,2.34 -1.01,1.12 -1.8,3.72 -3.64,3.3 -2.02,-2.15 -4.66,1.56 -2.02,2.76 0.31,0.97 -2.2,1.96 -0.06,2.42 2.59,0.34 1.5,2.36 0,3.31 -0.83,1.5 -2.82,2.32 -2.39,4.34 0.04,1.61 3.43,1.79 1.06,3.35 -1.8,0.75 -0.86,2.16 0.76,1.97 2.37,0.69 -2.18,3.2 0.89,3.57 1.71,0.75 4.42,-0.21 5.43,1.63 -1.66,1.67 -0.01,3.84 0.75,5.6 1.3,2.58 3.34,-0.94 4.92,-0.42 1.79,0.66 4.22,-0.26 5.77,1.61 1.5,1.28 2.33,3.24 4.07,4.22 0.76,2.2 3.51,1.81 4.78,0.26 1.25,-0.4 3.37,-3.39 4.09,-0.76 1.76,-0.42 3.25,-1.82 5.25,-1.36 1.95,0.53 4.83,-0.91 2.7,-2.93 -1.73,-1.56 -0.22,-3.92 1.82,-4 1.95,-0.73 0.57,-3.63 2.68,-4.55 0.82,-1.71 -2.58,-3.02 -0.6,-4.81 1.51,-1.4 2.17,-3.41 4,-4.58 0.93,-1.64 3.52,-2.31 3.34,-4.51 0.2,-1.11 -1.11,-4.2 1.21,-2.96 1.67,0.96 3.94,2.83 5.83,1.58 0.19,-1.48 -2.29,-2.37 -0.91,-4.18 0.6,-1.88 0.63,-3.89 0.79,-5.81 -0.59,-1.81 -2.99,-2.99 -1.89,-5.18 0.21,-1.88 3.04,-1.93 2.06,-4.16 1,-1.83 -1.46,-4.99 -2.67,-2.21 -1.52,1.66 -4.09,-1.17 -5.17,0.94 -0.31,2.03 -3.4,3.01 -4.02,0.67 -1.28,-0.62 -2.83,-0.77 -3.49,-2.39 -1.77,-0.68 -4.6,0.35 -5.48,-2.14 -0.27,-0.01 -0.39,-0.23 -0.56,-0.39 z",
						"department-15" : "m 376.66,370.99 c -1.19,1.79 -1.68,4.43 0.41,5.71 -0.45,1.36 -2.52,1.76 -3.5,0.7 -1.54,-0.13 -3.08,-2.7 -4.37,-1.52 1.01,1.48 0.32,3.55 -0.14,5 -1.99,0.75 -2.55,2.8 -4.34,3.77 -0.52,1.72 -2.45,2.69 -2.85,4.41 0.01,1.72 2.75,2.74 0.58,4.01 -1.7,1.18 -0.26,4.86 -3.09,4.34 -2.7,0.63 -1.59,3.71 0.01,4.92 0.65,2.63 -4.47,0.65 -2.9,3.46 0.18,1.52 2.06,2.72 0.55,4.15 0.27,1.69 1.6,3.03 2.57,4.37 1.84,1.32 0.96,3.2 0.36,4.84 0.62,1.33 -1.78,3.32 -0.26,3.79 2.44,-0.09 0.12,3.67 2.01,4.57 1.7,1.06 0.3,-2.61 2.62,-2 1.68,-0.52 3.98,-1.44 4.57,0.77 2,-0.58 4.32,0.81 6.07,-0.76 0.44,-2.1 2.62,-3.19 3.24,-5.21 -0.69,-2.32 2.22,-3.18 2.15,-5.13 0,-1.99 1.08,-3.78 2.78,-4.51 0.13,-1.76 2.69,-1.8 3.04,-3.55 2.42,-0.56 2.52,3.03 2.13,4.61 0.65,0.42 1.86,-1.04 3.03,-0.48 1.73,-0.26 0.79,2.88 1.8,4.07 0.04,1.66 1.48,1.37 2.34,1.41 0.51,2.24 -0.61,4.88 0.68,7.08 0.22,1.4 1.88,3.16 2.24,0.89 0.17,-2.12 2.41,-3.19 1.69,-5.33 1.31,-1.43 0.1,-3.81 1.86,-5 0.34,-0.92 1.65,-0.92 1.27,-2.39 -0.31,-1.78 2.39,-4.11 2.92,-1.38 1.09,2.08 3.69,-0.13 3.13,-1.91 0.66,-0.39 0.95,-3.09 1.75,-1.44 1.49,0.21 2.7,-1.4 3.92,-1.91 -0.4,-1.03 -0.3,-1.86 0.45,-2.36 -1.43,-1.31 -4.03,-2.15 -2.62,-4.75 0.57,-0.97 -2.13,-2.18 -0.29,-2.34 0.91,1.01 3.57,-0.09 1.27,-0.49 -1.88,-0.31 -2.74,-1.98 -2.94,-3.81 0.41,-1.5 -0.08,-3.01 -1.31,-3.68 -0.8,-1.3 0.17,-4.47 -2.41,-3.26 -1.04,-0.18 -1.8,-1.36 -3.22,-0.75 -1.58,-0.05 -0.93,-0.78 -0.31,-1.52 -0.5,-1.08 -0.49,-0.97 0.23,-1.83 0.02,-2.26 -2.51,0.74 -2.31,1.66 -1.34,2.41 -3.96,1.04 -5.4,-0.41 -0.95,-1.25 -0.73,-4.16 -2.95,-3.91 -1.28,-0.57 -3.08,-2.03 -4.57,-0.67 -1.82,-0.22 -3.86,0.66 -4.36,-1.78 -0,-1.2 0.3,-1.77 -1.25,-1.64 -1.36,-0.3 -1.58,-1.64 -3.02,-0.94 -0.85,-0.58 -1.73,-0.37 -2.46,-0.7 0.33,-0.79 0.12,-1.21 -0.81,-1.16 z",
						"department-30" : "m 444.42,438.64 c -1.37,1.4 -1.47,4.31 -4.11,3.82 -1.82,2.16 3.48,4.17 1.2,6.42 -0.95,2.18 3.26,2.24 1.03,3.92 -1.47,1.55 0.45,4.16 0.51,5.1 -2.55,-1.98 -2.8,3.78 -5.73,2.21 -3.21,1.37 -5.43,-3.13 -8.29,-2.8 -2.58,-0.13 0.51,3.85 -2.49,4.01 -2.34,-0.26 -4.74,-0.24 -7.06,-0.81 -1.48,-1.13 -3.28,-4.1 -5.3,-1.74 -0.62,1.58 -0.39,3.76 -2.68,3.78 -0.55,1.53 1.6,1.88 2.23,1.3 0.87,2.49 4.92,1.11 5.57,4.16 -0.53,2.64 -5.3,3.39 -3.9,6.35 1.94,-0.05 4.16,0.89 3.14,3.19 1.47,0.2 3.75,-3.49 4.35,-0.14 -0.13,1.74 4.38,2.24 2.25,0.01 0.91,-1.71 2.35,-3.26 4.23,-3.02 0.03,-2.83 4.68,-5.23 5.79,-1.96 3.58,0.46 -1.44,4.49 1.7,4.98 1.84,0.01 4.28,-1.91 4.52,1.08 1.97,-0.14 2.41,1.8 1.55,3.19 1.84,-0.54 3.4,0.27 4.34,2.12 1.78,1.76 4.49,2.35 4.8,5.16 1.1,2.05 1.91,4.32 -0.08,6.19 -0.61,1.65 -4.28,0.9 -2.22,3.48 2.02,1.25 0.6,4.53 2.93,5.5 2.92,2.1 1.98,-3.04 4.66,-2.88 1.75,-0.09 1.4,-1.83 1.58,-2.73 1.58,1.9 3.96,-0.99 5.08,-1.95 2.26,-0.22 2.56,-2.12 0.22,-2.36 -0.33,-2.07 2,-4.1 3.12,-5.48 1.84,-1.43 4.51,1.85 5.49,0.22 -1.01,-2.28 0.8,-4.15 1.45,-6.22 7.8e-4,-1.45 -0.24,-2.78 0.19,-4.01 -1.54,-1.58 2.64,-2.15 3.14,-3.77 1.09,-1.96 4.33,-2.36 4.06,-5.1 3.05,-0.25 -0.38,-2.82 -0.88,-4.23 -0.73,-1.79 -2.1,-2.03 -3.48,-2.47 -1.24,-1.93 0.68,-4 -0.12,-6.01 -0.11,-1.52 -0.55,-2.3 -1.93,-2.73 -0.09,-3.19 -3.03,-4.47 -5.49,-5.86 -0.85,-1.95 -5.42,-3.24 -4.58,0.22 -0.31,2.78 -4.09,0.65 -2.51,-1.49 -0.78,-2.43 -5.27,0.56 -5.06,2.59 -1.74,4.01 -4.07,-2.33 -6.63,-1.67 -0.17,-3.42 -6.06,1.94 -4.22,-2.25 0.89,-1.46 -1.23,-2.77 0.6,-3.8 -1.48,-1.1 -0.8,-3.1 -2.98,-3.5 z",
						"department-48" : "m 415.44,405.01 c -1.15,1.06 -2.74,1.92 -4.01,2.62 -0.69,-0.64 -1.67,-0.8 -1.29,0.46 -1.53,0.76 -0.13,2.62 -1.88,3.18 -2.01,2.09 -2.24,-3.15 -4.1,-1.35 -1.31,1.13 -0.06,3.44 -1.69,4.18 -1.69,0.94 -1.27,2.83 -1.72,4.34 -0.97,1.48 0.22,3.26 -1.62,4.26 0.03,1.5 -1.96,3.16 -0.38,4.4 0.87,1.51 2.1,2.7 3.33,3.9 1.23,1.55 -0.58,3.54 0.25,5.21 1.19,0.89 2.58,1.87 2.81,3.49 -0.01,1.82 -0.61,3.52 -0.63,5.35 0.39,1.6 2.03,3.36 0.24,4.88 -0.7,0.91 0.01,1.95 0.76,0.92 0.68,0.58 0.51,2.09 2.03,1.87 1.21,0.4 2.27,1.47 1.17,2.65 0.66,2 3.44,-0.87 5.09,0.05 1.99,-0.31 1.72,2.58 3.51,2.83 1.19,1.74 2.85,2.7 5,2.4 1.56,0.53 3.35,0.39 4.94,0.25 1.61,-0.93 -0.65,-3.55 1.39,-3.88 1.38,-0.82 2.06,1.14 3.43,1.18 1.7,0.64 2.84,3.1 4.85,1.69 1.84,0.97 3.69,-1.03 4.21,-2.44 0.25,-0.78 1.96,0.41 1.35,-0.86 -1.19,-1.1 -0.65,-3.71 0.66,-4.56 -0.1,-1.09 -2.12,-0.79 -1.59,-2.2 -1.5,-1.38 1.85,-2.26 -0.14,-3.49 -0.44,-1.17 -2.42,-2.48 -1.64,-3.65 1.53,-0.64 3.29,-0.85 3.66,-2.81 1.15,-1.55 0.43,-3.47 0.01,-5.14 -0.53,-1.76 -1.03,-3.64 -2.8,-4.29 -0.89,-1.53 -0.87,-3.24 -1.38,-4.86 -0.57,-1.51 -0.77,-3.11 -0.95,-4.62 0.86,-1.54 -2.63,-1.37 -1.37,-3.05 -0.77,0.01 -1.78,0.71 -1.71,-0.71 -1.09,-0.89 -1.87,-1.88 -2.39,-3.14 -0.97,-0.98 -4.72,1.23 -3.53,-1.13 0.36,-2.46 -4.25,-2.89 -3.41,-0.07 0.11,2.29 -2.55,0.73 -3.85,1.77 -1.38,2.1 -2.54,-0.83 -2.97,-2.15 -0.49,-1.59 -1.43,-3.11 -1.48,-4.81 0.52,-1.64 -1.52,-1.82 -2.17,-2.67 z",
						"department-63" : "m 392.19,319.89 c -2.55,-0.28 -0.86,5.52 -3.86,3.12 -1.25,-1.4 -2.58,-0.68 -2.05,1.07 -1.73,0.81 -2.77,2.02 -3.19,3.95 -1.44,2.07 -5.19,-2.58 -4.85,1.35 -0.63,3.31 3.36,4.8 2.13,8.08 1.47,2.13 -3.78,2.44 -2.19,5.1 -1.55,1.17 -2.37,3.35 -4.42,2.96 -0.24,1.6 -1.75,1.77 -2.74,2.77 1.42,1.48 1.73,4.08 3.81,4.89 1.87,1.54 2.57,3.84 2,6.14 -0.04,1.68 -2.35,1.12 -2.11,3.19 -1.39,2.53 3.34,3.48 1.78,6.19 -0.34,2.31 2.23,4.25 4.24,3.81 1.14,-1.05 1.08,1.95 2.83,1.17 1.79,0.25 -0.07,3.43 2.48,3.43 1.93,0.29 4.36,-1.4 6.09,0.07 1.68,0.46 3.42,1.27 3.58,3.5 0.82,2.93 5.77,3.88 6.02,0.11 1.93,-2.52 5.75,-0.49 7.36,-3.56 1.42,-0.5 2.93,-0.93 3.65,-2.15 0.85,0.9 1.35,1.08 1.79,-0.16 1.98,1.79 5.08,1.72 6.94,-0.24 0.86,1.51 2.29,1.65 3.63,2.06 0.19,1.6 1.96,5.14 3.37,2.33 0.39,-1.81 2.34,-1.49 2.81,-0.22 1.8,0.81 3.86,0.64 3.95,-1.61 1.52,-0.72 4.57,4.26 4.36,0.2 -0.77,-2.78 3.41,-2.65 3.56,-5.05 0.08,-1.27 0.91,-2.58 -0.57,-3.51 -0.34,-2.4 -0.78,-5.09 -3.4,-6.04 -2.51,-1.49 -4.52,-3.85 -4.93,-6.82 0.3,-1.94 -2.54,-2.71 -2.43,-4.43 -2.77,-1.23 1.27,-3.17 -0.17,-5.29 -0.46,-1.42 2.48,-2.04 0.65,-3.67 -1.64,-1.61 -3.16,-3.3 -4.93,-4.26 -0.17,-2.37 -2.05,-3.57 -4.29,-2.82 -1.63,0.22 -3.89,0.99 -3.11,-1.62 -0.63,-3.09 -4.12,-1.13 -5.86,-0.4 -1.31,-1.85 -4.09,-0.37 -5.8,-1.73 -2.55,1.22 -4.97,-0.25 -5.88,-2.33 -2.61,1.21 -5.99,-0.97 -6.02,-3.83 -2.94,-0.4 -1.14,-3.31 -0.64,-4.92 -0.73,-1.01 -2.48,-0.38 -3.57,-0.82 z",
						"department-42" : "m 439.34,318.51 c -1.4,1.09 -3.38,0.81 -4.47,2.28 -1.82,0.16 0.93,1.97 0.09,3.08 1.14,1.99 -0.44,3.99 0.89,6.05 0.77,1.92 -0.65,4.26 0.62,6.25 0.35,2.41 -2.79,1.86 -3.96,2.57 -2.35,-0.89 -2.47,3.14 -0.31,3.44 2.21,1.91 -1.24,3.68 -0.28,5.94 0.04,1.28 -2.44,2.83 -0,3.19 0.41,1.15 0.53,2.3 1.79,2.57 1.02,2.1 0.91,4.5 2.54,6.39 1.14,1.23 2.72,2.03 4.02,3.15 1.77,0.88 2.29,2.98 2.14,4.79 0.78,1.17 1.95,2.37 0.85,3.65 0.6,2.98 -3.75,2.43 -3.68,5.29 -0.24,1.25 0.87,4.49 1.47,1.78 1.44,-1.91 3.37,-0.45 4.17,1.17 0.79,-1.11 1.72,-0.5 2.67,-0 0.15,-2.21 3.89,-0.72 3.47,-2.81 1.64,-0.48 3.97,-0.56 5.25,0.84 0.93,1.42 3.2,-0.82 4.25,1.3 1.2,1.24 -2.34,2.57 0.2,3.33 -0.27,1.39 -0.17,3.69 1.96,2.19 2.29,-1.26 3.05,3.76 5.61,1.87 1.45,-0.32 4.47,-0.28 2.95,-2.46 1.25,-1.48 2,-3.74 4.25,-4.48 1.9,-0.58 4.46,-1.86 2.78,-4.17 0.41,-1.63 0.68,-3.17 -0.45,-4.78 -0.86,-0.61 -4.23,1.27 -3.91,-1.71 0.58,-1.76 -0.59,-3.8 -2.3,-4.26 -1.01,-0.71 -2.49,-0.43 -3.84,-0.22 -2.35,-0.44 -2.91,-2.73 -4.9,-4.04 -1.13,-1.62 -2.88,-3.3 -1.38,-5.4 0.82,-1.19 1.08,-2.78 -0.93,-2.26 -0.92,-1.7 1.59,-3.04 1.04,-5 0.45,-1.54 0.67,-2.42 -1.05,-2.72 -1.62,-1 -1.46,-2.43 -0.98,-3.94 -1.13,-0.87 -1.93,-1.93 -2.65,-3.2 -1.86,0.11 -1.37,-2.25 0.24,-1.18 1.64,0.3 1.12,-2.12 -0.24,-1.9 -1.53,-1.06 -1.23,-2.2 0.48,-2.49 1.51,-1.62 0.1,-4.83 3.05,-5.36 1.32,-0.92 3.68,1.05 3.53,-1.68 -0.94,-0.82 -2.52,-1.79 -0.66,-2.63 -0.89,-1.83 -2.59,0.28 -2.37,1.55 -2.07,-0.72 -3.95,3.07 -5.33,1.07 1.08,-1.6 -0.61,-0.93 -1.49,-0.98 -1.01,-1.58 -2.13,1.87 -3.66,0.28 -1.85,-2.55 -4.04,0.49 -6.21,0.61 -1.47,-0.6 -1.78,-3.3 -3.9,-2.35 -2.98,-0.56 1.31,-4.03 -1.36,-4.62 z",
						"department-69" : "m 475.71,316.54 c -0.87,0.66 -2.26,-0.17 -2.52,1.45 -0.41,2.16 -2.61,0.68 -2.93,-0.66 -0.67,1.6 -2.77,2.31 -3.66,0.46 -1.26,-0.9 -4.01,-1.3 -3.92,0.99 -0.37,1.43 -0.56,3.09 0.96,3.77 0.52,1.12 -1.91,1.33 -0.17,2.13 2.28,0.43 0.08,4.11 -1.34,2.29 -1.86,0.33 -3.58,1.48 -3.43,3.62 0.06,1.55 -1,2.53 -2.43,2.92 0.23,1.74 4.09,1.83 1.9,3.67 -0.72,0.19 -2.91,-0.81 -1.65,0.69 1.84,0.06 1.63,2.58 3.34,3.05 1.06,1.28 -1.05,2.4 0.38,3.62 0.39,1.32 3.3,0.37 2.11,2.15 -0.22,1.96 -0.21,4.04 -1.58,5.4 0.01,1.65 2.76,0.01 1.9,1.89 -0.91,1.51 -2.02,4.01 -0.15,5.21 0.45,1.6 1.94,2.05 2.81,3.29 1.08,1.58 3.06,2.61 4.86,1.74 1.3,0.99 3.32,0.03 3.52,2.21 2.12,0.47 -0.12,2.75 1.06,3.97 1.2,1.82 3.29,-1.7 3.78,0.86 0.16,1.37 1.78,1.74 1.97,0.15 1.24,-1.07 3.74,-2.21 3.57,-3.97 -1.59,-0.82 -2.65,-2.33 -3.79,-3.56 1.45,-0.9 3.37,1.43 4.16,-0.58 1.59,-1.09 4.11,-0.52 5.41,-1.38 0.73,-0.87 2.67,0.96 2.14,-1.14 0.23,-1.49 1.61,-2.43 2.72,-3.4 0.22,-1.63 3.96,-0.84 1.92,-2.7 -1.18,-0.64 -2.42,-0.95 -2.58,-2.5 -1.3,-0.05 -1.5,-2.4 0.07,-1.65 1.54,-1.27 -0.94,-1.76 -1.93,-1.2 -1.61,0.34 -3.23,-0.11 -4.84,0.15 -1.46,-0.38 -0.65,-2.88 -1.63,-4.04 -0.76,-1.58 -2.34,-3.8 -4.23,-2.1 0.32,-1.98 -1.88,-2.34 -3.22,-2.76 -0.56,-1.23 1.48,-2.37 0.5,-3.89 -0.4,-1.61 -0.39,-3.41 0.4,-4.71 -0.98,-1.88 1.05,-3.17 1.72,-4.76 0.92,-2.57 -2.82,-1.49 -3.35,-3.18 0.16,-1.57 0.89,-3.77 -1.35,-4.02 -1.92,-1 1.77,-1.42 0.19,-2.69 -0.13,-0.32 -0.31,-0.69 -0.67,-0.81 z",
						"department-43" : "m 421.26,374.78 c -1.2,1.34 -2.87,2.11 -4.64,1.49 -1.25,-0.76 -2.34,-1.79 -2.91,0.14 -0.84,-2.24 -1.76,0.07 -2.9,0.57 -2.32,-0.11 -3.26,3.38 -5.8,2.55 -1.63,-0.33 -0.77,1.6 -1.71,2.2 1.51,0.57 -1.3,1.89 0.77,2.09 1.26,-0.4 2.29,-0.57 2.73,0.69 3.54,-1.62 1.31,4.17 4.32,4.53 0.12,1.27 -0.87,2.9 0.49,4.06 -0.5,2.16 2.84,1.56 3.3,2.93 -0.7,1.4 -3.77,-1.07 -2.6,0.88 1.73,0.64 -1.08,3.7 1.02,4.16 0.94,0.32 2.01,1.12 2.27,2.04 -2.59,1.78 3.04,2.13 2.07,4.48 0.25,1.79 1.1,3.48 1.69,5.15 0.34,1.37 1.37,3.4 2.72,1.72 1.7,-0.4 4.26,-0.23 3.87,-2.73 0.47,-2.25 4.43,-0.37 3.4,1.53 -0.08,1.93 4.07,-1.29 4.11,1.69 0.63,1.03 1.69,1.88 2.42,2.95 1.04,-0.64 1.77,0.2 1.08,1.24 1.62,0.86 4.11,-0.85 4.35,-2.73 0.12,-1.27 1.27,-3.16 2.21,-1.61 -0.03,-1.43 2.73,-0.31 1.93,-2.16 0.24,-2.16 3.15,-1.12 4.56,-1.72 2.32,0.9 2.87,-1.83 3.7,-3.29 1,-1.17 1.05,-3.34 3.11,-2.48 1.27,0.03 2.5,-1.1 1.13,-2.06 -0.7,-2.65 2.91,-1.92 3.79,-3.19 -0.1,-1.04 -2.15,-1.3 -1.02,-2.72 -0.2,-1.4 2.99,-1.23 1.29,-2.52 -1.63,-1.76 2.34,-1.75 2.35,0.04 1.44,0.42 -0.32,-2.17 0.89,-2.9 0.94,-1.34 2.05,-3.68 0.73,-5.06 -0.88,-1.26 -2.34,-2.8 -3.69,-1.15 -1.58,0.28 -1.81,-1.62 -1.38,-2.5 -1.45,-0.91 -1.01,-1.92 0.04,-2.8 -0.1,-1.71 -2.16,-2.09 -3.32,-1.28 -1.53,-0.47 -2.3,-2.47 -4.19,-1.61 -1.37,-1.08 -2.04,0.41 -2.17,1.15 -1.7,-0.13 -2.84,0.96 -3.78,1.85 -0.54,-1.5 -1.86,-0.63 -2.23,0.5 -0.6,-1.73 -2.18,-4 -3.94,-1.96 -0.39,0.75 -1.16,2.59 -1.53,0.73 -1.82,-0.26 -2.76,-1.83 -4.21,-2.45 -1,0.7 -0.59,3.14 -2.68,2.22 -1.44,0.27 -2.48,-1.86 -3.42,-1.39 -0.83,2.24 -3.45,3.07 -3.98,0.29 0.04,-2.47 -3.46,-1.21 -3.94,-3.43 l -0.12,-0.08 -0.17,-0.03 -3e-5,-2e-5 z",
						"department-07" : "m 478.61,378.73 c -2.43,1.15 -5.28,2.24 -6.12,4.92 -1.47,0.79 0.77,3.37 -2.12,2.96 -2.3,0.14 -4.11,1.25 -4.03,3.67 -0.84,1.45 -1.94,2.84 -1.07,4.56 -1.38,1.82 -1.62,-3.04 -3.47,-1.01 0.08,0.93 1.95,1.84 0.07,2.26 -1.79,0.55 -1.33,2.95 0.02,3.6 -0.47,2.05 -5.25,0.66 -3.53,3.85 1.35,2.27 -2.75,1.28 -3.52,2.23 -0.5,1.82 -1.67,3.14 -2.48,4.79 -1.73,1.45 -4.69,0.09 -6.54,1.2 -0.06,1.33 5.1e-4,2.62 -1.59,2.74 -0.66,1.6 -2.32,-1.24 -2.47,1.13 -0.36,1.82 -1.26,3.38 -3.22,3.84 0.04,1.47 -0.12,2.83 0.5,4.14 -0.1,1.82 0.99,3.59 1.16,5.49 0.67,1.99 3.13,2.65 3.18,5.05 0.75,1.76 0.19,4.26 2.32,5.13 1.14,0.83 0.97,2.08 1.77,2.99 -1.24,1.36 0.11,3.46 -0.9,5.32 1.7,-0.1 3.99,-2.05 4.86,0.52 2.26,-0.51 3.42,4.43 5.77,2.48 0.31,-2.54 2.53,-4.68 5.23,-4.38 0.89,1.01 -0.75,4.43 2.04,3.6 1.01,-1.21 0.09,-4.63 2.94,-3.24 2.16,0.6 2.99,2.88 5.17,3.49 3.18,1.08 0.89,-3.83 1.62,-5.6 0.28,-2.28 1.17,-4.29 2.28,-6.18 -0.94,-1.85 0.15,-3.5 -0.11,-5.34 -0.79,-2.42 2.76,-2.83 2.6,-5.19 1.37,-1.81 1.38,-4.03 0.6,-6.07 -0.96,-2.59 0.31,-4.79 1.95,-6.59 1.36,-1.91 2.29,-4.02 2.49,-6.23 1.64,-1.73 0.06,-3.51 -0.65,-5.16 -1.26,-1.76 0.39,-3.62 -0.03,-5.17 -1.22,-0.73 -1.37,-3.11 -1.97,-4.41 1.51,-2.03 -0.75,-4.24 -0.05,-6.66 -0.04,-1.75 0.77,-4.06 -1.11,-5.2 -2.04,-0.52 0.62,-3.48 -1.62,-3.51 z",
						"department-26" : "m 490.06,380.18 c -2.2,0.56 -3.88,2.66 -6.05,2.81 -3.74,-1.64 -2.07,3.38 -2.55,5.43 -0.35,2.11 1.49,4.21 0.01,5.98 0.79,1.98 1.55,3.45 2.24,5.24 -1.29,2.04 -0.29,4.71 1.12,6.41 0.25,2.06 -1.29,3.81 -1.22,5.86 -1.25,2.18 -2.62,4.37 -4.07,6.28 -0.43,2.53 1.05,4.97 0.64,7.45 -1.11,2.2 -1.7,4.54 -3.68,6.04 0.42,2.44 -0.56,4.43 0.03,6.97 -0.96,1.7 -1.87,3.37 -2.02,5.52 -1.39,2.72 1.41,4.19 3.69,3.18 2.81,-0.3 3.35,2.71 3.5,4.85 0.37,3.51 2.74,-1.84 4.51,-0.57 2.16,-0.59 4.03,-1.98 6.1,-2.75 1.51,-0.08 2.29,2.59 4.01,0.74 0.5,-1.18 2.52,-1.98 1.58,-0.02 -1.01,1.27 0.17,2.55 -0.34,4.08 1.15,1.41 3.51,1.06 4.37,0.11 1.67,1.57 4.23,0.98 5.78,1.84 0.25,1.64 0.25,3.64 2.37,3.49 0.91,2.71 3.78,2.54 5.26,0.39 2.19,-0.46 -0.06,-2.21 1.78,-3.11 1.34,-0.38 2.44,2.36 3.26,-0.05 2.18,-0.81 -6.3e-4,-3.76 0.89,-5.26 -1.51,0.33 -2.13,-0.36 -2.13,-1.88 -1.71,-0.59 -0.04,-1.09 -0.62,-2.13 -2.21,0.34 -4.1,-0.84 -6.08,-0.9 -1.47,-1.34 -2.63,-1.81 -2.27,-3.98 -1.26,-1.18 -0.4,-2.46 1.16,-1.59 2.99,0.47 -0.78,-1.84 -0.05,-3.38 -0.23,-2.54 3.38,-0.17 4.83,0.17 1.61,1.06 2.72,-0.15 3.05,-1.54 3.5,-0.73 -3.7,-2.69 -0.93,-4.76 1.26,-1.58 1.47,-3.55 1.66,-5.28 1.87,-0.08 3.69,1.17 5.27,-0.42 1.95,0.61 4.32,-4.02 0.86,-2.8 -2.08,0.57 -3.09,-2.21 -5.42,-1.46 -1.77,-1.01 -3.15,-3.24 -4.84,-4.16 -0.16,1.89 -3.87,0.17 -4.2,-1.02 0.68,-1.61 -0.42,-3.55 0.42,-5.5 0.5,-2.42 -0.05,-4.88 0.51,-7.29 -0.24,-1.96 -1.28,-4.35 -0.26,-5.76 -2.06,0.11 -3.32,4.84 -5.81,2.14 -1.99,-1.01 -4.42,0.14 -6.13,-1.91 -1.24,-1.25 -3.27,2.19 -3.6,-0.2 1.59,-1.06 2.63,-3.44 2.06,-5.42 -0.76,-1.46 -1.02,-3.1 0.12,-4.28 -0.3,-2.46 -4.17,0.05 -2.8,-2.99 1,-3.02 -3.16,1.05 -2.98,-2.14 -0.86,-0.9 -2.38,-1.19 -2.72,-2.37 l -0.22,0.01 -0.1,-0.08 -3e-5,3e-5 z m -1.27,60.37 c 2.48,0.28 2.21,2.93 4.58,3.23 -0.38,1.33 -2.81,1.88 -2.81,3.92 -0.59,3.17 -3.27,0.44 -5.16,1.06 -0.4,-1.03 -0.64,-2.47 -0.57,-3.43 1.53,-1.47 1.23,-3.83 3.67,-4.42 l 0.29,-0.35 0,-5e-5 z",
						"department-84" : "m 488.85,440.78 c -1.34,0.86 -2.93,1.54 -2.87,3.42 -0.68,0.82 -1.64,1.74 -0.5,2.58 -1.2,2.34 2.22,1.84 3.59,2.34 1.48,-0.54 1.64,-2.52 2.39,-3.79 0.79,-0.35 2.96,-1.64 0.82,-1.79 -1.64,-0.52 -1.5,-2.57 -3.42,-2.75 z m -10.71,6.69 c -1.19,0.91 -3.89,-0.8 -3.68,1.44 -0.73,2.05 0.8,3.62 1.06,5.48 -0.11,0.77 2.02,0.05 1.46,1.41 1.54,2.17 -0.72,4.93 0.39,7.13 0.94,0.88 2.18,-0.09 2.84,1.53 0.92,1.17 1.41,2.6 2.56,3.59 1.05,1.11 0.24,2.14 -1.06,2.18 0.2,1.77 -1.63,3.02 -3.13,3.54 2.03,1.04 4.6,0.46 6.54,1.82 1.39,1.18 3.61,1.18 4.61,2.89 1.6,1.26 2.39,3.14 3.49,4.69 1.51,1.08 3.21,1.85 4.79,2.81 1.63,0.75 3.18,-0.86 4.87,-0.11 2.29,0.4 3.91,2.2 5.94,3.19 2.96,1.79 6.59,3.05 10.03,1.93 1.29,-1.1 2.79,-1.78 4.31,-2.16 1.8,-1.2 1.92,-2.89 -0.06,-3.86 -0.16,-1.44 -1.74,-2.11 -2.33,-3.45 -1,-1.76 -3.47,-1.32 -4.99,-0.56 -1.48,-0.8 0.41,-2.84 1.15,-3.82 0.46,-1.11 1.45,-2.4 -0.1,-3.03 -0.35,-2.14 -3.82,-0.43 -3.2,-3.05 0.4,-2.09 1.95,-4.02 1.54,-6.21 -0.81,-0.41 -2.5,0.33 -2.15,-1.48 0.64,-1.88 -1.29,-2 -2.27,-2.81 -0.01,-2.28 -4.01,-1.03 -2.94,-3.84 0.24,-2.27 -2.29,-1.24 -3.59,-1.48 -1.07,-0.69 -2.71,-2.07 -3.26,-0.4 -1.82,0.23 -4.43,-0.82 -3.4,-2.94 -1.52,-1.18 1.5,-2.71 -0.01,-3.48 -0.77,1.1 -2.19,2.64 -3.61,1.68 -1.1,-2.3 -2.93,-0.02 -4.5,0.33 -1.39,0.4 -2.62,1.76 -4.19,1.24 -1.3,-0.02 -2.72,3.52 -3.54,1.33 -0.4,-1.69 -1.5e-4,-4.12 -1.77,-5.12 -0.57,-0.28 -1.12,-0.47 -1.78,-0.4 z",
						"department-13" : "m 478.58,474.18 c -1.02,1.74 -3.79,2.63 -4.3,4.26 1.41,0.89 -0.85,2.14 0.08,3.62 0.42,2.15 -2.05,3.5 -1.66,5.71 0.86,1.45 -0.19,2.57 -1.65,1.52 -1.97,-1.55 -4.66,-0.42 -5.3,1.68 -1.63,1.04 -2.16,4.14 0.43,3.77 0.06,2.02 -2.9,1.68 -3.35,3.32 -1.75,0.99 -3.63,1.22 -4.48,2.81 -1.75,0.17 -4.98,3.13 -2.07,3.96 2.99,-0.17 5.89,1.39 8.87,0.54 2.1,-0.36 4.54,-0.1 6.14,1.39 1.4,1.7 -2.45,3.84 0.49,4.9 1.67,0.45 3.47,0.17 5.19,0.41 1.54,-0.09 3.73,0.57 4.86,-0.31 0.04,-2.31 -3.26,-2.38 -3.93,-4.38 -0.37,-2.14 0.44,-4.38 -0.32,-6.5 -0.27,-0.91 -2.06,-4.56 -0.27,-2.13 1.58,2.03 1.37,4.67 1.02,7.06 -0.44,2.92 3.29,3.56 4.97,5.18 2.32,-0.03 -1.87,-2.76 1.23,-3.14 1.7,-0.98 3.7,-0.9 4.98,0.78 2.12,-0.03 4.8,-1.93 3,-4.13 -2.29,-0.91 -1.95,-4.35 -0.96,-5.24 1.18,1.76 4.95,0.13 3.94,3.25 1.13,1.96 3.22,1.2 4.73,0.55 1.52,1.99 -1.58,3.78 -3.04,4.82 -1.9,0.72 -4.27,-0.43 -5.92,1.16 -1.75,1.59 0.48,4.43 2.49,4.22 2.62,-0.1 5.4,0.48 7.9,-0.43 1.54,-1.44 4.68,-1.73 4.92,0.97 -0.14,1.58 -0.17,2.95 0.5,4.25 -1.22,1.5 -0.87,3.6 1.42,3.31 2.25,-0.5 4.6,0.97 6.52,0.15 1.1,1.57 2.77,3.18 4.58,1.51 2.82,0.58 0.75,-3.74 3.05,-4.43 1.69,-0.57 3.36,-2.03 1.32,-3.58 -0.67,-1.39 -3.72,-0.01 -2.13,-2.07 1.3,-1.41 -1.85,-4.96 1.42,-4.8 1.44,0.62 3.95,-0.29 1.73,-1.54 -1.13,-1.86 -3.57,-3.47 -1.96,-5.73 1.16,-2.3 -1.63,-2.6 -2.43,-3.88 1.77,-1.07 0.43,-4.96 3.4,-5.18 2.17,-0.08 4.44,-1.71 2.13,-3.53 -1.53,-2.95 -2.76,2.22 -4.93,1.23 -1.92,1.74 -4.53,2.47 -7.1,1.81 -3.71,-0.74 -6.76,-3.14 -9.98,-4.96 -2.3,-1.39 -4.89,0.82 -6.98,-0.72 -2.66,-1.2 -4.83,-2.8 -6.01,-5.48 -1.4,-1.42 -2.56,-3.22 -4.67,-3.62 -1.73,-1.15 -3.64,-1.96 -5.77,-2.02 -0.7,-0.12 -1.39,-0.34 -2.11,-0.35 z",
						"department-83" : "m 559.22,482.26 c -1.57,0.81 -4.53,-0.4 -4.3,2.48 -0.47,2.33 -3.03,1.82 -4.36,0.6 -1.41,-0.76 -2.26,-2.48 -3.64,-3.12 -2.45,0.17 -2.27,4 -4.8,4.06 -1.96,-0.22 -2.3,2.52 -4.07,3.08 -0.59,2.99 -2.57,-0.15 -3.05,-1.52 -1.23,-0.42 -1.79,-1.24 -2.31,-2.45 -1.22,-0.17 -1.1,2.16 -2.74,2.01 -1.26,0.13 -2.14,-3.05 -4.04,-1.85 -1.64,1.3 0.43,2.05 0.67,3.41 2.14,1.11 -0.57,3.17 -2.19,2.85 -2.35,0.42 -2.84,2.84 -2.76,4.79 -2.56,1.38 3.23,1.17 1.65,3.42 -0.26,1.61 -1.37,3.36 0.44,4.46 0.29,1.5 2.21,2.13 2.37,3.42 -1.12,1.57 -3.85,-0.8 -4.35,1.34 0.76,1.53 0.55,2.92 0.06,4.45 0.47,1.1 2.42,0.11 2.67,1.81 2.05,1.9 -1.02,2.56 -2.07,3.64 -1.27,1.01 -1.39,3.18 -0.59,4.5 -0.02,1.61 1.89,3.03 3.53,2.54 0.63,0.64 0.56,1.76 1.87,1.59 0.19,0.99 -2.67,1.2 -1.12,2.52 1.43,0.36 3.78,3.24 4.48,0.31 0.46,-1.06 3.11,0.26 1.75,-1.2 -1.19,-0.66 -2.07,-1.93 -0.13,-2.23 1.14,-0.04 1.62,1.7 3.17,1.02 1.73,-0.39 2.63,1.9 4.52,0.7 2.33,-0.05 2.29,3.1 -0.04,3.08 1.01,0.28 3.42,0.9 4.13,-0.08 -1.41,-0.84 -0.65,-3.04 0.06,-4.2 1.81,-0.51 4.14,-1.1 5.91,0.02 0.9,0.75 1.8,2.99 3.07,1.38 -1.33,-2.25 0.74,-4.08 2.94,-4.32 1.82,-0.15 3.69,-0.25 4.8,-1.93 1.53,-0.99 2.65,0.47 3.21,1.51 1.86,-0.28 1.12,-2.69 3.08,-2.91 -0.25,-0.86 -1.2,-2 0.22,-2.75 2,-2.05 -1.75,-2.02 -3,-1.6 -2.62,-0.25 0.68,-1.83 1.74,-1.96 0.92,-0.9 0.59,-2.79 2.41,-3 1.27,-1 0.94,-3 1.39,-4.45 1.32,-1.24 3.42,1.1 5.12,-0.25 2.11,-0.39 5.31,-3.55 2.23,-5.07 -0.91,-0.67 0.04,-2.14 -0.81,-2.85 1.19,-1.51 2.17,-5.23 -0.93,-4.5 -1.9,-0.64 -3.15,-2.19 -4.31,-3.7 -0.38,-1.46 0.89,-3.33 -0.59,-4.65 -1.69,-0.39 -2.7,-1.75 -4.45,-1.31 -0.63,-1.4 -1.63,-4.65 -3.65,-2.69 -0.92,1.21 -1.67,0.76 -2.07,-0.48 -0.31,-0.35 -0.87,-0.26 -1.13,0.1 z",
						"department-06" : "m 576.68,445.25 c -1.34,1.23 -3.9,1.28 -4.17,3.49 -0.13,1.25 -0.15,2.32 -1.56,2.41 -1.9,1.04 -1.65,2.94 -2.4,4.72 -1.12,1.8 -0.44,3.86 0.62,5.5 1.39,1.18 1.52,2.81 1.21,4.48 0.95,1.31 2.36,2.44 3.59,3.57 1.13,1.57 2.02,3.38 3.71,4.46 1.86,0.62 1.75,2.74 -0.45,2.28 -1.47,-0.07 -2.99,-2.84 -4.42,-0.95 -0.71,1.34 -2.19,2.93 -3.8,1.81 -2,-0.79 -0.09,1.89 -1.86,2.2 -0.86,1.13 3.05,2.08 0.42,2.7 -2.14,-0.09 -2.94,2.46 -0.88,3.26 1.41,-0.36 2.86,1.09 4.07,1.52 1.52,1.48 -0.21,3.43 0.75,4.88 0.99,1.27 2.13,2.35 3.57,3.11 1.1,0.29 3.38,-0.11 2.46,1.9 0.25,1.55 -1.7,2.77 -0.61,4.33 -0.6,2.27 3.36,2.88 2.7,0.25 0.05,-1.74 2.24,-2.34 3.66,-2.24 1.4,-0.6 3.03,-1.96 4.31,-0.48 0.92,-1.55 -0.13,-3.6 0.66,-5.28 0.47,-2.1 3.38,-1.02 4.03,-3.01 0.72,-1.31 3.11,-1.16 4.22,-0.93 0.41,1.87 1.38,-0.15 0.99,-1.1 1.14,-0.12 2.6,-0.32 2.24,-2.03 0.47,-1.55 1.98,-1.35 2.76,-0.43 1.62,-0.12 1.35,-2.48 3.24,-2.43 0.12,-1.52 -1.2,-3.1 -1.24,-4.77 -0.33,-2.13 2.98,-2.32 2.8,-4.51 0.2,-2.18 2.79,-2.46 3.91,-4.1 1.16,-1.41 0.77,-3.42 2.5,-4.52 1.68,-1.83 -0.84,-3.38 -1.62,-4.86 0.1,-1.29 0.78,-4.61 -1.63,-3.23 -1.26,1.94 -4,1.29 -5.92,2.41 -1.51,0.57 -3.06,1.13 -4.67,1.28 -1.89,0.43 -2.51,-1.6 -4.03,-1.95 -2.04,0.55 -3.05,-1.81 -4.89,-2.29 -1.02,-1.04 -2,-2.14 -3.6,-1.65 -1.13,-0.99 -2.66,-2.58 -4.35,-1.81 -2.02,0.21 -1.9,-2.22 -2.76,-3.32 -1.88,-1.1 -1.62,-3.6 -3.55,-4.67 l -2e-5,0 z",
						"department-04" : "m 578.06,425.55 c -1.79,1.91 -3.88,3.35 -6.26,4.36 -0.91,2.06 -3.09,2.86 -4.5,4.3 -0.94,1.81 -1.79,3.6 -2.77,5.22 -2.29,-0.14 -4.98,0.19 -7.06,-0.62 -1.64,-0.84 -3.17,-1.46 -3.98,-3.23 -1.53,-1.67 -2.1,-0.06 -1.63,1.35 -0.71,2.73 -2.97,-0.6 -4.42,1.45 -0.89,1.01 2.03,4.3 -0.67,5.1 -1.25,-1.28 -2.93,-2.88 -3.78,-4.62 -0.62,-1.54 -3.84,-1.76 -3.55,0.47 -2.18,1.03 -4.15,2.5 -5.81,4.38 -0.23,1.86 -3.02,3.89 -1.01,5.05 -0.39,1.39 0.39,5.1 -1.68,2.68 -0.48,-1.23 -1.95,-3.42 -2.69,-1.06 -0.25,2.02 2.07,2.84 2.74,4.63 2.88,1.42 -1.86,1.68 -2.85,0.49 -2.27,-1.04 -4.5,0.48 -6.65,1.03 -2.34,-0.2 -1.23,1.76 0.05,1.9 -0.37,1.86 -3.04,0.49 -2.51,-0.96 -1.2,-1.89 -3.39,-0.47 -2.33,1.29 -1.38,1.24 -4.15,2.32 -3.59,4.73 0.1,1.81 2.93,0.33 2.17,2.72 0.04,2.14 -2.45,4.21 -1.09,6.19 2.04,0.05 4.71,2.28 3.01,4.32 -0.56,0.85 -3.08,4.05 -0.97,3.82 1.98,-0.87 4.5,-0.39 5.28,1.85 1.68,0.71 1.89,4.62 3.93,3.44 2.28,-2.68 4.41,3.96 6.19,0.2 0.56,-2.48 1.95,0.75 2.61,1.18 1.68,0.45 2.42,5.33 3.85,1.97 1.9,-0.61 2.25,-4.15 4.41,-2.96 2.18,-0.65 2.11,-4.38 4.7,-4.13 1.56,1.2 2.64,3.02 4.57,3.82 3.07,1.67 2.6,-2.97 4.56,-3.46 1.84,0.36 4.06,-1.35 5.21,0.56 1.19,-0.81 2.6,-1.81 3.71,-0.55 1.42,-0.11 4.73,-1.19 1.92,-2.19 -1.35,-1.2 2.26,-2.28 -0.08,-3.51 0.29,-1.03 3.95,1.85 4.85,-0.55 0.91,-2.66 3.44,-1.65 4.86,-0.2 3.02,0.64 1.63,-2.29 -0.12,-2.82 -2.05,-1.6 -2.63,-4.03 -4.84,-5.66 -2.89,-1.21 -0.33,-4.82 -3.03,-6.42 -1.52,-2.18 -0.87,-4.61 0.1,-6.86 -0.18,-2.84 3.58,-3.02 3.54,-5.58 0.04,-2.67 4.23,-2.08 4.01,-4.72 -0.43,-1.8 0.9,-3.4 2.1,-3.9 -1.19,-1.88 -3.77,-3.29 -3.4,-5.88 0.82,-2.4 3.87,-3.31 4.42,-6.02 0.5,-1.14 -0.06,-2.78 -1.51,-2.6 z",
						"department-05" : "m 547.99,394.72 c -2.38,0.66 0.14,3.65 -2.04,4.59 -1.72,2.79 1.38,4.23 3.67,3.34 2.39,-0.55 0.11,3.63 2.6,4.03 0.47,1.76 0.32,4.23 -0.38,6.05 -1.48,-0.46 -3.11,-2.39 -4.34,-0.35 -2.25,0.76 -5.02,-1.36 -6.72,0.9 -1.11,1.7 -2.56,1.95 -3.87,0.46 -0.55,1.28 -4.19,1.53 -1.83,3.08 -0.94,2.26 -4.27,2.96 -6.39,2.25 -1.23,0.91 -1.35,3.15 -0.59,4.29 -1.22,2.28 -3.08,2.71 -5.48,3.19 -1.63,-1.42 -3.66,-0.27 -2.81,1.73 -0.72,1.97 -3.57,4.79 -0.27,5.87 1.2,0.81 1.12,1.93 -0.27,1.84 -0.36,2.15 -2.1,2.6 -3.75,1.29 -1.52,-0.34 -5.12,-2.62 -4.07,0.55 -0.41,1.39 2.93,2.85 0.39,3.11 -1.92,-1.14 -2.38,0.42 -1.36,1.93 -0.48,1.59 1.39,2.76 2.89,3.31 1.63,-0.31 3.02,1.4 4.87,0.66 1.62,0.26 -0.61,1.99 1.27,2.58 -1.05,2.29 3.4,0.59 1.78,2.97 0.12,1.55 -0.2,5.31 2.1,3.26 2.05,-1 4.29,-0.84 6.21,0.33 0.91,0.52 3.34,0.01 1.39,-0.84 -1.03,-1.7 -4.85,-4.53 -1.7,-6.04 1.62,0 1.19,3.71 3.13,2.57 -0.69,-1.31 0.59,-3.18 -0.89,-3.95 0.72,-1.83 1.98,-3.48 2.79,-5.24 1.98,-1.13 3.83,-2.62 5.33,-4.06 0.55,-2.47 4.01,0.2 4.36,1.68 1.17,1.24 3.19,5.35 3.76,1.42 -0.12,-1.55 -1.92,-3.72 0.84,-3.9 0.95,-0.85 2.77,1.43 3.17,-0.92 -1.08,-1.89 1.26,-3 2.06,-0.94 1.41,2.28 4.07,3.44 6.77,3.41 2.13,0.13 5.13,0.83 4.93,-2.31 1.73,-1.41 1.26,-4.25 4.01,-4.38 1.4,-2.29 3.54,-3.54 5.83,-4.74 1.17,-1.99 3.47,-1.95 4.93,-3.17 0.67,-2.95 6.23,1.05 4.2,-2.83 -2.19,-1.97 -1.76,-5.14 -1.75,-7.7 -1.52,-2.46 -4.35,-1.97 -6.64,-1.67 -2.02,-1.18 -4,-2.53 -5.8,-3.98 -0.48,-1.92 0.47,-3.94 -0.24,-5.89 -0.38,-2.63 -4.7,-0.2 -3.98,-3.67 -0.57,-1.87 -2.49,-5.8 -4.62,-2.96 -1.36,0.43 -3.53,-0.42 -3.04,1.99 -0.06,2.84 -3.63,0.47 -5.25,0.4 0.16,-2.01 -1.71,-4.09 -3.81,-2.68 -0.55,-0.15 -0.86,-0.68 -1.39,-0.87 z",
						"department-38" : "m 506.21,344.54 c -1.88,1.33 -2.23,3.7 -3.32,5.52 -1.34,2.3 -4.23,2.26 -5.28,-0.2 -1.63,-1.26 -3.52,0.86 -4.4,1.39 1.17,1.3 1.8,2.91 3.88,3.67 1.31,1.91 -2.57,1.27 -2.93,3.19 -2.06,0.59 -1.33,3.63 -2.79,3.93 -1.48,-0.6 -0.86,1.43 -2.43,0.5 -2.33,-0.47 -4.27,1.29 -6,1.87 -1.18,-1.22 -3.3,-0.13 -1.21,0.96 1.61,1.13 3.81,3.06 1.1,4.43 -2.09,1.53 -4.17,3.49 -4.03,6.09 1.39,2.32 -0.56,6.97 3.37,6.92 1.73,-0.4 3.29,0.6 4.78,-1.36 1.66,-1.29 3.87,-1.73 5.01,0.03 1.52,1.35 2.19,3.28 4.49,1.68 -0.19,1.26 -0.96,4.15 1.21,2.89 1.74,0.94 1.9,2.4 0.45,3.29 1.63,2.94 0.62,5.97 -0.85,8.62 0.93,0.61 2.14,-1.99 3.53,-0.26 1.93,2.01 4.97,0.58 6.92,2.09 0.61,-0.46 2.39,-0.05 2.89,-1.65 0.65,-1.87 3.29,-0.55 1.34,0.75 -0.07,2.06 1.31,4.42 0.43,6.78 0.61,2.89 -1.23,6.17 -0.17,8.74 -0.34,1.42 -0.84,2.36 1.15,2.84 1.54,0.86 1.8,0.11 2.38,-0.56 2.2,1.13 3.44,4.49 6.11,4.38 1.81,0.1 4.74,3.29 5.87,-0.16 -0.07,-3.68 3.68,-0.6 5.62,-2.47 2.01,-0.73 1.35,-1.84 0.68,-3.02 1.72,-0.3 3.15,-2.8 4.65,-0.87 2.1,-0.43 3.17,-3.79 5.7,-2.12 1.86,0.27 3.49,-0.15 4.92,-1.35 1.13,0.91 3.29,2.59 2.84,-0.19 0.52,-2.11 0.19,-4.11 -1.34,-5.54 0.21,-1.88 -0.42,-3.23 -2.41,-2.34 -3.75,0.79 -3.51,-3.59 -1.43,-5.33 -1.62,-1.66 3.15,-4.86 -0.53,-4.45 -1.08,-0.84 -2.04,-1.13 -3.48,-0.51 0.71,-1.86 -0.03,-3.81 -1.05,-5.65 0.02,-2.43 0.68,-4.88 2.79,-6.15 -0.4,-2.19 -0.11,-4.49 -2.42,-6.09 -1.51,-2.03 -5.27,0.02 -6.22,-3.15 -1.31,-2.51 -4.19,-0.31 -3.7,1.79 -1.06,1.18 1.08,4.22 -1.58,3.15 -1.76,-1.2 -3.8,-3.06 -6.16,-2.68 -1.03,-2.41 -2.12,-5.17 -3.71,-7.54 -1.49,-2.29 -2.42,-5.24 -4.04,-7.47 -2.05,-1.32 -1.69,-4.2 -4.09,-5.63 -1.56,-1.81 -3.52,-3.85 -3.25,-6.16 -0.86,-1.11 -1.94,-2.11 -3.29,-2.57 z",
						"department-73" : "m 528.16,341 c 0.35,3.72 -2.24,6.95 -2.01,10.67 0.1,2.01 -0.58,5.1 -3.24,4.31 -0.43,1.18 -0.8,3.5 -1.67,4.48 -2.51,0.74 -2.36,3.37 -0.57,4.81 0.93,2.31 2.34,4.23 3.26,6.58 -0.17,1.78 0.96,2.22 2.43,1.92 1.76,1.08 3.64,1.93 5.33,2.99 0.87,-0.84 -0.73,-2.31 0.55,-3.46 -0.12,-1.78 1.2,-3.68 3.21,-2.61 1.1,1.74 2.37,3.4 4.64,2.84 2.27,0.25 3.8,2.63 4.54,4.68 0.36,1.5 0.44,3.81 -1.67,4.51 -0.76,1.6 -1.21,3.9 -0.45,5.48 1.39,1.25 0.79,2.93 0.5,4.28 1.2,-0.09 2.15,-0.82 3.27,0.45 2.17,-0.4 2.46,4.16 4.9,1.97 2.63,0.04 0.95,3.94 3.55,3.69 1.62,0.4 4.26,1.17 3.61,-1.57 0.15,-2.51 3.33,0.03 4.25,-2.3 2.39,1.02 4.15,-0.9 6.2,-1.32 1.67,-0.64 2.89,-1.71 4.58,-0.27 0.86,1.73 4.44,1.23 3.34,-0.98 2.96,-0.22 3.03,-3.89 6.13,-3.81 1.12,-1.22 2.89,1.16 3.11,-1.12 2.54,-0.93 1.89,-3.28 1.07,-5.24 0.54,-1.73 2.07,-3.23 2.76,-5.1 0.35,-2.33 -3.37,-2.25 -3.54,-4.68 -1.48,-1.57 -3.47,-2.39 -4.85,-4.16 0.27,-1.97 -1.2,-3.82 -0.64,-5.76 1.75,-2.42 -1.85,-2.52 -3.12,-3.34 -1.24,-1.6 -4.56,-1.92 -4.61,-4.76 0.32,-1.85 -1.36,-3.51 -2.59,-1.43 -0.39,1.65 -3.27,3.17 -2.65,0.38 -0.11,-2.47 -2.2,-3.62 -4.41,-3.02 -1.75,-1.13 -3.62,-3.87 -1.33,-5.28 -0.65,-2.14 -3.49,-1.94 -4.36,-0.05 -1.44,1.91 -1.25,4.9 -3.66,6.11 -1.87,2.17 -1.6,6.61 -5.3,6.55 -1.34,0.69 -2.15,-0.24 -2.58,-1.16 -2.37,1.73 -0.5,-3.64 -3.3,-3.5 -0.96,0.26 -2.31,-0.37 -2.17,1.15 -2.03,-0.44 -5.65,0.22 -5.65,-3.01 -0.25,-1.87 -2.33,-1.33 -3.5,-2.01 -1.48,-1.5 -1.27,-4.07 -1.6,-6.29 0.01,-1.1 -0.75,-1.73 -1.73,-1.62 z",
						"department-74" : "m 564.76,306.43 c -2.47,0.62 -5.51,-0.54 -7.48,1.57 -1.52,1.73 -3.75,1.96 -5.89,2.12 -1.97,0.39 -2.97,2.38 -4.35,3.67 -1.65,1.56 1.06,2.57 0.25,4.17 -0.09,2.18 3.52,0.59 2.24,2.89 -1.49,1.45 -3.64,2.16 -4.84,3.94 -0.54,2.24 -3.41,2.73 -5.28,1.92 -2.23,0.66 -4.6,0.8 -6.85,1.51 -2.16,-0.26 -0.66,3.85 -3.07,2.57 -0.79,-0.6 -1.45,-1.68 -1.68,-0.05 -0.63,2.06 -0.34,4.25 -0.34,6.37 1.88,1.17 -0.08,3.96 2.4,4.32 0.17,1.93 0.65,3.96 0.64,5.96 1.07,0.82 1.6,2.58 3.2,1.53 0.88,0.13 0.55,1.3 1.58,1.55 -0.54,1.95 1.99,3.65 3.72,2.82 1.5,1.44 1.43,-1.59 2.61,-0.6 1.78,-0.8 3.39,1.12 3.44,2.85 -0.33,1.6 1.97,-0.38 1.83,1.5 1.74,0.8 4.89,0.04 4.99,-2.32 0.35,-1.06 1.42,-1.99 1.19,-3.04 1.59,-1.28 3.12,-2.82 3.5,-4.91 0.29,-1.68 1.88,-3.9 3.55,-3.77 1.45,0.28 3.23,2.49 1.02,3.1 -0.26,1.75 1.71,4.26 3.56,3.85 1.8,-0.82 3.15,1.46 3.11,3.02 0.11,1.05 0.38,2.51 1.57,1.12 0.48,-2.17 3.83,-2.17 3.36,-4.65 -0.04,-1.75 1.82,-1.78 2.78,-1.88 0.32,-1.93 2.75,0.2 3.94,-1.24 1.92,-0.72 2.65,-2.74 3.46,-4.46 1.07,-1.81 -0.81,-3.55 -1.3,-5.23 -1.54,-0.97 -2.38,-4.43 -4.39,-3.39 -2.46,1.2 -1.22,-2.52 -0.81,-3.62 0.45,-2.38 -5.13,-0.6 -4.45,-3.46 0.63,-1.52 0.27,-3.31 1.13,-4.7 1.66,-1.42 2.02,-3.72 0.13,-5.18 -1.28,-1.29 -2.78,-3.1 -0.71,-4.33 1.13,-1.5 0.53,-3.97 -1.56,-4.12 -2.01,-0.66 -4.04,-1.43 -6.18,-1.43 z",
						"department-71" : "m 453.97,260.36 c -1.7,0.76 -3.89,0.82 -5.01,2.19 -3.19,-0.21 -2.31,3.21 -1.24,4.78 0.01,2.17 -2.18,3.07 -3.18,4.73 3.67,-1.68 1.21,3.06 2.15,4.73 2.64,1.04 2.65,3.75 0.11,4.66 0.67,1.67 1.23,4.24 -1.54,3.66 -2.78,0.52 -4.41,3.5 -7.35,3.66 -1.2,1.61 -3.28,1.92 -3.49,-0.48 -1.65,-2.53 -4.63,-0.04 -6.98,-0.58 0.57,3.06 3.65,4.82 4.22,7.82 0.75,1.41 1.18,3.47 0.99,5.08 2.04,1.85 5.27,-0.04 5.82,3.26 1.08,1.35 3.62,-1.11 4.91,1.13 2.56,1.38 0.02,4.04 0.37,6.08 0.06,1.87 1.72,4.92 -1.23,4.69 -0.63,1.31 -3.78,1.57 -2.13,3.67 -1.04,1.85 -0.29,4.31 2.16,3.67 1.09,1.48 2.46,3.31 4.3,1.41 2.27,-2.66 4.88,2.5 6.7,-0.65 1.34,0.75 3.65,-0.04 2.69,2.22 1.65,0.02 3.16,-2.01 5.15,-2 1.19,-2.22 0.14,-5.86 2.62,-7.28 2.52,0.05 4.61,3.79 6.38,0.45 0.58,2.51 2.95,1.43 3.29,-0.51 2.49,-1.24 4.02,1.89 2.39,2.85 2.76,0.76 1.61,3.13 1.87,5.09 3.75,1.26 2.77,-4.7 4.36,-6.77 1.05,-2.9 1.52,-5.83 2.78,-8.64 0.84,-2.16 1.01,-4.91 2.57,-6.52 1.57,0.12 3.15,-0.61 4.21,1.23 2.7,1.53 7.09,-3.92 8.31,0.83 1.01,2.83 4.3,2.08 6.39,1.08 2.34,0.51 4.17,-2.3 1.2,-2.95 -1.86,-1.31 -1.41,-5.18 1.03,-5.11 -0.29,-1.51 0.28,-2.26 1.34,-3.13 -1.26,-2.48 -1.08,-5 -3.19,-7.15 1.37,-1.38 0.91,-2.7 -0.97,-3.3 -2.12,-3.08 4.27,-2.04 5.27,-3.08 -2.01,-1.05 -2.54,-4.3 -5.1,-3.15 -2.06,-0.25 -1.37,-4.84 -3.92,-3.05 0.08,-1.67 -0.33,-4.36 -2.71,-3.02 -2.08,0.62 -4.65,2.85 -6.22,0.57 -2.22,-1.78 -3.53,2.05 -5.94,0.23 -2.24,0.43 -4.32,1.81 -6.55,2.75 -1.83,0.18 -3.34,0.81 -5.05,1.44 -1.04,-0.89 -0.19,-2.78 -2.45,-2.61 -2.38,-0.24 -3.18,-4.05 -4,-4.76 -2.09,-0.05 -3.73,-1.74 -5.85,-2.18 -0.82,-0.81 -0.06,-3.57 -1.95,-1.73 -2.05,1.86 -0.28,-3.07 -2.99,-2.19 -2.63,0.44 -2.45,-2.64 -4.56,-3.1 z",
						"department-03" : "m 397.2,283.6 c -0.53,0.03 -0.65,0.93 -1.28,0.58 -1.07,-0.24 -1.29,1.09 -2.18,1.35 -0.68,0.38 -0.83,1.21 -1.57,1.57 -0.59,0.3 -0.37,1.08 -0.67,1.47 -0.82,-0.75 -2.14,-0.58 -2.85,0.25 -0.56,0.51 -1.31,0.26 -1.58,-0.42 -0.26,-0.45 -0.61,-1.5 -1.29,-0.94 -0.65,0.39 -0.38,1.55 -1.28,1.63 -0.49,0.33 -0.44,1.07 -1.07,1.29 -0.54,0.29 -0.85,0.95 -1.54,0.66 -0.62,0.1 -0.27,0.76 -0.06,1.06 0.07,0.49 -0.16,1.38 -0.8,0.88 -0.59,-0.44 -1.77,-0.28 -2.01,0.33 0.58,0.17 1.69,0.86 1,1.55 -0.36,0.28 -0.06,0.77 -0.23,1.04 -0.67,0.39 -0.15,1.28 0.46,1.35 0.61,0.77 0.55,1.86 0.72,2.79 -1.18,0.73 -2.34,1.71 -3.62,2.11 -0.29,-0.68 -0.88,-0.33 -1.32,-0.08 -0.47,0.1 -0.2,-0.76 -0.8,-0.58 -1.03,0.35 -2.03,0.8 -3.17,0.71 -1.3,0.06 -2.78,0.14 -3.58,1.33 -0.8,0.47 -0.02,1.59 -0.84,2.01 -0.42,0.05 -0.96,-0.06 -1.15,0.48 -0.78,1.48 -0.9,3.37 -0.4,4.96 0.26,0.38 0.79,0.29 1.15,0.57 0.49,0.09 1.26,0.02 1.06,0.79 0.02,0.4 -0.72,0.13 -0.85,0.54 -1.01,0.83 0.27,2.03 1.17,2.2 0.58,-0.08 0.87,0.54 1.33,0.59 0.39,-0.14 0.38,-1.36 0.9,-0.77 0.76,0.62 1.67,1.41 1.25,2.52 0.36,0.53 0.91,-0.64 1.46,-0.19 0.81,0.23 1.7,0.87 1.45,1.84 0.14,1.11 1.68,1.3 1.67,2.49 0.4,1.14 -0,3.01 1.48,3.41 0.81,0.19 0.41,1.35 0.75,1.93 0.25,0.78 1.04,1.13 1.79,1.18 0.65,0.32 1.81,1 2.22,-0.03 0.46,-0.9 0.75,-1.9 1.09,-2.8 0.55,-0.73 1.89,-0.29 2.08,-1.36 0.24,-0.68 -0.44,-1.52 0.43,-1.96 0.66,-0.22 0.95,0.83 1.63,0.76 0.55,0.39 1.4,1.36 2.04,0.56 0.42,-0.83 -0.03,-1.98 0.37,-2.71 0.72,-0.31 1.49,-1.18 2.3,-0.64 1.07,0.12 2.57,-0.1 3.28,0.88 -0.24,0.56 -0.03,1.41 -0.79,1.61 -0.76,0.37 -0.44,1.16 -0.29,1.75 -0.13,0.49 -0.09,1.14 0.58,1.12 0.68,-0.1 1.21,0.33 1.13,1.02 0.09,0.86 0.18,2.33 1.42,2.14 0.89,0.14 1.21,1.58 2.25,1.17 0.81,0.52 1.65,-0.25 2.49,-0.28 0.45,0.5 0.3,1.19 0.45,1.75 0.87,0.19 1.51,1 2.48,1.02 0.76,0.25 1.24,-0.53 2.01,-0.38 0.48,-0.11 0.79,0.09 1.13,0.28 0.44,-0.22 0.55,0.55 1.06,0.34 1.38,-0.06 2.97,-0.26 4,0.88 0.96,0.41 1.66,-0.65 2.44,-0.96 0.64,0.07 1.32,-0.9 1.79,-0.16 0.31,0.43 0.85,0.4 1.28,0.42 0.72,0.93 0.57,2.17 0.55,3.26 1.03,0.14 2.05,-0.24 2.95,-0.62 0.45,0.01 0.76,0.46 1.28,0.23 0.59,0.08 1.31,-0.75 1.72,0 0.77,0.99 1.15,2.22 1.65,3.32 0.67,0.5 2.27,0.29 2.14,1.5 0.41,0.47 0.99,-0.52 0.95,-0.95 -0.15,-0.63 0.53,-1.04 1.07,-0.73 0.48,0.22 1.27,0.4 1.28,-0.34 0.41,-0.77 1.09,0.48 1.68,-0.03 0.66,-0.43 2.17,-0.85 1.53,-1.93 -0.55,-1.45 -0.99,-3.06 -0.37,-4.56 0.35,-0.94 -0.22,-1.78 -0.75,-2.44 -0.09,-0.98 -0.2,-2.05 -0.29,-3.01 0.9,-0.02 0.57,-0.74 0.19,-1.26 -0.62,-1 0.1,-2.51 -0.98,-3.26 -0.34,-0.41 -0.36,-1.4 0.42,-1.13 0.62,0.33 1.04,-0.24 1.05,-0.81 0.86,-0.77 2.51,-0.06 3.19,-1.15 0.39,-0.12 0.9,-0.24 0.79,-0.8 0.24,-1.13 2.3,-0.37 2.35,-1.71 -0.01,-1.08 1.5,-0.38 2.04,-0.87 -0.47,-0.98 0.15,-2.27 -0.18,-3.37 -0.22,-0.75 -0.56,-1.54 -0.06,-2.26 -0.09,-0.66 0.49,-1.17 0.25,-1.83 0.92,-0.68 0.27,-2.39 -0.81,-2.61 -0.47,-0.05 -0.91,-0.14 -0.99,-0.67 -0.62,-0.48 -1.88,-0.87 -2.29,0.07 -0.58,0.43 -1.56,-0.12 -1.78,-0.72 0.04,-0.44 0.16,-1.45 -0.59,-1.13 -0.61,-0.09 -0.16,-0.76 -0.46,-1.01 -0.68,-0.03 -1.24,0.99 -1.91,0.34 -0.7,-0.25 -1.13,-1.1 -1.96,-0.88 -0.71,-0.06 -1.29,-0.9 -0.77,-1.51 0.12,-0.95 0.28,-2.27 -0.52,-2.97 -0.67,-0.08 -0.6,-0.63 -0.36,-1.08 -0.11,-0.87 -0.73,-1.6 -0.95,-2.44 -0.41,-0.57 -1.28,-0.79 -1.36,-1.54 -0.43,-0.32 -0.76,-0.7 -0.76,-1.26 -0.23,-0.42 -0.82,-0.6 -0.66,-1.2 -0.07,-0.72 -0.65,-1.29 -0.65,-2 -0.38,-0.23 -0.96,-0.06 -1.13,-0.6 -0.76,-0.3 -0.78,0.93 -0.41,1.32 0.52,0.51 0.35,1.1 -0.32,1.27 -0.46,0.18 -1.77,-0.11 -1.37,0.76 0.22,0.53 0.68,1.24 -0.05,1.6 -0.45,0.63 -0.72,-0.73 -1.25,-0.14 -0.73,0.55 -1.34,1.34 -1.72,2.1 -0.7,0.19 -2.06,0.06 -1.81,-0.97 0.28,-0.69 0.26,-1.75 -0.66,-1.9 -0.06,-0.42 -0.09,-1.15 -0.73,-0.99 -0.6,-0.11 -1.41,-0.35 -1.66,0.43 -0.42,1.36 -2.42,1.83 -3.19,0.53 -0.36,-0.46 -0.4,-1.37 -1.24,-1.2 -0.93,-0.04 -1.39,0.93 -2.18,1.27 -0.52,0.67 -1.46,1.45 -2.3,0.76 -1.65,-0.71 -2.01,-3.06 -3.96,-3.3 -1.62,-0.6 -2.82,-2.05 -3.15,-3.73 -0.68,-0.77 -1.92,-0.52 -2.83,-0.76 l -0.03,0.01 z",
						"department-58" : "m 403,231.74 c -1.61,0.85 -3.16,2.61 -5.05,1.25 -1.93,0.57 -4.68,0.4 -5.94,1.66 1.17,1.4 2.03,2.95 2.66,4.63 1.41,1.6 0.66,3.61 -0.14,5.29 -1.13,1.89 -2.63,4.76 0.46,5.69 1.61,1.55 3.43,2.81 3.01,5.3 0.69,2.02 1.61,4 1.89,6.16 0.66,1.8 -0.92,4.42 1.24,5.56 2.12,1 -0.1,3.53 0.9,5.04 0.58,2.1 -1.6,3.95 -0.29,6.07 0.71,2.09 -0.94,3.84 -1.39,5.75 -0.16,2.28 2.09,3.67 3.99,4.26 1.45,1.18 3,4.59 5.07,2.2 1.39,-2.15 3.2,-1.4 4.21,0.47 1.89,0.79 3.52,-3.53 5.01,-0.9 1.15,0.73 0.12,3.44 2,3.08 0.82,-1.25 2.25,-2.27 3.42,-2.12 -0.45,-1.58 -0.46,-2.4 1.31,-2.25 -0.04,-1.1 -0.2,-3.79 1.47,-2.05 1.98,1.69 4.21,-0.24 6.42,0.3 1.65,0.48 1.92,4.5 3.88,2.11 1.32,-1.3 3.38,-1 4.65,-2.37 1.34,-1.63 3.98,-1.82 5.37,-2.35 0.36,-1.68 -1.59,-3.7 0.98,-4.22 2.45,-1.92 -2.44,-2.83 -1.99,-4.92 0.77,-1.4 0.79,-4.58 -1.37,-3.13 -1.32,-1.27 2.65,-1.88 2.41,-3.81 1.13,-2.15 -2.17,-3.91 0.01,-5.72 1.51,0.02 2.3,-1.19 2.99,-1.85 1.63,-0.25 4.07,0.09 4.06,-2.15 1.61,-1.8 -0.93,-5.24 -2.87,-4.31 -2.41,-0.08 -1.25,-4 -1.32,-5.69 -1.6,-1.91 -3.82,0.35 -5.22,1.11 -2.31,-0.58 -1.44,-3.5 -2.39,-4.88 -1.39,-0.39 -3.82,2.68 -4.21,0.09 0.57,-1.02 1.94,-3.49 -0.37,-2.94 -1.09,1.17 -0.89,4.3 -3.02,2.53 -0.82,-1.43 -3.58,0.43 -3.95,-1.99 -1.39,-1.5 -3.37,-2.87 -5.27,-2.64 -0.47,-1.77 -1.23,-2.94 -2.84,-3.91 -0.77,-0.83 -1.17,-3.5 -1.49,-0.9 0.69,2.28 -0.99,3.03 -2.81,1.79 -2.14,-0.98 -3.42,3.82 -4.92,1.46 -1.47,-1.84 -3.98,0.9 -4.9,-1.51 -1.01,-1.69 -2.86,-0.31 -4.03,-2.06 -1.13,-0.72 0.21,-3.16 -1.65,-3.11 z",
						"department-89" : "m 416.07,178.07 c -1.02,3.01 -4.52,0.42 -6.35,1.97 -2.2,0.17 -4.84,-1.18 -6.41,1.04 -2.57,-1.79 -3.92,2.41 -3.23,4.37 1.68,1.97 -0.59,4.61 -2.42,5.5 -1.87,0.69 -2.43,2.92 0.08,3.27 3.44,0.48 2.14,5.14 5,6.43 1.86,1.41 0.82,2.99 1.95,4.97 -0.66,1.96 -2.64,3.26 -4.2,4.59 -2.15,0.99 -1.21,3.09 -0.29,4.3 -1.27,1.6 0.94,4.33 -2.29,4.25 -1.68,2 -6.04,-0.22 -5.91,3.16 -0.16,1.79 1.73,0.84 2.05,2.41 1.23,1 1.51,2.38 2.4,3.59 -1.59,1.67 0.31,4.3 2.07,5.11 2.02,1.43 3.87,-2.51 5.6,-0.9 -0.48,3.02 2.39,3.66 4.54,4.3 0.65,2.89 3.81,-0.1 5.39,2.05 2.16,0.59 3.06,-3.06 5.43,-1.44 3.12,2.56 0.69,-6.07 2.79,-2.47 0.34,2.17 3.6,2.68 3.38,5.11 2.35,0.08 4.35,1.34 5.66,3.39 1.5,1.65 3.35,0.01 4.61,1.97 1.13,-0.63 1.69,-5.29 3.46,-2.37 0.17,1.13 -2.33,3.48 0.33,3.18 1.2,-1.21 4.18,-1.8 3.34,0.93 -0.16,2.01 2.22,4.07 3.49,1.59 1.54,-0.36 3.98,-1 1.98,-2.64 -1.02,-1.45 -0.96,-2.97 0.11,-4.3 3.25,-0.51 -0.48,-4.66 2.32,-6 2.17,-2.35 2.86,-5.81 4.59,-8.49 -1.41,-1.48 0.29,-1.3 1.02,-2.22 -0.49,-1.38 -1.69,-2.55 0.39,-3.26 3.6,0.23 2.54,-4.47 2.26,-6.7 -1.12,-0.71 -3.42,0.85 -2.86,-1.65 -1.36,-1.73 4.34,-3.1 0.86,-3.74 -2.2,0.32 -2.21,-2.85 -3.24,-2.99 0.17,2 -0.72,2.05 -1.83,0.88 -1.33,1.07 -2.82,2.87 -4.14,0.8 -1.05,0.35 -1.78,1.79 -3.13,0.43 -1.52,0.35 -3.34,0.31 -5.13,0.58 0.09,-1.31 1.54,-4.13 -0.4,-4.48 -0.29,2.73 -3.6,-0.65 -1.05,-0.91 -1.81,-2.12 -2.57,-4.79 -3.64,-7.42 -1.51,-0.41 -2.48,-0.79 -1.75,-2.59 -1.08,-1.86 -1.8,2.43 -3.8,1.17 -0.25,-1.72 -1.5,-3.76 -3.26,-2.47 -1.89,-0.87 2.48,-2.37 0.41,-3.67 2.2,-1.9 -1.21,-2.95 -1.4,-4.71 -1.76,-1.44 -2.8,-5.31 -5.82,-4.03 -1.46,1.55 -1.28,-2.45 -2.97,-1.89 z",
						"department-77" : "m 402.05,130.64 c -0.98,0.49 0.07,2.55 -1.72,1.71 -1.65,-0.86 -2.4,2.1 -3.31,-0.03 -2.1,0.41 -4.58,1.91 -6.32,0 -1.77,-1.32 -2.95,3.72 -4.59,0.96 -2.01,1.88 -2.83,-3.58 -5.07,-1.24 -1.29,0.64 -1.74,2 -1.24,3.05 -0.95,0.81 -3.15,2.12 -0.8,2.44 0.51,1.65 0.36,3.31 1.46,4.83 0.2,1.84 -2.51,3.56 -0.73,5.06 -0.36,1.84 1.1,3.56 0.49,5.57 1.71,0.58 -0.41,2.58 -0.68,3.73 -0.83,0.92 1.08,3.6 -1.37,3.26 -0.89,0.8 0.48,2.47 -1.19,2.92 1.1,1.07 0.89,1.9 0.01,2.91 -0.77,1.91 -0.97,4.13 -0.7,6.31 -0.66,1.98 -0.02,4.05 1.47,5.35 -1.96,0.5 -3.65,1.61 -4.81,3.16 0.68,1.87 -2.82,1.21 -1.16,3.11 1.12,1.38 -0.36,3.98 2.42,3.8 2.91,0.69 3.08,4.37 1.74,6.29 -1.65,-0.84 -2.88,2.95 -0.41,1.95 1.73,-0.49 3.18,-1.28 5.02,-0.34 1.93,-0.8 3.99,1.78 5.7,-0.31 1.86,-0.31 -0.29,-2.14 1.35,-1.79 1.18,-0.45 3.04,-0.08 1.95,1.41 1.33,2.12 2.96,-1.69 4.98,-1.18 1.67,-0.49 2.06,-2.91 4.05,-3.24 1.12,-1.43 2.9,-3.37 1.15,-5.05 -0.16,-1.63 0.37,-3.9 1.72,-4.82 2.36,0.85 4.12,-2.06 6.45,-0.5 2.32,-0.04 4.02,-1.12 6.35,-0.55 1.28,-0.24 1.31,-2.3 2.98,-1.19 2,-0.66 -1.7,-2.32 -0.05,-3.59 -0.5,-1.21 -1.19,-2.87 0.87,-2.81 1.09,-0.89 -2.02,-3.22 0.6,-2.74 1.77,0.23 2.39,-1.17 1.6,-2.47 1.17,-1.39 2.01,-2.57 3.58,-3.44 -1.04,-1.49 -2.62,-1.68 -4.07,-1.01 -1.93,-1.91 1.07,-3.45 0.32,-5.34 0.3,-1.53 -1.55,-1.92 -2.52,-2.41 -1.25,-0.38 0.19,-2.49 1.3,-2.24 0.34,-0.82 -2.8,-1.79 -0.49,-1.8 1.33,0.7 3.87,-1.63 2.13,-2.17 -1.66,1.45 -1.37,-1.76 -3.39,-1.23 -2.08,-0.53 -0.39,-4.63 -3.08,-2.96 -1.53,-0.07 -0.54,-3.09 -2.68,-1.87 -1.2,-1.64 -2.76,-4.17 -5.07,-5.24 0.91,-1.5 1.06,-2.88 -0.12,-4.29 -0.33,-2.14 -2.62,-1.35 -4.08,-1.98 z",
						"department-10" : "m 457.73,157.29 c -2.13,0.5 -4.1,0.01 -6.19,0.69 -1.05,1.79 -3.96,-1.12 -4.04,1.65 -0.8,1.75 -4.08,0.09 -3.96,2.74 -0.79,1.45 -1.6,1.88 -2.99,2.35 -0.52,1.42 -1.24,1.3 -2.41,1.49 0.59,1.46 -0.11,4.83 -2.36,3.62 -2.16,-0.98 -4.56,-1.03 -6.89,-0.99 -1.9,-0.17 -0.8,-3.17 -2.94,-2.89 -0.63,-2.25 -3.58,-3.04 -4.15,-0.61 -2.73,0.52 0.33,3.88 -2.69,3.9 -1.65,-0.53 -1.58,0.55 -0.76,1.57 1.13,1.8 -3.04,0.94 -1.25,3.05 0.42,1.28 -0.32,2.49 1,3.48 -1.08,1.82 0.38,3.42 2.02,2.16 1.85,0.1 2.84,1.8 3.75,3.14 1.48,1.39 2.14,3.14 3.41,4.6 -1.41,1.17 0.77,2.62 -1.14,3.49 -1.3,1.27 0.05,1.7 1.09,0.98 1.77,0.49 1.45,4.11 3.67,2.68 0.94,-0.2 0.63,-2.76 2.01,-1.09 0.65,0.86 -0.95,2.76 1.1,2.37 2.02,1.3 1.83,4.2 3.05,6.1 1.58,0.78 1.7,2.3 0.49,2.9 0.54,1.51 1.71,0.28 1.97,-0.31 2.56,0.7 -1.28,5.42 2.12,4.33 1.91,-0.23 3.38,-0.23 5.06,0.09 0.59,-1.33 1.98,-1.11 2.57,0.19 1.58,-0.22 2.9,-3.31 4.17,-0.98 0.61,-0.58 -0.29,-2.65 1.36,-1.57 -0.48,2.55 3.68,3.96 3.75,0.78 1.55,-0.59 3.74,-0.45 5.58,-0.63 1.75,0.63 3.69,-0.42 5.57,-0.41 0.29,-1.14 -1.61,-2.57 0.46,-3.04 1.86,-2.3 4.62,1.06 6.58,-0.66 1.53,-1.62 -1.39,-2.98 -1.79,-3.56 2.1,-0.49 3.01,-3.71 5.54,-1.94 3.54,1.4 1.49,-3.68 3.11,-5.2 0.87,-1.45 -1.51,-1.82 -0.48,-3.12 0.78,-2.08 -0.11,-3.86 -1.22,-5.55 1.83,-2.28 -2,-1.74 -2.8,-3.27 0.6,-2.31 -3.01,-0.73 -2.93,-2.86 -0.68,-1.21 -1.21,-2.36 -2.64,-3.04 -0.15,-0.98 1.41,-1.57 1.07,-2.96 1.69,-2.03 -2.24,-4.27 -3.96,-2.73 -1.05,0.86 -1.8,1.41 -2.76,0.14 -2.27,0.33 -4.96,-0.93 -6.52,-2.73 -1.6,-0.9 -2.65,-2.09 -2.11,-3.94 -0.01,-1.39 0.86,-4.72 -1.54,-4.44 z",
						"department-51" : "m 447.04,111.45 c -0.85,1.01 -1.08,4.16 -2.83,2.12 -1.58,-0.94 -4.14,-2.71 -5.55,-0.59 -0.47,1.86 -2,2.53 -3.66,1.62 -2.11,0.93 -4.6,1.61 -6.36,2.87 -0.53,2.28 1.53,4.27 0.51,6.61 1.8,0.71 2.46,2.17 3.95,3 -0.94,2.45 -4.1,0.37 -5.88,1.52 -1.7,1.66 2.4,4.41 -0.88,5.43 -2.23,2.44 5.5,0.69 2.68,3.64 -2.5,1.8 -3,5.45 -5.92,6.76 -2.49,1 -1.18,4.96 -2.87,5.99 -1.36,-0.13 -2.85,0.17 -1.28,1.25 -0.7,1.1 -2.96,2.55 -0.28,3.03 3,1.24 1.1,4.28 0.73,6.33 0.94,1.84 3.99,-0.48 4.72,2.18 0.97,2.24 3.46,2.39 3.8,4.7 1.7,2.1 4.48,-0.15 6.49,1.41 1.87,1.23 4.49,0.11 3.61,-2.32 0.72,-2.05 4.22,-2.38 4.98,-4.55 1,-2.47 4.06,-1.56 4.95,-3.87 1.36,-1 2.53,0.52 3.92,-0.8 1.98,-0.43 4.01,-0.73 6.02,-0.59 2.43,0.46 1.84,3.16 1.42,4.89 0.07,2.8 2.97,4.48 5.15,5.65 2.17,0.01 4.61,2.13 6.41,0.29 1.75,-1.51 3.47,1.15 5.44,0.69 1.38,-0.17 5.75,0.76 3.67,-1.89 -1.52,-2.95 5.7,-2.41 2.65,-5.48 -1.1,-0.11 -3.65,-0.35 -1.73,-1.74 2.05,0.26 4.2,-0.05 6.08,-0.37 2.3,0.42 5.1,-2.57 2.7,-4.35 -1.02,-1.86 -5.76,-3.17 -3.53,-5.51 1.95,-1.47 -1.1,-4.2 1.12,-5.8 1.48,-1.5 6.06,-1.27 3.62,-4.43 0.08,-0.05 1.84,-2.53 -0.16,-3.07 -3.37,1.1 0.99,-2.04 -0.42,-3.46 0.13,-2.66 -3.59,-5.3 -1.68,-7.58 2.23,-1.77 -1.54,-3.71 -3.12,-4.06 -1.16,0.6 -1.58,2.95 -3.32,1.4 -1.92,-0.84 -4.19,-0.61 -6.28,-0.69 -1.94,1.7 -3.65,0.28 -4.11,-1.83 -1.78,-2.74 -4.95,1.45 -7.53,-0.27 -2.04,-1.12 -3.55,-2.8 -5.87,-3.47 -1.97,-2.67 -5.03,-4.71 -8.47,-4.58 -0.96,-0.06 -1.92,0.15 -2.86,-0.07 z",
						"department-02" : "m 430.16,68.04 c -1.21,0.83 -2.32,3.01 -4.11,1.54 -1.81,-2.61 -3.41,0.5 -5.32,1.07 -2.18,0.63 -4.39,-2.01 -6.45,-0.26 -1.68,1.82 -4.04,-1.37 -6,0.14 -1.73,0.41 -2.66,2.19 -0.51,2.52 -1.27,1.85 -3.05,3.07 -3.52,5.47 0.07,1.82 -3.05,3.76 -2.22,5.05 2,1.39 -1.77,3.7 1.27,4.17 0.03,2.02 1.57,4.06 1.1,6.24 -1.34,0.98 -0.25,2.25 -1.01,3.49 2.49,1.68 1.44,5.41 0.18,6.99 1.25,1.47 -0.33,3.13 2.08,3.55 1.93,2.17 -4.06,0.32 -2.49,3.12 -0.03,2.09 -1.26,5.68 -3.84,4.98 -2.94,-0.88 -1.76,3.18 0.48,3.05 0.99,1.01 0.03,3.83 0.62,5.08 1.37,0.51 2.25,1.48 3.49,1.21 -0.51,1.59 2.6,2.48 0.04,3.45 -1.71,0.49 -1.76,2.46 0.31,2.05 2.65,0.21 3.58,4.11 2.26,5.97 1.62,1.27 3.48,2.23 4.22,4.3 0.74,1.63 2.35,-0.47 2.52,1.87 0.72,2.19 2.68,-1.33 2.65,1.31 -0.24,2.49 3.53,2.85 4.12,3.91 1.75,-1.8 2.07,-4.56 4.88,-5.19 0.68,-2.23 2.35,-3.4 3.55,-5.39 2.67,-0.52 -0.65,-3.26 -2.06,-1.85 -2.26,-0.47 0.23,-2.88 1.31,-3.13 -0.73,-1.44 -2.36,-4.14 0.26,-4.66 1.65,-0.44 4.91,1.29 4.79,-1.49 -2.06,0.27 -1.99,-2.15 -3.88,-2.4 0.6,-1.8 -0.18,-4.32 -0.79,-6.48 1.32,-1.8 3.96,-1.53 5.66,-2.91 1.45,-1.38 4.53,1.53 4.01,-1.33 1.45,-1.59 3.81,-2.88 5.19,-0.49 1.28,-0.12 3.37,2.53 3.3,-0.24 0.33,-2.86 0.57,-4.99 0.01,-7.76 1.55,-0.89 1.69,-2.64 0.84,-3.44 1.81,-1.93 -3.62,-5.62 0.69,-5.56 3.16,1.39 1.54,-3.2 4.12,-3.75 1.57,-1.42 5.27,-4.07 2.24,-5.67 0.32,-1.83 0.55,-4.01 1.75,-5.91 1.09,-2.4 -2.7,-2.87 -1.03,-5.36 -0.92,-1.56 -3.39,-2.21 -5.32,-1.52 -1.91,-0.8 -7.18,-0.15 -5.51,-3.66 -0.63,-2.33 -4.88,3.03 -5.11,-0.11 -1.96,-1.5 -4.73,-0.41 -6.75,-2.06 -0.64,-0.23 -1.39,-0.27 -2,0.09 z",
						"department-59" : "M 377.51,2.78e-5 C 374.07,1.47 370.51,2.66 366.77,2.44 c -3.1,0.89 -6.29,1.6 -9.18,3.02 1.24,2.59 3.27,6.24 4.33,9.49 0.45,3.3 2.89,5.84 6.41,5.27 1.94,-0.78 4.85,1.64 1.47,1.89 -2.68,1.66 1.93,3.12 0.19,5.04 2.78,-0.45 4.23,3.9 7.14,2.5 1.81,1.18 3.37,-0.01 5.36,1.07 1.63,-1.32 3.21,-0.63 4.48,0.93 0.73,-1.57 2,-1.61 0.95,-3.07 1.61,-2.58 6.95,1.51 2.94,2.57 -2.83,1.01 0.34,3.73 -1.12,5.39 0.9,1.48 4.86,-1.3 3.65,1.61 2.92,-0.02 7.29,0 6.35,4.16 1.35,-0.92 3.57,-0.15 1.94,1.67 -3,0.14 -4.31,3.74 -1.12,5.07 1.69,0.96 2.08,2.48 0.62,3.67 0.34,2.55 4.5,0.15 4.8,3.09 2.64,0.43 -0.05,2.2 -0.9,2.42 1.06,1.6 0.36,2.77 -1.25,3.07 2.12,1.52 -1.64,2.22 0.07,4.15 -2.91,2.78 1.69,6.63 4.47,4.88 2.26,-1.32 5.08,2 6.87,-0.71 2.98,0.44 6.14,1.89 8.42,-1.06 1.98,-0.29 4.46,2.95 5.68,-0.34 2.9,-1.43 5.98,1.3 9.04,1.19 1.53,2.96 3.45,-0.56 5.79,0.04 -1.87,3.96 3.7,3.7 6.26,4.11 2.29,-0.95 -0.64,-4.29 2.61,-4.77 2.82,-0.8 0.92,-4.83 -0.55,-5.74 -3.06,0.67 -0.13,-3.85 -0.08,-5.37 1.87,-1.24 2.82,-4.03 -0.19,-4.26 -1.07,4.16 -2.1,-2.65 -4.39,-2.68 -1.69,-3.72 -4.82,-0.59 -7.62,-0.73 -2.37,-0.85 -5.7,-2.48 -7.81,-0.09 -1.66,4.51 -4.19,-2.36 -2.95,-4.64 0.52,-3.52 -3.24,-7.4 -6.77,-5.76 -1.77,0.07 0.3,-3.59 -2.48,-2.13 -2.41,2.31 -6.1,2.01 -8.29,-0.47 -0.77,-2.54 -0.39,-5.31 -1.88,-7.78 0.28,-2.25 0.31,-4.41 -2.29,-5.22 -0.57,-2.79 -2.95,-5.31 -5.75,-3.44 -2.32,0.87 -5.9,0.75 -6.52,3.6 -1.2,3.14 -4.3,-0.54 -6.47,-0.63 -1.62,-2.75 -3.49,-6.42 -7.19,-5.82 -1.19,-1.96 -1.69,-5.46 -1.07,-7.12 2.22,-2.65 -1.65,-4.24 -2.01,-6.55 C 378.49,2.6 378.6,1.01 377.51,3.38e-5 z M 405.6,54.52 l 0.01,0.01 -0.01,-0.01 z",
						"department-62" : "m 355.25,5.34 c -4.67,0.52 -9.21,1.96 -13.53,3.78 -2.62,1.21 -3.81,4.26 -6.75,4.99 -3.31,1.16 0.87,5.46 -0.72,8.04 -1.1,2.07 -1.78,4.43 -1.12,6.76 0.28,2.42 0.02,4.96 1.31,7.03 -2.1,2.06 -0.72,6.37 -1.76,9.35 1.02,1.95 3.5,2.58 4.79,4.3 2.63,0.04 5.25,-2.81 7.87,-0.77 1.48,1.06 3.47,3.44 4.92,1.35 2.53,0.17 -1.69,2.79 1.25,2.82 1.83,1.47 5.46,1.25 4.91,4.34 1.83,1.66 4.07,1.54 6.17,0.26 1.49,0.74 2.98,-1.45 4.29,0.08 1.29,-0.11 0.37,-2.58 1.85,-0.79 1.06,2.83 2.15,-1.72 4.16,-0.11 1.81,-0.02 3.83,3.18 0.85,3.1 -2.82,0.39 -4.82,5.18 -1.24,5.81 0.43,-1.96 3.4,-4.56 4.7,-1.88 0.95,0.06 0.96,-2.21 2.37,-0.91 -1.29,2.63 2.5,1.39 3.75,2.68 1.01,0.02 2.8,1.43 1.68,-0.5 0.03,-2.85 2.71,-0.54 3.78,-0.21 0.17,1.65 -2.95,5.59 0.49,3.59 1.5,-1.55 3.47,-1.99 3.75,0.67 0.78,1.86 3.16,-1.9 4.69,-0.23 1.76,-2.04 5.53,1.57 5.23,-2.33 1.82,-0.8 -0.99,-3.24 1.46,-3.82 -0.45,-0.85 -1.59,-2.12 0.4,-1.97 1.78,-0.85 -1.59,-3.43 1.35,-3.43 2.24,-0.56 -1.16,-1.9 -1.45,-2.99 -2.25,0.21 -5.17,-0.99 -2.83,-3.27 -0.39,-2.24 -4.63,-3.32 -3.45,-5.81 1.35,-0.31 3.11,-1.48 3.62,-2.52 -0.44,-2.03 -2.57,1.36 -2.76,-1 1.27,-2.56 -2.5,-4.31 -4.51,-3.12 -2.13,1.34 -0.64,-3.34 -2.9,-1.64 -2.14,0.87 -3.1,-0.93 -1.73,-2.41 -2.1,-1.66 0.38,-3.87 2.35,-4.54 -0.4,-1.72 -4.03,-3.07 -4.41,-1.07 1.31,1 0.79,1.19 -0.41,1.55 -0.65,3.25 -2.43,-1.81 -4.43,-0.01 -1.64,0.85 -3.56,-1.09 -5.12,-0.15 -1.63,-1.09 -3.74,0.22 -5.15,-1.85 -0.76,-1.31 -4.6,-0.82 -2.62,-2.71 -1.83,-1.13 -2.35,-4.01 0.48,-4.05 1.1,-2.3 -3.42,-0.89 -4.7,-1.53 -2.52,-0.32 -4.04,-2.72 -4.24,-5.08 -1.2,-2.74 -2.08,-5.7 -3.77,-8.17 -0.66,-0.91 -1.63,-1.82 -2.85,-1.64 z",
						"department-08" : "m 482.05,60.79 c -1.24,1.53 -2.93,2.65 -4.16,4.17 -2.61,0.85 -1.46,3.67 -1.95,5.63 -0.38,2.67 -3.5,2.01 -5.24,3.06 -1.78,1.03 -3.5,2.67 -5.74,2.32 -2.01,-0.47 -4.05,-0.8 -5.95,-1.63 -2.18,-1.07 -5.67,1.33 -3.92,3.54 2.27,0.8 0.69,3.6 -0.1,5.06 -0.22,1.15 -0.73,3.46 -0.21,3.94 2.34,1.86 -1.57,4.31 -2.92,5.53 -2.32,0.59 -0.78,4.67 -3.55,3.87 -2.19,-0.91 -2.89,1.6 -0.98,2.55 0.93,1.15 0.02,2.21 -0.01,3.29 2.33,1.24 -2.55,2.95 -0.59,4.92 1.73,1.58 -1.34,2.01 0.07,3.67 1.5,1.6 3.93,0.2 5.84,0.81 1.49,1.06 3.52,1.38 4.61,2.9 0.98,1.8 2.93,2.38 4.62,2.79 0.78,1.81 2.87,3 4.8,2.36 1.81,0.34 4.34,-2.39 5.3,0.06 0.29,1.83 2.28,4.22 3.73,1.72 2.1,-0.32 4.12,1.1 6.3,0.51 0.97,1.12 2.33,1.27 2.55,-0.58 1.13,-1.62 2.67,-0.09 3.58,0.8 1.43,-0.97 3.17,-1.86 4.5,-2.69 -1.52,-2 -1.1,-5.69 1.75,-6.15 1.39,-0.71 -1.18,-2.04 0.69,-2.81 0.81,-2.16 -1.48,-3.72 -1.84,-5.84 1.6,-0.81 1.12,-3.14 1.98,-4.24 -0.08,-2.31 2.06,-1.25 2.71,-0.04 1.75,-0.02 3.3,-0.08 4.41,1.54 2.3,0.19 2.66,-3.44 5.12,-3.18 1.49,-1.51 -0.93,-3.02 -1.94,-1.37 -2.45,-0.56 1.14,-3.53 -1.98,-4.43 -1.17,-1.71 -3.03,0.71 -4.52,-0.56 -1.26,-0.27 -1.05,-1.59 -2.38,-1.47 -0.88,-1.51 -1.11,-3.87 -3.5,-3.53 -2.22,-0.27 -3.54,-3.42 -5.99,-1.44 -1.59,0.26 -4.06,-0.12 -2.85,-2.28 -0.7,-1.6 -0.79,-3.23 0.37,-4.75 1.08,-2.94 -3.72,-2.91 -3.45,-5.23 1.66,-1.87 1.37,-4.62 2.11,-6.71 0.47,-1.55 1.75,-1.8 1.81,-3.65 0.26,-2.46 -2.55,-0.09 -3.06,-2.48 z",
						"department-55" : "m 508.47,97.39 c -1.09,2.05 -3.63,1.84 -4.57,4.16 -2.06,1.9 -3.2,-2.58 -5.42,-0.81 -1.22,-0.12 -2.66,-3.25 -3.15,-0.51 0.16,1.18 -1.21,2.01 -0.91,3.51 -0.98,0.86 -1.71,1.56 -0.27,2.6 0.87,1.11 1.38,3 1.1,4.25 -1.92,0.65 1.06,2.66 -1.3,2.99 -1.85,0.5 -3.02,3.3 -1.51,4.85 2.03,2.44 -5.43,1.91 -3.11,4.74 1.73,1.94 -2.71,2.02 -0.97,4.16 1.12,2.15 2.35,4.54 2.07,7.02 -0.73,0.97 -0.79,2.07 0.63,1.57 1.91,0.63 0.24,2.8 -0.25,3.21 2.97,1.13 -0.49,3.95 -2.42,3.82 -2.83,0.92 -1.21,4.11 -1.41,5.89 -2.27,0.76 -1.58,3.13 0.49,3.43 0.78,2.04 3.87,2.5 3.36,4.92 -1.03,1.56 0.33,2.53 -0.65,4.17 -0.41,2.22 1.45,2.79 2.67,1.27 0.35,1.45 0.97,2.84 2.7,2.33 1.09,2.08 3.55,2.53 5.08,4.32 2.27,0.9 4.79,0.9 6.21,3.18 2.51,0.35 2.21,3.61 4.98,3.84 1.98,1.61 2.43,-1.81 4.7,-1.14 1.68,0.05 3.39,-0.67 3.61,-2.22 2.31,1.26 5.03,0.43 5.1,-2.48 1.3,-2.76 -3.09,-2.27 -2.23,-4.93 0.49,-1.55 4.14,-1.1 3.52,-2.57 -2.98,1.13 -1.9,-3.7 -1.68,-5.29 -0.81,-1.25 -2.43,-2.57 -0.87,-3.84 1.05,-1.97 2.47,-4.01 1.58,-6.35 -0.31,-1.17 1.43,-1.8 -0.18,-2.79 -1.99,-1.98 2.36,-2.77 3.49,-3.51 0.15,-1.51 -2.96,-2.03 -1.11,-3.8 0.35,-1.34 2.42,-2.73 0.1,-3.38 -1.66,-0.63 1.46,-3.23 -1.32,-3.22 -2.67,1.16 -1.73,-2.91 -1.77,-4.26 0.97,-1.66 -0.56,-1.3 -1.37,-1.7 0.04,-1.36 0.51,-2.53 -0.03,-3.85 0.74,-1.13 3.52,-3.01 0.66,-3.53 -1.63,-0.76 1.01,-2.93 -1.09,-3.73 -0.78,-1.79 -2.19,-5.34 -4.53,-3.65 -2.18,0.4 -4.84,0.76 -6.11,2.5 -0.93,-0.71 -2.09,-1.61 -0.08,-1.47 1.84,-0.22 0.36,-0.85 -0.21,-1.5 0.24,-1.6 -0.85,-3.62 -1.99,-3.97 0.41,-1.78 2.71,1.63 1.92,-0.65 -0.19,-2.1 -0.51,-4.34 -1.91,-6.26 -0.32,-0.62 -0.84,-1.22 -1.57,-1.33 z",
						"department-54" : "m 525.26,101.49 c -1.67,3.08 -5.74,-1.97 -6.62,2.41 -1.05,-0.08 -3.39,-1.43 -4.31,0.56 -3.51,-0.32 -2.79,4.63 -1.02,5.99 1.99,2.03 6.27,-3.29 8.36,0.29 0.58,2.18 3.3,3.94 1.95,6.22 1.82,0.2 2.6,1.81 0.78,3.05 -1.53,1.28 -0.26,3.15 -0.71,4.81 3.05,-0.45 0.01,2.93 1.57,4.18 -1.63,2.79 4.43,1.04 2.45,4.59 3.98,1.28 -2.64,4.79 0.72,6.38 2.88,2.4 -6.01,2.2 -2.7,4.99 1.25,1.36 -0.87,1.91 0.22,3.46 0.67,3.06 -2.06,4.76 -2.37,7.34 3.26,1.72 -0.99,5.95 2.7,7.21 2.1,0.67 -2.15,1.54 -2.88,2.25 -1.99,2.7 4.09,2.42 1.82,5.11 0.58,3.62 4.01,-1.09 5.99,1.11 0.39,1.44 -0.68,6.33 2.57,6.57 -0.5,2.57 1.79,3.47 3.74,2.25 1.47,0.58 2.05,-0.61 2.49,-1.28 0.72,1.12 1.27,2.45 2.34,0.78 0.57,-1.56 0.94,-3.52 2.83,-1.93 2.51,0.61 4.4,-4.11 5.88,-0.37 1.14,0.17 2.65,-1 3.35,0.7 2.12,-1.53 4.79,-1.87 7.24,-2.11 0.85,0.47 0.77,-3.65 3.11,-2.96 0.6,1.89 2.14,4.14 4.75,3.61 1.95,1.07 4.36,1.67 5.46,-0.83 1.01,-0.22 2.04,1.42 3.05,-0.32 1.31,-3.24 6.08,-2.95 7.27,-5.6 -0.09,-2.38 -2.96,-3.69 -3.28,-5.46 0.62,-0.89 -3.43,0.07 -3.45,-1.97 -2.66,2.33 -4.51,-1.39 -7.24,-1.18 -0.64,-1.76 -4.3,-1.21 -4.56,-1.82 0.16,-2.63 -3.76,-1.66 -4.4,-4.26 -2.09,-1.05 -4.75,-0.89 -6.46,-2.77 -2,0.91 -3.97,0.15 -4.45,-2.1 -1.51,-0.39 -2.94,-2.33 -1.39,-3.6 -0.91,-1.39 2.1,-2.51 -0.43,-3.13 -1.98,-0.94 -4.44,-1.36 -6.82,-1.34 -1.14,0.57 -1.26,-3.18 -3.09,-1.82 -0.69,-1.21 -2.63,-0.86 -1.78,-2.82 -1.05,-2.26 -4.66,-2.19 -5.05,-5.04 -0.93,-3.14 4.8,-0.49 2.54,-3.98 1.3,-0.99 2.16,-2.33 -0.02,-2.86 -0.71,-1.96 3.56,-3.09 1.06,-5.28 -0.76,-1.39 0.36,-3.17 -1.9,-3.24 -2.05,-1.2 0.73,-2.78 -1.7,-3.63 -0.01,-1.52 -1.11,-3.1 0.14,-4.5 1.39,-4.07 -3.97,-2.74 -4.76,-5.9 -0.79,-0.88 -1.96,-1.21 -2.98,-1.73 z",
						"department-57" : "m 545.41,104.88 c -2.5,-0.46 -3.8,2.23 -5.52,3.11 -2.04,0.13 -5.36,1.5 -5.56,-1.88 -0.59,-1.44 -4.31,-0.38 -1.74,-0.13 2.34,2.17 -1.1,4.54 0.53,6.71 -0.43,1.5 2.89,2.35 0.68,3.23 0.45,1.92 3.33,0.94 2.52,3.37 0.36,1.77 2.08,3.54 -0.18,4.75 -2.66,1.64 3.44,3.04 -0.15,4.05 -0.95,0.98 1.36,3.68 -1.36,2.85 -3.83,0.4 0.08,4.84 2.28,5.14 1.87,0.97 0.37,3.68 2.61,3.64 0.79,0.54 2.61,0.75 2.81,2.56 2.85,-0.4 5.85,0.18 8.17,1.37 1.23,1.36 -0.78,2 -0.46,3.45 -1.63,2.22 1.95,1.27 1.75,3.32 0.47,1.19 1.75,2.87 3.71,1.93 1.5,0.16 3.5,2.53 5.53,1.92 2.01,0.81 2.89,3.35 5.4,3.55 0.67,2.73 4.24,1.46 5.45,3.54 2.61,-0.38 3.46,2.94 6.08,1.29 1.17,-0.47 1.75,1.9 3.52,1.14 1.62,-0.08 -0.23,1.96 1.79,2.2 1.3,2.73 5.23,4.48 7.7,2.02 2.54,-1.28 3.61,-5.48 3.95,-7.28 -3.58,-1.29 -0.15,-3.79 0.29,-6.01 1.57,-2.39 -1.82,-4.03 -3.41,-4.9 -0.92,-0.46 -2.83,-2.68 -3.33,-0.42 0.04,1.34 -2.74,3.68 -3.49,1.98 1.42,-1.19 -2.32,-1.18 -0.65,-2.88 0.58,-0.42 2.94,-0.76 1.01,-1.21 -1.9,0.22 -3.08,-2.28 -5.33,-2.09 0.36,-1.47 -1.95,-2.93 0.65,-2.51 -0.24,-2.46 3.11,-1.17 2.78,-3.65 0.97,-1.9 0.9,-5.07 2.82,-5.94 1.56,0.28 -0.2,2.23 1.03,3.05 0.44,2.29 3.07,1.45 4.37,2.98 2.08,-0.63 3.45,0.94 4.45,2.21 2.35,0.41 4.6,-0.99 6.96,-0.88 1.74,1.66 4.77,2.7 5.4,-0.5 0.03,-2.29 3.07,-4.06 1.9,-6.14 -1.64,-1.28 -4.24,-0.4 -4.92,-3.09 -1.46,-0.89 -0.27,-4.11 -2.87,-3.22 -1.94,-1.81 -3.95,-0.44 -5,1.53 -1.63,0.41 -3.01,2.36 -4.96,1.09 -2.43,0.91 -4.48,-0.47 -6.55,-1.34 -0.06,2.16 -3.19,2.68 -2.83,0.01 0.36,-3.27 -3.34,-4.32 -5.77,-4.8 -1.02,0.19 -3.84,-0.2 -2.5,1.89 0.56,3.34 -3.8,1.81 -5.54,1.16 -1.66,-0.89 1.42,-3.26 -1.34,-3.14 -1.25,-2.69 -3.39,-5.28 -5.63,-7.59 -0.97,-1.2 2.01,-2.75 -0.64,-3.58 -1.56,-1.24 -0.91,-3.44 -3.28,-4.1 -1.88,-1.38 -4.06,-1.79 -6.22,-0.88 -2.51,-0.28 -4.01,-3.63 -6.73,-2.87 l -0.15,0.05 -0.06,-0.04 0,5e-5 z",
						"department-67" : "m 586.48,133.27 c -2.1,-0.01 -0.68,2.11 -2.08,3.12 -0.53,1.32 -0.47,4.02 -1.76,4.5 -1.51,0.02 -3.74,3.48 -1.64,4.38 1.94,0.49 3.53,1.77 5.28,2.3 -0.53,0.75 -3.04,0.83 -1.83,2.54 1.17,0.35 1.65,0.72 0.87,1.57 2.9,0.8 2.46,-4.09 5.08,-3.5 0.08,1.99 2.92,1.11 3.25,2.11 0.08,1.35 3.49,2.12 2,4.18 -0.63,1.68 -2.45,3.57 -2.01,5.16 0.83,1.05 2.96,0.73 1.33,2.27 -1,1.88 -1.1,4.44 -3.12,5.66 -1.49,1.59 -3.41,2.15 -5.48,1.5 -1.5,-0.11 -1.21,1.41 0.14,0.89 1.61,0.28 1.05,1.43 -0.19,1.37 1.72,1.32 0.18,3.69 -0.01,5.65 -0.32,1.37 1.24,2.65 -0.54,3.55 0.55,1.82 2.87,1.7 4.33,1.36 0.21,2.85 3.86,1.22 5.05,3.02 -0.15,1.25 1.84,1.58 1.67,1.66 -1.26,2.18 2.77,1.14 3.72,2.54 1.74,0.84 3.98,1.5 3.04,3.9 0.15,1.35 2.62,0.77 2.17,2.57 2.06,1.73 4.17,-0.2 4.35,-2.47 0.77,-2.6 3.83,-4.18 3.47,-7.1 -0.49,-2.51 3.86,-2.87 2.34,-5.54 -0.61,-2.16 0.05,-4.4 1.11,-6.29 -0.44,-2.54 2.89,-3.38 1.72,-5.97 -0.24,-1.77 -0.09,-3.59 0.79,-5.17 1.2,-2.36 4.12,-3.11 5.56,-5.33 0.93,-1.46 0.84,-3.77 3.23,-3.4 0.47,-2.65 4.3,-1.88 4.34,-4.96 0.46,-2.67 2.05,-4.9 3.43,-7.17 0.58,-0.8 2.64,-1.94 0.45,-1.99 -1.97,-0.34 -4.11,-0.64 -5.89,-1.63 -1.91,-1.34 -4.31,-2.41 -6.36,-3.17 -1.93,0.68 -3.88,0.62 -5.6,-0.57 -2.1,0.71 -4.29,0.31 -6.52,0.54 -2.49,-0.15 -2.67,2.97 -3.55,4.65 -0.5,2.61 -2.96,2.86 -4.66,1.16 -1.92,-1.57 -4.24,0.44 -6.34,0.4 -2.52,0.72 -2.77,-3.35 -5.5,-2.33 -1.48,-0.12 -2.58,-1.72 -4.29,-1.55 -0.6,-1.43 -1.27,-3.09 -1.08,-4.38 l -0.26,-0.04 5e-5,0 z",
						"department-88" : "m 585.73,170.68 c -2.45,1.43 -5.58,1.85 -7.18,4.45 -0.96,1.47 -2.29,1.77 -3.44,0.74 -0.93,2.21 -3.2,2.66 -5.01,1.2 -2.33,-0.14 -5.19,-0.81 -5.12,-3.6 -2.39,-0.96 -2.71,2.35 -2.61,3.27 -1.93,-1.81 -3.92,1.08 -5.99,0.26 -1.01,0.82 -2.5,2.2 -3.21,0.34 -1.78,0.73 -2.97,-0.15 -3.76,-1.53 -1.42,2.09 -4.08,2.6 -6.33,1.87 0.76,2.14 -2.82,4.34 -3.08,1.56 -0.46,2.2 -2.74,0.58 -4.34,1.72 -3.04,1.09 -0.77,-3.56 -3.3,-3.04 -2.34,-1.59 -0.26,-5.09 -1.69,-6.58 -1.91,-1.32 -3.68,1.34 -5.56,0.73 -0.85,1.7 -2.39,2.22 -4,1.22 -1.74,0.11 -1.97,2.99 -3.84,2.02 -1.41,0.46 -3.18,-0.16 -3.82,1.84 -1.4,-1.6 -6.39,1.53 -3.06,2.17 -1.78,1.06 -0.18,4.07 1.14,1.74 2.93,-1.33 3.23,2.4 4.88,3.85 0.91,1.42 2.92,-0.64 3.62,1.69 -0.71,2.15 1.41,2.13 2.78,2.92 0.78,1.08 1.52,2.74 -0.55,2.48 -0.84,1.28 -0.49,3.14 -1.59,4.27 0.81,1.2 -2.56,2.07 -0.54,2.8 2.09,-0.91 3.21,2.35 5.14,2.83 2.36,1.3 0.12,4.13 1.53,5.44 1.54,0.44 2.35,-2.6 2.85,-0.07 0.68,2.6 2.59,0.64 2.93,-0.97 2.15,-1.68 1.29,1.09 0.7,1.99 1.78,-0.62 3.58,-1.93 4.45,-3.92 1.23,-1.14 3.61,-1.48 4.98,-1.18 1.42,1.44 -0.13,4.06 2.33,4.41 1.59,2.64 3.6,-1.34 5.57,-0.08 2.15,-1.17 4.71,-0.41 5.99,1.59 0.64,1.74 1.59,3.22 3.37,1.77 1.6,-0.75 3.16,-4.54 4.98,-1.73 1.23,2.37 3.96,3.36 6.12,4.67 1.42,0.78 2.18,3.58 4.22,1.97 2.04,-0.21 3.21,-1.93 2.15,-3.74 1.27,-2.36 0.32,-6.03 2.66,-8.19 2.71,-0.63 2.23,-4.21 4.36,-5.62 2.03,-1.71 -0.83,-4 1.34,-5.8 1.63,-1.7 1.81,-4.21 3.2,-6.05 1.11,-1.35 2.76,-4.2 -0.04,-4.35 -1.71,0.99 -4.62,-1.25 -2.47,-2.77 -1.57,-2.1 1.26,-4.86 0.24,-7.12 -1.03,-0.23 -0.26,-1.2 -0.99,-1.45 z",
						"department-52" : "m 488.81,158.92 c -1.65,0.95 -3.06,-0.3 -4.66,1.1 -1.31,0.1 -3.91,-1.43 -3.96,0.98 2.46,-1.25 5.27,3.02 1.67,3.22 -1.87,0.33 -2.46,1.95 -1.25,3.03 0.66,1.59 0.05,2.39 -1.53,1.62 -2.02,-0.86 -3.97,-0.08 -4.24,2.16 -0.09,1.52 -2.15,3.2 0.26,3.75 1.17,1.64 1.57,3.82 4,3.82 -0.2,2.3 2.56,1.99 3.77,3.31 -1.81,1.62 1.09,2.67 0.71,4.38 0.13,1.7 -1,3.34 0.4,4.62 -1.52,1.98 -0.18,4.83 -1.77,6.47 -2.13,-0.35 -4.62,-1.38 -5.85,1.18 -1.68,1.02 2.45,2.45 0.66,3.99 0.25,2.41 5.66,0.09 3.84,3.35 -0.25,1.39 4.61,0.54 2.78,2.97 -1.68,0.97 -0.11,3.15 0.63,1.11 2.69,-1.66 2.18,3.09 4.08,3.66 1.18,1.84 2.43,4 -0.56,4.83 -1.81,0.95 -0.49,1.59 0.71,1.67 1.1,1.35 -1.35,5.62 1.61,4.32 1.63,-1.99 2.74,0.57 3.16,1.71 1.59,1.44 3.76,1.45 4.59,-0.72 0.9,0.19 0.25,2.48 2.06,2.54 0.69,1.12 2.73,1.17 1.58,2.65 0.3,2.71 2.08,0.28 3.03,-0.44 1.42,-0.65 2.3,1.83 2.86,-0.42 1.04,-1.74 1.04,-4.78 3.76,-4.01 1.6,-1.14 3.57,0.94 4.64,-1.4 1.53,-1.73 1.57,2.71 3.71,1.25 1.9,-0.14 2.96,-1.33 2.2,-3.24 1.43,-1.27 0.76,-2.67 -0.4,-3.65 -0.36,-1.86 1.29,-3.1 2.85,-2.79 0.09,-1.65 1.06,-3.14 2.8,-1.91 1.89,0.14 0.95,-4.51 3.65,-3.28 0.78,-1.86 -1.66,-5.01 -3.64,-3.16 -2.15,-0.87 0.65,-4.14 -1.69,-5.39 -2.08,-0.99 -3.29,-3.6 -5.72,-3.12 -0.78,-1.43 1.75,-1.98 1.2,-3.51 1.49,-1.43 -0.02,-4.02 2.65,-4.08 0.87,-2.59 -4.13,-1.97 -3.4,-4.17 0.23,-2.18 -2.46,-1.79 -3.17,-1.75 -1.8,-1.38 -2.07,-4.99 -4.83,-4.49 -0.93,1.04 -3.31,1.85 -2.44,-0.54 1.81,-1.67 -2.54,-1.69 -0.14,-2.74 3.11,-1.15 -1.05,-3.22 -1.16,-4.6 -2.32,-0.43 -3.09,-3.26 -5.76,-2.98 -2.2,-0.41 -3.45,-2.38 -5.4,-3.25 -1,-0.87 -2.09,-2.25 -3.62,-2.31 -0.33,-1.23 -1.02,-2.41 -1.95,-0.9 -2.48,0.33 -1.06,-3.27 -1.21,-4.49 -0.43,-0.33 -1,-0.32 -1.51,-0.34 z",
						"department-70" : "m 541.89,202.86 c -1.48,1.05 -4.27,0.26 -4.69,2.61 -0.74,1.61 -2.57,2.54 -4.03,2.95 -0.34,-0.77 1.76,-2.53 -0.13,-2.5 -0.99,1.61 -1.89,3.19 -2.4,4.92 -2.68,-0.87 -1.82,3.12 -3.27,3.5 -1.3,-0.7 -3.39,-0.73 -2.74,1.32 -0.88,1.21 -3.24,-0.03 -3.14,2.25 -0.46,1.62 2.55,1.95 0.89,3.63 -0.98,1.52 0.52,4.16 -2.2,4.08 -1.57,0.85 -3.26,0.22 -3.47,-1.55 -1.37,0.18 -2.07,2.82 -3.9,1.41 -1.24,0.85 -3.18,-0.03 -4.03,1.05 0.43,1.42 -2.58,3.53 -0.45,4.25 0.89,-1.83 2.68,-2.68 3.75,-0.37 0.5,1.68 1.75,4.16 -0.07,5.46 -0.69,1.13 -1.66,2.52 -3.19,1.8 -1.3,0.54 0.74,1.52 -0.68,1.82 -0.5,1.32 2.33,0.19 2.27,1.82 -0.45,1.42 -0.22,4.27 1.97,3.2 1.12,0.71 0.49,3.24 0.07,4.44 -0.62,0.77 2.51,1.14 2.67,2.6 1.22,1.84 3.79,2.72 5.53,1.1 1.62,-0.54 3.67,0.84 5.12,-0.89 1.46,-0.88 3.25,-1.31 4.58,-2.34 1.38,-0.22 2.05,-1.72 3.16,-1.63 0.94,0.49 2.1,0.97 2.7,0.39 1.27,0.3 2.44,-1.09 3.48,-1.5 0.36,-1.16 1.47,-0.71 1.64,-2.05 0.91,-0.18 2.82,0.69 2.74,-1.27 0.27,-0.7 1.73,-1.48 2.59,-1.17 1.35,-0.01 2.08,-1.54 2.9,-2.58 0.28,-1.93 2.34,-3 4.25,-3.13 1.33,-1.11 3.28,-0.04 4.17,0.96 1.3,-1.43 3.37,1.14 4.62,-0.44 -0.53,-1.64 0.03,-3.37 1.78,-1.81 1.69,0.65 2.38,-1.65 1.8,-2.91 1.33,0.53 2.65,1.19 3.89,1.55 1.94,2.63 4.4,-1.84 2.14,-3.2 -1.24,-1.45 1.28,-2.68 -0.52,-4.1 0.51,-2.09 -1.61,-3.98 -0.66,-6.03 0.28,-1.73 3.7,-2.9 1.82,-4.59 -1.1,-2.17 -3.7,-2.72 -5.59,-4.24 -2.21,-0.35 -2.45,-4.75 -4.99,-2.91 -0.65,1.93 -4.88,4.56 -5.28,1.25 -0.87,-1.44 -2.49,-3.07 -4.26,-2.96 -1.68,0.96 -3.66,-0.19 -5.12,1.22 -1.27,1.15 -2.34,0.38 -2.89,-0.87 -3.16,0.23 -0.07,-3.74 -2.83,-4.53 z",
						"department-21" : "m 472.24,202.36 c -1.95,0.11 -3.53,1.98 -2.15,3.65 -2.49,1.1 -5.45,0.75 -8.07,0.87 -2.13,-0.11 -4.95,0.4 -3.47,3.25 -0.52,1.33 -3.18,1.72 -1.86,3.85 0.7,1.08 3.26,-0.46 2.82,1.95 1.14,2.24 -0.16,6.53 -2.9,5.76 -2.3,1.31 2.84,4.18 -0.84,3.8 -1.6,0.51 0.85,1.58 -0.66,2.61 -1.1,2.67 -2.37,5.15 -3.94,7.39 -2.71,1.7 0.71,5 -2.38,6.58 -2.1,1.34 0.03,3.32 0.53,4.08 -0.41,1.7 1.09,1.55 1.57,0.87 -0.55,2.05 -1.11,4.28 -0.67,6.46 0.55,1.84 3.24,-0.74 3.79,1.75 2.63,1.57 -1.77,5.03 1.74,5.7 0.01,3.38 5.77,1.31 4.92,4.94 0.76,-0.67 3.17,-1.87 2.58,0.38 0.04,2.32 3.97,1.19 5.01,3.23 2.54,-0.96 1.81,2.86 3.71,3.92 1.27,1.19 4.2,0.81 3.48,3.08 1.54,0.9 2.71,-2.03 4.41,-0.83 2.41,-1.07 4.93,-2.39 7.32,-3.1 2.46,1.63 4.97,-2.65 6.88,0.37 3.01,0.49 5.91,-1.7 8.53,-1.99 1.29,-0.68 2.17,-1.59 0.52,-2.29 -0.4,-3.73 4.96,-2.48 5.6,-5.4 0.99,-2.18 2.8,-4.2 2.54,-6.5 1.77,-1.75 0.39,-4.84 2.52,-6.44 -0.95,-0.58 -2.64,-1.02 -1,-2.29 0.09,-1.58 0.38,-4.17 -2.01,-3.22 -1.24,-1.39 0.1,-5.59 -3.15,-4.35 -0.46,-1.01 1.12,-1.52 0.72,-2.67 1.66,-0.28 3.15,-0.34 3.73,-2.23 1.65,-1.75 0.29,-6.48 -2.25,-6.5 -0.68,1.44 -1.95,2.05 -2.98,2.03 -1.1,-0.38 -2.25,-1.75 -3.19,0.17 -1.11,1.75 -2.93,0.45 -2.18,-1.27 -0.65,-2.03 -3.73,-1.94 -3.27,-4.42 -1.58,3.05 -5.35,1.59 -6.18,-1.1 -0.91,-2.23 -2.22,2.18 -3.58,-0.21 0.08,-1.59 0.76,-4.64 -1.67,-4.45 -0.04,-1.89 5.08,-2.47 2,-4.81 -1.06,-1.58 -1.95,-3.5 -3.18,-5.21 -1.04,-0.38 -2.42,2.56 -3.09,0.19 2.11,-0.98 1.08,-3.93 -1.22,-3.08 -1.29,-0.86 0.47,-3.43 -2.27,-2.98 -2.36,-0.57 -4.26,-0.93 -6.76,-1.56 z",
						"department-25" : "m 566.77,232.71 c 0.09,2.3 -2.25,3.3 -3.94,2.02 0.08,1.13 -0.25,4.27 -2.22,2.67 -1.06,-0.3 -2.94,0.2 -2.94,0.45 -0.89,-2.65 -3.73,-1.2 -5.47,-0.96 -2.07,0.84 -2.28,2.88 -3.61,4.31 -0.88,0.69 -1.46,2.91 -2.9,1.19 -1.05,0.39 -1.48,0.81 -1.12,1.59 -0.93,1.73 -4.27,-0.36 -3.13,2.26 -0.87,0.67 -1.2,-0.97 -1.76,0.58 -1.96,1.7 -4.45,2.18 -6.73,1.12 -0.17,1.07 -1.58,0.31 -1.68,1.83 -2.1,-0.32 -3.88,1.69 -5.8,2.31 -1.02,1.33 -4.07,0.04 -2.32,2.52 0.45,2.81 4.3,3.32 4.76,6.2 -0.21,2.31 -3.08,3.49 -1.86,6.03 -0.97,0.45 -2.59,2.47 -0.46,2.49 1.13,-0.09 1.69,-3.42 2.01,-1.01 0.64,1.41 3.62,2.86 4.68,1.33 0.04,0.48 -0.21,2.56 1.46,1.7 2.32,0.51 -0.12,2.86 2.01,3.54 -1.13,1.45 0.9,2.75 1.29,3.8 0.85,0.48 0.08,2.28 1.68,1.38 2.03,-0.05 3.91,2.07 5.34,3.62 2.95,2.01 -0.39,4.47 -2.29,5.65 -1.9,0.71 -2.6,2.44 -1.2,4.01 -0.4,1.36 -3.17,2.8 -0.77,4.45 1.04,1.22 3.33,2.73 2.42,0.04 1.33,-1.8 3.4,-2.98 4.87,-4.71 1.55,-1.95 4,-2.56 5.83,-4.09 0.99,-1.82 5.3,-2.43 3.21,-5 -0.6,-1.98 1.81,-3.57 1.08,-5.63 -0.72,-1.81 -1.83,-3.34 0.3,-4.68 1.51,-1.44 3.86,-1.05 5.63,-2.1 1.98,-0.67 3.24,-2.47 4.94,-3.62 0.57,-0.92 -0.58,-3.55 1.74,-3.61 0.6,-2.37 3.96,-2.15 4.66,-4.52 1.07,-2.43 3.95,-3.27 5.09,-5.54 -0.36,-1.72 0.12,-3.46 2.27,-3.53 0.32,-1.83 3.74,-1.85 2.02,-3.99 -1.97,-1.19 -4.42,0.69 -6.67,0.22 -2.07,-0.27 1.22,-2.7 1.83,-3.4 0.91,-2.25 -1.75,-3.9 -1.17,-5.86 0.9,-0.28 2.32,-0.68 0.7,-1.63 -1.17,-0.85 -1.3,-2.85 -3.34,-1.98 -1.6,0.43 -2.5,-0.72 -3.56,0.74 -1.33,-0.53 -2.45,-1.44 -4,-1.6 -0.24,-0.27 -0.42,-0.75 -0.89,-0.6 z",
						"department-2B" : "m 633.52,517.94 c -2.35,-0.01 -1.42,2.87 -1.09,4.27 0.7,1.81 -2.49,2.8 -1.11,4.67 -0.49,1.37 -1.42,2.72 -0.13,3.97 0.7,1.67 0.72,3.53 0.53,5.3 -1.04,0.77 -0.92,3.88 -2.55,3.14 -0.73,-1.62 -2.13,-3.04 -4.02,-3.03 -1.86,-0.3 -3.96,-0.04 -5.19,1.55 -1.27,1.17 -0.88,3.32 -2.75,3.92 -1.35,0.75 -2.94,0.89 -4.45,0.77 -1.63,0.44 -2.78,1.92 -4.53,2.07 -1.08,1.11 -1.58,3.82 -3.61,2.5 -2.28,-0.27 -0.71,2.89 -2.74,3.25 -1.77,0.65 -1.34,2.56 -0.72,3.72 -0.66,1.21 -0.31,3.42 -2.4,2.98 -0.67,0.62 -0.74,2.12 -1.28,2.46 1.35,0.64 2.94,0.58 4.15,1.59 1.97,0.67 3.81,1.67 5.8,2.23 1.18,0.16 2.98,-1.17 2.57,1 0.67,1.04 0.89,2.57 2.02,3.34 1.69,0.62 3.17,2.31 4.96,3.14 2.04,-0.26 1.45,2.35 2.36,3.4 0.23,1.54 0.99,2.85 2.49,3.38 1.12,1.46 -0.05,4.35 2.16,5 1.26,-0.1 2.79,0.25 2.31,1.89 0.24,1.9 0.14,4.01 0.49,5.76 1.4,0.6 0.98,1.75 0.27,2.73 -0.72,1.74 1.1,2.24 2.4,1.98 1.18,1.05 2.26,0.38 3.07,-0.7 1.66,-0.67 2.53,-2.38 2.39,-4.11 -0.47,-1.47 -0.29,-2.79 0.86,-3.86 0.84,-1.19 1.62,-2.44 2.13,-3.82 -1.58,-0.86 0.16,-2.37 1.2,-1.81 1.03,-1.08 2.36,-2.78 2.27,-4.18 -1,0.15 -2.19,-0.13 -0.8,-0.98 1.56,-1.35 1.27,-3.53 1.22,-5.37 0.1,-3.14 -0.09,-6.32 -0.92,-9.37 -0.32,-3.98 0.06,-7.99 -0.32,-11.97 0.24,-1.18 -0.67,-2.04 -1.7,-1.88 -1.43,-1.2 -1.56,-3.24 -2.14,-4.89 0.02,-1.82 0.2,-3.65 0.48,-5.45 0.35,-1.84 0.88,-3.65 1.41,-5.45 -0.1,-2.84 -1.09,-5.59 -1.05,-8.44 -0.76,-1.38 0.26,-3.68 -1.57,-4.41 -0.78,-0.33 -1.65,-0.32 -2.48,-0.3 z",
						"department-2A" : "m 595.95,559.63 c -0.71,0.81 -0.11,3.57 1.21,2.02 1.32,-0.93 3.1,1.24 0.97,1.62 -0.01,1 1.97,0.99 2.59,1.98 2.68,1.95 -1.55,2.5 -3.02,2.97 -0.69,0.53 -3.15,0.82 -1.41,1.73 1.22,1.06 0.05,2.77 0.63,3.53 0.85,0.12 -0.9,1.12 0.27,1.67 0.95,1.15 2.75,1.37 3.79,2.45 2.1,-0.64 1.94,2.53 3.38,3.52 -0.02,1.76 -4.46,1.46 -3.63,3.95 0.68,2.57 -4.21,0.57 -2.84,2.8 1.83,0.44 -0.6,3.94 1.9,2.83 1.99,0.16 3.75,-0.5 5.28,-1.55 2.42,0.22 1.96,2.84 1.15,4.32 1.13,1.3 -2.41,1.08 -0.2,2.1 0.63,2.06 -3.77,1.38 -2.66,3.8 0.22,1.8 -4.36,1.47 -1.33,2.5 0.94,2.3 4.06,-1.71 4.08,1.22 0.12,1.47 2.46,0.33 3.33,1.44 1.12,-0.15 4.2,0.76 1.93,1.72 -0.87,1.64 -2.46,2.6 -4.41,2.64 -0.89,1.51 -0.19,3.27 -0.21,4.83 0.82,0.95 2.52,1.18 2.75,2.46 1.7,0.55 2.99,1.97 4.71,2.39 1.66,0.13 3.24,1.87 4.81,1.24 1.07,-1.21 -0.26,2.6 1.64,1.48 2.2,0.53 -1.62,3.32 1.26,3.46 1.58,0.19 2.5,2.76 4.29,1.61 0.89,-0.72 2.28,-4.23 0.03,-2.57 -0.14,-1.13 -0.24,-2.82 1.44,-3.18 2.06,-1.11 0.43,-3.27 1.23,-4.76 1.02,-1.38 3.25,-2.05 3.36,-3.96 -0.51,-2.43 -3.67,1.63 -3.15,-1.09 0.32,-2.31 2.98,-0.08 3.17,-2.26 2.28,-0.35 0.05,-3.4 2.21,-4.19 0.34,-1.98 -0.19,-4.06 0.09,-6.09 -0.04,-1.41 0.43,-5.9 -2.01,-3.86 -1.23,2.09 -3.44,0.59 -5.21,0.54 -1.99,-1.45 2.02,-4.26 -1.36,-4.77 0.81,-1.91 -0.12,-4.19 0.23,-6.27 -0.3,-1.98 -3.78,-0.21 -3.87,-2.87 -0.12,-1.76 -0.24,-3.79 -2.23,-4.35 -1.22,-1.72 -1.07,-4.4 -2.74,-5.63 -1.52,-0.21 -2.6,-1.9 -4.02,-2.28 -1.38,-0.99 -2.79,-1.78 -3.15,-3.59 -0.59,-1.09 -0.54,-2.29 -2.16,-1.83 -2.04,0.35 -3.59,-1.16 -5.42,-1.72 -2.16,-0.83 -4.29,-2 -6.72,-2 z",
						"department-66" : "m 392.27,540.87 c -1.61,0.58 -3.58,1.12 -4.31,2.84 -0.15,1.76 -2.07,2.98 -3.74,2.44 -2.88,-0.05 -5.71,-0.68 -8.58,-0.78 -1.69,0.79 -3.6,0.4 -5.34,-0.01 -1.95,-0.34 -2.77,1.79 -1.78,3.24 0.32,1.46 1.15,3.05 0.58,4.5 -0.82,1.73 -2.83,1.45 -4.25,2.25 -1,1.02 -2.13,1.83 -3.29,2.7 -0.99,0.41 -1.87,-1.29 -3.13,-0.82 -1.57,0.09 -3.05,0.46 -4.56,0.84 -1.73,-0.34 -1.74,2.74 -3.54,2.93 -1.28,-0.07 -2.45,0.31 -2.94,1.55 -1.36,0.64 -3.02,0.25 -4.32,1.15 -1.36,0.9 -1.71,2.74 -1.56,4.26 0.86,1.46 2.9,0.77 4.25,1.35 1.65,0.37 2.31,2.34 4.08,2.41 1.43,-0.11 2.31,0.89 2.36,2.25 0.19,1.48 0.67,3.17 2.18,3.81 1.13,0.44 2.47,0.22 3.51,-0.34 1.24,-0.79 1.72,-2.27 2.67,-3.32 1.39,-1.04 3.26,-0.06 4.73,-0.89 1.22,-0.79 2.5,-0.04 3.64,0.5 1.48,0.81 2.99,1.54 4.59,2.08 1.32,0.67 1.65,2.4 3.09,3 1.2,0.95 2.82,0.92 3.39,-0.67 1.34,-0.63 2.88,1.09 4.46,0.87 2.15,-0.12 -1.28,-2.73 0.67,-3.58 1.27,-0.56 2.55,-2.04 4.03,-1.23 1.72,0.59 2.74,-1.31 3.96,-2.12 1.15,-1.32 3.16,0.13 4.03,-1.41 0.83,-1.27 1.95,0.63 3.11,-0.15 2.01,-0.88 2.41,1.55 3.76,2.33 1.27,0.46 3.16,0.45 4.24,-0.36 -0.27,-1.45 -1.37,-2.7 -2.23,-3.9 -0.28,-1.72 -2.72,-1.88 -2.89,-3.65 -0.57,-2.26 -0.42,-4.64 -1.01,-6.9 -1.47,0.73 -1.88,-2.91 -0.29,-1.48 1.18,0.06 0.41,-2.13 0.75,-2.99 0.09,-1.49 0.11,-3.02 -0.31,-4.47 -0.95,-1.13 -3.87,-0.57 -3.45,-2.71 0.64,-1.39 -0.48,-2.54 -1.82,-2.74 -1.38,-0.34 -2.47,-1.19 -3.6,-1.95 -0.35,-0.31 -0.67,-0.7 -1.14,-0.82 z",
						"department-01" : "m 487.41,302.61 c -0.9,1.57 -0.93,3.47 -1.87,5.03 -0.08,2.19 -1.38,3.92 -1.93,5.93 -0.03,2.1 -1.15,3.89 -1.73,5.86 -0.42,1.81 -1.3,3.51 -1.51,5.35 1.95,2.03 -0.73,4.04 -1.37,6.1 0.45,2.04 -0.98,4.25 0.01,6.51 0.71,1.46 -2.38,3.28 0.35,3.44 1.39,-0.37 2.31,2.05 2.65,2.11 2.25,-1.29 4,2 4.16,3.57 0.56,1.6 0.49,3.54 2.81,2.73 3.02,0.35 6.37,-1.1 9.1,0.77 0.88,2.56 3.84,1.72 4.88,-0.3 1.04,-1.78 1.48,-5 3.81,-5.17 1.24,1.04 3.66,2.18 3.18,3.99 -0.07,2.15 2.61,3.84 3.8,5.69 0.37,1.12 3.48,2.32 2.41,3.1 -1.75,-1.25 0.26,1.66 1.18,1.79 0.81,0.79 1.47,4.56 2.6,1.9 2.12,-0.55 1.75,-2.31 2.63,-3.9 -1.04,-2.22 3.07,-0.3 3.11,-2.82 0.62,-2.49 0.12,-5.28 1.29,-7.73 0.79,-1.87 1.18,-3.85 1.11,-5.88 0.91,-2.45 -1.84,-4.44 -0.77,-7.08 -0.18,-1.49 0.45,-5.51 2.24,-2.86 2.51,0.81 0.41,-2.98 3.09,-2.68 2.03,0.37 4.6,-2.6 2.34,-3.96 -0.92,-2.11 2.75,-3.28 4.44,-3.52 3.3,0.13 0.54,-3.31 2.3,-4.83 1.05,-1.66 2.36,-4.08 0.02,-5.37 -1.53,-2.11 -3.79,-0.86 -4.73,1.04 -1.87,1.05 -2.36,3.24 -3.81,4.61 -1.35,1.27 -3.15,4.02 -5.8,3.21 -1.93,-0.56 -4.96,1.08 -4.38,-2.24 -0.76,-1.18 -2.84,-1.79 -3.61,-2.54 -1.5,1.09 -1.85,3.07 -3.86,3.7 -1.35,2.09 -5.97,0.71 -3.69,-1.99 -0.13,-1.17 -2.23,0.32 -2.08,-1.73 -0.53,-0.8 -0.77,3.05 -1.07,0.87 -0.55,-1.56 -1.98,-2.98 -1.65,-4.48 -1.69,-0.63 -3.44,-1.35 -2.39,-3.29 -1.67,-0.94 -4.57,-0.64 -4.85,-3.2 -0.77,-2.9 -3.6,-0.34 -5.35,-0.3 -2.42,1.93 -4.08,-2.75 -6.45,-0.84 -0.29,-0.08 -0.46,-0.35 -0.61,-0.59 z",
						"department-39" : "m 514.04,250.63 c -1.89,1.19 -1.41,3.32 -1.89,5.29 -0.64,0.76 -1.51,1.41 -0.89,2.56 -0.09,2.24 -2.26,3.17 -2.61,5.27 -0.78,2.29 -3.94,1.22 -5.02,3.42 -1.54,1.4 0.68,1.65 1.05,2.54 -1.89,0.73 -2.96,2.39 -2.48,4.33 0.13,1.42 2.53,-0.61 2.4,1.57 0.08,2.38 2.07,2.39 3.72,2.02 0.66,0.84 0.67,2.23 2.23,2.18 2.43,0.87 -0.09,3.1 -1.71,1.96 -1.17,0.08 -2.55,0.59 -3.37,1.25 0.11,1.68 4.21,2.07 1.77,3.98 -0.64,1.56 1.6,1.33 1.54,2.91 0.07,1.18 -0.12,1.58 0.83,2.44 0.19,1.36 1.42,2.53 -0.34,3.52 -0.67,0.75 0.36,2.67 -1.62,2.51 -1.19,0.8 -1.32,4.36 1.01,4.73 2.68,1.66 -1.11,3.55 -2.81,2.97 -1.59,0.44 -1.06,2.31 -1.05,3.41 1.19,0.84 3.25,1.23 2.45,3.03 0.35,0.78 1.76,2.89 2.4,1.17 0.08,1.37 1.23,2.01 2.19,1.81 0.32,1.28 -1.44,3.9 1.22,3.43 2.17,0.36 3.07,-1.82 4.79,-2.43 -0.05,-1.35 2.19,-3.36 2.53,-1.42 1.91,0.51 3.26,1.46 2.92,3.66 1.58,0.41 3.84,0.2 5.69,0.41 2.04,-0.37 2.86,-2.2 4.05,-3.32 1.59,-0.86 1.89,-3.63 3.87,-4.44 0.79,-1.41 2.45,-2.26 3.01,-3.68 -1,-2.03 0.83,-3.26 1.54,-4.97 0.09,-1.12 3.27,-3.18 0.85,-3.09 -1.33,-0.11 -2.8,-2.09 -3.8,-3.26 0.31,-1.77 3.21,-2.74 1.14,-4.67 -0.05,-2.2 3.25,-2.62 4.42,-4.31 1.79,-1.34 1.01,-2.85 -0.45,-4.05 -1.09,-1.57 -2.94,-2.35 -4.27,-3.29 -1.13,0.65 -2.22,0.54 -2.27,-0.9 -0.74,-1.09 -1.45,-2.1 -1.83,-3.4 1.47,-1.38 -2.22,-1.64 -0.41,-2.83 0.19,-1.99 -2.81,-0.62 -3.13,-2.43 -1.62,-0.17 -4.52,-0.62 -4.4,-2.92 -0.26,1.15 -2.52,3.12 -3.02,0.86 -0.35,-1.5 0.05,-1.67 1.38,-1.39 0.81,-1.24 -0.85,-3.11 1.04,-3.84 1.28,-1.28 1.47,-3.89 -0.53,-4.47 -0.44,-1.71 -3.15,-1.61 -3.09,-3.86 -0.11,-1.87 -1.88,-3.24 -3.34,-1.52 -1.61,0.12 -3.45,0.65 -4.24,-1.23 -0.57,-0.4 -0.93,-1.18 -1.47,-1.53 z",
						"department-68" : "m 591.47,183.79 c -2.1,0.97 -2.85,3.5 -3.75,5.52 -0.4,1.82 -2.19,2.92 -2.55,4.75 -1.33,1.4 1.36,1.6 0.27,2.87 -0.93,1.83 -2.95,3.04 -3.07,5.23 -0.53,1.75 -3.15,1.46 -3.13,3.23 -0.66,1.37 -1.22,3.06 -0.75,4.66 -0.41,1.17 -1.65,2.15 -0.51,3.43 0.71,1.97 -2.43,1.73 -3.09,2.98 -0.01,2.42 2.61,2.31 4.21,3.1 1.23,0.9 2.73,1.32 3.92,2.26 0.75,1.15 0.29,2.81 0.85,4.22 0.01,1.63 -1.93,1.81 -1.61,3.67 -0.16,2.76 3.69,-0.48 3.8,2.34 0.66,1.17 1.29,2.31 2.22,3.23 -0.26,1.35 -0.34,3.32 1.72,2.8 1.73,0.11 -1.35,2.88 0.68,3.58 1.21,-0.48 1.99,0.74 2.58,1.18 1.4,-0.54 2.91,-1.51 4.42,-0.87 1.79,0.56 3.19,-0.73 4.39,-1.84 1.37,-0.81 -1.77,-2.28 0.35,-2.24 1.11,1.41 3.16,-0.23 2.08,-1.61 1.35,0.23 1.87,-1.32 0.4,-1.53 0.05,-1.19 2.27,-1.12 2.66,-2.48 2.32,-0.26 0.55,-3.04 -0.23,-4.09 -1.18,-1.03 -2.5,-2.48 -1.9,-4.18 1.12,-1 1.8,-2.48 0.85,-3.92 -0.75,-1.85 0.36,-3.7 1.28,-5.22 -0.2,-1.24 -0.59,-2.6 0.78,-3.3 -0.03,-1.74 0.45,-3.15 1.71,-4.41 0.99,-1.53 -0.1,-3.22 -1.28,-4.25 -1.68,-1.54 -0.61,-3.93 -0.56,-5.85 -0.14,-1.63 -3.48,-0.24 -2.69,-2.54 -1.27,-0.5 -2.91,-1.03 -1.97,-2.74 -0.27,-1.98 -2.78,-1.98 -4.09,-3.08 -1.07,-0.97 -3.47,-0.16 -3.41,-1.99 -1.07,-0.75 -0.89,-3.1 -2.98,-2.56 -0.55,-0.04 -1.03,-0.39 -1.58,-0.37 z",
						"department-90" : "m 574.39,216.2 c -0.55,0.23 -0.49,0.97 -0.95,1.33 -0.63,0.8 -1.51,1.36 -1.95,2.3 -0.77,0.99 -0.8,2.48 -0.08,3.5 -0.03,0.67 0.48,1.24 0.41,1.93 -0.01,0.83 -0.07,1.76 0.62,2.36 0.29,0.29 0.48,0.66 0.1,0.97 -0.14,0.38 -0.57,0.43 -0.76,0.72 -0.05,0.5 0.53,0.78 0.56,1.29 0.18,0.47 0.52,0.85 0.75,1.28 0.26,0.15 0.87,0.53 0.4,0.81 -0.7,0.47 -0.05,1.72 0.76,1.5 0.78,0.02 1.57,-0.19 2.27,-0.46 0.8,0.18 1.42,0.82 1.46,1.64 0.04,0.86 1.41,0.54 1.43,1.42 0.01,0.47 0.26,1.11 -0.01,1.5 -0.5,0.35 -0.45,-0.64 -0.86,-0.74 -0.5,-0.2 -0.94,0.42 -0.64,0.85 0.2,0.34 -0.18,0.93 0.34,1.04 0.43,0.61 0.84,1.44 0.71,2.19 -0.36,0.5 0.42,0.64 0.75,0.45 0.83,-0.18 1.47,-0.8 2.26,-1.07 0.62,-0.6 -0.22,-1.42 -0.38,-2.05 -0.12,-0.36 -0.45,-1.06 0.17,-1.13 0.42,-0.08 0.81,-0.3 1.15,-0.48 0.96,0.2 1.82,0.91 2.87,0.71 1.1,-0.11 2.47,-0.62 2.45,-1.94 0.17,-1 -0.69,-1.63 -1.42,-2.13 -0.16,-0.46 -0.02,-1.09 -0.52,-1.4 -0.45,-0.55 -0.43,-1.71 -1.38,-1.73 -0.72,-0.12 -1.46,0.05 -1.95,0.59 -0.4,0.24 -0.3,-0.53 -0.6,-0.62 -0.31,-0.79 -0.34,-1.73 0.1,-2.47 0.16,-0.36 0.01,-1.1 0.63,-0.98 0.41,0.01 0.38,-0.37 0.4,-0.64 0.61,-1 -0.15,-2.14 -0.3,-3.13 0.23,-0.47 0.38,-1.05 -0.1,-1.44 -0.8,-1.1 -2.3,-1.18 -3.29,-2.06 -0.38,-0.36 -0.84,-0.58 -1.34,-0.6 -0.84,-0.67 -2.13,-0.38 -2.92,-1.15 -0.45,-0.63 -0.74,-1.4 -0.95,-2.13 -0.05,-0.04 -0.12,-0.05 -0.18,-0.04 z",
						"department-971" : "m 29.7,299 c -1.87,1.62 -3.85,3.09 -5.8,4.6 -1.43,1.52 -0.11,4.46 1.17,5.6 2.13,-0.29 1.96,2.76 1.56,3.13 -0.94,0.26 -0.86,0.93 -2.23,0.75 -1.03,1.66 -1.29,3.62 -2.45,4.7 1.04,1.32 0.08,3.56 1.78,4.78 0.07,1.69 2.29,0.69 2.84,1.78 2.57,1.14 4.82,0.08 7.34,-0.38 2.38,-0.82 4.2,-1.85 6.78,-2.46 2.37,0.03 4.67,-0.43 6.92,-1.15 2.18,-0.06 4.33,0.34 6.48,0.62 2.37,0.69 -1.08,-1.04 -1.87,-0.73 -3.38,-0.38 -3.95,-4.08 -6.74,-5.2 -2.32,-1.36 -4.81,-0.91 -7.05,-1.44 -2.4,-1 -4.48,-4.07 -3.05,-6.6 0.27,-2.73 -1.51,-4.9 -3.7,-6.25 -0.49,-1.1 -2.18,0.21 -1.97,-1.73 z m -7.17,21.03 c 0.11,-1.09 -0.45,-1.63 -1.09,-1.6 1.7,-0.65 -2.37,-1.12 -2.11,0.41 -0.62,1.09 -1.76,0.26 -1.23,-0.66 -0.14,0.74 -1.86,1.51 -1.16,0.16 -1.87,1.19 -0.57,-2.14 -0.53,-0.23 0.53,-0.38 2.26,-2.49 0.24,-1.72 -2.07,0.4 -2.51,-2.1 -4.57,-1.54 -1.98,-0.8 -3.96,-1.34 -5.61,-2.88 -1.91,-0.59 -4.89,0.65 -5.15,3.01 -1.66,0.26 0.25,1.19 -0.95,1.74 -0.71,2.26 -0.52,4.57 1.52,6.1 -0.09,1.85 -0.15,3.66 0.81,5.04 -0.57,1.79 0.61,2.89 0.15,4.71 0.8,1.67 -0.36,3.89 1.54,5.38 0.67,2.38 2.22,3.96 3.95,5.62 -0.52,2.79 2.77,2.33 3.89,0.76 0.91,0.09 1.87,-0.69 3.16,-0.35 1.57,-1.07 2.52,-3.39 4.69,-4.38 1.9,-1.56 1.47,-3.64 1.43,-5.75 -0.18,-1.37 -1.46,-2.26 -0.25,-3.52 -1.49,-0.22 -1.13,-1.71 -1.93,-2.53 0.7,-1.4 -1.1,-2.18 -0.05,-3.66 -1.4,-2.35 2.33,-3 2.98,-1.09 1.78,-0.78 -1.18,-1.71 0.27,-3.01 z m 46.75,-7.55 c -2.05,0.7 -3.82,2.03 -5.88,2.72 -0.67,0.4 -2.43,0.86 -1.64,2.25 1.93,-1.3 4.48,-1.07 6.19,-2.82 1.64,-0.34 2.78,-0.69 1.33,-2.15 z m -23.09,28.1 c -2.49,0.56 -3.6,2.83 -4.31,4.93 -1.85,0.89 -0.59,4.21 0.59,5.34 1.72,0.81 3.58,1.63 5.49,0.98 2.2,-0.83 5.35,-2.33 5.09,-5.09 -0.59,-1.82 -2.8,-2.59 -3.39,-4.32 -1.07,-0.65 -2.48,-1.08 -3.47,-1.83 z",
						"department-972" : "m 41.12,417.83 c 1.08,-0.51 0.39,-1.76 -0.57,-0.9 0.17,0.88 -1.41,-0.39 -1.27,-1.01 -1.24,-0.99 1.89,-2.22 0.44,-3.63 1.28,0.98 0.78,-0.99 2.05,-0.53 -0.37,-0.35 0.77,-1.14 -0.47,-1.12 0.04,-0.9 -0.95,0.65 -0.65,-0.43 -1.5,0.33 -2.35,3.48 -3.67,1.24 -0.33,-2.28 -2.52,0.16 -3.91,-0.8 -1.39,0.24 -2.33,-1.07 -3.57,-0.37 0.25,-1.05 -0.91,-1.38 -1.15,-0.52 -1.07,-1.01 0.24,1.52 -1.12,0.6 -0.49,-0.54 -0.75,-1.49 -1.33,-0.43 -1.1,-1.32 -3.62,-0.54 -4.2,0.97 -0.58,1.92 -2.17,0.41 -2.74,-0.58 -2.08,0.55 0.33,-2.63 -1.76,-2.44 -5.48e-4,-0.53 1.16,-1.07 -0.06,-1.42 -2.07,0.45 -0.47,-1.87 0.13,-2.37 0.62,-1.62 2.65,-0.37 3.18,-2.13 0.87,0.36 0.47,-1.74 1,-0.52 -0.64,1.14 2.43,-0.72 0.85,0.8 -0.4,0.92 1.34,0.72 1.64,1.17 0.97,-0.45 1.45,0.48 2.19,-0.49 0.85,0.34 1.33,-1.02 1.54,-1.07 0.26,-1.45 -2.92,-0.45 -1.99,-2.3 0.46,-0.94 -2.73,-1.2 -0.72,-2.06 -0.22,-0.83 -0.91,-0.31 -0.32,-1.22 -0.28,-1.25 -1.72,-0.04 -2.19,0.42 0.84,0.51 -1.42,1.49 -0.91,0.58 -0.58,-0.48 -1.39,0.67 -1.49,-0.49 -1.01,-8e-4 -3.19,0.56 -3.88,-0.97 -0.78,-1.26 -2.08,-1.97 -3.49,-2.28 -1.15,-0.83 -2.34,-1.58 -3.07,-2.86 -0.88,-1.77 -2.7,-3.11 -2.93,-5.17 -0.03,-1.4 1.44,-2.77 0.52,-4.11 -1.38,-1.67 -3.18,-2.85 -4.5,-4.46 -0.96,-1.27 -1.25,-3.03 -0.33,-4.41 0.77,-1.16 1.42,-2.66 2.96,-2.91 1.42,-0.6 2.51,-1.36 4.14,-1.34 1.94,-0.31 3.72,0.55 5.55,1 1.84,1.32 3.97,2.23 5.78,3.47 0.88,0.17 1.63,-0.49 2.29,0.47 1.2,-0.45 -0.22,1.09 1.16,0.77 0.55,0.84 0.95,2.15 2.18,1.32 0.46,0.47 -0.31,1.48 0.76,2.04 0.55,0.58 1.02,1.32 1.85,1.29 -0.17,1.12 2,1.82 1.83,3.36 0.87,1.99 1.35,-0.57 2.16,-1.09 1.4,-1.24 3.07,0.15 4.34,-1.28 1.3,-0.15 1.97,-1.87 3.28,-0.59 0.31,1.1 -0.19,2.01 -0.82,0.64 -1.26,-0.45 -1.99,0.91 -0.82,1.48 -0.66,0.53 -1.36,0.82 -0.16,1.39 -1.04,0.46 -2.2,0.46 -2.53,-0.69 -0.98,-1.09 -4.2,-0.24 -2.77,1.16 -0.07,-0.08 -1.31,0.94 -0.15,1.45 0.54,0.96 1.79,-0.77 1.13,0.65 -0.86,1.64 2.23,-0.74 1.71,0.68 -0.05,1.07 2.49,0.61 0.91,1.29 -0.54,0.71 -2.62,0.33 -2.44,1.52 -1.19,-0.96 -1.91,1.6 -0.65,1.89 0.96,1.92 1.98,-0.69 3.1,-0.19 0.53,-0.7 1.62,1.13 2.18,-0.26 1.09,0.7 -0.67,2.09 -1.68,1.55 -0.75,0.72 1.96,1.16 0.72,2.18 -1.01,0.96 0.44,1.05 1.02,1.19 -0.3,0.36 2.56,-0.58 1.17,0.24 -0.61,0.96 1.29,1.06 0.4,2.08 0.68,1.31 2.89,-0.39 2.41,1.68 1.13,-0.12 -1.31,0.7 0.07,1.12 0.45,-0.31 -0.09,0.75 0.96,0.4 -1.15,1.68 2.42,-1.51 0.96,0.45 -1.33,0.96 -0.09,1.54 0.49,2.31 -0.21,0.48 -1.59,0.45 -0.21,0.55 1.27,0.1 -0.04,1.32 -0.52,1.19 -0.46,1.05 0.15,1.15 0.92,0.8 0.51,0.76 -0.16,2.24 1.12,2.39 0.9,1.14 -0.09,1.68 -0.67,1.77 0.66,0.76 0.79,1.51 -0.18,2.18 0.29,1.26 -1.18,2.05 -1.49,2.98 -0.77,-0.72 -1.83,-0.35 -0.75,0.49 0.39,0.2 0.85,0.97 -0.05,0.52 -1.06,0.12 -1.08,2.05 -2.33,1.55 -0.14,0.12 -0.36,0.31 -0.56,0.15 z",
						"department-973" : "m 8.71,468.07 c 0.65,-1.02 1.07,0.28 1.13,-0.79 0.6,-1.37 1.44,-3.03 0.93,-4.38 -1.66,0.13 -0.96,-2.54 -2.78,-2.38 -0.6,-0.96 -1.5,-1.7 -1.87,-2.73 -1.18,-0.67 0.75,-2.15 -1.08,-2.39 0.53,-1.57 -0.71,-2.9 -0.71,-4.39 1.24,-0.95 -0.25,-2.77 -0.39,-3.83 0,-1.65 0.37,-3.36 1.62,-4.57 0.78,-1.59 2.45,-2.29 3.72,-3.41 1.25,-0.94 1.5,-2.32 1.8,-3.75 0.65,-0.4 1,0.91 0.34,-0.26 0.06,-1.37 3.02,-0.59 2.9,0.84 0.82,-0.03 1.05,1.48 0.59,0.08 -0.99,0.16 -0.71,-1.46 -1.36,-1.44 1.6,0.69 3.18,1.47 4.8,2.1 1.33,0.32 2.78,0.17 4,0.85 -1.36,-0.48 -0.37,-0.97 0.4,-0.29 1.17,0.73 3.53,0.91 3.51,2.46 0.15,-0.44 -0.92,-1.82 0.32,-0.98 1.44,0.61 2.5,1.73 3.63,2.7 0.86,0.47 0.91,0.83 0.28,1.24 0.68,-0.75 2.44,1.17 3.52,1.74 0.99,0.55 1.3,1.55 -0.1,1.43 -0.9,0.02 1.24,-0.07 1.05,0.04 0.89,-1.67 2.77,0.32 1.04,1.07 -0.22,0.58 -0.66,1.9 -0.09,0.47 1.05,-2.28 3.22,0.37 4.41,1.15 0.62,1.46 1.88,3.86 -0.2,4.74 -1.09,-0.08 -2.47,1.1 -2.94,1.37 1.28,-1.39 3.58,-0.74 4.43,-2.59 -0.11,-1.14 -0.29,-4.42 1.62,-2.67 0.78,1 0.87,3.03 1.64,3.51 -0.36,1.37 1.94,2.42 0.64,3.98 -0.88,0.91 -1.94,1.45 -2.28,2.82 -1.35,1.08 -2.13,1.89 -2.81,3.44 -0.72,1.18 -1.63,2.27 -2.32,3.48 -0.66,1.57 -3.27,2.04 -2.6,4.08 -0.47,1.63 -1.6,2.37 -2.12,3.98 -1.14,1.19 -0.58,2.64 -1.58,3.75 -0.94,1.49 -2.65,1.97 -4.04,3.01 -0.89,1.67 -2.64,1.09 -4,0.49 -0.92,0.05 -2.79,0.91 -1.61,-0.51 -0.85,-1.69 -2.58,-0.7 -3.74,0.09 -1.12,-0.05 -3.37,-0.46 -3.6,-1.1 -0.48,-1.26 -1.35,0.32 -1.85,0.37 -0.51,0.22 -0.76,0.52 -1.24,0.65 -0.2,1.31 -2.14,0.51 -2.39,1.77 -0.99,0.4 -1.37,-0.86 -2.43,-0.3 -1.27,0 -1.69,-1 -2.99,-0.94 -1.07,-0.36 -0.91,-1.62 -1.81,-1.66 0.75,-0.08 1.5,0.21 1.41,-0.85 1.82,-0.45 2.27,-2.16 3.1,-3.6 1.14,-1.2 1.62,-2.64 1.67,-4.27 -0.34,-0.76 0.11,-1.81 -0.59,-2.19 0.12,-0.6 0.6,-1.04 1.04,-1.43 z",
						"department-974" : "m 6.55,518.47 c -0.78,1.45 -2.64,1.3 -3.67,1.73 -0.99,0.7 -1.49,1.6 -0.68,2.68 -0.71,1.55 0.53,2.89 1.77,3.65 0.93,1.16 2.29,2.18 2.27,3.78 1.62,0.39 1.26,2.73 0.7,3.93 0.45,1.49 1.2,2.88 2.74,3.48 1.08,0.59 1.53,1.64 1.59,2.6 1.58,0.71 3.59,0.34 5.04,1.47 1.1,1.14 2.04,2.73 3.9,2.49 0.94,0.35 1.57,1.68 2.8,1.36 0.41,0.86 2.31,0.21 3.21,1.12 1.44,0.09 2.25,1.23 3.54,1.09 1.35,0.11 2.51,-0.11 3.53,0.99 1.15,0.16 2.43,-0.77 3.36,0.25 0.97,-0.65 2.13,-0.39 3.06,-1.1 1.71,0.47 3.22,-0.48 4.88,-0.5 1.4,-0.53 3.03,-0.16 4.19,-1.51 1.57,-1.15 0.29,-3.12 0.62,-4.69 -0.36,-1.46 -0.16,-2.97 0.21,-4.43 0.05,-1.5 1.91,-2.21 1.43,-3.7 1.44,0.27 0.59,-1.52 0.63,-2.21 -0.35,-1.08 -1.04,-1.57 -2.06,-1.88 -0.88,-1.15 -2.6,-0.49 -2.96,-2.18 -1.08,-1.2 -2.34,-2.37 -3.22,-3.72 0.44,-1.22 -1.09,-2.15 -1.97,-2.71 -0.85,-1.32 -0.31,-2.94 -0.71,-4.36 -0.6,-1.39 -1.75,-2.36 -2.73,-3.46 -1.17,-1.09 -2.77,-1.02 -4.16,-1.47 -1.38,-0.92 -2.99,-1 -4.56,-1.16 -1.75,0.65 -3.41,-1.15 -5.14,-0.63 -1.66,0.9 -2.84,-1.39 -4.3,-0.66 -1.84,-0.3 -3.75,0.39 -5.21,1.5 -1.17,0.67 -2.02,1.64 -3.1,2.36 -0.47,0.42 -1.58,-0.1 -1.2,0.65 -1.11,0.28 0.14,-0.7 -1.09,-0.23 -1.02,-0.1 -2.71,-0.7 -1.94,0.71 -1.38,0.63 -0.02,2.61 -0.46,3.77 -0.09,0.33 -0.08,0.76 -0.33,1.01 z",
						"department-976" : "m 49.48,582.55 c -1.09,1.5 -3.13,3.73 -4.29,3.49 -0.04,1.14 -2.37,-0.07 -1.41,1.23 1.85,0.72 3.9,1.95 4.4,4.11 -0.1,1.08 1.24,1.43 1.82,1.86 -0.65,-1.36 -0.49,-3.36 1.48,-3.55 1.1,-0.6 -0.97,-2.5 0.97,-2.4 -0.79,-1.8 -1.36,-3.15 -2.75,-4.67 l -0.22,-0.08 -4e-6,0 z m -25.87,43.4 c -1.57,0.66 -2.04,-0.42 -2.69,-1.5 -0.96,0.2 -2.68,1.53 -2.26,-0.56 -0.29,-2.1 -3.3,-0.98 -2.96,1.01 -1.62,-0.83 0.04,-2.33 -0.71,-3.6 1.64,-0.91 -0.12,-3.97 -1.08,-1.71 -1.63,1.31 -2.55,-0.9 -4.24,-0.25 0.82,-1.56 3.2,-1.18 3.96,-2.88 1.01,-1.3 1.13,-5.01 -1.46,-3.23 -1.62,0.66 0.17,-1.25 -1.53,-1.26 -0.93,-1.21 -0.93,-3.41 -2.47,-3.89 1.47,-0.76 4.49,-0.99 5.8,-0.12 1.15,1.3 -0.49,4.45 2.29,4.33 1.9,0.37 2.98,2.44 5.05,1.92 2.41,0.01 1.95,-2.86 1.45,-4.39 -1.22,-1.08 -1.51,-2.15 -2.04,-3.65 -1.59,-1.05 -3.84,-1.95 -4.25,-4.13 -1.32,-0.69 -3.52,-1.33 -3.97,-2.87 1.54,0.04 1.54,-2.04 3.24,-1.32 2.23,0.16 0.64,-1.78 -0.71,-1.32 -2.76,-0.15 1.21,-3.79 -0.77,-4.49 -1.17,-1.17 -0.41,-2.93 0.99,-3.08 -0.81,-0.3 -2.36,0.07 -2.38,-1.41 -0.73,-0.83 1.72,-0.73 1.2,-2.07 0.52,-1.02 -0.6,-2.24 -1.17,-0.74 -1.08,-0.02 -2.3,-1.56 -3.73,-0.67 -1.38,-1.12 -2.95,-3.83 -4.66,-1.87 -0.45,-1.03 -3,-1.58 -1.11,-2.91 2.35,-0.34 2.82,-4.03 -0.2,-2.95 -2.28,0.03 0.97,-1.22 1.01,-2.35 -0.21,-1.04 -0.06,-2.57 1.45,-1.8 1.15,0.24 2.14,-0.36 2.17,-1.33 1.37,0.02 0.77,-2.06 -0.41,-1.84 0.29,-0.76 3.75,0.79 2.93,-1.59 0.08,-1.65 2.69,-1.39 2.16,-3.05 1.08,1.03 2.85,-2.46 2.47,-0.48 -1.81,0.56 1.51,1.73 -0.75,1.56 -0.98,0.03 -3.73,1.55 -1.35,1.54 0.86,0.67 2.53,0.49 1.6,1.93 1.21,-0.17 2.2,0.81 1.8,1.89 0.87,1.21 3.54,0.7 3.54,2.06 -2.07,-0.6 -0.93,1.74 -8.76e-4,2.31 0.04,2.42 2.59,1.12 3.79,2.15 0.54,2.08 2.3,-0.27 2.8,-0.97 -0.78,-2.25 1.18,0.06 1.82,0.58 2.04,-0.22 3.89,0.64 5.99,0.59 0.47,1.45 2.5,-0.57 1.49,1.25 0.7,1.31 2.83,0.84 3.67,2.26 1.61,0.56 1.58,2.4 0.73,3.53 -0.86,0.86 -0.83,1.5 0.49,2.06 0.18,1.64 -2.47,0.32 -3.17,1.86 -1.49,0.3 -0.43,2.32 -2.07,2.69 -1.28,0.99 -1.03,2.78 -2.77,3.12 -1.51,0.97 1.38,1.21 -0.28,1.86 -1.29,1.06 0.47,1.9 0.16,2.96 0.48,0.72 1.17,0.81 1.64,1.7 0.58,0.53 2.15,0.13 1.18,1.39 0.07,1.56 3.14,-0.41 1.84,1.46 -1.63,0.49 0.52,1.96 -1.3,2.13 -0.96,1.27 -4.27,1.29 -2.85,3.7 -0.91,1.44 3.37,2.6 0.79,2.21 -1.19,-0.25 -4.04,-1.63 -3.48,0.73 -1.74,0.05 -1.93,1.8 -0.95,2.74 0.79,1.58 -2.92,-0.58 -1.9,1.79 1.5,1.03 1.09,3.24 3.21,3.52 1,0.24 1.78,1.35 3.05,0.64 0.56,0.98 -1.46,2.2 -2.15,2.56 -1.46,-1.46 -2.81,0.08 -2.47,1.36 -1.65,0.28 -0.51,-4.66 -3.13,-3.2 -1.69,0.47 -0.29,2.47 -1.63,3.31 -0.13,0.32 -0.41,0.54 -0.68,0.75 z m -2.2,-10e-4 c -0.08,2.44 -1.24,0.23 0,0 z"
					}
				}
			}
		}
	);
})(jQuery);