/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_tg extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AC", "\u0410\u0441\u0443\u043d\u0441\u043e\u043d" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0440\u0430" },
            { "AE", "\u0410\u043c\u043e\u0440\u0430\u0442\u04b3\u043e\u0438 \u041c\u0443\u0442\u0442\u0430\u04b3\u0438\u0434\u0430\u0438 \u0410\u0440\u0430\u0431" },
            { "AF", "\u0410\u0444\u0493\u043e\u043d\u0438\u0441\u0442\u043e\u043d" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0432\u0430 \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "AI", "\u0410\u043d\u0433\u0438\u043b\u0438\u044f" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438\u044f" },
            { "AM", "\u0410\u0440\u043c\u0430\u043d\u0438\u0441\u0442\u043e\u043d" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0434\u0430" },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430" },
            { "AS", "\u0421\u0430\u043c\u043e\u0430\u0438 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438\u044f" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "AX", "\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u0410\u043b\u0430\u043d\u0434" },
            { "AZ", "\u041e\u0437\u0430\u0440\u0431\u043e\u0439\u04b7\u043e\u043d" },
            { "BA", "\u0411\u043e\u0441\u043d\u0438\u044f \u0432\u0430 \u04b2\u0435\u0440\u0441\u0435\u0433\u043e\u0432\u0438\u043d\u0430" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "BE", "\u0411\u0435\u043b\u0433\u0438\u044f" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430-\u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u0443\u043b\u0493\u043e\u0440\u0438\u044f" },
            { "BH", "\u0411\u0430\u04b3\u0440\u0430\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u0421\u0435\u043d\u0442-\u0411\u0430\u0440\u0442\u0435\u043b\u043c\u0438" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434\u0430" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439" },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438\u044f" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f" },
            { "BS", "\u0411\u0430\u0433\u0430\u043c" },
            { "BT", "\u0411\u0443\u0442\u043e\u043d" },
            { "BV", "\u04b6\u0430\u0437\u0438\u0440\u0430\u0438 \u0411\u0443\u0432\u0435" },
            { "BW", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "BY", "\u0411\u0435\u043b\u043e\u0440\u0443\u0441" },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "CC", "\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u041a\u043e\u043a\u043e\u0441 (\u041a\u0438\u043b\u0438\u043d\u0433)" },
            { "CF", "\u04b6\u0443\u043c\u04b3\u0443\u0440\u0438\u0438 \u0410\u0444\u0440\u0438\u049b\u043e\u0438 \u041c\u0430\u0440\u043a\u0430\u0437\u04e3" },
            { "CH", "\u0428\u0432\u0435\u0439\u0442\u0441\u0430\u0440\u0438\u044f" },
            { "CI", "\u041a\u043e\u0442-\u0434\u2019\u0418\u0432\u0443\u0430\u0440" },
            { "CK", "\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u041a\u0443\u043a" },
            { "CL", "\u0427\u0438\u043b\u0438" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u0425\u0438\u0442\u043e\u0439" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u044f" },
            { "CR", "\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "CW", "\u041a\u044e\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u04b6\u0430\u0437\u0438\u0440\u0430\u0438 \u041a\u0440\u0438\u0441\u043c\u0430\u0441" },
            { "CY", "\u041a\u0438\u043f\u0440" },
            { "CZ", "\u04b6\u0443\u043c\u04b3\u0443\u0440\u0438\u0438 \u0427\u0435\u0445" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f" },
            { "DJ", "\u04b6\u0438\u0431\u0443\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0438\u044f" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430" },
            { "DO", "\u04b6\u0443\u043c\u04b3\u0443\u0440\u0438\u0438 \u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d" },
            { "DZ", "\u0410\u043b\u04b7\u0430\u0437\u043e\u0438\u0440" },
            { "EC", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "EE", "\u042d\u0441\u0442\u043e\u043d\u0438\u044f" },
            { "EG", "\u041c\u0438\u0441\u0440" },
            { "ER", "\u042d\u0440\u0438\u0442\u0440\u0435\u044f" },
            { "ES", "\u0418\u0441\u043f\u0430\u043d\u0438\u044f" },
            { "ET", "\u042d\u0444\u0438\u043e\u043f\u0438\u044f" },
            { "FI", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f" },
            { "FJ", "\u0424\u0438\u04b7\u0438" },
            { "FK", "\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434" },
            { "FM", "\u0428\u0442\u0430\u0442\u04b3\u043e\u0438 \u0424\u0435\u0434\u0435\u0440\u0430\u0442\u0438\u0432\u0438\u0438 \u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u044f" },
            { "FO", "\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u0424\u0430\u0440\u0435\u0440" },
            { "FR", "\u0424\u0430\u0440\u043e\u043d\u0441\u0430" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "GB", "\u0428\u043e\u04b3\u0438\u0433\u0430\u0440\u0438\u0438 \u041c\u0443\u0442\u0442\u0430\u04b3\u0438\u0434\u0430" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "GE", "\u0413\u0443\u0440\u04b7\u0438\u0441\u0442\u043e\u043d" },
            { "GF", "\u0413\u0432\u0438\u0430\u043d\u0430\u0438 \u0424\u0430\u0440\u043e\u043d\u0441\u0430" },
            { "GG", "\u0413\u0435\u0440\u043d\u0441\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438\u044f" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u044f" },
            { "GP", "\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0430" },
            { "GQ", "\u0413\u0432\u0438\u043d\u0435\u044f\u0438 \u042d\u043a\u0432\u0430\u0442\u043e\u0440\u04e3" },
            { "GR", "\u042e\u043d\u043e\u043d" },
            { "GS", "\u04b6\u043e\u0440\u04b7\u0438\u044f\u0438 \u04b6\u0430\u043d\u0443\u0431\u04e3 \u0432\u0430 \u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u0421\u0430\u043d\u0434\u0432\u0438\u0447" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u044f-\u0411\u0438\u0441\u0430\u0443" },
            { "GY", "\u0413\u0430\u0439\u0430\u043d\u0430" },
            { "HK", "\u04b2\u043e\u043d\u043a\u043e\u043d\u0433 (\u041c\u041c\u041c)" },
            { "HM", "\u04b6\u0430\u0437\u0438\u0440\u0430\u0438 \u04b2\u0435\u0440\u0434 \u0432\u0430 \u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u0434" },
            { "HN", "\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u043e\u0440\u0432\u0430\u0442\u0438\u044f" },
            { "HT", "\u0413\u0430\u0438\u0442\u0438" },
            { "HU", "\u041c\u0430\u04b7\u043e\u0440\u0438\u0441\u0442\u043e\u043d" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f" },
            { "IE", "\u0418\u0440\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "IL", "\u0418\u0441\u0440\u043e\u0438\u043b" },
            { "IM", "\u04b6\u0430\u0437\u0438\u0440\u0430\u0438 \u041c\u044d\u043d" },
            { "IN", "\u04b2\u0438\u043d\u0434\u0443\u0441\u0442\u043e\u043d" },
            { "IO", "\u049a\u0430\u043b\u0430\u043c\u0440\u0430\u0432\u0438 \u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f \u0434\u0430\u0440 \u0443\u049b\u0451\u043d\u0443\u0441\u0438 \u04b2\u0438\u043d\u0434" },
            { "IQ", "\u0418\u0440\u043e\u049b" },
            { "IR", "\u042d\u0440\u043e\u043d" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438\u044f" },
            { "JE", "\u04b6\u0435\u0440\u0441\u0438" },
            { "JM", "\u042f\u043c\u0430\u0439\u043a\u0430" },
            { "JO", "\u0423\u0440\u0434\u0443\u043d" },
            { "JP", "\u042f\u043f\u043e\u043d\u0438\u044f" },
            { "KE", "\u041a\u0435\u043d\u0438\u044f" },
            { "KG", "\u049a\u0438\u0440\u0493\u0438\u0437\u0438\u0441\u0442\u043e\u043d" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u04b7\u0430" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440" },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u0432\u0430 \u041d\u0435\u0432\u0438\u0441" },
            { "KP", "\u041a\u043e\u0440\u0435\u044f\u0438 \u0428\u0438\u043c\u043e\u043b\u04e3" },
            { "KW", "\u049a\u0443\u0432\u0430\u0439\u0442" },
            { "KY", "\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u041a\u0430\u0439\u043c\u0430\u043d" },
            { "KZ", "\u049a\u0430\u0437\u043e\u049b\u0438\u0441\u0442\u043e\u043d" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0443\u0431\u043d\u043e\u043d" },
            { "LC", "\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0438\u044f" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d" },
            { "LK", "\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430" },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438\u044f" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438\u044f" },
            { "LY", "\u041b\u0438\u0431\u0438\u044f" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u0430\u0448" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u043e\u0432\u0430" },
            { "ME", "\u0427\u0435\u0440\u043d\u043e\u0433\u043e\u0440\u0438\u044f" },
            { "MF", "\u04b6\u0430\u0437\u0438\u0440\u0430\u0438 \u0421\u0435\u043d\u0442-\u041c\u0430\u0440\u0442\u0438\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "MH", "\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u041c\u0430\u0440\u0448\u0430\u043b\u043b" },
            { "MK", "\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u044f\u0438 \u0428\u0438\u043c\u043e\u043b\u04e3" },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "MM", "\u041c\u044f\u043d\u043c\u0430" },
            { "MN", "\u041c\u0443\u0493\u0443\u043b\u0438\u0441\u0442\u043e\u043d" },
            { "MO", "\u041c\u0430\u043a\u0430\u043e (\u041c\u041c\u041c)" },
            { "MP", "\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u041c\u0430\u0440\u0438\u0430\u043d\u0430\u0438 \u0428\u0438\u043c\u043e\u043b\u04e3" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a\u0430" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u044f" },
            { "MS", "\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442" },
            { "MT", "\u041c\u0430\u043b\u0442\u0430" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439" },
            { "MV", "\u041c\u0430\u043b\u0434\u0438\u0432" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437\u0438\u044f" },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438\u044f" },
            { "NC", "\u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f\u0438 \u041d\u0430\u0432" },
            { "NE", "\u041d\u0438\u0433\u0435\u0440" },
            { "NF", "\u04b6\u0430\u0437\u0438\u0440\u0430\u0438 \u041d\u043e\u0440\u0444\u043e\u043b\u043a" },
            { "NG", "\u041d\u0438\u0433\u0435\u0440\u0438\u044f" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "NL", "\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0433\u0438\u044f" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0438\u0443\u044d" },
            { "NZ", "\u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f\u0438 \u041d\u0430\u0432" },
            { "OM", "\u0423\u043c\u043e\u043d" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f\u0438 \u0424\u0430\u0440\u043e\u043d\u0441\u0430" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 \u0413\u0432\u0438\u043d\u0435\u044f\u0438 \u041d\u0430\u0432" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d" },
            { "PK", "\u041f\u043e\u043a\u0438\u0441\u0442\u043e\u043d" },
            { "PL", "\u041b\u0430\u04b3\u0438\u0441\u0442\u043e\u043d" },
            { "PM", "\u0421\u0435\u043d\u0442-\u041f\u0435\u0440 \u0432\u0430 \u041c\u0438\u043a\u0435\u043b\u043e\u043d" },
            { "PN", "\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u041f\u0438\u0442\u043a\u0435\u0439\u0440\u043d" },
            { "PR", "\u041f\u0443\u044d\u0440\u0442\u043e-\u0420\u0438\u043a\u043e" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u044f" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "QA", "\u049a\u0430\u0442\u0430\u0440" },
            { "RE", "\u0420\u0435\u044e\u043d\u0438\u043e\u043d" },
            { "RO", "\u0420\u0443\u043c\u0438\u043d\u0438\u044f" },
            { "RS", "\u0421\u0435\u0440\u0431\u0438\u044f" },
            { "RU", "\u0420\u0443\u0441\u0438\u044f" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "SA", "\u0410\u0440\u0430\u0431\u0438\u0441\u0442\u043e\u043d\u0438 \u0421\u0430\u0443\u0434\u04e3" },
            { "SB", "\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u0421\u043e\u043b\u043e\u043c\u043e\u043d" },
            { "SC", "\u0421\u0435\u0439\u0448\u0435\u043b" },
            { "SD", "\u0421\u0443\u0434\u043e\u043d" },
            { "SE", "\u0428\u0432\u0435\u0442\u0441\u0438\u044f" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SH", "\u0421\u0435\u043d\u0442 \u0415\u043b\u0435\u043d\u0430" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u044f" },
            { "SJ", "\u0428\u043f\u0438\u0442\u0441\u0431\u0435\u0440\u0433\u0435\u043d \u0432\u0430 \u042f\u043d \u041c\u0430\u0439\u0435\u043d" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u043a\u0438\u044f" },
            { "SL", "\u0421\u0438\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u04e3" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "SS", "\u0421\u0443\u0434\u043e\u043d\u0438 \u04b6\u0430\u043d\u0443\u0431\u04e3" },
            { "ST", "\u0421\u0430\u043d \u0422\u043e\u043c\u0435 \u0432\u0430 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438" },
            { "SV", "\u042d\u043b-\u0421\u0430\u043b\u0432\u0430\u0434\u043e\u0440" },
            { "SX", "\u0421\u0438\u043d\u0442-\u041c\u0430\u0430\u0440\u0442\u0435\u043d" },
            { "SY", "\u0421\u0443\u0440\u0438\u044f" },
            { "SZ", "\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434" },
            { "TA", "\u0422\u0440\u0438\u0441\u0442\u0430\u043d-\u0434\u0430-\u041a\u0443\u043d\u044f" },
            { "TC", "\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u0422\u0435\u0440\u043a\u0441 \u0432\u0430 \u041a\u0430\u0439\u043a\u043e\u0441" },
            { "TD", "\u0427\u0430\u0434" },
            { "TF", "\u041c\u0438\u043d\u0442\u0430\u049b\u0430\u04b3\u043e\u0438 \u04b6\u0430\u043d\u0443\u0431\u0438\u0438 \u0424\u0430\u0440\u043e\u043d\u0441\u0430" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "TH", "\u0422\u0430\u0438\u043b\u0430\u043d\u0434" },
            { "TJ", "\u0422\u043e\u04b7\u0438\u043a\u0438\u0441\u0442\u043e\u043d" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "TL", "\u0422\u0438\u043c\u043e\u0440-\u041b\u0435\u0441\u0442\u0435" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0430\u043d\u0438\u0441\u0442\u043e\u043d" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "TR", "\u0422\u0443\u0440\u043a\u0438\u044f" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0432\u0430 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u044f" },
            { "UA", "\u0423\u043a\u0440\u0430\u0438\u043d\u0430" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "UM", "\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u0425\u0443\u0440\u0434\u0438 \u0414\u0443\u0440\u0434\u0430\u0441\u0442\u0438 \u0418\u041c\u0410" },
            { "US", "\u0418\u0451\u043b\u043e\u0442\u0438 \u041c\u0443\u0442\u0442\u0430\u04b3\u0438\u0434\u0430" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "UZ", "\u04ee\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u043e\u043d" },
            { "VA", "\u0428\u0430\u04b3\u0440\u0438 \u0412\u043e\u0442\u0438\u043a\u043e\u043d" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0432\u0430 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d\u0430" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430" },
            { "VG", "\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u0412\u0438\u0440\u0433\u0438\u043d\u0438 \u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f" },
            { "VI", "\u04b6\u0430\u0437\u0438\u0440\u0430\u04b3\u043e\u0438 \u0412\u0438\u0440\u0433\u0438\u043d\u0438 \u0418\u041c\u0410" },
            { "VN", "\u0412\u0435\u0442\u043d\u0430\u043c" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "WF", "\u0423\u043e\u043b\u043b\u0438\u0441 \u0432\u0430 \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "YE", "\u042f\u043c\u0430\u043d" },
            { "YT", "\u041c\u0430\u0439\u043e\u0442\u0442\u0430" },
            { "ZA", "\u0410\u0444\u0440\u0438\u043a\u0430\u0438 \u04b6\u0430\u043d\u0443\u0431\u04e3" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438\u044f" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "ZZ", "\u041c\u0438\u043d\u0442\u0430\u049b\u0430\u0438 \u043d\u043e\u043c\u0430\u044a\u043b\u0443\u043c" },
            { "af", "\u0430\u0444\u0440\u0438\u043a\u0430\u0430\u043d\u0441" },
            { "am", "\u0430\u043c\u04b3\u0430\u0440\u04e3" },
            { "ar", "\u0430\u0440\u0430\u0431\u04e3" },
            { "as", "\u0430\u0441\u0441\u043e\u043c\u04e3" },
            { "az", "\u043e\u0437\u0430\u0440\u0431\u043e\u0439\u04b7\u043e\u043d\u04e3" },
            { "ba", "\u0431\u043e\u0448\u049b\u0438\u0440\u0434\u04e3" },
            { "be", "\u0431\u0435\u043b\u043e\u0440\u0443\u0441\u04e3" },
            { "bg", "\u0431\u0443\u043b\u0493\u043e\u0440\u04e3" },
            { "bn", "\u0431\u0438\u043d\u0493\u043e\u043b\u04e3" },
            { "bo", "\u0442\u0438\u0431\u0435\u0442\u04e3" },
            { "br", "\u0431\u0440\u0435\u0442\u043e\u043d\u04e3" },
            { "bs", "\u0431\u043e\u0441\u043d\u0438\u044f\u0433\u04e3" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u043e\u043d\u04e3" },
            { "co", "\u043a\u043e\u0440\u0441\u0438\u043a\u0430\u043d\u04e3" },
            { "cs", "\u0447\u0435\u0445\u04e3" },
            { "cy", "\u0432\u0430\u043b\u043b\u04e3" },
            { "da", "\u0434\u0430\u043d\u0438\u044f\u0433\u04e3" },
            { "de", "\u043d\u0435\u043c\u0438\u0441\u04e3" },
            { "dv", "\u0434\u0438\u0432\u0435\u04b3\u04e3" },
            { "dz", "\u0434\u0437\u043e\u043d\u0433\u0445\u0430" },
            { "el", "\u044e\u043d\u043e\u043d\u04e3" },
            { "en", "\u0430\u043d\u0433\u043b\u0438\u0441\u04e3" },
            { "eo", "\u044d\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "es", "\u0438\u0441\u043f\u0430\u043d\u04e3" },
            { "et", "\u044d\u0441\u0442\u043e\u043d\u04e3" },
            { "eu", "\u0431\u0430\u0441\u043a\u04e3" },
            { "fa", "\u0444\u043e\u0440\u0441\u04e3" },
            { "ff", "\u0444\u0443\u043b\u0430\u04b3" },
            { "fi", "\u0444\u0438\u043d\u04e3" },
            { "fo", "\u0444\u0430\u0440\u0435\u0440\u04e3" },
            { "fr", "\u0444\u0440\u0430\u043d\u0441\u0443\u0437\u04e3" },
            { "fy", "\u0444\u0440\u0438\u0437\u0438\u0438 \u0493\u0430\u0440\u0431\u04e3" },
            { "ga", "\u0438\u0440\u043b\u0430\u043d\u0434\u04e3" },
            { "gd", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434\u0438\u0438 \u0433\u044d\u043b\u04e3" },
            { "gl", "\u0433\u0430\u043b\u0438\u0441\u0438\u044f\u0433\u04e3" },
            { "gn", "\u0433\u0443\u0430\u0440\u0430\u043d\u04e3" },
            { "gu", "\u0433\u0443\u04b7\u0430\u0440\u043e\u0442\u04e3" },
            { "ha", "\u04b3\u0430\u0443\u0441\u0430" },
            { "he", "\u0438\u0431\u0440\u043e\u043d\u04e3" },
            { "hi", "\u04b3\u0438\u043d\u0434\u04e3" },
            { "hr", "\u0445\u043e\u0440\u0432\u0430\u0442\u04e3" },
            { "ht", "\u0433\u0430\u0438\u0442\u0438\u0438 \u043a\u0440\u0435\u043e\u043b\u04e3" },
            { "hu", "\u043c\u0430\u04b7\u043e\u0440\u04e3" },
            { "hy", "\u0430\u0440\u043c\u0430\u043d\u04e3" },
            { "hz", "\u04b3\u0435\u0440\u0435\u0440\u043e" },
            { "id", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u04e3" },
            { "ig", "\u0438\u0433\u0431\u043e" },
            { "is", "\u0438\u0441\u043b\u0430\u043d\u0434\u04e3" },
            { "it", "\u0438\u0442\u0430\u043b\u0438\u044f\u0432\u04e3" },
            { "iu", "\u0438\u043d\u0443\u043a\u0442\u0438\u0442\u0443\u0442\u04e3" },
            { "ja", "\u044f\u043f\u043e\u043d\u04e3" },
            { "ka", "\u0433\u0443\u0440\u04b7\u04e3" },
            { "kk", "\u049b\u0430\u0437\u043e\u049b\u04e3" },
            { "km", "\u043a\u0445\u043c\u0435\u0440\u04e3" },
            { "kn", "\u043a\u0430\u043d\u043d\u0430\u0434\u0430" },
            { "ko", "\u043a\u043e\u0440\u0435\u044f\u0433\u04e3" },
            { "kr", "\u043a\u0430\u043d\u0443\u0440\u04e3" },
            { "ks", "\u043a\u0430\u0448\u043c\u0438\u0440\u04e3" },
            { "ku", "\u043a\u0443\u0440\u0434\u04e3" },
            { "ky", "\u049b\u0438\u0440\u0493\u0438\u0437\u04e3" },
            { "la", "\u043b\u043e\u0442\u0438\u043d\u04e3" },
            { "lb", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433\u04e3" },
            { "lo", "\u043b\u0430\u043e\u0441\u04e3" },
            { "lt", "\u043b\u0438\u0442\u0432\u043e\u043d\u04e3" },
            { "lv", "\u043b\u0430\u0442\u0438\u0448\u04e3" },
            { "mg", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u04e3" },
            { "mi", "\u043c\u0430\u043e\u0440\u04e3" },
            { "mk", "\u043c\u0430\u049b\u0434\u0443\u043d\u04e3" },
            { "ml", "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c\u04e3" },
            { "mn", "\u043c\u0443\u0493\u0443\u043b\u04e3" },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u04b3\u04e3" },
            { "ms", "\u043c\u0430\u043b\u0430\u0439\u04e3" },
            { "mt", "\u043c\u0430\u043b\u0442\u04e3" },
            { "my", "\u0431\u0438\u0440\u043c\u0430\u043d\u04e3" },
            { "ne", "\u043d\u0435\u043f\u0430\u043b\u04e3" },
            { "nl", "\u0433\u043e\u043b\u043b\u0430\u043d\u0434\u04e3" },
            { "no", "\u043d\u043e\u0440\u0432\u0435\u0433\u04e3" },
            { "ny", "\u043d\u044f\u043d\u04b7\u0430" },
            { "oc", "\u043e\u043a\u0441\u0438\u0442\u0430\u043d\u04e3" },
            { "om", "\u043e\u0440\u043e\u043c\u043e" },
            { "or", "\u043e\u0434\u0438\u044f" },
            { "pa", "\u043f\u0430\u043d\u04b7\u043e\u0431\u04e3" },
            { "pl", "\u043b\u0430\u04b3\u0438\u0441\u0442\u043e\u043d\u04e3" },
            { "ps", "\u043f\u0443\u0448\u0442\u0443" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u04e3" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430" },
            { "rm", "\u0440\u0435\u0442\u043e\u0440\u043e\u043c\u0430\u043d\u04e3" },
            { "ro", "\u0440\u0443\u043c\u0438\u043d\u04e3" },
            { "ru", "\u0440\u0443\u0441\u04e3" },
            { "rw", "\u043a\u0438\u043d\u044f\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u0438\u0442" },
            { "sd", "\u0441\u0438\u043d\u0434\u04e3" },
            { "se", "\u0441\u0430\u043c\u0438\u0438 \u0448\u0438\u043c\u043e\u043b\u04e3" },
            { "si", "\u0441\u0438\u043d\u0433\u0430\u043b\u04e3" },
            { "sk", "\u0441\u043b\u043e\u0432\u0430\u043a\u04e3" },
            { "sl", "\u0441\u043b\u043e\u0432\u0435\u043d\u04e3" },
            { "so", "\u0441\u043e\u043c\u0430\u043b\u04e3" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d\u04e3" },
            { "sr", "\u0441\u0435\u0440\u0431\u04e3" },
            { "sv", "\u0448\u0432\u0435\u0434\u04e3" },
            { "ta", "\u0442\u0430\u043c\u0438\u043b\u04e3" },
            { "te", "\u0442\u0435\u043b\u0443\u0433\u0443" },
            { "tg", "\u0442\u043e\u04b7\u0438\u043a\u04e3" },
            { "th", "\u0442\u0430\u0439\u04e3" },
            { "ti", "\u0442\u0438\u0433\u0440\u0438\u043d\u044f" },
            { "tk", "\u0442\u0443\u0440\u043a\u043c\u0430\u043d\u04e3" },
            { "to", "\u0442\u043e\u043d\u0433\u0430\u043d\u04e3" },
            { "tr", "\u0442\u0443\u0440\u043a\u04e3" },
            { "tt", "\u0442\u043e\u0442\u043e\u0440\u04e3" },
            { "ug", "\u04ef\u0439\u0493\u0443\u0440\u04e3" },
            { "uk", "\u0443\u043a\u0440\u0430\u0438\u043d\u04e3" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "uz", "\u04ef\u0437\u0431\u0435\u043a\u04e3" },
            { "ve", "\u0432\u0435\u043d\u0434\u0430" },
            { "vi", "\u0432\u0435\u0442\u043d\u0430\u043c\u04e3" },
            { "wo", "\u0432\u043e\u043b\u043e\u0444" },
            { "yi", "\u0438\u0434\u0438\u0448" },
            { "yo", "\u0439\u043e\u0440\u0443\u0431\u0430" },
            { "zh", "\u0445\u0438\u0442\u043e\u04e3" },
            { "ban", "\u0431\u0430\u043b\u0438\u043d\u04e3" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "ceb", "\u0441\u0435\u0431\u0443\u0430\u043d\u043e" },
            { "chm", "\u043c\u0430\u0440\u04e3" },
            { "chr", "\u0447\u0435\u0440\u043e\u043a\u04e3" },
            { "ckb", "\u043a\u0443\u0440\u0434\u0438\u0438 \u043c\u0430\u0440\u043a\u0430\u0437\u04e3" },
            { "dsb", "\u0441\u0435\u0440\u0431\u0438\u0438 \u043f\u043e\u0451\u043d\u04e3" },
            { "fil", "\u0444\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u04e3" },
            { "haw", "\u04b3\u0430\u0432\u0430\u0439\u04e3" },
            { "hil", "\u04b3\u0438\u043b\u0438\u0433\u0430\u0439\u043d\u043e\u043d" },
            { "hsb", "\u0441\u0435\u0440\u0431\u0438\u0438 \u0431\u043e\u043b\u043e\u04e3" },
            { "ibb", "\u0438\u0431\u0438\u0431\u0438\u043e" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u04e3" },
            { "kru", "\u043a\u0443\u0440\u0443\u043a\u0441" },
            { "men", "\u043c\u0435\u043d\u0434\u0435" },
            { "mni", "\u043c\u0430\u043d\u0438\u043f\u0443\u0440\u04e3" },
            { "moh", "\u043c\u043e\u04b3\u043e\u043a" },
            { "niu", "\u043d\u0438\u0443\u044d\u04e3" },
            { "pap", "\u043f\u0430\u043f\u0438\u0430\u043c\u0435\u043d\u0442\u043e" },
            { "quc", "\u043a\u0438\u0447\u0435" },
            { "sah", "\u0441\u0430\u0445\u0430" },
            { "sat", "\u0441\u0430\u043d\u0442\u0430\u043b\u04e3" },
            { "sma", "\u0441\u0430\u043c\u0438\u0438 \u04b7\u0430\u043d\u0443\u0431\u04e3" },
            { "smj", "\u043b\u0443\u043b\u0435 \u0441\u0430\u043c\u04e3" },
            { "smn", "\u0438\u043d\u0430\u0440\u0438 \u0441\u0430\u043c\u04e3" },
            { "sms", "\u0441\u043a\u043e\u043b\u0442\u0438 \u0441\u0430\u043c\u04e3" },
            { "syr", "\u0441\u0443\u0440\u0438\u0451\u043d\u04e3" },
            { "tzm", "\u0442\u0430\u043c\u0430\u0437\u0430\u0439\u0442\u0438 \u0410\u0442\u043b\u0430\u0441\u0438 \u041c\u0430\u0440\u043a\u0430\u0437\u04e3" },
            { "und", "\u0437\u0430\u0431\u043e\u043d\u0438 \u043d\u043e\u043c\u0430\u044a\u043b\u0443\u043c" },
            { "Arab", "\u0410\u0440\u0430\u0431\u04e3" },
            { "Cyrl", "\u041a\u0438\u0440\u0438\u043b\u043b\u04e3" },
            { "Hans", "\u041e\u0441\u043e\u043d\u0444\u0430\u04b3\u043c" },
            { "Hant", "\u0410\u043d\u044a\u0430\u043d\u0430\u0432\u04e3" },
            { "Latn", "\u041b\u043e\u0442\u0438\u043d\u04e3" },
            { "Zxxx", "\u041d\u043e\u043d\u0430\u0432\u0438\u0448\u0442\u0430" },
            { "Zzzz", "\u0421\u043a\u0440\u0438\u043f\u0442\u0438 \u043d\u043e\u043c\u0430\u044a\u043b\u0443\u043c" },
            { "de_AT", "\u043d\u0435\u043c\u0438\u0441\u0438\u0438 \u0430\u0432\u0441\u0442\u0440\u0438\u044f\u0433\u04e3" },
            { "de_CH", "\u043d\u0435\u043c\u0438\u0441\u0438\u0438 \u0448\u0432\u0435\u0439\u0441\u0430\u0440\u0438\u0438 \u0431\u043e\u043b\u043e\u04e3" },
            { "en_AU", "\u0430\u043d\u0433\u043b\u0438\u0441\u0438\u0438 \u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f\u0433\u04e3" },
            { "en_CA", "\u0430\u043d\u0433\u043b\u0438\u0441\u0438\u0438 \u043a\u0430\u043d\u0430\u0434\u0430\u0433\u04e3" },
            { "en_GB", "\u0430\u043d\u0433\u043b\u0438\u0441\u0438\u0438 \u0431\u0440\u0438\u0442\u0430\u043d\u04e3" },
            { "en_US", "\u0430\u043d\u0433\u043b\u0438\u0441\u0438\u0438 \u0430\u043c\u0435\u0440\u0438\u043a\u043e\u04e3" },
            { "es_ES", "\u0438\u0441\u043f\u0430\u043d\u0438\u0438 \u0430\u0432\u0440\u0443\u043f\u043e\u04e3" },
            { "es_MX", "\u0438\u0441\u043f\u0430\u043d\u0438\u0438 \u043c\u0435\u043a\u0441\u0438\u043a\u043e\u04e3" },
            { "fr_CA", "\u0444\u0440\u0430\u043d\u0441\u0443\u0437\u0438\u0438 \u043a\u0430\u043d\u0430\u0434\u0430\u0433\u04e3" },
            { "fr_CH", "\u0444\u0440\u0430\u043d\u0441\u0443\u0437\u0438\u0438 \u0448\u0432\u0435\u0439\u0441\u0430\u0440\u04e3" },
            { "pt_BR", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u0438 \u0431\u0440\u0430\u0437\u0438\u043b\u0438\u044f\u0433\u04e3" },
            { "pt_PT", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u0438 \u0430\u0432\u0440\u0443\u043f\u043e\u04e3" },
            { "es_419", "\u0438\u0441\u043f\u0430\u043d\u0438\u0438 \u0430\u043c\u0435\u0440\u0438\u043a\u043e\u0438\u0438 \u043b\u043e\u0442\u0438\u043d\u04e3" },
            { "zh_Hans", "\u0445\u0438\u0442\u043e\u0438\u0438 \u043e\u0441\u043e\u043d\u0444\u0430\u04b3\u043c" },
            { "zh_Hant", "\u0445\u0438\u0442\u043e\u0438\u0438 \u0430\u043d\u044a\u0430\u043d\u0430\u0432\u04e3" },
            { "type.nu.arab", "\u0420\u0430\u049b\u0430\u043c\u04b3\u043e\u0438 \u04b3\u0438\u043d\u0434\u0443-\u0430\u0440\u0430\u0431\u04e3" },
            { "type.nu.latn", "\u0420\u0430\u049b\u0430\u043c\u04b3\u043e\u0438 \u0493\u0430\u0440\u0431\u04e3" },
            { "type.co.standard", "\u0422\u0430\u0440\u0442\u0438\u0431\u0438 \u043c\u0443\u0440\u0430\u0442\u0442\u0430\u0431\u0441\u043e\u0437\u0438\u0438 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u04e3" },
            { "type.ca.gregorian", "\u0422\u0430\u049b\u0432\u0438\u043c\u0438 \u0433\u0440\u0435\u0433\u043e\u0440\u0438\u0430\u043d\u04e3" },
        };
        return data;
    }
}
