/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.web.common.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.web.common.FirWebCommonErrors;
import org.jetbrains.kotlin.fir.analysis.web.common.checkers.FirAbstractWebCheckerUtils;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J-\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0011H\u0002R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0012J-\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0014H\u0002R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/expression/FirAbstractNativeRttiChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "webCheckerUtils", "Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/FirAbstractWebCheckerUtils;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/FirAbstractWebCheckerUtils;)V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "checkGetClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;)V", "checkTypeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;)V", "checkers.web.common"})
@SourceDebugExtension(value={"SMAP\nFirAbstractNativeRttiChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAbstractNativeRttiChecker.kt\norg/jetbrains/kotlin/fir/analysis/web/common/checkers/expression/FirAbstractNativeRttiChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,71:1\n57#2:72\n59#2:73\n*S KotlinDebug\n*F\n+ 1 FirAbstractNativeRttiChecker.kt\norg/jetbrains/kotlin/fir/analysis/web/common/checkers/expression/FirAbstractNativeRttiChecker\n*L\n37#1:72\n59#1:73\n*E\n"})
public abstract class FirAbstractNativeRttiChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    private final FirAbstractWebCheckerUtils webCheckerUtils;

    public FirAbstractNativeRttiChecker(@NotNull FirAbstractWebCheckerUtils webCheckerUtils) {
        Intrinsics.checkNotNullParameter((Object)webCheckerUtils, (String)"webCheckerUtils");
        super(MppCheckerKind.Common);
        this.webCheckerUtils = webCheckerUtils;
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirStatement expression) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        FirStatement firStatement = expression;
        if (firStatement instanceof FirGetClassCall) {
            this.checkGetClassCall(context2, reporter, (FirGetClassCall)expression);
        } else if (firStatement instanceof FirTypeOperatorCall) {
            this.checkTypeOperatorCall(context2, reporter, (FirTypeOperatorCall)expression);
        }
    }

    private final void checkGetClassCall(CheckerContext context2, DiagnosticReporter reporter, FirGetClassCall expression) {
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, FirTypeUtilsKt.getResolvedType(expression.getArgument()));
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol declarationToCheck = firRegularClassSymbol;
        FirCall $this$arguments$iv = expression;
        boolean $i$f$getArguments = false;
        if (!(CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments()) instanceof FirResolvedQualifier)) {
            return;
        }
        if (this.webCheckerUtils.isNativeOrExternalInterface(declarationToCheck, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), (KtDiagnosticFactory0)FirWebCommonErrors.INSTANCE.getEXTERNAL_INTERFACE_AS_CLASS_LITERAL(), null, (int)8, null);
        }
    }

    private final void checkTypeOperatorCall(CheckerContext context2, DiagnosticReporter reporter, FirTypeOperatorCall expression) {
        FirTypeRef targetTypeRef = expression.getConversionTypeRef();
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(targetTypeRef, context2.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol declarationToCheck = firRegularClassSymbol;
        if (!this.webCheckerUtils.isNativeOrExternalInterface(declarationToCheck, context2.getSession())) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[expression.getOperation().ordinal()]) {
            case 1: 
            case 2: {
                FirCall $this$argument$iv = expression;
                boolean $i$f$getArgument = false;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), FirWebCommonErrors.INSTANCE.getUNCHECKED_CAST_TO_EXTERNAL_INTERFACE(), (Object)FirTypeUtilsKt.getResolvedType((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments())), (Object)FirTypeUtilsKt.getConeType(targetTypeRef), null, (int)32, null);
                break;
            }
            case 3: 
            case 4: {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), FirWebCommonErrors.INSTANCE.getCANNOT_CHECK_FOR_EXTERNAL_INTERFACE(), (Object)FirTypeUtilsKt.getConeType(targetTypeRef), null, (int)16, null);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.AS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.SAFE_AS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.IS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_IS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

