/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.MathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.CompressedAppendableFile;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.io.FileChannelWithSizeTracking;
import com.intellij.util.io.IOCancellationCallbackHolder;
import com.intellij.util.io.PersistentMapImpl;
import com.intellij.util.io.ResilientFileChannel;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class PersistentHashMapValueStorage {
    @Nullable
    private RAReader myCompactionModeReader;
    private volatile long mySize;
    private final Path myPath;
    private final CompressedAppendableFile myCompressedAppendableFile;
    private final CreationTimeOptions myOptions;
    private boolean myCompactionMode;
    private static final int CACHE_PROTECTED_QUEUE_SIZE = 10;
    private static final int CACHE_PROBATIONAL_QUEUE_SIZE = 20;
    private static final long MAX_RETAINED_LIMIT_WHEN_COMPACTING = 0x6400000L;
    public static final long SOFT_MAX_RETAINED_LIMIT = 0xA00000L;
    public static final int BLOCK_SIZE_TO_WRITE_WHEN_SOFT_MAX_RETAINED_LIMIT_IS_HIT = 1024;
    private static final FileAccessorCache<Path, FileChannelWithSizeTracking> ourFileChannelCache = new FileAccessorCache<Path, FileChannelWithSizeTracking>(20, 40){

        @Override
        @NotNull
        protected FileChannelWithSizeTracking createAccessor(Path path) throws IOException {
            return new FileChannelWithSizeTracking(path);
        }

        @Override
        protected void disposeAccessor(@NotNull FileChannelWithSizeTracking fileAccessor) throws IOException {
            if (fileAccessor == null) {
                1.$$$reportNull$$$0(0);
            }
            fileAccessor.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAccessor", "com/intellij/util/io/PersistentHashMapValueStorage$1", "disposeAccessor"));
        }
    };
    private static final FileAccessorCache<Path, SyncAbleBufferedOutputStreamOverCachedFileChannel> ourAppendersCache = new FileAccessorCache<Path, SyncAbleBufferedOutputStreamOverCachedFileChannel>(10, 20){

        @Override
        @NotNull
        protected SyncAbleBufferedOutputStreamOverCachedFileChannel createAccessor(Path path) {
            return new SyncAbleBufferedOutputStreamOverCachedFileChannel(path);
        }

        @Override
        protected void disposeAccessor(@NotNull SyncAbleBufferedOutputStreamOverCachedFileChannel stream) throws IOException {
            if (stream == null) {
                2.$$$reportNull$$$0(0);
            }
            stream.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/util/io/PersistentHashMapValueStorage$2", "disposeAccessor"));
        }
    };
    private static final FileAccessorCache<Path, RAReader> ourReadersCache = new FileAccessorCache<Path, RAReader>(10, 20){

        @Override
        @NotNull
        protected RAReader createAccessor(Path path) {
            return new ReaderOverFileChannelCache(path);
        }

        @Override
        protected void disposeAccessor(@NotNull RAReader fileAccessor) throws IOException {
            if (fileAccessor == null) {
                3.$$$reportNull$$$0(0);
            }
            fileAccessor.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAccessor", "com/intellij/util/io/PersistentHashMapValueStorage$3", "disposeAccessor"));
        }
    };
    public static final boolean COMPRESSION_ENABLED = SystemProperties.getBooleanProperty("idea.compression.enabled", true);
    private static final ThreadLocalCachedByteArray myBuffer = new ThreadLocalCachedByteArray();
    private static final int ourBufferLength = 1024;
    private long myChunksRemovalTime;
    private long myChunksReadingTime;
    private int myChunks;
    private long myChunksOriginalBytes;
    private long myChunksBytesAfterRemoval;
    private int myLastReportedChunksCount;
    private static final boolean ourDumpChunkRemovalTime = SystemProperties.getBooleanProperty("idea.phmp.dump.chunk.removal.time", false);

    @NotNull
    CreationTimeOptions getOptions() {
        CreationTimeOptions creationTimeOptions = this.myOptions;
        if (creationTimeOptions == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(0);
        }
        return creationTimeOptions;
    }

    PersistentHashMapValueStorage(@NotNull Path path, @NotNull CreationTimeOptions options) throws IOException {
        if (path == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(1);
        }
        if (options == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(2);
        }
        this.myPath = path;
        this.myOptions = options;
        if (this.myOptions.useCompression()) {
            this.myCompressedAppendableFile = new MyCompressedAppendableFile();
            this.mySize = this.myCompressedAppendableFile.length();
        } else {
            this.myCompressedAppendableFile = null;
            this.mySize = Files.exists(this.myPath, new LinkOption[0]) ? Files.size(this.myPath) : 0L;
        }
    }

    public long appendBytes(ByteArraySequence data, long prevChunkAddress) throws IOException {
        return this.appendBytes(data.getInternalBuffer(), data.getOffset(), data.getLength(), prevChunkAddress);
    }

    public long appendBytes(byte[] data, int offset, int dataLength, long prevChunkAddress) throws IOException {
        if (this.mySize == 0L) {
            long currentLength;
            byte[] bytes = "Header Record For PersistentHashMapValueStorage".getBytes(StandardCharsets.UTF_8);
            this.doAppendBytes(bytes, 0, bytes.length, 0L);
            FileAccessorCache.Handle<SyncAbleBufferedOutputStreamOverCachedFileChannel> streamCacheValue = ourAppendersCache.getIfCached(this.myPath);
            if (streamCacheValue != null) {
                try {
                    SyncAbleBufferedOutputStreamOverCachedFileChannel stream = streamCacheValue.get();
                    stream.flush();
                    stream.sync();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    streamCacheValue.release();
                }
            }
            long l = currentLength = Files.exists(this.myPath, new LinkOption[0]) ? Files.size(this.myPath) : 0L;
            if (currentLength > this.mySize) {
                Logger.getInstance(this.getClass().getName()).info("Avoided PSHM corruption due to write failure:" + this.myPath);
                this.mySize = currentLength;
            }
        }
        return this.doAppendBytes(data, offset, dataLength, prevChunkAddress);
    }

    void checkAppendsAllowed(int previouslyAccumulatedChunkSize) {
        if (previouslyAccumulatedChunkSize != 0 && this.myOptions.myHasNoChunks) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doAppendBytes(byte[] data, int offset, int dataLength, long prevChunkAddress) throws IOException {
        DataOutputStream dataOutputStream;
        if (!this.allowedToCompactChunks()) {
            throw new AssertionError();
        }
        if (prevChunkAddress != 0L && this.myOptions.myHasNoChunks) {
            throw new AssertionError();
        }
        long currentChunkAddress = this.mySize;
        if (this.myCompressedAppendableFile != null) {
            dataOutputStream = new DataOutputStream(new OutputStream(){

                @Override
                public void write(byte @NotNull [] b, int off, int len) throws IOException {
                    if (b == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    PersistentHashMapValueStorage.this.myCompressedAppendableFile.append(b, off, len);
                }

                @Override
                public void write(int b) throws IOException {
                    byte[] r = new byte[]{(byte)(b & 0xFF)};
                    this.write(r);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/util/io/PersistentHashMapValueStorage$4", "write"));
                }
            });
        } else {
            @NotNull FileAccessorCache.Handle<SyncAbleBufferedOutputStreamOverCachedFileChannel> appender = ourAppendersCache.get(this.myPath);
            dataOutputStream = PersistentHashMapValueStorage.toDataOutputStream(appender);
        }
        try {
            this.saveHeader(dataLength, prevChunkAddress, currentChunkAddress, dataOutputStream);
            dataOutputStream.write(data, offset, dataLength);
            this.mySize += (long)dataOutputStream.resetWrittenBytesCount();
        }
        finally {
            dataOutputStream.close();
        }
        return currentChunkAddress;
    }

    /*
     * WARNING - void declaration
     */
    private void saveHeader(int dataLength, long prevChunkAddress, long chunkAddress, @NotNull DataOutputStream dataOutputStream) throws IOException {
        void dataOutputStream2;
        if (dataOutputStream == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(3);
        }
        DataInputOutputUtil.writeINT((DataOutput)dataOutputStream2, dataLength);
        if (!this.myOptions.myHasNoChunks) {
            if (chunkAddress < prevChunkAddress) {
                throw new IOException("writePrevChunkAddress:" + chunkAddress + "," + prevChunkAddress + "," + this.myPath);
            }
            long diff = chunkAddress - prevChunkAddress;
            DataInputOutputUtil.writeLONG((DataOutput)dataOutputStream2, prevChunkAddress == 0L ? 0L : diff);
        }
    }

    @Contract(mutates="this,param1")
    private long compactValuesWithoutChunks(@NotNull List<PersistentMapImpl.CompactionRecordInfo> infos, @NotNull PersistentHashMapValueStorage storage) throws IOException {
        if (infos == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(4);
        }
        if (storage == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(5);
        }
        infos.sort(Comparator.comparingLong(info -> info.valueAddress));
        int fileBufferLength = 262144;
        byte[] buffer = new byte[262144];
        int fragments = 0;
        int newFragments = 0;
        byte[] outputBuffer = new byte[4096];
        long readStartOffset = -1L;
        int bytesRead = -1;
        for (PersistentMapImpl.CompactionRecordInfo info2 : infos) {
            int newBytesFitInBuffer;
            int bytesFitInBuffer;
            int recordStartInBuffer = (int)(info2.valueAddress - readStartOffset);
            if (recordStartInBuffer + 5 > 262144 || readStartOffset == -1L) {
                readStartOffset = info2.valueAddress;
                long remainingBytes = readStartOffset != -1L ? this.mySize - readStartOffset : this.mySize;
                bytesRead = remainingBytes < 262144L ? (int)remainingBytes : 262144;
                this.myCompactionModeReader.get(readStartOffset, buffer, 0, bytesRead);
                recordStartInBuffer = (int)(info2.valueAddress - readStartOffset);
            }
            DataInputStream stream = PersistentHashMapValueStorage.toDataInputStream(buffer, recordStartInBuffer, buffer.length);
            int available = stream.available();
            int chunkSize = PersistentHashMapValueStorage.readChunkSize(stream);
            long prevChunkAddress = this.readPrevChunkAddress(info2.valueAddress, stream);
            assert (prevChunkAddress == 0L);
            int dataOffset = available - stream.available() + recordStartInBuffer;
            if (chunkSize >= outputBuffer.length) {
                outputBuffer = new byte[(chunkSize / 4096 + 1) * 4096];
            }
            System.arraycopy(buffer, dataOffset, outputBuffer, 0, bytesFitInBuffer);
            for (bytesFitInBuffer = Math.min(chunkSize, 262144 - dataOffset); bytesFitInBuffer != chunkSize; bytesFitInBuffer += newBytesFitInBuffer) {
                long remainingBytes = this.mySize - (readStartOffset += (long)bytesRead);
                bytesRead = remainingBytes < 262144L ? (int)remainingBytes : 262144;
                this.myCompactionModeReader.get(readStartOffset, buffer, 0, bytesRead);
                newBytesFitInBuffer = Math.min(chunkSize - bytesFitInBuffer, 262144);
                System.arraycopy(buffer, 0, outputBuffer, bytesFitInBuffer, newBytesFitInBuffer);
            }
            info2.newValueAddress = storage.appendBytes(outputBuffer, 0, chunkSize, 0L);
            ++fragments;
            ++newFragments;
        }
        return (long)fragments | (long)newFragments << 32;
    }

    @Contract(mutates="this,param1")
    long compactValues(@NotNull List<PersistentMapImpl.CompactionRecordInfo> infos, @NotNull PersistentHashMapValueStorage storage) throws IOException {
        long lastReadOffset;
        if (infos == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(6);
        }
        if (storage == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(7);
        }
        if (this.myOptions.myHasNoChunks) {
            return this.compactValuesWithoutChunks(infos, storage);
        }
        PriorityQueue<PersistentMapImpl.CompactionRecordInfo> records = new PriorityQueue<PersistentMapImpl.CompactionRecordInfo>(infos.size(), (info, info2) -> Long.compare(info2.valueAddress, info.valueAddress));
        records.addAll(infos);
        int fileBufferLength = 262144;
        int maxRecordHeader = 15;
        byte[] buffer = new byte[262159];
        byte[] reusedAccumulatedChunksBuffer = new byte[]{};
        long lastConsumedOffset = lastReadOffset = this.mySize;
        long allRecordsStart = 0L;
        int fragments = 0;
        int newFragments = 0;
        byte[] stuffFromPreviousRecord = null;
        int bytesRead = (int)(this.mySize - this.mySize / 262144L * 262144L);
        long retained = 0L;
        while (lastReadOffset != 0L) {
            long readStartOffset = lastReadOffset - (long)bytesRead;
            this.myCompactionModeReader.get(readStartOffset, buffer, 0, bytesRead);
            while (!records.isEmpty()) {
                PersistentMapImpl.CompactionRecordInfo info3 = (PersistentMapImpl.CompactionRecordInfo)records.peek();
                if (info3.valueAddress >= readStartOffset) {
                    byte[] accumulatedChunksBuffer;
                    if (info3.valueAddress >= lastReadOffset) {
                        throw new IOException("Value storage is corrupted: value file size:" + this.mySize + ", readStartOffset:" + readStartOffset + ", record address:" + info3.valueAddress + "; file: " + this.myPath);
                    }
                    int recordStartInBuffer = (int)(info3.valueAddress - readStartOffset);
                    DataInputStream inputStream = PersistentHashMapValueStorage.toDataInputStream(buffer, recordStartInBuffer, buffer.length);
                    if (stuffFromPreviousRecord != null && 262144 - recordStartInBuffer < 15) {
                        if (allRecordsStart != 0L) {
                            this.myCompactionModeReader.get(allRecordsStart, buffer, bytesRead, 15);
                        } else {
                            int maxAdditionalBytes = Math.min(stuffFromPreviousRecord.length, 15);
                            System.arraycopy(stuffFromPreviousRecord, 0, buffer, bytesRead, maxAdditionalBytes);
                        }
                    }
                    int available = inputStream.available();
                    int chunkSize = PersistentHashMapValueStorage.readChunkSize(inputStream);
                    long prevChunkAddress = this.readPrevChunkAddress(info3.valueAddress, inputStream);
                    int dataOffset = available - inputStream.available();
                    if (info3.value != null) {
                        int defragmentedChunkSize = info3.value.length + chunkSize;
                        if (prevChunkAddress == 0L) {
                            if (defragmentedChunkSize >= reusedAccumulatedChunksBuffer.length) {
                                reusedAccumulatedChunksBuffer = new byte[defragmentedChunkSize];
                            }
                            accumulatedChunksBuffer = reusedAccumulatedChunksBuffer;
                        } else {
                            accumulatedChunksBuffer = new byte[defragmentedChunkSize];
                            retained += (long)defragmentedChunkSize;
                        }
                        System.arraycopy(info3.value, 0, accumulatedChunksBuffer, chunkSize, info3.value.length);
                    } else if (prevChunkAddress == 0L) {
                        if (chunkSize >= reusedAccumulatedChunksBuffer.length) {
                            reusedAccumulatedChunksBuffer = new byte[chunkSize];
                        }
                        accumulatedChunksBuffer = reusedAccumulatedChunksBuffer;
                    } else {
                        accumulatedChunksBuffer = new byte[chunkSize];
                        retained += (long)chunkSize;
                    }
                    int chunkSizeOutOfBuffer = MathUtil.clamp((int)(info3.valueAddress + (long)dataOffset + (long)chunkSize - lastReadOffset), 0, chunkSize);
                    if (chunkSizeOutOfBuffer > 0) {
                        if (allRecordsStart != 0L) {
                            this.myCompactionModeReader.get(allRecordsStart, accumulatedChunksBuffer, chunkSize - chunkSizeOutOfBuffer, chunkSizeOutOfBuffer);
                        } else {
                            int offsetInStuffFromPreviousRecord = Math.max((int)(info3.valueAddress + (long)dataOffset - lastReadOffset), 0);
                            System.arraycopy(stuffFromPreviousRecord, offsetInStuffFromPreviousRecord, accumulatedChunksBuffer, chunkSize - chunkSizeOutOfBuffer, chunkSizeOutOfBuffer);
                        }
                    }
                    stuffFromPreviousRecord = null;
                    allRecordsStart = 0L;
                    lastConsumedOffset = info3.valueAddress;
                    PersistentHashMapValueStorage.checkPreconditions(accumulatedChunksBuffer, chunkSize);
                    System.arraycopy(buffer, recordStartInBuffer + dataOffset, accumulatedChunksBuffer, 0, chunkSize - chunkSizeOutOfBuffer);
                    ++fragments;
                    records.remove(info3);
                    if (info3.value != null) {
                        chunkSize += info3.value.length;
                        retained -= (long)info3.value.length;
                        info3.value = null;
                    }
                    if (prevChunkAddress == 0L) {
                        info3.newValueAddress = storage.appendBytes(accumulatedChunksBuffer, 0, chunkSize, info3.newValueAddress);
                        ++newFragments;
                        continue;
                    }
                    if (retained > 0xA00000L && accumulatedChunksBuffer.length > 1024 || retained > 0x6400000L) {
                        newFragments += this.saveAccumulatedDataOnDiskPreservingWriteOrder(storage, info3, prevChunkAddress, accumulatedChunksBuffer, chunkSize);
                        retained -= (long)accumulatedChunksBuffer.length;
                        continue;
                    }
                    info3.value = accumulatedChunksBuffer;
                    info3.valueAddress = prevChunkAddress;
                    records.add(info3);
                    continue;
                }
                if (stuffFromPreviousRecord == null) {
                    stuffFromPreviousRecord = new byte[(int)(lastConsumedOffset - readStartOffset)];
                    System.arraycopy(buffer, 0, stuffFromPreviousRecord, 0, stuffFromPreviousRecord.length);
                    break;
                }
                allRecordsStart = readStartOffset;
                break;
            }
            lastReadOffset -= (long)bytesRead;
            bytesRead = 262144;
        }
        return (long)fragments | (long)newFragments << 32;
    }

    private int saveAccumulatedDataOnDiskPreservingWriteOrder(PersistentHashMapValueStorage storage, PersistentMapImpl.CompactionRecordInfo info, long prevChunkAddress, byte[] accumulatedChunksData, int accumulatedChunkDataLength) throws IOException {
        ReadResult result = this.readBytes(prevChunkAddress);
        info.newValueAddress = storage.appendBytes(result.buffer, 0, result.buffer.length, info.newValueAddress);
        info.newValueAddress = storage.appendBytes(accumulatedChunksData, 0, accumulatedChunkDataLength, info.newValueAddress);
        info.value = null;
        info.valueAddress = 0L;
        return 2;
    }

    public ReadResult readBytes(long tailChunkAddress) throws IOException {
        PersistentHashMapValueStorage.forceAppender(this.myPath);
        PersistentHashMapValueStorage.checkCancellation();
        long startedTime = ourDumpChunkRemovalTime ? System.nanoTime() : 0L;
        RAReader reader = this.myCompactionModeReader;
        FileAccessorCache.Handle<RAReader> readerHandle = null;
        if (this.myCompressedAppendableFile != null) {
            reader = new ReaderOverCompressedFile(this.myCompressedAppendableFile);
        }
        if (reader == null) {
            readerHandle = ourReadersCache.get(this.myPath);
            reader = readerHandle.get();
        }
        int chunkCount = 0;
        byte[] result = null;
        try {
            long chunk = tailChunkAddress;
            while (chunk != 0L) {
                if (chunk < 0L || chunk > this.mySize) {
                    throw new CorruptedException(this.myPath);
                }
                byte[] buffer = myBuffer.getBuffer(1024);
                int len = (int)Math.min(1024L, this.mySize - chunk);
                reader.get(chunk, buffer, 0, len);
                DataInputStream inputStream = PersistentHashMapValueStorage.toDataInputStream(buffer, 0, len);
                int chunkSize = PersistentHashMapValueStorage.readChunkSize(inputStream);
                long prevChunkAddress = this.readPrevChunkAddress(chunk, inputStream);
                int headerOffset = len - inputStream.available();
                byte[] b = new byte[(result != null ? result.length : 0) + chunkSize];
                if (result != null) {
                    System.arraycopy(result, 0, b, b.length - result.length, result.length);
                }
                result = b;
                PersistentHashMapValueStorage.checkPreconditions(result, chunkSize);
                if (chunkSize < 1024 - headerOffset) {
                    System.arraycopy(buffer, headerOffset, result, 0, chunkSize);
                } else {
                    reader.get(chunk + (long)headerOffset, result, 0, chunkSize);
                }
                if (prevChunkAddress >= chunk) {
                    throw new CorruptedException(this.myPath);
                }
                chunk = prevChunkAddress;
                ++chunkCount;
                if (prevChunkAddress != 0L) {
                    PersistentHashMapValueStorage.checkCancellation();
                    assert (!this.myOptions.myHasNoChunks);
                }
                if ((long)result.length <= this.mySize || this.myCompressedAppendableFile != null) continue;
                throw new CorruptedException(this.myPath);
            }
        }
        catch (OutOfMemoryError error) {
            throw new CorruptedException(this.myPath);
        }
        finally {
            if (readerHandle != null) {
                readerHandle.release();
            }
        }
        if (chunkCount > 1) {
            PersistentHashMapValueStorage.checkCancellation();
            this.myChunksReadingTime += (ourDumpChunkRemovalTime ? System.nanoTime() : 0L) - startedTime;
            this.myChunks += chunkCount;
            this.myChunksOriginalBytes += (long)result.length;
        }
        return new ReadResult(result, chunkCount);
    }

    private boolean allowedToCompactChunks() {
        return !this.myCompactionMode && !this.myOptions.myReadOnly;
    }

    boolean performChunksCompaction(int chunksCount) {
        return chunksCount > 1 && this.allowedToCompactChunks();
    }

    long compactChunks(@NotNull AppendablePersistentMap.ValueDataAppender appender, @NotNull ReadResult result) throws IOException {
        long newValueOffset;
        long startedTime;
        if (appender == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(8);
        }
        if (result == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(9);
        }
        PersistentHashMapValueStorage.checkCancellation();
        long l = startedTime = ourDumpChunkRemovalTime ? System.nanoTime() : 0L;
        if (this.myOptions.myCompactChunksWithValueDeserialization) {
            BufferExposingByteArrayOutputStream stream = new BufferExposingByteArrayOutputStream(result.buffer.length);
            DataOutputStream testStream = new DataOutputStream(stream);
            appender.append(testStream);
            newValueOffset = this.appendBytes(stream.toByteArraySequence(), 0L);
            this.myChunksBytesAfterRemoval += (long)stream.size();
        } else {
            newValueOffset = this.appendBytes(ByteArraySequence.create(result.buffer), 0L);
            this.myChunksBytesAfterRemoval += (long)result.buffer.length;
        }
        if (ourDumpChunkRemovalTime) {
            this.myChunksRemovalTime += System.nanoTime() - startedTime;
            if (this.myChunks - this.myLastReportedChunksCount > 1000) {
                this.myLastReportedChunksCount = this.myChunks;
                System.out.println(this.myChunks + " chunks were read " + this.myChunksReadingTime / 1000000L + "ms, bytes: " + this.myChunksOriginalBytes + (this.myChunksOriginalBytes != this.myChunksBytesAfterRemoval ? "->" + this.myChunksBytesAfterRemoval : "") + " compaction:" + this.myChunksRemovalTime / 1000000L + "ms in " + this.myPath);
            }
        }
        return newValueOffset;
    }

    private static void checkCancellation() {
        IOCancellationCallbackHolder.checkCancelled();
    }

    private static int readChunkSize(@NotNull DataInputStream in) throws IOException {
        int chunkSize;
        if (in == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(10);
        }
        if ((chunkSize = DataInputOutputUtil.readINT(in)) < 0) {
            throw new IOException("Value storage corrupted: negative chunk size: " + chunkSize);
        }
        return chunkSize;
    }

    /*
     * WARNING - void declaration
     */
    private long readPrevChunkAddress(long chunkAddress, @NotNull DataInputStream dataInputStream) throws IOException {
        void in;
        if (dataInputStream == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(11);
        }
        if (this.myOptions.myHasNoChunks) {
            return 0L;
        }
        long prevOffsetDiff = DataInputOutputUtil.readLONG((DataInput)in);
        if (prevOffsetDiff >= chunkAddress) {
            throw new IOException("readPrevChunkAddress:" + chunkAddress + "," + prevOffsetDiff + "," + this.mySize + "," + this.myPath);
        }
        return prevOffsetDiff != 0L ? chunkAddress - prevOffsetDiff : 0L;
    }

    public long getSize() {
        return this.mySize;
    }

    private static void checkPreconditions(byte[] result, int chunkSize) throws IOException {
        if (chunkSize < 0) {
            throw new IOException("Value storage corrupted: negative chunk size");
        }
        if (chunkSize > result.length) {
            throw new IOException("Value storage corrupted");
        }
    }

    public void force() {
        if (this.myOptions.myReadOnly) {
            return;
        }
        if (this.myCompressedAppendableFile != null) {
            this.myCompressedAppendableFile.force();
        }
        if (this.mySize < 0L) assert (false);
        PersistentHashMapValueStorage.forceAppender(this.myPath);
    }

    private static void forceAppender(Path path) {
        FileAccessorCache.Handle<SyncAbleBufferedOutputStreamOverCachedFileChannel> cached = ourAppendersCache.getIfCached(path);
        if (cached != null) {
            try {
                ((OutputStream)cached.get()).flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                cached.release();
            }
        }
    }

    public void dispose() {
        try {
            if (this.myCompressedAppendableFile != null) {
                this.myCompressedAppendableFile.dispose();
            }
        }
        finally {
            if (this.mySize < 0L) assert (false);
            ourReadersCache.remove(this.myPath);
            ourAppendersCache.remove(this.myPath);
            ourFileChannelCache.remove(this.myPath);
            if (this.myCompactionModeReader != null) {
                try {
                    this.myCompactionModeReader.dispose();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.myCompactionModeReader = null;
            }
        }
    }

    void switchToCompactionMode() throws IOException {
        ourReadersCache.remove(this.myPath);
        ourFileChannelCache.remove(this.myPath);
        this.myCompactionModeReader = this.myCompressedAppendableFile != null ? new ReaderOverCompressedFile(this.myCompressedAppendableFile) : new FileReader(this.myPath);
        this.myCompactionMode = true;
    }

    @NotNull
    private static DataInputStream toDataInputStream(byte @NotNull [] buffer, int offset, int length) {
        if (buffer == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(12);
        }
        return new DataInputStream(new UnsyncByteArrayInputStream(buffer, offset, length));
    }

    @NotNull
    private static DataOutputStream toDataOutputStream(final @NotNull FileAccessorCache.Handle<SyncAbleBufferedOutputStreamOverCachedFileChannel> handle) {
        if (handle == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(13);
        }
        return new DataOutputStream(handle.get()){

            @Override
            public void close() throws IOException {
                super.close();
                handle.close();
            }
        };
    }

    public static PersistentHashMapValueStorage create(@NotNull Path path, @NotNull CreationTimeOptions options) throws IOException {
        if (path == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(14);
        }
        if (options == null) {
            PersistentHashMapValueStorage.$$$reportNull$$$0(15);
        }
        return new PersistentHashMapValueStorage(path, options);
    }

    @TestOnly
    public boolean isReadOnly() {
        return this.myOptions.myReadOnly;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/PersistentHashMapValueStorage";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataOutputStream";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/PersistentHashMapValueStorage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveHeader";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compactValuesWithoutChunks";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compactValues";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compactChunks";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readChunkSize";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readPrevChunkAddress";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toDataInputStream";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toDataOutputStream";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class CreationTimeOptions {
        public static final ThreadLocal<Boolean> READONLY = new ThreadLocal();
        public static final ThreadLocal<Boolean> COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION = new ThreadLocal();
        public static final ThreadLocal<Boolean> HAS_NO_CHUNKS = new ThreadLocal();
        @VisibleForTesting
        @ApiStatus.Internal
        public static final ThreadLocal<Boolean> DO_COMPRESSION = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return COMPRESSION_ENABLED;
            }
        };
        private final boolean myReadOnly;
        private final boolean myCompactChunksWithValueDeserialization;
        private final boolean myHasNoChunks;
        private final boolean myUseCompression;

        public CreationTimeOptions(boolean readOnly, boolean compactChunksWithValueDeserialization, boolean hasNoChunks, boolean doCompression) {
            this.myReadOnly = readOnly;
            this.myCompactChunksWithValueDeserialization = compactChunksWithValueDeserialization;
            this.myHasNoChunks = hasNoChunks;
            this.myUseCompression = doCompression;
        }

        int getVersion() {
            return (this.myHasNoChunks ? 10 : 0) * 31 + (this.myUseCompression ? 19 : 0);
        }

        boolean isReadOnly() {
            return this.myReadOnly;
        }

        boolean useCompression() {
            return this.myUseCompression;
        }

        public CreationTimeOptions setReadOnly() {
            return new CreationTimeOptions(true, this.myCompactChunksWithValueDeserialization, this.myHasNoChunks, this.myUseCompression);
        }

        public CreationTimeOptions readOnly(boolean readOnly) {
            return new CreationTimeOptions(readOnly, this.myCompactChunksWithValueDeserialization, this.myHasNoChunks, this.myUseCompression);
        }

        public CreationTimeOptions setCompactChunksWithValueDeserialization() {
            return new CreationTimeOptions(this.myReadOnly, true, this.myHasNoChunks, this.myUseCompression);
        }

        public CreationTimeOptions setHasNoChunks() {
            return new CreationTimeOptions(this.myReadOnly, this.myCompactChunksWithValueDeserialization, true, this.myUseCompression);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T, E extends Throwable> T with(@NotNull ThrowableComputable<T, E> func) throws E {
            if (func == null) {
                CreationTimeOptions.$$$reportNull$$$0(0);
            }
            CreationTimeOptions previousOptions = CreationTimeOptions.setThreadLocalOptions(this);
            try {
                Object object = func.compute();
                return (T)object;
            }
            finally {
                CreationTimeOptions.setThreadLocalOptions(previousOptions);
            }
        }

        @NotNull
        public static CreationTimeOptions threadLocalOptions() {
            return new CreationTimeOptions(READONLY.get() == Boolean.TRUE, COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION.get() == Boolean.TRUE, HAS_NO_CHUNKS.get() == Boolean.TRUE, DO_COMPRESSION.get() == Boolean.TRUE);
        }

        @NotNull
        public static CreationTimeOptions setThreadLocalOptions(CreationTimeOptions options) {
            CreationTimeOptions currentOptions = CreationTimeOptions.threadLocalOptions();
            READONLY.set(options.myReadOnly);
            COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION.set(options.myCompactChunksWithValueDeserialization);
            HAS_NO_CHUNKS.set(options.myHasNoChunks);
            DO_COMPRESSION.set(options.myUseCompression);
            CreationTimeOptions creationTimeOptions = currentOptions;
            if (creationTimeOptions == null) {
                CreationTimeOptions.$$$reportNull$$$0(1);
            }
            return creationTimeOptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "func";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/PersistentHashMapValueStorage$CreationTimeOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/PersistentHashMapValueStorage$CreationTimeOptions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setThreadLocalOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "with";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MyCompressedAppendableFile
    extends CompressedAppendableFile {
        MyCompressedAppendableFile() throws IOException {
            super(PersistentHashMapValueStorage.this.myPath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected InputStream getChunkInputStream(long offset, int pageSize) throws IOException {
            PersistentHashMapValueStorage.forceAppender(PersistentHashMapValueStorage.this.myPath);
            FileAccessorCache.Handle fileAccessor = ourReadersCache.get(PersistentHashMapValueStorage.this.myPath);
            byte[] bytes = new byte[pageSize];
            ((RAReader)fileAccessor.get()).get(offset, bytes, 0, pageSize);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
            if (byteArrayInputStream2 == null) {
                MyCompressedAppendableFile.$$$reportNull$$$0(0);
            }
            return byteArrayInputStream2;
            finally {
                fileAccessor.release();
            }
        }

        @Override
        @NotNull
        protected DataOutputStream getChunkAppendStream() {
            DataOutputStream dataOutputStream = PersistentHashMapValueStorage.toDataOutputStream(ourAppendersCache.get(PersistentHashMapValueStorage.this.myPath));
            if (dataOutputStream == null) {
                MyCompressedAppendableFile.$$$reportNull$$$0(1);
            }
            return dataOutputStream;
        }

        @Override
        @NotNull
        protected DataOutputStream getChunkLengthAppendStream() {
            DataOutputStream dataOutputStream = PersistentHashMapValueStorage.toDataOutputStream(ourAppendersCache.get(this.getChunkLengthFile()));
            if (dataOutputStream == null) {
                MyCompressedAppendableFile.$$$reportNull$$$0(2);
            }
            return dataOutputStream;
        }

        @Override
        @NotNull
        protected Path getChunksFile() {
            Path path = PersistentHashMapValueStorage.this.myPath;
            if (path == null) {
                MyCompressedAppendableFile.$$$reportNull$$$0(3);
            }
            return path;
        }

        @Override
        public synchronized void force() {
            super.force();
            PersistentHashMapValueStorage.forceAppender(this.getChunkLengthFile());
        }

        @Override
        public synchronized void dispose() {
            super.dispose();
            ourAppendersCache.remove(this.getChunkLengthFile());
            ourFileChannelCache.remove(this.getChunkLengthFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/util/io/PersistentHashMapValueStorage$MyCompressedAppendableFile";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunkInputStream";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunkAppendStream";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunkLengthAppendStream";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunksFile";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static final class SyncAbleBufferedOutputStreamOverCachedFileChannel
    extends BufferedOutputStream {
        private final Path myPath;

        SyncAbleBufferedOutputStreamOverCachedFileChannel(Path path) {
            super(new OutputStreamOverRandomAccessFileCache(path));
            this.myPath = path;
        }

        public void sync() throws IOException {
            FileAccessorCache.Handle fileAccessor = ourFileChannelCache.get(this.myPath);
            FileChannelWithSizeTracking fileChannel = (FileChannelWithSizeTracking)fileAccessor.get();
            fileChannel.force();
        }

        private static final class OutputStreamOverRandomAccessFileCache
        extends OutputStream {
            private final Path myPath;

            public OutputStreamOverRandomAccessFileCache(Path path) {
                this.myPath = path;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(byte @NotNull [] b, int off, int len) throws IOException {
                if (b == null) {
                    OutputStreamOverRandomAccessFileCache.$$$reportNull$$$0(0);
                }
                FileAccessorCache.Handle fileAccessor = ourFileChannelCache.get(this.myPath);
                FileChannelWithSizeTracking file = (FileChannelWithSizeTracking)fileAccessor.get();
                try {
                    file.write(file.length(), b, off, len);
                }
                finally {
                    fileAccessor.release();
                }
            }

            @Override
            public void write(int b) throws IOException {
                byte[] r = new byte[]{(byte)(b & 0xFF)};
                this.write(r);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/util/io/PersistentHashMapValueStorage$SyncAbleBufferedOutputStreamOverCachedFileChannel$OutputStreamOverRandomAccessFileCache", "write"));
            }
        }
    }

    private static interface RAReader {
        public void get(long var1, byte[] var3, int var4, int var5) throws IOException;

        public void dispose() throws IOException;
    }

    static final class ReadResult {
        final byte[] buffer;
        final int chunksCount;

        ReadResult(byte[] buffer, int chunksCount) {
            this.buffer = buffer;
            this.chunksCount = chunksCount;
        }
    }

    private static final class ReaderOverCompressedFile
    implements RAReader {
        @NotNull
        private final CompressedAppendableFile myCompressedAppendableFile;

        ReaderOverCompressedFile(@NotNull CompressedAppendableFile compressedAppendableFile) {
            if (compressedAppendableFile == null) {
                ReaderOverCompressedFile.$$$reportNull$$$0(0);
            }
            this.myCompressedAppendableFile = compressedAppendableFile;
        }

        @Override
        public void get(long addr, byte[] dst, int off, int len) throws IOException {
            try (DataInputStream stream = this.myCompressedAppendableFile.getStream(addr);){
                stream.readFully(dst, off, len);
            }
        }

        @Override
        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compressedAppendableFile", "com/intellij/util/io/PersistentHashMapValueStorage$ReaderOverCompressedFile", "<init>"));
        }
    }

    private static final class FileReader
    implements RAReader {
        private final ResilientFileChannel fileChannel;

        private FileReader(Path file) throws IOException {
            this.fileChannel = new ResilientFileChannel(file, StandardOpenOption.READ);
        }

        @Override
        public void get(long addr, byte[] dst, int off, int len) throws IOException {
            this.fileChannel.read(ByteBuffer.wrap(dst, off, len), addr);
        }

        @Override
        public void dispose() throws IOException {
            this.fileChannel.close();
        }
    }

    private static final class ReaderOverFileChannelCache
    implements RAReader {
        private final Path myPath;

        private ReaderOverFileChannelCache(@NotNull Path path) {
            if (path == null) {
                ReaderOverFileChannelCache.$$$reportNull$$$0(0);
            }
            this.myPath = path;
        }

        @Override
        public void get(long addr, byte[] dst, int off, int len) throws IOException {
            try (FileAccessorCache.Handle fileAccessor = ourFileChannelCache.get(this.myPath);){
                FileChannelWithSizeTracking file = (FileChannelWithSizeTracking)fileAccessor.get();
                file.read(addr, dst, off, len);
            }
        }

        @Override
        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/io/PersistentHashMapValueStorage$ReaderOverFileChannelCache", "<init>"));
        }
    }
}

