/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.expr.Constant;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.RemoveLocalFromSSA;
import com.googlecode.dex2jar.ir.ts.StatedTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RemoveConstantFromSSA
extends StatedTransformer {
    public static final Comparator<Local> LOCAL_COMPARATOR = Comparator.comparingInt(local -> local._ls_index);

    @Override
    public boolean transformReportChanged(IrMethod method) {
        boolean changed = false;
        ArrayList<AssignStmt> assignStmtList = new ArrayList<AssignStmt>();
        HashMap<Local, Object> cstMap = new HashMap<Local, Object>();
        for (Stmt p = method.stmts.getFirst(); p != null; p = p.getNext()) {
            if (p.st != Stmt.ST.ASSIGN) continue;
            AssignStmt as = (AssignStmt)p;
            if (as.getOp1().vt != Value.VT.LOCAL) continue;
            if (as.getOp2().vt == Value.VT.CONSTANT) {
                assignStmtList.add(as);
                cstMap.put((Local)as.getOp1(), ((Constant)as.getOp2()).value);
                continue;
            }
            if (as.getOp2().vt != Value.VT.LOCAL) continue;
            cstMap.put((Local)as.getOp1(), as.getOp2());
        }
        if (assignStmtList.size() == 0) {
            return false;
        }
        RemoveLocalFromSSA.fixReplace(cstMap);
        final HashMap<Local, Value> toReplace = new HashMap<Local, Value>();
        HashSet<Value> usedInPhi = new HashSet<Value>();
        List<LabelStmt> phiLabels = method.phiLabels;
        if (phiLabels != null) {
            boolean loopAgain = true;
            while (loopAgain) {
                loopAgain = false;
                usedInPhi.clear();
                Iterator<LabelStmt> it = phiLabels.iterator();
                while (it.hasNext()) {
                    LabelStmt labelStmt = it.next();
                    if (labelStmt.phis == null) continue;
                    Iterator<AssignStmt> it2 = labelStmt.phis.iterator();
                    while (it2.hasNext()) {
                        AssignStmt phi = it2.next();
                        Value[] vs = phi.getOp2().getOps();
                        Object sameCst = null;
                        boolean allEqual = true;
                        for (Value p : vs) {
                            Object cst = cstMap.get(p);
                            if (cst == null) {
                                allEqual = false;
                                break;
                            }
                            if (sameCst == null) {
                                sameCst = cst;
                                continue;
                            }
                            if (sameCst.equals(cst)) continue;
                            allEqual = false;
                            break;
                        }
                        if (allEqual) {
                            cstMap.put((Local)phi.getOp1(), sameCst);
                            if (sameCst instanceof Local) {
                                phi.setOp2((Value)sameCst);
                            } else {
                                phi.setOp2(Exprs.nConstant(sameCst));
                                assignStmtList.add(phi);
                            }
                            it2.remove();
                            method.stmts.insertAfter(labelStmt, phi);
                            changed = true;
                            loopAgain = true;
                            continue;
                        }
                        usedInPhi.addAll(Arrays.asList(phi.getOp2().getOps()));
                    }
                    if (labelStmt.phis.size() != 0) continue;
                    it.remove();
                }
            }
        }
        Iterator it = assignStmtList.iterator();
        while (it.hasNext()) {
            AssignStmt as = (AssignStmt)it.next();
            if (!usedInPhi.contains(as.getOp1())) {
                it.remove();
                method.stmts.remove(as);
                method.locals.remove(as.getOp1());
                changed = true;
            }
            toReplace.put((Local)as.getOp1(), as.getOp2());
        }
        Cfg.travelMod(method.stmts, new Cfg.TravelCallBack(){

            @Override
            public Value onAssign(Local v, AssignStmt as) {
                return v;
            }

            @Override
            public Value onUse(Local v) {
                Value n = (Value)toReplace.get(v);
                return n == null ? v : n.clone();
            }
        }, false);
        return changed;
    }
}

