//
//  debug_window.c
//  
//
//  Created by Parker, Charles W. on 1/27/18.
//
//  Build from pcb/src with:
//  gcc -fPIC -shared -o debug_window.so \
//       debug_window.c -I.. -I/opt/local/include/glib-2.0 \
//       -I/opt/local/lib/glib-2.0/include -DHAVE_CONFIG_H
//  Make sure that the resulting shared object file (dynamic library) produces
//  the following output from the "file" function:
//  $ file debug_window.so
//  linux:
//  debug_window.so: ELF 64-bit LSB shared object, x86-64, version 1 (SYSV), dynamically linked, with debug_info, not stripped 
//  MacOS:
//  debug_window.so: Mach-O 64-bit dynamically linked shared library x86_64
//

#include <stdio.h>

#include "globalconst.h"
#include "global.h" // types

#include "error.h" // Message
#include "hid.h"   // REGISTER_ACTIONS
#include "hid/gtk/gui.h"

#include <gtk/gtk.h>

#include "data.h" // crosshair data structure

static GtkWidget *debug_window = NULL;

static gint update_timer = 0;
int update_timer_period = 333; // ms

/*
 * Keep pointers to the info widgets that we're going to update
 */
GtkWidget *l_range_xmin, *l_range_xmax, *l_range_ymin, *l_range_ymax;
GtkWidget *l_pbmode, *l_pbxy, *l_pbbb, *l_attachedobj;

static gboolean
debug_window_update_cb(void* data)
{
  /*
   * Use this callback to update the info widgets
   */
  char msg[256];
  
  // don't try it if the window doesn't exist
  if (!debug_window) return 0;

  sprintf(msg, "%d", Crosshair.MinX);
  gtk_label_set_text(GTK_LABEL(l_range_xmin), msg);
  sprintf(msg, "%d", Crosshair.MaxX);
  gtk_label_set_text(GTK_LABEL(l_range_xmax), msg);
  sprintf(msg, "%d", Crosshair.MinY);
  gtk_label_set_text(GTK_LABEL(l_range_ymin), msg);
  sprintf(msg, "%d", Crosshair.MaxY);
  gtk_label_set_text(GTK_LABEL(l_range_ymax), msg);
  if (Settings.Mode == PASTEBUFFER_MODE)
  {
    sprintf(msg, "%s", "TRUE");
    gtk_label_set_text(GTK_LABEL(l_pbmode), msg);
	sprintf(msg, "%d, %d", PASTEBUFFER->X, PASTEBUFFER->Y);
    gtk_label_set_text(GTK_LABEL(l_pbxy), msg);
	sprintf(msg, "%d, %d, %d, %d", 
			PASTEBUFFER->BoundingBox.X1, PASTEBUFFER->BoundingBox.Y1,
			PASTEBUFFER->BoundingBox.X2, PASTEBUFFER->BoundingBox.Y2);
    gtk_label_set_text(GTK_LABEL(l_pbbb), msg);
  } else {
    sprintf(msg, "%s", "FALSE");
    gtk_label_set_text(GTK_LABEL(l_pbmode), msg);
	sprintf(msg, "%s", "NONE");
    gtk_label_set_text(GTK_LABEL(l_pbxy), msg);
  	sprintf(msg, "%d, %d, %d, %d", 0,0,0,0);
    gtk_label_set_text(GTK_LABEL(l_pbbb), msg);
  }
  sprintf(msg, "%s", 
		  (Crosshair.AttachedObject.Type != NO_TYPE) ? "TRUE":"FALSE");
  gtk_label_set_text(GTK_LABEL(l_attachedobj), msg);
  return TRUE;
}

static void
debug_window_destroy_cb(void)
{
  gtk_timeout_remove(update_timer);
  debug_window = NULL;
  l_range_xmin = NULL;
  l_range_xmax = NULL;
  l_range_ymin = NULL;
  l_range_ymax = NULL;
  l_pbmode = NULL;
  l_attachedobj = NULL;
  return;
}

static GtkWidget *
debug_window_create(void)
{
  GtkWidget *vbox;

  debug_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  g_signal_connect(G_OBJECT(debug_window), 
		           "destroy", G_CALLBACK(debug_window_destroy_cb), gport);

  gtk_window_set_title(GTK_WINDOW(debug_window), "Debug Window");
  gtk_window_resize(GTK_WINDOW(debug_window), 300, 100);

  vbox = gtk_vbox_new(FALSE, 4);
  gtk_container_add(GTK_CONTAINER(debug_window), vbox);

  /*
   * From here add whatever widgets you're going to use to display debugging
   * information.
   */

  gtk_container_add(GTK_CONTAINER(vbox), 
		            gtk_label_new("Crosshair xmin:"));
  l_range_xmin = gtk_label_new("xmin");
  gtk_container_add(GTK_CONTAINER(vbox), l_range_xmin);
  gtk_container_add(GTK_CONTAINER(vbox), 
		            gtk_label_new("Crosshair xmax:"));
  l_range_xmax = gtk_label_new("xmax");
  gtk_container_add(GTK_CONTAINER(vbox), l_range_xmax);
  gtk_container_add(GTK_CONTAINER(vbox), 
		            gtk_label_new("Crosshair ymin:"));
  l_range_ymin = gtk_label_new("ymin");
  gtk_container_add(GTK_CONTAINER(vbox), l_range_ymin);
  gtk_container_add(GTK_CONTAINER(vbox), 
		            gtk_label_new("Crosshair ymax:"));
  l_range_ymax = gtk_label_new("ymax");
  gtk_container_add(GTK_CONTAINER(vbox), l_range_ymax);
  gtk_container_add(GTK_CONTAINER(vbox), 
		            gtk_label_new("Pastebuffer Mode:"));
  l_pbmode = gtk_label_new("mode");
  gtk_container_add(GTK_CONTAINER(vbox), l_pbmode);
  gtk_container_add(GTK_CONTAINER(vbox), 
		            gtk_label_new("Pastebuffer X, Y:"));
  l_pbxy = gtk_label_new("none");
  gtk_container_add(GTK_CONTAINER(vbox), l_pbxy);
  gtk_container_add(GTK_CONTAINER(vbox), 
		            gtk_label_new("Pastebuffer BB X1, Y1, X2, Y2:"));
  l_pbbb = gtk_label_new("none");
  gtk_container_add(GTK_CONTAINER(vbox), l_pbbb);
  gtk_container_add(GTK_CONTAINER(vbox), 
		            gtk_label_new("Attached Object:"));
  l_attachedobj = gtk_label_new("aobj");
  gtk_container_add(GTK_CONTAINER(vbox), l_attachedobj);


  update_timer = gtk_timeout_add(update_timer_period, 
		                         debug_window_update_cb,
								 NULL);

  return debug_window;
}

static int
open_debug_window_action (int argc, char **argv, Coord x, Coord y)
{
  int i = 0;
  if (!debug_window){
    debug_window_create();
  }
  gtk_widget_show_all(debug_window);
  gtk_window_present(GTK_WINDOW(debug_window));
  /* Argument handling
  if ((argc == 2) && (strcmp(argv[0], "Echo") == 0))
  {
    Message("Echoing: %s\n", argv[1]);
  }
  */
  
  return 0;
}

static HID_Action plugin_action_list[] =
{
  {"OpenDebugWindowAction", NULL, open_debug_window_action, NULL, NULL}
};

REGISTER_ACTIONS (plugin_action_list)

void
pcb_plugin_init()
{
  Message("Loading Debug Window Plugin\n");
  register_plugin_action_list();
}
