/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.ApplicationMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ProtocolMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationMessageSerializer
extends ProtocolMessageSerializer<ApplicationMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ApplicationMessage msg;

    public ApplicationMessageSerializer(ApplicationMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeProtocolMessageContent() {
        LOGGER.debug("Serializing ApplicationMessage");
        this.writeData(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeData(ApplicationMessage msg) {
        this.appendBytes((byte[])msg.getData().getValue());
        LOGGER.debug("Data: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getData().getValue())));
    }
}

