/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public final class QueryResultKey
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(QueryResultKey.class);
    private static final long BASE_SF_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SortField.class);
    final Query query;
    final Sort sort;
    final List<SortField> sfields;
    final List<Query> filters;
    final int nc_flags;
    final int minExactCount;
    final boolean distribStatsDisabled;
    private final int hc;
    private final long ramBytesUsed;

    public QueryResultKey(Query query, List<Query> filters, Sort sort, int nc_flags) {
        this(query, filters, sort, nc_flags, Integer.MAX_VALUE, false);
    }

    public QueryResultKey(Query query, List<Query> filters, Sort sort, int nc_flags, int minExactCount) {
        this(query, filters, sort, nc_flags, minExactCount, false);
    }

    public QueryResultKey(Query query, List<Query> filters, Sort sort, int nc_flags, int minExactCount, boolean distribStatsDisabled) {
        this.query = query;
        this.sort = sort;
        this.nc_flags = nc_flags;
        this.minExactCount = minExactCount;
        this.distribStatsDisabled = distribStatsDisabled;
        int h = query.hashCode();
        if (filters == null) {
            this.filters = null;
        } else {
            this.filters = filters.stream().filter(Objects::nonNull).collect(Collectors.toList());
            for (Query filt : this.filters) {
                h += filt.hashCode();
            }
        }
        this.sfields = this.sort == null ? List.of() : Arrays.stream(sort.getSort()).filter(Objects::nonNull).collect(Collectors.toList());
        long ramSfields = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        for (SortField sf : this.sfields) {
            h = h * 29 + sf.hashCode();
            ramSfields += BASE_SF_RAM_BYTES_USED + RamUsageEstimator.sizeOfObject((Object)sf.getField());
        }
        this.hc = h = h * 31 + minExactCount;
        this.ramBytesUsed = BASE_RAM_BYTES_USED + ramSfields + RamUsageEstimator.sizeOfObject((Object)query, (long)1024L) + RamUsageEstimator.sizeOfObject(this.filters, (long)1024L);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryResultKey)) {
            return false;
        }
        QueryResultKey other = (QueryResultKey)o;
        if (this.hc != other.hc) {
            return false;
        }
        if (this.sfields.size() != other.sfields.size()) {
            return false;
        }
        if (!this.query.equals((Object)other.query)) {
            return false;
        }
        if (!QueryResultKey.unorderedCompare(this.filters, other.filters)) {
            return false;
        }
        if (this.minExactCount != other.minExactCount) {
            return false;
        }
        if (this.distribStatsDisabled != other.distribStatsDisabled) {
            return false;
        }
        for (int i = 0; i < this.sfields.size(); ++i) {
            SortField sf2;
            SortField sf1 = this.sfields.get(i);
            if (sf1.equals((Object)(sf2 = other.sfields.get(i)))) continue;
            return false;
        }
        return true;
    }

    private static boolean unorderedCompare(List<Query> fqList1, List<Query> fqList2) {
        if (fqList1 == fqList2) {
            return true;
        }
        if (fqList1 == null || fqList2 == null) {
            return false;
        }
        int sz = fqList1.size();
        if (sz != fqList2.size()) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            if (fqList1.get(i).equals((Object)fqList2.get(i))) continue;
            return QueryResultKey.unorderedCompare(fqList1, fqList2, i);
        }
        return true;
    }

    private static boolean unorderedCompare(List<Query> fqList1, List<Query> fqList2, int start) {
        assert (null != fqList1);
        assert (null != fqList2);
        int sz = fqList1.size();
        assert (fqList2.size() == sz);
        ArrayList<Query> set2 = new ArrayList<Query>(fqList2.subList(start, sz));
        for (int i = start; i < sz; ++i) {
            Query q1 = fqList1.get(i);
            if (set2.remove(q1)) continue;
            return false;
        }
        return set2.isEmpty();
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }
}

