/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.auth.jaas.internal;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.auth.Authentication;
import org.openhab.core.auth.AuthenticationException;
import org.openhab.core.auth.AuthenticationProvider;
import org.openhab.core.auth.Credentials;
import org.openhab.core.auth.GenericUser;
import org.openhab.core.auth.UsernamePasswordCredentials;
import org.openhab.core.auth.jaas.internal.ManagedUserLoginConfiguration;
import org.openhab.core.auth.jaas.internal.ManagedUserLoginModule;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@NonNullByDefault
@Component(configurationPid={"org.openhab.jaas"})
public class JaasAuthenticationProvider
implements AuthenticationProvider {
    private static final String DEFAULT_REALM = "openhab";
    private @Nullable String realmName;

    public Authentication authenticate(Credentials credentials) throws AuthenticationException {
        if (this.realmName == null) {
            this.realmName = DEFAULT_REALM;
        }
        if (!(credentials instanceof UsernamePasswordCredentials)) {
            throw new AuthenticationException("Unsupported credentials passed to provider.");
        }
        UsernamePasswordCredentials userCredentials = (UsernamePasswordCredentials)credentials;
        final String name = userCredentials.getUsername();
        final char[] password = userCredentials.getPassword().toCharArray();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            GenericUser userPrincipal = new GenericUser(name);
            Subject subject = new Subject(true, Set.of(userPrincipal), Set.of(), Set.of(userCredentials));
            Thread.currentThread().setContextClassLoader(ManagedUserLoginModule.class.getClassLoader());
            LoginContext loginContext = new LoginContext(this.realmName, subject, new CallbackHandler(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void handle(@NonNullByDefault(value={}) Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    Callback[] callbackArray = callbacks;
                    int n = callbacks.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Callback callback = callbackArray[n2];
                        Callback callback2 = callback;
                        if (callback2 instanceof PasswordCallback) {
                            void passwordCallback;
                            PasswordCallback cfr_ignored_0 = (PasswordCallback)callback2;
                            PasswordCallback cfr_ignored_1 = (PasswordCallback)callback2;
                            passwordCallback.setPassword(password);
                        } else {
                            Callback callback3 = callback;
                            if (callback3 instanceof NameCallback) {
                                void nameCallback;
                                NameCallback cfr_ignored_2 = (NameCallback)callback3;
                                NameCallback cfr_ignored_3 = (NameCallback)callback3;
                                nameCallback.setName(name);
                            } else {
                                throw new UnsupportedCallbackException(callback);
                            }
                        }
                        ++n2;
                    }
                }
            }, new ManagedUserLoginConfiguration());
            loginContext.login();
            Authentication authentication = this.getAuthentication(name, loginContext.getSubject());
            return authentication;
        }
        catch (LoginException e) {
            String message = e.getMessage();
            throw new AuthenticationException(message != null ? message : "An unexpected LoginException occurred");
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private Authentication getAuthentication(String name, Subject subject) {
        return new Authentication(name, this.getRoles(subject.getPrincipals()));
    }

    private String[] getRoles(Set<Principal> principals) {
        String[] roles = new String[principals.size()];
        int i = 0;
        for (Principal principal : principals) {
            roles[i++] = principal.getName();
        }
        return roles;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.modified(properties);
    }

    @Deactivate
    protected void deactivate(Map<String, Object> properties) {
    }

    /*
     * WARNING - void declaration
     */
    @Modified
    protected void modified(Map<String, Object> properties) {
        if (properties == null) {
            this.realmName = DEFAULT_REALM;
            return;
        }
        Object propertyValue = properties.get("realmName");
        if (propertyValue != null) {
            Object object = propertyValue;
            if (object instanceof String) {
                void string;
                String string2 = (String)object;
                String cfr_ignored_0 = (String)object;
                this.realmName = string;
            } else {
                this.realmName = propertyValue.toString();
            }
        } else {
            this.realmName = DEFAULT_REALM;
        }
    }

    public boolean supports(Class<? extends Credentials> type) {
        return UsernamePasswordCredentials.class.isAssignableFrom(type);
    }
}

