/*
 * Decompiled with CFR 0.152.
 */
package org.manticore;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.ByteList;

public class Manticore
implements Library {
    public void load(Ruby ruby, boolean bl) {
        RubyModule rubyModule = ruby.defineModule("Manticore");
        RubyClass rubyClass = ruby.defineClassUnder("EntityConverter", ruby.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new EntityConverter(ruby, rubyClass);
            }
        }, rubyModule);
        rubyClass.defineAnnotatedMethods(EntityConverter.class);
    }

    public class EntityConverter
    extends RubyObject {
        public EntityConverter(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod(name={"read_entity"})
        public IRubyObject readEntity(ThreadContext threadContext, IRubyObject iRubyObject, Block block) throws IOException {
            String string;
            HttpEntity httpEntity = (HttpEntity)iRubyObject.toJava(HttpEntity.class);
            String string2 = EntityUtils.getContentCharSet((HttpEntity)httpEntity);
            if (string2 == null) {
                string = EntityUtils.getContentMimeType((HttpEntity)httpEntity);
                string2 = string != null && string.startsWith("application/json") ? "UTF-8" : "ISO-8859-1";
            }
            try {
                string = threadContext.getRuntime().getEncodingService().getEncodingFromString(string2);
            }
            catch (Throwable throwable) {
                string = threadContext.getRuntime().getEncodingService().getEncodingFromString("ISO-8859-1");
            }
            if (block.isGiven()) {
                return this.streamEntity(threadContext, httpEntity, (Encoding)string, block);
            }
            return this.readWholeEntity(threadContext, httpEntity, (Encoding)string);
        }

        private IRubyObject readWholeEntity(ThreadContext threadContext, HttpEntity httpEntity, Encoding encoding) throws IOException {
            ByteList byteList = new ByteList(EntityUtils.toByteArray((HttpEntity)httpEntity), false);
            return RubyString.newString((Ruby)threadContext.getRuntime(), (ByteList)byteList, (Encoding)encoding);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IRubyObject streamEntity(ThreadContext threadContext, HttpEntity httpEntity, Encoding encoding, Block block) throws IOException {
            int n;
            InputStream inputStream = httpEntity.getContent();
            if (inputStream == null) {
                return null;
            }
            String string = EntityUtils.getContentCharSet((HttpEntity)httpEntity);
            if (string == null) {
                string = "ISO-8859-1";
            }
            if ((n = (int)httpEntity.getContentLength()) < 0) {
                n = 4096;
            }
            if (string == null) {
                string = "ISO-8859-1";
            }
            try {
                int n2;
                byte[] byArray = new byte[4096];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    block.call(threadContext, (IRubyObject)RubyString.newStringShared((Ruby)threadContext.getRuntime(), (ByteList)new ByteList(byArray, 0, n2, false), (Encoding)encoding));
                }
            }
            finally {
                inputStream.close();
            }
            return threadContext.nil;
        }
    }
}

