/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.reactor.impl;

import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.impl.CollectorImpl;
import org.apache.qpid.proton.reactor.Task;
import org.apache.qpid.proton.reactor.impl.TaskImpl;

public class Timer {
    private CollectorImpl collector;
    private PriorityQueue<TaskImpl> tasks = new PriorityQueue();
    private AtomicInteger counter = new AtomicInteger();

    public Timer(Collector collector) {
        this.collector = (CollectorImpl)collector;
    }

    Task schedule(long deadline) {
        TaskImpl task = new TaskImpl(deadline, this.counter.incrementAndGet());
        this.tasks.add(task);
        return task;
    }

    long deadline() {
        this.flushCancelled();
        if (this.tasks.size() > 0) {
            Task task = this.tasks.peek();
            return task.deadline();
        }
        return 0L;
    }

    private void flushCancelled() {
        TaskImpl task;
        while (!this.tasks.isEmpty() && (task = this.tasks.peek()).isCancelled()) {
            this.tasks.poll();
        }
    }

    void tick(long now) {
        TaskImpl task;
        while (!this.tasks.isEmpty() && now >= (task = this.tasks.peek()).deadline()) {
            this.tasks.poll();
            if (task.isCancelled()) continue;
            this.collector.put(Event.Type.TIMER_TASK, task);
        }
    }

    int tasks() {
        this.flushCancelled();
        return this.tasks.size();
    }
}

