/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.spi;

import org.hibernate.HibernateException;
import org.hibernate.boot.models.xml.internal.SimpleTypeInterpretation;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.spi.XmlDocument;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.EffectiveMappingDefaults;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.MutableClassDetails;

public interface XmlDocumentContext {
    public XmlDocument getXmlDocument();

    public EffectiveMappingDefaults getEffectiveDefaults();

    public ModelsContext getModelBuildingContext();

    public BootstrapContext getBootstrapContext();

    default public MutableClassDetails resolveJavaType(String name) {
        try {
            return (MutableClassDetails)XmlAnnotationHelper.resolveJavaType(name, this);
        }
        catch (Exception e) {
            HibernateException hibernateException = new HibernateException("Unable to resolve Java type " + name);
            hibernateException.addSuppressed(e);
            throw hibernateException;
        }
    }

    default public String resolveClassName(String specifiedName) {
        SimpleTypeInterpretation simpleTypeInterpretation = SimpleTypeInterpretation.interpret(specifiedName);
        if (simpleTypeInterpretation != null) {
            return simpleTypeInterpretation.getJavaType().getName();
        }
        if (specifiedName.contains(".")) {
            return specifiedName;
        }
        return StringHelper.qualifyConditionallyIfNot(this.getXmlDocument().getDefaults().getPackage(), specifiedName);
    }
}

