/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.table;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class ResultSetTableModel
extends AbstractTableModel {
    private ResultSet rs = null;

    public ResultSetTableModel(@Nullable ResultSet result) {
        this.rs = result;
    }

    public void setRs(ResultSet rs) {
        this.rs = rs;
    }

    @Override
    public int getColumnCount() {
        if (this.rs == null) {
            return 0;
        }
        try {
            for (int i = 0; this.rs.getMetaData() == null && i < 100; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.rs.getMetaData() != null) break;
            }
            if (this.rs.getMetaData() != null) {
                return this.rs.getMetaData().getColumnCount();
            }
            return 0;
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not get the column count from the result set meta data.", e);
        }
    }

    @Override
    public int getRowCount() {
        int newRowCount;
        if (this.rs == null) {
            return 0;
        }
        try {
            int prevRow = this.rs.getRow();
            this.rs.afterLast();
            newRowCount = this.rs.getRow();
            this.rs.absolute(prevRow);
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not access the result set given to the table model", e);
        }
        return newRowCount;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.rs == null) {
            return null;
        }
        try {
            int prevRow = this.rs.getRow();
            this.rs.absolute(rowIndex + 1);
            Object objectAtPosition = this.rs.getObject(columnIndex + 1);
            this.rs.absolute(prevRow);
            return objectAtPosition;
        }
        catch (SQLException e) {
            throw new RuntimeException(" Could not access the result set given the rowIndex or columnIndex.", e);
        }
    }

    @Override
    public int findColumn(String columnName) {
        if (this.rs == null) {
            return -1;
        }
        try {
            for (int i = 0; i < this.rs.getMetaData().getColumnCount(); ++i) {
                if (!this.rs.getMetaData().getColumnName(i).equals(columnName)) continue;
                return i;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not access the result set.", e);
        }
        return -1;
    }

    @Override
    public String getColumnName(int column) {
        if (this.rs == null) {
            return "";
        }
        try {
            String colName = this.rs.getMetaData().getColumnLabel(column + 1);
            if (colName == null || colName.equals("")) {
                colName = this.rs.getMetaData().getColumnName(column + 1);
            }
            return colName;
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not get the column name.", e);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        int columnType;
        if (this.rs == null) {
            return Object.class;
        }
        try {
            if (columnIndex < 0 || columnIndex >= this.rs.getMetaData().getColumnCount()) {
                return Object.class;
            }
        }
        catch (SQLException e1) {
            throw new RuntimeException(e1);
        }
        try {
            columnType = this.rs.getMetaData().getColumnType(columnIndex + 1);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (columnType == 12) {
            return String.class;
        }
        if (columnType == -7 || columnType == 4 || columnType == 5 || columnType == -6) {
            return Integer.class;
        }
        if (columnType == 3 || columnType == 8 || columnType == 2) {
            return Double.class;
        }
        if (columnType == 6) {
            return Float.class;
        }
        return Object.class;
    }

    public void dataChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("A call to a UI update was sent from a thread other than the event dispatch thread. See ResultSetTableModel.");
        }
        this.fireTableDataChanged();
    }

    public boolean isRsPresent() {
        return this.rs != null;
    }
}

