/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer;

import java.io.Serializable;
import java.util.Comparator;
import org.graalvm.visualvm.lib.profiler.snaptracer.ClassNameComparator;

public interface Positionable {
    public static final int POSITION_AT_THE_END = 0x7FFFFFFE;
    public static final int POSITION_LAST = Integer.MAX_VALUE;
    public static final Comparator COMPARATOR = new PositionableComparator();
    public static final Comparator STRONG_COMPARATOR = new StrongPositionableComparator();

    public int getPreferredPosition();

    public static final class StrongPositionableComparator
    implements Comparator,
    Serializable {
        public int compare(Object o1, Object o2) {
            int position2;
            Positionable p1 = (Positionable)o1;
            Positionable p2 = (Positionable)o2;
            int position1 = p1.getPreferredPosition();
            if (position1 > (position2 = p2.getPreferredPosition())) {
                return 1;
            }
            if (position1 < position2) {
                return -1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            int result = ClassNameComparator.INSTANCE.compare(o1, o2);
            if (result != 0) {
                return result;
            }
            result = Integer.valueOf(System.identityHashCode(o1)).compareTo(System.identityHashCode(o2));
            if (result != 0) {
                return result;
            }
            result = Integer.valueOf(o1.hashCode()).compareTo(o2.hashCode());
            if (result != 0) {
                return result;
            }
            return -1;
        }
    }

    public static final class PositionableComparator
    implements Comparator,
    Serializable {
        public int compare(Object o1, Object o2) {
            int position2;
            Positionable p1 = (Positionable)o1;
            Positionable p2 = (Positionable)o2;
            int position1 = p1.getPreferredPosition();
            if (position1 == (position2 = p2.getPreferredPosition())) {
                return 0;
            }
            if (position1 > position2) {
                return 1;
            }
            return -1;
        }
    }
}

