/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.spreadsheet;

import com.projectlibre1.datatype.Hyperlink;
import com.projectlibre1.dialog.ResourceAdditionDialog;
import com.projectlibre1.field.Field;
import com.projectlibre1.graphic.configuration.ActionList;
import com.projectlibre1.graphic.configuration.CellStyle;
import com.projectlibre1.graphic.configuration.GraphicConfiguration;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.NodeBridge;
import com.projectlibre1.grouping.core.NodeFactory;
import com.projectlibre1.job.Job;
import com.projectlibre1.job.JobRunnable;
import com.projectlibre1.options.GeneralOption;
import com.projectlibre1.pm.graphic.frames.GraphicManager;
import com.projectlibre1.pm.graphic.model.cache.GraphicNode;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCache;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheetColumnModel;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheetPopupMenu;
import com.projectlibre1.pm.graphic.spreadsheet.common.CommonSpreadSheet;
import com.projectlibre1.pm.graphic.spreadsheet.common.CommonSpreadSheetAction;
import com.projectlibre1.pm.graphic.spreadsheet.common.CommonSpreadSheetModel;
import com.projectlibre1.pm.graphic.spreadsheet.common.transfer.NodeListTransferHandler;
import com.projectlibre1.pm.graphic.spreadsheet.editor.SimpleComboBoxEditor;
import com.projectlibre1.pm.graphic.spreadsheet.renderer.NameCellComponent;
import com.projectlibre1.pm.graphic.spreadsheet.selection.SpreadSheetListSelectionModel;
import com.projectlibre1.pm.graphic.spreadsheet.selection.SpreadSheetSelectionModel;
import com.projectlibre1.pm.graphic.spreadsheet.selection.event.HeaderMouseListener;
import com.projectlibre1.pm.resource.ResourceImpl;
import com.projectlibre1.pm.resource.ResourcePool;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.server.data.EnterpriseResourceData;
import com.projectlibre1.server.data.SerializedDataObject;
import com.projectlibre1.server.data.Serializer;
import com.projectlibre1.session.Session;
import com.projectlibre1.session.SessionFactory;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.Alert;
import com.projectlibre1.util.BrowserControl;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.collections.Closure;

public class SpreadSheet
extends CommonSpreadSheet
implements Cloneable {
    private static final long serialVersionUID = 5958334223191182318L;
    protected SpreadSheetPopupMenu popup = null;
    private String[] actionList = null;
    private Map actionMap = null;
    protected SpreadSheetAction indentAction = new SpreadSheetAction("Spreadsheet.Action.indent", this){

        @Override
        public void execute() {
            SpreadSheet.this.finishCurrentOperations();
            this.getCache().indentNodes(this.getSelected());
        }
    };
    protected SpreadSheetAction outdentAction = new SpreadSheetAction("Spreadsheet.Action.outdent", this){

        @Override
        public void execute() {
            SpreadSheet.this.finishCurrentOperations();
            this.getCache().outdentNodes(this.getSelected());
        }
    };
    protected SpreadSheetAction newAction = new SpreadSheetAction("Spreadsheet.Action.new", this){

        @Override
        public void execute() {
            List list = this.getSelected();
            if (list == null || list.size() == 0) {
                int n = SpreadSheet.this.getCurrentRow();
                if (n == -1) {
                    return;
                }
                this.getCache().newNode((GraphicNode)this.getCache().getElementAt(n));
            } else {
                this.getCache().newNode((GraphicNode)list.get(list.size() - 1));
            }
        }
    };
    protected SpreadSheetAction newResourceAction = new SpreadSheetAction("Spreadsheet.Action.new", this){

        @Override
        public void execute() {
            List list = this.getSelected();
            final ResourcePool resourcePool = (ResourcePool)this.getCache().getModel().getDataFactory();
            Project project = (Project)resourcePool.getProjects().get(0);
            if (list == null || list.size() == 0) {
                return;
            }
            ArrayList arrayList = new ArrayList();
            Session session = SessionFactory.getInstance().getSession(false);
            Job job = (Job)SessionFactory.callNoEx(session, "getLoadProjectDescriptorsJob", new Class[]{Boolean.TYPE, List.class, Boolean.TYPE}, new Object[]{true, arrayList, true});
            job.addSwingRunnable(new JobRunnable(this, "Local: addNodes"){
                final /* synthetic */ 7 this$1;
                {
                    this.this$1 = var1_1;
                    super(string);
                }

                @Override
                public Object run() throws Exception {
                    Closure closure = new Closure(this){

                        @Override
                        public void execute(Object object) {
                        }
                    };
                    Closure closure2 = new Closure(){

                        @Override
                        public void execute(Object object) {
                            ResourceAdditionDialog.Form form = (ResourceAdditionDialog.Form)object;
                            ArrayList<Node> arrayList = new ArrayList<Node>();
                            Iterator iterator = form.getSelectedResources().iterator();
                            while (iterator.hasNext()) {
                                try {
                                    arrayList.add(NodeFactory.getInstance().createNode(Serializer.deserializeResourceAndAddToPool((EnterpriseResourceData)iterator.next(), resourcePool, null)));
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    classNotFoundException.printStackTrace();
                                }
                            }
                            this$1.getCache().addNodes(((GraphicNode)this$1.getSelected().get(0)).getNode(), arrayList);
                            this$1.getCache().update();
                        }
                    };
                    ResourceAdditionDialog.Form form = new ResourceAdditionDialog.Form();
                    try {
                        Object object2;
                        List list = (List)SessionFactory.call(SessionFactory.getInstance().getSession(false), "retrieveResourceDescriptors", null, null);
                        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
                        for (Object object2 : list) {
                            hashMap.put(new Long(((SerializedDataObject)object2).getUniqueId()), object2);
                        }
                        ArrayList arrayList = resourcePool.getResourceList();
                        object2 = arrayList.iterator();
                        while (object2.hasNext()) {
                            ResourceImpl resourceImpl = (ResourceImpl)object2.next();
                            Long l = new Long(resourceImpl.getUniqueId());
                            if (!hashMap.containsKey(l)) continue;
                            hashMap.remove(l);
                        }
                        form.getSelectedResources().addAll(hashMap.values());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ResourceAdditionDialog.getInstance((JFrame)SwingUtilities.getRoot(this.this$1.SpreadSheet.this), form).execute(closure, closure2);
                    return null;
                }
            });
            session.schedule(job);
        }
    };
    protected SpreadSheetAction deleteAction = new SpreadSheetAction("Spreadsheet.Action.delete", this){
        private static final long serialVersionUID = 1561847977122331970L;

        @Override
        public void execute() {
            SpreadSheet.this.finishCurrentOperations();
            List list = SpreadSheet.this.getSelectedDeletableRows();
            if (list.isEmpty()) {
                return;
            }
            if (!GeneralOption.getInstance().isConfirmDeletes() || Alert.okCancel(Messages.getString("Message.confirmDeleteRows"))) {
                this.getCache().deleteNodes(list);
            }
        }
    };
    protected SpreadSheetAction cutAction = new SpreadSheetAction("Spreadsheet.Action.cut", this){
        private static final long serialVersionUID = -7928292866527615772L;

        @Override
        public void execute() {
            SpreadSheet.this.finishCurrentOperations();
            this.execute(SpreadSheet.this.getSelectedRows());
        }

        @Override
        public void execute(Object object) {
            if (object != null && object instanceof List) {
                SpreadSheet.this.finishCurrentOperations();
                List list = SpreadSheet.this.getSelectedCuttableRows((List)object);
                if (list.isEmpty()) {
                    return;
                }
                this.executeFirst();
                this.getCache().cutNodes(list);
            }
        }
    };
    protected SpreadSheetAction copyAction = new SpreadSheetAction("Spreadsheet.Action.copy", this){
        private static final long serialVersionUID = -7593036949653490043L;

        @Override
        public void execute() {
            this.execute(SpreadSheet.this.getSelectedNodes());
        }

        @Override
        public void execute(Object object) {
            if (object != null && object instanceof List) {
                SpreadSheet.this.finishCurrentOperations();
                List list = (List)object;
                this.executeFirst();
                this.getCache().copyNodes(list);
            }
        }
    };
    protected SpreadSheetAction pasteAction = new SpreadSheetAction("Spreadsheet.Action.paste", this){
        private static final long serialVersionUID = 5904764895696983803L;

        @Override
        public void execute() {
            this.execute(SpreadSheet.this.getSelectedNodes());
        }

        @Override
        public void execute(Object object) {
            if (object != null && object instanceof List) {
                Object object2;
                SpreadSheet.this.finishCurrentOperations();
                ArrayList arrayList = SpreadSheet.this.getSelectedNodes();
                Node node = null;
                int n = 0;
                if (arrayList.size() > 0) {
                    object2 = (Node)arrayList.get(0);
                    node = (Node)object2.getParent();
                    n = ((NodeBridge)node).getIndex((TreeNode)object2);
                }
                object2 = (List)object;
                this.executeFirst();
                this.spreadSheet.clearSelection();
                this.getCache().pasteNodes(node, (List)object2, n);
            }
        }
    };
    protected SpreadSheetAction expandAction = new SpreadSheetAction("Spreadsheet.Action.expand", this){

        @Override
        public void execute() {
            SpreadSheet.this.finishCurrentOperations();
            this.getCache().expandNodes(this.getSelected(), true);
        }
    };
    protected SpreadSheetAction collapseAction = new SpreadSheetAction("Spreadsheet.Action.collapse", this){

        @Override
        public void execute() {
            SpreadSheet.this.finishCurrentOperations();
            this.getCache().expandNodes(this.getSelected(), false);
        }
    };

    public SpreadSheet() {
        NodeListTransferHandler.registerWith(this);
    }

    protected void finalize() {
        System.out.println("SpreadSheet.finalize()" + String.valueOf(this));
    }

    @Override
    public void cleanUp() {
        if (this.getModel() instanceof CommonSpreadSheetModel) {
            ((CommonSpreadSheetModel)this.getModel()).getCache().removeNodeModelListener(this);
        }
        super.cleanUp();
    }

    public void setCache(NodeModelCache nodeModelCache, ArrayList arrayList, CellStyle cellStyle, ActionList actionList) {
        TableColumnModel tableColumnModel;
        if (this.getCache() != null) {
            this.getCache().getReference().close();
        }
        SpreadSheetColumnModel spreadSheetColumnModel = (tableColumnModel = this.getColumnModel()) != null && tableColumnModel instanceof SpreadSheetColumnModel ? (((SpreadSheetColumnModel)tableColumnModel).getFieldArray() == arrayList ? (SpreadSheetColumnModel)tableColumnModel : new SpreadSheetColumnModel(arrayList)) : new SpreadSheetColumnModel(arrayList);
        this.setModel(new SpreadSheetModel(nodeModelCache, spreadSheetColumnModel, cellStyle, actionList), spreadSheetColumnModel == tableColumnModel ? null : spreadSheetColumnModel);
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        SpreadSheetModel spreadSheetModel = (SpreadSheetModel)this.getModel();
        Field field = spreadSheetModel.getFieldInColumn(n2 + 1);
        GraphicNode graphicNode = spreadSheetModel.getNode(n);
        if (field != null && (field.isDynamicOptions() || field.hasFilter())) {
            return new SimpleComboBoxEditor(new DefaultComboBoxModel<Object>(field.getOptions(graphicNode.getNode().getImpl())));
        }
        return super.getCellEditor(n, n2);
    }

    @Override
    public void setFieldArray(ArrayList arrayList) {
        ((SpreadSheetColumnModel)this.getColumnModel()).setFieldArray(arrayList);
        this.createDefaultColumnsFromModel(arrayList);
        this.resizeAndRepaintHeader();
    }

    @Override
    public void resizeAndRepaintHeader() {
        JTableHeader jTableHeader = this.getTableHeader();
        SpreadSheetColumnModel spreadSheetColumnModel = (SpreadSheetColumnModel)this.getColumnModel();
        int n = spreadSheetColumnModel.getColWidth();
        jTableHeader.setPreferredSize(new Dimension(n, jTableHeader.getPreferredSize().height));
        jTableHeader.resizeAndRepaint();
    }

    public void createDefaultColumnsFromModel(ArrayList arrayList) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        while (tableColumnModel.getColumnCount() > 0) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = new TableColumn(i);
            this.addColumn(tableColumn);
        }
    }

    private void makeCustomTableHeader(TableColumnModel tableColumnModel) {
        JTableHeader jTableHeader = new JTableHeader(tableColumnModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                if (SpreadSheet.this.isHasColumnHeaderPopup()) {
                    int n = this.columnAtPoint(mouseEvent.getPoint());
                    Field field = ((SpreadSheetModel)SpreadSheet.this.getModel()).getFieldInNonTranslatedColumn(n + 1);
                    if (field != null) {
                        return "<html>" + field.getName() + "<br>" + Messages.getString("Text.rightClickToInsertRemoveColumns") + "</html>";
                    }
                }
                return super.getToolTipText(mouseEvent);
            }
        };
        this.setTableHeader(jTableHeader);
    }

    public SpreadSheetPopupMenu getPopup() {
        if (this.popup == null) {
            this.popup = this.hasRowPopup() ? new SpreadSheetPopupMenu(this) : null;
        }
        return this.popup;
    }

    public void setModel(SpreadSheetModel spreadSheetModel, SpreadSheetColumnModel spreadSheetColumnModel) {
        this.makeCustomTableHeader(spreadSheetColumnModel);
        TableModel tableModel = this.getModel();
        this.setModel(spreadSheetModel);
        if (spreadSheetColumnModel != null) {
            this.setColumnModel(spreadSheetColumnModel);
            this.selection = new SpreadSheetSelectionModel(this);
            this.selection.setRowSelection(new SpreadSheetListSelectionModel(this.selection, true));
            this.selection.setColumnSelection(new SpreadSheetListSelectionModel(this.selection, false));
            this.setSelectionModel(this.selection.getRowSelection());
            this.createDefaultColumnsFromModel(spreadSheetModel.getFieldArray());
            this.getColumnModel().setSelectionModel(this.selection.getColumnSelection());
        }
        this.registerEditors();
        this.initRowHeader(spreadSheetModel);
        this.initModel();
        this.initListeners();
        GraphicConfiguration graphicConfiguration = GraphicConfiguration.getInstance();
        this.setTableHeader(this.createDefaultTableHeader());
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setPreferredSize(new Dimension((int)jTableHeader.getPreferredSize().getWidth(), graphicConfiguration.getColumnHeaderHeight()));
        jTableHeader.addMouseListener(new HeaderMouseListener(this));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = SpreadSheet.this.rowAtPoint(point);
                int n2 = SpreadSheet.this.columnAtPoint(point);
                SpreadSheetPopupMenu spreadSheetPopupMenu = SpreadSheet.this.getPopup();
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    Hyperlink hyperlink;
                    SpreadSheetColumnModel spreadSheetColumnModel = (SpreadSheetColumnModel)SpreadSheet.this.getColumnModel();
                    Field field = ((SpreadSheetModel)SpreadSheet.this.getModel()).getFieldInNonTranslatedColumn(n2 + 1);
                    SpreadSheetModel spreadSheetModel = (SpreadSheetModel)SpreadSheet.this.getModel();
                    if (field.isNameField()) {
                        GraphicNode graphicNode = spreadSheetModel.getNode(n);
                        if (SpreadSheet.this.isOnIcon(mouseEvent) && spreadSheetModel.getCellProperties(graphicNode).isCompositeIcon()) {
                            SpreadSheet.this.finishCurrentOperations();
                            SpreadSheet.this.selection.getRowSelection().clearSelection();
                            boolean bl = true;
                            if (!graphicNode.isFetched()) {
                                bl = graphicNode.fetch();
                            }
                            if (bl) {
                                spreadSheetModel.changeCollapsedState(n);
                            }
                            mouseEvent.consume();
                        }
                    } else if (field != null && field.isHyperlink() && (hyperlink = (Hyperlink)spreadSheetModel.getValueAt(n, n2 + 1)) != null) {
                        BrowserControl.displayURL(hyperlink.getAddress());
                        mouseEvent.consume();
                    }
                    if (!mouseEvent.isConsumed()) {
                        if (mouseEvent.getClickCount() == 2) {
                            SpreadSheet.this.doDoubleClick(n, n2);
                        } else {
                            SpreadSheet.this.doClick(n, n2);
                        }
                    }
                } else if (spreadSheetPopupMenu != null && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    spreadSheetPopupMenu.setRow(n);
                    spreadSheetPopupMenu.setCol(n2);
                    spreadSheetPopupMenu.show(SpreadSheet.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        if (tableModel != spreadSheetModel && tableModel instanceof CommonSpreadSheetModel) {
            ((CommonSpreadSheetModel)this.getModel()).getCache().removeNodeModelListener(this);
        }
        spreadSheetModel.getCache().addNodeModelListener(this);
    }

    public void doDoubleClick(int n, int n2) {
        GraphicManager.getInstance(this).doInformationDialog(false);
    }

    public void doClick(int n, int n2) {
    }

    public boolean isOnIcon(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        Rectangle rectangle = this.getCellRect(n, n2, false);
        SpreadSheetModel spreadSheetModel = (SpreadSheetModel)this.getModel();
        GraphicNode graphicNode = spreadSheetModel.getNode(n);
        return NameCellComponent.isOnIcon(new Point((int)(point.getX() - rectangle.getX()), (int)(point.getY() - rectangle.getY())), rectangle.getSize(), spreadSheetModel.getCache().getLevel(graphicNode));
    }

    public boolean isOnText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        Rectangle rectangle = this.getCellRect(n, n2, false);
        SpreadSheetModel spreadSheetModel = (SpreadSheetModel)this.getModel();
        GraphicNode graphicNode = spreadSheetModel.getNode(n);
        return NameCellComponent.isOnText(new Point((int)(point.getX() - rectangle.getX()), (int)(point.getY() - rectangle.getY())), rectangle.getSize(), spreadSheetModel.getCache().getLevel(graphicNode));
    }

    public void updateNameCellEditor(GraphicNode graphicNode) {
        SpreadSheetColumnModel spreadSheetColumnModel = (SpreadSheetColumnModel)this.getColumnModel();
        if (this.isEditing() && this.editorComp != null && ((SpreadSheetModel)this.getModel()).getFieldInColumn(this.getEditingColumn() + 1).isNameField()) {
            NameCellComponent nameCellComponent = (NameCellComponent)this.editorComp;
            SpreadSheetModel spreadSheetModel = (SpreadSheetModel)this.getModel();
            if (spreadSheetModel.getCellProperties(graphicNode).isCompositeIcon()) {
                nameCellComponent.setCollapsed(graphicNode.isCollapsed());
            }
        }
    }

    @Override
    protected void initListeners() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = SpreadSheet.this.getSelectedRow();
                if (n < 0) {
                    return;
                }
                CommonSpreadSheetModel commonSpreadSheetModel = (CommonSpreadSheetModel)SpreadSheet.this.getModel();
                if (keyEvent.getKeyCode() == 155) {
                    SpreadSheet.this.executeAction("InsertTask");
                } else if (keyEvent.getKeyCode() == 127) {
                    SpreadSheet.this.executeAction("Delete");
                } else if (keyEvent.getKeyCode() == 114) {
                    GraphicManager.getInstance().doFind(SpreadSheet.this, null);
                } else if (keyEvent.getKeyCode() == 70 && keyEvent.getModifiers() == 2) {
                    GraphicManager.getInstance().doFind(SpreadSheet.this, null);
                }
            }
        });
    }

    public List getSelectedGraphicNodes() {
        return this.rowsToGraphicNodes(this.getSelectedRows());
    }

    public List rowsToGraphicNodes(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return new LinkedList();
        }
        NodeModelCache nodeModelCache = ((SpreadSheetModel)this.getModel()).getCache();
        return nodeModelCache.getElementsAt(nArray);
    }

    public void executeAction(String string) {
        CommonSpreadSheetAction commonSpreadSheetAction = this.getAction(string);
        if (commonSpreadSheetAction == null) {
            System.out.println("No action for " + string);
            return;
        }
        commonSpreadSheetAction.setSpreadSheet(this);
        commonSpreadSheetAction.execute();
    }

    public CommonSpreadSheetAction prepareAction(String string) {
        CommonSpreadSheetAction commonSpreadSheetAction = this.getAction(string);
        commonSpreadSheetAction.setSpreadSheet(this);
        return commonSpreadSheetAction;
    }

    public String[] getActionList() {
        if (this.actionList == null) {
            this.actionList = ((SpreadSheetModel)this.getModel()).getActionList();
        }
        return this.actionList;
    }

    public CommonSpreadSheetAction getAction(String string) {
        if (this.actionMap == null) {
            this.actionMap = new HashMap();
            this.addActions(this.getActionList());
        }
        return (CommonSpreadSheetAction)this.actionMap.get(string);
    }

    private void addAction(String string, String string2, CommonSpreadSheetAction commonSpreadSheetAction) {
        if (string2.equals(string)) {
            this.actionMap.put(string2, commonSpreadSheetAction);
        }
    }

    private void addActions(String[] stringArray) {
        NodeListTransferHandler nodeListTransferHandler = null;
        if (this.getTransferHandler() instanceof NodeListTransferHandler) {
            nodeListTransferHandler = (NodeListTransferHandler)this.getTransferHandler();
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                this.addAction(string, "Indent", this.indentAction);
                this.addAction(string, "Outdent", this.outdentAction);
                this.addAction(string, "InsertTask", this.newAction);
                this.addAction(string, "Delete", this.deleteAction);
                if (nodeListTransferHandler != null) {
                    this.addAction(string, "Copy", nodeListTransferHandler.getNodeListCopyAction());
                    this.addAction(string, "Cut", nodeListTransferHandler.getNodeListCutAction());
                    this.addAction(string, "Paste", nodeListTransferHandler.getNodeListPasteAction());
                }
                this.addAction(string, "Expand", this.expandAction);
                this.addAction(string, "Collapse", this.collapseAction);
            }
        }
    }

    public void clearActions() {
        this.actionMap = null;
        this.actionList = null;
        this.popup = null;
        ((CommonSpreadSheetModel)this.getModel()).clearActions();
    }

    public void setActions(String[] stringArray) {
        this.actionList = stringArray;
        if (this.actionMap == null) {
            this.actionMap = new HashMap();
        } else {
            this.actionMap.clear();
        }
        this.addActions(stringArray);
    }

    public void setActions(String string) {
        this.addActions(CommonSpreadSheetModel.convertActions(string));
    }

    public boolean isReadOnly() {
        return ((SpreadSheetModel)this.getModel()).isReadOnly();
    }

    public void setReadOnly(boolean bl) {
        ((SpreadSheetModel)this.getModel()).setReadOnly(bl);
    }

    public boolean hasRowPopup() {
        this.getAction(null);
        return this.actionMap != null && this.actionMap.size() > 0;
    }

    public SpreadSheetAction getCopyAction() {
        return this.copyAction;
    }

    public SpreadSheetAction getCutAction() {
        return this.cutAction;
    }

    public SpreadSheetAction getPasteAction() {
        return this.pasteAction;
    }

    public static abstract class SpreadSheetAction
    extends AbstractAction
    implements Closure,
    CommonSpreadSheetAction {
        protected SpreadSheet spreadSheet;
        protected int[] rows;

        public SpreadSheetAction(String string, SpreadSheet spreadSheet) {
            super(Messages.getString(string));
            this.spreadSheet = spreadSheet;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.execute();
        }

        public void executeFirst() {
            this.rows = this.spreadSheet.finishCurrentOperations();
        }

        @Override
        public void execute(Object object) {
            this.executeFirst();
            this.execute();
        }

        @Override
        public abstract void execute();

        @Override
        public CommonSpreadSheet getSpreadSheet() {
            return this.spreadSheet;
        }

        @Override
        public void setSpreadSheet(CommonSpreadSheet commonSpreadSheet) {
            this.spreadSheet = (SpreadSheet)commonSpreadSheet;
        }

        public NodeModelCache getCache() {
            return ((SpreadSheetModel)this.spreadSheet.getModel()).getCache();
        }

        public List getSelected() {
            return this.spreadSheet.rowsToGraphicNodes(this.rows == null ? this.spreadSheet.getSelectedRows() : this.rows);
        }
    }
}

