/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opencl.gl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.PointerBuffer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL10GL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLDeviceCapabilities;
import org.lwjgl.opencl.CLEvent;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLObject;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.KHRGLEvent;
import org.lwjgl.opencl.api.Filter;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.AMDDebugOutputCallback;
import org.lwjgl.opengl.ARBCLEvent;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.ARBDebugOutputCallback;
import org.lwjgl.opengl.ARBSync;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.GLSync;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class DemoFractal {
    private static final int MAX_PARALLELISM_LEVEL = 8;
    private static final int COLOR_MAP_SIZE = 256;
    private Set<String> params;
    private CLContext clContext;
    private CLCommandQueue[] queues;
    private CLKernel[] kernels;
    private CLProgram[] programs;
    private CLMem[] glBuffers;
    private IntBuffer glIDs;
    private boolean useTextures;
    private int dlist;
    private int vsh;
    private int fsh;
    private int program;
    private CLMem[] colorMap;
    private final PointerBuffer kernel2DGlobalWorkSize;
    private int maxIterations = 500;
    private int width = 512;
    private int height = 512;
    private double minX = -2.0;
    private double minY = -1.2f;
    private double maxX = 0.6f;
    private double maxY = 1.3f;
    private boolean dragging;
    private double dragX;
    private double dragY;
    private double dragMinX;
    private double dragMinY;
    private double dragMaxX;
    private double dragMaxY;
    private int mouseX;
    private int mouseY;
    private int slices;
    private boolean drawSeparator;
    private boolean doublePrecision = true;
    private boolean buffersInitialized;
    private boolean rebuild;
    private boolean run = true;
    private final PointerBuffer syncBuffer = BufferUtils.createPointerBuffer((int)1);
    private boolean syncGLtoCL;
    private CLEvent[] clEvents;
    private GLSync[] clSyncs;
    private boolean syncCLtoGL;
    private GLSync glSync;
    private CLEvent glEvent;

    public DemoFractal(String[] args) {
        this.params = new HashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.charAt(0) != '-' && arg.charAt(0) != '/') {
                throw new IllegalArgumentException("Invalid command-line argument: " + args[i]);
            }
            String param = arg.substring(1);
            if ("forcePBO".equalsIgnoreCase(param)) {
                this.params.add("forcePBO");
                continue;
            }
            if ("forceCPU".equalsIgnoreCase(param)) {
                this.params.add("forceCPU");
                continue;
            }
            if ("debugGL".equalsIgnoreCase(param)) {
                this.params.add("debugGL");
                continue;
            }
            if ("iterations".equalsIgnoreCase(param)) {
                if (args.length < i + 1 + 1) {
                    throw new IllegalArgumentException("Invalid iterations argument specified.");
                }
                try {
                    this.maxIterations = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid number of iterations specified.");
                }
            }
            if (!"res".equalsIgnoreCase(param)) continue;
            if (args.length < i + 2 + 1) {
                throw new IllegalArgumentException("Invalid res argument specified.");
            }
            try {
                this.width = Integer.parseInt(args[++i]);
                this.height = Integer.parseInt(args[++i]);
                if (this.width >= 1 && this.height >= 1) continue;
                throw new IllegalArgumentException("Invalid res dimensions specified.");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid res dimensions specified.");
            }
        }
        this.kernel2DGlobalWorkSize = BufferUtils.createPointerBuffer((int)2);
    }

    public static void main(String[] args) {
        DemoFractal demo = new DemoFractal(args);
        demo.init();
        demo.run();
    }

    public void init() {
        try {
            CL.create();
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.width, this.height));
            Display.setTitle((String)"OpenCL Fractal Demo");
            Display.setSwapInterval((int)0);
            Display.create((PixelFormat)new PixelFormat(), (ContextAttribs)new ContextAttribs().withDebug(this.params.contains("debugGL")));
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        try {
            this.initCL(Display.getDrawable());
        }
        catch (Exception e) {
            if (this.clContext != null) {
                CL10.clReleaseContext((CLContext)this.clContext);
            }
            Display.destroy();
            throw new RuntimeException(e);
        }
        GL11.glDisable((int)2929);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        DemoFractal.initView(Display.getDisplayMode().getWidth(), Display.getDisplayMode().getHeight());
        this.initGLObjects();
        GL11.glFinish();
        this.setKernelConstants();
    }

    private void initCL(Drawable drawable) throws Exception {
        List platforms = CLPlatform.getPlatforms();
        if (platforms == null) {
            throw new RuntimeException("No OpenCL platforms found.");
        }
        CLPlatform platform = (CLPlatform)platforms.get(0);
        Filter<CLDevice> glSharingFilter = new Filter<CLDevice>(){

            public boolean accept(CLDevice device) {
                CLDeviceCapabilities caps = CLCapabilities.getDeviceCapabilities((CLDevice)device);
                return caps.CL_KHR_gl_sharing;
            }
        };
        int device_type = this.params.contains("forceCPU") ? 2 : 4;
        List devices = platform.getDevices(device_type, (Filter)glSharingFilter);
        if (devices == null && (devices = platform.getDevices(device_type = 2, (Filter)glSharingFilter)) == null) {
            throw new RuntimeException("No OpenCL devices found with KHR_gl_sharing support.");
        }
        this.clContext = CLContext.create((CLPlatform)platform, (List)devices, (CLContextCallback)new CLContextCallback(){

            protected void handleMessage(String errinfo, ByteBuffer private_info) {
                System.out.println("[CONTEXT MESSAGE] " + errinfo);
            }
        }, (Drawable)drawable, null);
        this.slices = Math.min(devices.size(), 8);
        this.queues = new CLCommandQueue[this.slices];
        this.kernels = new CLKernel[this.slices];
        this.colorMap = new CLMem[this.slices];
        for (int i = 0; i < this.slices; ++i) {
            this.colorMap[i] = CL10.clCreateBuffer((CLContext)this.clContext, (long)4L, (long)256L, null);
            this.colorMap[i].checkValid();
            this.queues[i] = CL10.clCreateCommandQueue((CLContext)this.clContext, (CLDevice)((CLDevice)devices.get(i)), (long)2L, null);
            this.queues[i].checkValid();
            ByteBuffer colorMapBuffer = CL10.clEnqueueMapBuffer((CLCommandQueue)this.queues[i], (CLMem)this.colorMap[i], (int)1, (long)2L, (long)0L, (long)256L, null, null, null);
            DemoFractal.initColorMap(colorMapBuffer.asIntBuffer(), 32, Color.BLUE, Color.GREEN, Color.RED);
            CL10.clEnqueueUnmapMemObject((CLCommandQueue)this.queues[i], (CLMem)this.colorMap[i], (ByteBuffer)colorMapBuffer, null, null);
        }
        boolean all64bit = true;
        for (CLDevice device : devices) {
            if (DemoFractal.isDoubleFPAvailable(device)) continue;
            all64bit = false;
            break;
        }
        this.programs = new CLProgram[all64bit ? 1 : this.slices];
        ContextCapabilities caps = GLContext.getCapabilities();
        if (!caps.OpenGL20) {
            throw new RuntimeException("OpenGL 2.0 is required to run this demo.");
        }
        if (device_type == 2 && !caps.OpenGL21) {
            throw new RuntimeException("OpenGL 2.1 is required to run this demo.");
        }
        if (this.params.contains("debugGL")) {
            if (caps.GL_ARB_debug_output) {
                ARBDebugOutput.glDebugMessageCallbackARB((ARBDebugOutputCallback)new ARBDebugOutputCallback());
            } else if (caps.GL_AMD_debug_output) {
                AMDDebugOutput.glDebugMessageCallbackAMD((AMDDebugOutputCallback)new AMDDebugOutputCallback());
            }
        }
        if (device_type == 4) {
            System.out.println("OpenCL Device Type: GPU (Use -forceCPU to use CPU)");
        } else {
            System.out.println("OpenCL Device Type: CPU");
        }
        for (int i = 0; i < devices.size(); ++i) {
            System.out.println("OpenCL Device #" + (i + 1) + " supports KHR_gl_event = " + CLCapabilities.getDeviceCapabilities((CLDevice)((CLDevice)devices.get((int)i))).CL_KHR_gl_event);
        }
        System.out.println("\nMax Iterations: " + this.maxIterations + " (Use -iterations <count> to change)");
        System.out.println("Display resolution: " + this.width + "x" + this.height + " (Use -res <width> <height> to change)");
        System.out.println("\nOpenGL caps.GL_ARB_sync = " + caps.GL_ARB_sync);
        System.out.println("OpenGL caps.GL_ARB_cl_event = " + caps.GL_ARB_cl_event);
        boolean bl = this.useTextures = device_type == 4 && (!caps.OpenGL21 || !this.params.contains("forcePBO"));
        if (this.useTextures) {
            System.out.println("\nCL/GL Sharing method: TEXTURES (use -forcePBO to use PBO + DrawPixels)");
            System.out.println("Rendering method: Shader on a fullscreen quad");
        } else {
            System.out.println("\nCL/GL Sharing method: PIXEL BUFFER OBJECTS");
            System.out.println("Rendering method: DrawPixels");
        }
        this.buildPrograms();
        this.syncGLtoCL = caps.GL_ARB_cl_event;
        if (this.syncGLtoCL) {
            this.clEvents = new CLEvent[this.slices];
            this.clSyncs = new GLSync[this.slices];
            System.out.println("\nGL to CL sync: Using OpenCL events");
        } else {
            System.out.println("\nGL to CL sync: Using clFinish");
        }
        boolean bl2 = this.syncCLtoGL = caps.OpenGL32 || caps.GL_ARB_sync;
        if (this.syncCLtoGL) {
            for (CLDevice device : devices) {
                if (CLCapabilities.getDeviceCapabilities((CLDevice)device).CL_KHR_gl_event) continue;
                this.syncCLtoGL = false;
                break;
            }
        }
        if (this.syncCLtoGL) {
            System.out.println("CL to GL sync: Using OpenGL sync objects");
        } else {
            System.out.println("CL to GL sync: Using glFinish");
        }
        if (this.useTextures) {
            this.dlist = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.dlist, (int)4864);
            GL11.glBegin((int)7);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex2f((float)0.0f, (float)0.0f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex2i((int)0, (int)this.height);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex2f((float)this.width, (float)this.height);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex2f((float)this.width, (float)0.0f);
            GL11.glEnd();
            GL11.glEndList();
            this.vsh = GL20.glCreateShader((int)35633);
            GL20.glShaderSource((int)this.vsh, (CharSequence)"varying vec2 texCoord;\n\nvoid main(void) {\n\tgl_Position = ftransform();\n\ttexCoord = gl_MultiTexCoord0.xy;\n}");
            GL20.glCompileShader((int)this.vsh);
            this.fsh = GL20.glCreateShader((int)35632);
            GL20.glShaderSource((int)this.fsh, (CharSequence)"uniform sampler2D mandelbrot;\n\nvarying vec2 texCoord;\n\nvoid main(void) {\n\tgl_FragColor = texture2D(mandelbrot, texCoord);}");
            GL20.glCompileShader((int)this.fsh);
            this.program = GL20.glCreateProgram();
            GL20.glAttachShader((int)this.program, (int)this.vsh);
            GL20.glAttachShader((int)this.program, (int)this.fsh);
            GL20.glLinkProgram((int)this.program);
            GL20.glUseProgram((int)this.program);
            GL20.glUniform1i((int)GL20.glGetUniformLocation((int)this.program, (CharSequence)"mandelbrot"), (int)0);
        }
        System.out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildPrograms() {
        int i;
        if (this.programs[0] != null) {
            for (CLProgram program : this.programs) {
                CL10.clReleaseProgram((CLProgram)program);
            }
        }
        try {
            this.createPrograms();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (i = 0; i < this.programs.length; ++i) {
            CLDevice device = this.queues[i].getCLDevice();
            StringBuilder options = new StringBuilder(this.useTextures ? "-D USE_TEXTURE" : "");
            CLDeviceCapabilities caps = CLCapabilities.getDeviceCapabilities((CLDevice)device);
            if (this.doublePrecision && DemoFractal.isDoubleFPAvailable(device)) {
                options.append(" -D DOUBLE_FP");
                if (!caps.CL_KHR_fp64 && caps.CL_AMD_fp64) {
                    options.append(" -D AMD_FP");
                }
            }
            System.out.println("\nOpenCL COMPILER OPTIONS: " + options);
            try {
                CL10.clBuildProgram((CLProgram)this.programs[i], (CLDevice)device, (CharSequence)options, null);
                continue;
            }
            finally {
                System.out.println("BUILD LOG: " + this.programs[i].getBuildInfoString(device, 4483));
            }
        }
        this.rebuild = false;
        for (i = 0; i < this.kernels.length; ++i) {
            this.kernels[i] = CL10.clCreateKernel((CLProgram)this.programs[Math.min(i, this.programs.length)], (CharSequence)"mandelbrot", null);
        }
    }

    private void initGLObjects() {
        if (this.glBuffers == null) {
            this.glBuffers = new CLMem[this.slices];
            this.glIDs = BufferUtils.createIntBuffer((int)this.slices);
        } else {
            for (CLMem mem : this.glBuffers) {
                CL10.clReleaseMemObject((CLMem)mem);
            }
            if (this.useTextures) {
                GL11.glDeleteTextures((IntBuffer)this.glIDs);
            } else {
                GL15.glDeleteBuffers((IntBuffer)this.glIDs);
            }
        }
        if (this.useTextures) {
            GL11.glGenTextures((IntBuffer)this.glIDs);
            for (int i = 0; i < this.slices; ++i) {
                GL11.glBindTexture((int)3553, (int)this.glIDs.get(i));
                GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)(this.width / this.slices), (int)this.height, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                this.glBuffers[i] = CL10GL.clCreateFromGLTexture2D((CLContext)this.clContext, (long)2L, (int)3553, (int)0, (int)this.glIDs.get(i), null);
            }
            GL11.glBindTexture((int)3553, (int)0);
        } else {
            GL15.glGenBuffers((IntBuffer)this.glIDs);
            for (int i = 0; i < this.slices; ++i) {
                GL15.glBindBuffer((int)35052, (int)this.glIDs.get(i));
                GL15.glBufferData((int)35052, (long)(this.width * this.height * 4 / this.slices), (int)35040);
                this.glBuffers[i] = CL10GL.clCreateFromGLBuffer((CLContext)this.clContext, (long)2L, (int)this.glIDs.get(i), null);
            }
            GL15.glBindBuffer((int)35052, (int)0);
        }
        this.buffersInitialized = true;
    }

    private void setKernelConstants() {
        for (int i = 0; i < this.slices; ++i) {
            this.kernels[i].setArg(6, (CLObject)this.glBuffers[i]).setArg(7, (CLObject)this.colorMap[i]).setArg(8, 256).setArg(9, this.maxIterations);
        }
    }

    private void run() {
        long startTime = System.currentTimeMillis() + 5000L;
        long fps = 0L;
        while (this.run) {
            if (!Display.isVisible()) {
                Thread.yield();
            }
            this.handleIO();
            this.display();
            Display.update();
            if (Display.isCloseRequested()) break;
            if (startTime > System.currentTimeMillis()) {
                ++fps;
                continue;
            }
            long timeUsed = 5000L + (startTime - System.currentTimeMillis());
            startTime = System.currentTimeMillis() + 5000L;
            System.out.println(fps + " frames in 5 seconds = " + (float)fps / ((float)timeUsed / 1000.0f));
            fps = 0L;
        }
        CL10.clReleaseContext((CLContext)this.clContext);
        if (this.useTextures) {
            GL20.glDeleteProgram((int)this.program);
            GL20.glDeleteShader((int)this.fsh);
            GL20.glDeleteShader((int)this.vsh);
            GL11.glDeleteLists((int)this.dlist, (int)1);
        }
        CL.destroy();
        Display.destroy();
    }

    public void display() {
        if (this.syncCLtoGL && this.glEvent != null) {
            for (CLCommandQueue queue : this.queues) {
                CL10.clEnqueueWaitForEvents((CLCommandQueue)queue, (CLEvent)this.glEvent);
            }
        } else {
            GL11.glFinish();
        }
        if (!this.buffersInitialized) {
            this.initGLObjects();
            this.setKernelConstants();
        }
        if (this.rebuild) {
            this.buildPrograms();
            this.setKernelConstants();
        }
        this.compute(this.doublePrecision);
        this.render();
    }

    private void compute(boolean is64bit) {
        int i;
        int sliceWidth = (int)((float)this.width / (float)this.slices);
        double rangeX = (this.maxX - this.minX) / (double)this.slices;
        double rangeY = this.maxY - this.minY;
        this.kernel2DGlobalWorkSize.put(0, (long)sliceWidth).put(1, (long)this.height);
        for (i = 0; i < this.slices; ++i) {
            this.kernels[i].setArg(0, sliceWidth).setArg(1, this.height);
            if (!is64bit || !DemoFractal.isDoubleFPAvailable(this.queues[i].getCLDevice())) {
                this.kernels[i].setArg(2, (float)(this.minX + rangeX * (double)i)).setArg(3, (float)this.minY).setArg(4, (float)rangeX).setArg(5, (float)rangeY);
            } else {
                this.kernels[i].setArg(2, this.minX + rangeX * (double)i).setArg(3, this.minY).setArg(4, rangeX).setArg(5, rangeY);
            }
            CL10GL.clEnqueueAcquireGLObjects((CLCommandQueue)this.queues[i], (CLMem)this.glBuffers[i], null, null);
            CL10.clEnqueueNDRangeKernel((CLCommandQueue)this.queues[i], (CLKernel)this.kernels[i], (int)2, null, (PointerBuffer)this.kernel2DGlobalWorkSize, null, null, null);
            CL10GL.clEnqueueReleaseGLObjects((CLCommandQueue)this.queues[i], (CLMem)this.glBuffers[i], null, (PointerBuffer)(this.syncGLtoCL ? this.syncBuffer : null));
            if (!this.syncGLtoCL) continue;
            this.clEvents[i] = this.queues[i].getCLEvent(this.syncBuffer.get(0));
            this.clSyncs[i] = ARBCLEvent.glCreateSyncFromCLeventARB((CLContext)((CLContext)this.queues[i].getParent()), (CLEvent)this.clEvents[i], (int)0);
        }
        if (!this.syncGLtoCL) {
            for (i = 0; i < this.slices; ++i) {
                CL10.clFinish((CLCommandQueue)this.queues[i]);
            }
        }
    }

    private void render() {
        GL11.glClear((int)16384);
        if (this.syncGLtoCL) {
            for (int i = 0; i < this.slices; ++i) {
                ARBSync.glWaitSync((GLSync)this.clSyncs[i], (int)0, (long)0L);
            }
        }
        int sliceWidth = this.width / this.slices;
        if (this.useTextures) {
            for (int i = 0; i < this.slices; ++i) {
                int seperatorOffset = this.drawSeparator ? i : 0;
                GL11.glBindTexture((int)3553, (int)this.glIDs.get(i));
                GL11.glCallList((int)this.dlist);
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int seperatorOffset = this.drawSeparator ? i : 0;
                GL15.glBindBuffer((int)35052, (int)this.glIDs.get(i));
                GL11.glRasterPos2i((int)(sliceWidth * i + seperatorOffset), (int)0);
                GL11.glDrawPixels((int)sliceWidth, (int)this.height, (int)6408, (int)5121, (long)0L);
            }
            GL15.glBindBuffer((int)35052, (int)0);
        }
        if (this.syncCLtoGL) {
            this.glSync = ARBSync.glFenceSync((int)37143, (int)0);
            this.glEvent = KHRGLEvent.clCreateEventFromGLsyncKHR((CLContext)this.clContext, (GLSync)this.glSync, null);
        }
    }

    private void handleIO() {
        if (Keyboard.getNumKeyboardEvents() != 0) {
            while (Keyboard.next()) {
                if (Keyboard.getEventKeyState()) continue;
                int key = Keyboard.getEventKey();
                if (2 <= key && key <= 9) {
                    int number = key - 2 + 1;
                    this.slices = Math.min(number, Math.min(this.queues.length, 8));
                    System.out.println("NEW PARALLELISM LEVEL: " + this.slices);
                    this.buffersInitialized = false;
                    continue;
                }
                switch (Keyboard.getEventKey()) {
                    case 57: {
                        this.drawSeparator = !this.drawSeparator;
                        System.out.println("SEPARATOR DRAWING IS NOW: " + (this.drawSeparator ? "ON" : "OFF"));
                        break;
                    }
                    case 32: {
                        this.doublePrecision = !this.doublePrecision;
                        System.out.println("DOUBLE PRECISION IS NOW: " + (this.doublePrecision ? "ON" : "OFF"));
                        this.rebuild = true;
                        break;
                    }
                    case 199: {
                        this.minX = -2.0;
                        this.minY = -1.2f;
                        this.maxX = 0.6f;
                        this.maxY = 1.3f;
                        break;
                    }
                    case 1: {
                        this.run = false;
                    }
                }
            }
        }
        while (Mouse.next()) {
            int eventBtn = Mouse.getEventButton();
            int x = Mouse.getX();
            int y = Mouse.getY();
            if (Mouse.isButtonDown((int)0) && (x != this.mouseX || y != this.mouseY)) {
                if (!this.dragging) {
                    this.dragging = true;
                    this.dragX = this.mouseX;
                    this.dragY = this.mouseY;
                    this.dragMinX = this.minX;
                    this.dragMinY = this.minY;
                    this.dragMaxX = this.maxX;
                    this.dragMaxY = this.maxY;
                }
                double offsetX = ((double)x - this.dragX) * (this.maxX - this.minX) / (double)this.width;
                double offsetY = ((double)y - this.dragY) * (this.maxY - this.minY) / (double)this.height;
                this.minX = this.dragMinX - offsetX;
                this.minY = this.dragMinY - offsetY;
                this.maxX = this.dragMaxX - offsetX;
                this.maxY = this.dragMaxY - offsetY;
            } else {
                int dwheel;
                if (this.dragging) {
                    this.dragging = false;
                }
                if (eventBtn == -1 && (dwheel = Mouse.getEventDWheel()) != 0) {
                    double scaleFactor = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157) ? 0.25 : 0.05;
                    double scale = dwheel > 0 ? scaleFactor : -scaleFactor;
                    double deltaX = scale * (this.maxX - this.minX);
                    double deltaY = scale * (this.maxY - this.minY);
                    double offsetX = ((double)x / (double)this.width - 0.5) * deltaX * 2.0;
                    double offsetY = ((double)y / (double)this.height - 0.5) * deltaY * 2.0;
                    this.minX += deltaX + offsetX;
                    this.minY += deltaY - offsetY;
                    this.maxX += -deltaX + offsetX;
                    this.maxY += -deltaY - offsetY;
                }
            }
            this.mouseX = x;
            this.mouseY = y;
        }
    }

    private static boolean isDoubleFPAvailable(CLDevice device) {
        CLDeviceCapabilities caps = CLCapabilities.getDeviceCapabilities((CLDevice)device);
        return caps.CL_KHR_fp64 || caps.CL_AMD_fp64;
    }

    private void createPrograms() throws IOException {
        String source = this.getProgramSource("org/lwjgl/test/opencl/gl/Mandelbrot.cl");
        for (int i = 0; i < this.programs.length; ++i) {
            this.programs[i] = CL10.clCreateProgramWithSource((CLContext)this.clContext, (CharSequence)source, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProgramSource(String file) throws IOException {
        InputStream source = null;
        URL sourceURL = Thread.currentThread().getContextClassLoader().getResource(file);
        if (sourceURL != null) {
            source = sourceURL.openStream();
        }
        if (source == null) {
            source = new FileInputStream("src/java/" + file);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(source));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        finally {
            source.close();
        }
        return sb.toString();
    }

    private static void initColorMap(IntBuffer colorMap, int stepSize, ReadableColor ... colors) {
        for (int n = 0; n < colors.length - 1; ++n) {
            ReadableColor color = colors[n];
            int r0 = color.getRed();
            int g0 = color.getGreen();
            int b0 = color.getBlue();
            color = colors[n + 1];
            int r1 = color.getRed();
            int g1 = color.getGreen();
            int b1 = color.getBlue();
            int deltaR = r1 - r0;
            int deltaG = g1 - g0;
            int deltaB = b1 - b0;
            for (int step = 0; step < stepSize; ++step) {
                float alpha = (float)step / (float)(stepSize - 1);
                int r = (int)((float)r0 + alpha * (float)deltaR);
                int g = (int)((float)g0 + alpha * (float)deltaG);
                int b = (int)((float)b0 + alpha * (float)deltaB);
                colorMap.put(r << 0 | g << 8 | b << 16);
            }
        }
    }

    private static void initView(int width, int height) {
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)width, (double)0.0, (double)height, (double)0.0, (double)1.0);
    }
}

