/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class UTF8Reader
extends Reader {
    private final InputStream _in;
    private ByteBuffer _bb;
    private CharBuffer _cb;
    private CharsetDecoder _dc;
    private static final int REPLACEMENT = 65533;

    public UTF8Reader(InputStream in) {
        this._in = in;
    }

    @Override
    public int read() throws IOException {
        int end;
        int b = this._in.read();
        if (b < 0) {
            return b;
        }
        if ((b & 0x80) == 0) {
            return b;
        }
        if (this._bb == null) {
            this._bb = ByteBuffer.allocate(6);
            this._cb = CharBuffer.allocate(1);
            this._dc = Charset.forName("UTF-8").newDecoder();
        } else {
            ((Buffer)this._bb).clear();
            ((Buffer)this._cb).clear();
        }
        this._bb.put((byte)b);
        if ((b & 0xE0) == 192) {
            end = 1;
        } else if ((b & 0xF0) == 224) {
            end = 2;
        } else if ((b & 0xF8) == 240) {
            end = 3;
        } else if ((b & 0xFC) == 248) {
            end = 4;
        } else if ((b & 0xFE) == 252) {
            end = 5;
        } else {
            return 65533;
        }
        for (int i = 0; i < end; ++i) {
            b = this._in.read();
            if (b < 0) {
                return 65533;
            }
            if ((b & 0x80) == 0) {
                return 65533;
            }
            this._bb.put((byte)b);
        }
        this._dc.reset();
        ((Buffer)this._bb).flip();
        CoderResult result = this._dc.decode(this._bb, this._cb, true);
        ((Buffer)this._cb).flip();
        if (result.isError() || !this._cb.hasRemaining()) {
            return 65533;
        }
        return this._cb.get() & 0xFFFF;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c < 0) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cbuf[off + i] = (char)c;
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this._in.close();
    }
}

