/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.artifacts.ResolveException;

public class TypedResolveException
extends ResolveException {
    private final String type;
    private final ImmutableList<String> resolutions;

    public TypedResolveException(String type, String displayName, Iterable<? extends Throwable> failures) {
        this(type, displayName, failures, (List<String>)ImmutableList.of());
    }

    public TypedResolveException(String type, String displayName, Iterable<? extends Throwable> failures, List<String> resolutions) {
        super(TypedResolveException.buildMessage(type, displayName), failures, false);
        this.type = type;
        this.resolutions = ImmutableList.copyOf(resolutions);
    }

    public String getType() {
        return this.type;
    }

    public List<String> getResolutions() {
        return ImmutableList.builder().addAll(this.resolutions).addAll((Iterable)super.getResolutions()).build();
    }

    private static String buildMessage(String type, String displayName) {
        return String.format("Could not resolve all %s for %s.", type, displayName);
    }
}

