/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.impl.CSSUtil;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.parser.AbstractCondition;
import io.sf.carte.doc.style.css.parser.AbstractNamedCondition;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.LangConditionImpl;
import io.sf.carte.doc.style.css.parser.PositionalConditionImpl;
import io.sf.carte.doc.style.css.parser.PseudoConditionImpl;
import io.sf.carte.doc.style.css.parser.SelectorArgumentConditionImpl;
import io.sf.carte.doc.style.css.parser.SelectorArgumentPEConditionImpl;
import io.sf.carte.doc.style.css.parser.SelectorListImpl;
import io.sf.carte.uparser.TokenProducer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;

class ConditionSetterFactory {
    private static final HashMap<String, ConditionSetter> pcSetters = ConditionSetterFactory.createPseudoClassSetterMap();
    private static final HashMap<String, ConditionSetter> peSetters = ConditionSetterFactory.createPseudoElementSetterMap();
    private static final ConditionSetter pseudoClassSetter = new PseudoClassConditionSetter();
    private static final ConditionSetter pseudoElementSetter = new PseudoElementConditionSetter();
    private static final ConditionSetterFactory instance = new ConditionSetterFactory();

    private ConditionSetterFactory() {
    }

    private static HashMap<String, ConditionSetter> createPseudoClassSetterMap() {
        HashMap<String, ConditionSetter> setters = new HashMap<String, ConditionSetter>(23);
        setters.put("lang", new LangConditionSetter());
        setters.put("first-child", new FirstChildConditionSetter());
        setters.put("last-child", new LastChildConditionSetter());
        setters.put("nth-child", new NthChildConditionSetter());
        setters.put("nth-last-child", new NthLastChildConditionSetter());
        setters.put("first-of-type", new FirstOfTypeConditionSetter());
        setters.put("last-of-type", new LastOfTypeConditionSetter());
        setters.put("nth-of-type", new NthOfTypeConditionSetter());
        setters.put("nth-last-of-type", new NthLastOfTypeConditionSetter());
        setters.put("only-child", new OnlyChildConditionSetter());
        setters.put("only-of-type", new OnlyOfTypeConditionSetter());
        setters.put("not", new SelectorArgumentConditionSetter());
        setters.put("is", new SelectorArgumentConditionSetter());
        setters.put("where", new SelectorArgumentConditionSetter());
        setters.put("host-context", new SelectorArgumentConditionSetter());
        setters.put("has", new HasConditionSetter());
        setters.put("host", new MaybeSelectorArgumentConditionSetter());
        setters.put("dir", new ArgumentPseudoClassConditionSetter());
        ConditionSetterFactory.setLegacyPseudoElementSetters(setters);
        return setters;
    }

    private static HashMap<String, ConditionSetter> createPseudoElementSetterMap() {
        HashMap<String, ConditionSetter> setters = new HashMap<String, ConditionSetter>(8);
        setters.put("slotted", new SelectorArgumentPEConditionSetter());
        setters.put("highlight", new ArgumentPseudoElementConditionSetter());
        setters.put("picker", new ArgumentPseudoElementConditionSetter());
        ConditionSetterFactory.setLegacyPseudoElementSetters(setters);
        return setters;
    }

    private static void setLegacyPseudoElementSetters(Map<String, ConditionSetter> setters) {
        setters.put("first-line", new NoArgumentPseudoElementConditionSetter());
        setters.put("first-letter", new NoArgumentPseudoElementConditionSetter());
        setters.put("before", new NoArgumentPseudoElementConditionSetter());
        setters.put("after", new NoArgumentPseudoElementConditionSetter());
    }

    static ConditionSetterFactory getInstance() {
        return instance;
    }

    ConditionSetter getPseudoClassSetter(String name) {
        ConditionSetter setter = pcSetters.get(name);
        if (setter == null) {
            setter = pseudoClassSetter;
        }
        return setter;
    }

    ConditionSetter getPseudoElementSetter(String name) {
        ConditionSetter setter = peSetters.get(name);
        if (setter == null) {
            setter = pseudoElementSetter;
        }
        return setter;
    }

    private static boolean parsePositionalArgument(PositionalConditionImpl cond, String expression, CSSParser.SelectorTokenHandler handler) {
        CSSParser.SelectorTokenHandler.MyAnBExpression expr = handler.new CSSParser.SelectorTokenHandler.MyAnBExpression();
        try {
            expr.parse(expression);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        cond.offset = expr.getOffset();
        cond.slope = expr.getStep();
        cond.ofList = expr.getSelectorList();
        cond.hasKeyword = expr.isKeyword();
        return true;
    }

    private static void pseudoMustHaveArgumentError(int index, String name, int triggerCp, CSSParser.SelectorTokenHandler handler) {
        StringBuilder buf = new StringBuilder(name.length() * 2 + 26);
        buf.append("Expected ':").append(name).append("(', found ':").append(name).appendCodePoint(triggerCp).append('\'');
        handler.handleError(index, (byte)4, buf.toString());
    }

    private static SelectorListImpl parseSelectorArgument(CSSParser.SelectorTokenHandler handler) throws CSSParseException {
        String seltext = handler.rawBuffer();
        CSSParser.SelectorTokenHandler selectorTokenHandler = handler;
        Objects.requireNonNull(selectorTokenHandler);
        CSSParser.SelectorTokenHandler.SelectorArgumentManager manager = selectorTokenHandler.new CSSParser.SelectorTokenHandler.SelectorArgumentManager(handler.factory);
        TokenProducer tp = manager.createTokenProducer();
        tp.parse(seltext);
        return manager.getTrimmedSelectorList();
    }

    private static class LangConditionSetter
    extends PseudoConditionSetter {
        private LangConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            return new LangConditionImpl();
        }

        @Override
        public void setArgument(int index, Condition cond, CSSParser.SelectorTokenHandler handler) {
            if (handler.buffer.length() != 0) {
                int len;
                String s = handler.unescapeBuffer(index);
                if (s.charAt((len = s.length()) - 1) == ',') {
                    handler.handleError(index - 2, (byte)9, "Unexpected functional argument: " + s);
                } else {
                    ((LangConditionImpl)cond).lang = s;
                }
            } else {
                handler.unexpectedCharError(index, 41);
            }
        }
    }

    private static class FirstChildConditionSetter
    extends NoArgumentConditionSetter {
        private FirstChildConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            if (this.checkLeftParen(index, triggerCp, handler)) {
                return null;
            }
            return new PositionalConditionImpl(false);
        }
    }

    private static class LastChildConditionSetter
    extends NoArgumentConditionSetter {
        private LastChildConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            if (this.checkLeftParen(index, triggerCp, handler)) {
                return null;
            }
            PositionalConditionImpl condition = new PositionalConditionImpl(false);
            condition.offset = 1;
            condition.forwardCondition = false;
            return condition;
        }
    }

    private static class NthChildConditionSetter
    extends PositionalArgumentConditionSetter {
        private NthChildConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            return new PositionalConditionImpl(true);
        }
    }

    private static class NthLastChildConditionSetter
    extends PositionalArgumentConditionSetter {
        private NthLastChildConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            PositionalConditionImpl condition = new PositionalConditionImpl(true);
            condition.offset = 1;
            condition.forwardCondition = false;
            return condition;
        }
    }

    private static class FirstOfTypeConditionSetter
    extends NoArgumentConditionSetter {
        private FirstOfTypeConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            if (this.checkLeftParen(index, triggerCp, handler)) {
                return null;
            }
            PositionalConditionImpl condition = new PositionalConditionImpl(false);
            condition.oftype = true;
            condition.offset = 1;
            return condition;
        }
    }

    private static class LastOfTypeConditionSetter
    extends NoArgumentConditionSetter {
        private LastOfTypeConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            if (this.checkLeftParen(index, triggerCp, handler)) {
                return null;
            }
            PositionalConditionImpl condition = new PositionalConditionImpl(false);
            condition.oftype = true;
            condition.offset = 1;
            condition.forwardCondition = false;
            return condition;
        }
    }

    private static class NthOfTypeConditionSetter
    extends PositionalArgumentConditionSetter {
        private NthOfTypeConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            PositionalConditionImpl condition = new PositionalConditionImpl(true);
            condition.oftype = true;
            return condition;
        }
    }

    private static class NthLastOfTypeConditionSetter
    extends PositionalArgumentConditionSetter {
        private NthLastOfTypeConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            PositionalConditionImpl condition = new PositionalConditionImpl(true);
            condition.oftype = true;
            condition.forwardCondition = false;
            return condition;
        }
    }

    private static class OnlyChildConditionSetter
    extends NoArgumentConditionSetter {
        private OnlyChildConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            if (this.checkLeftParen(index, triggerCp, handler)) {
                return null;
            }
            return handler.factory.createAttributeCondition(Condition.ConditionType.ONLY_CHILD);
        }
    }

    private static class OnlyOfTypeConditionSetter
    extends NoArgumentConditionSetter {
        private OnlyOfTypeConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            if (this.checkLeftParen(index, triggerCp, handler)) {
                return null;
            }
            return handler.factory.createAttributeCondition(Condition.ConditionType.ONLY_TYPE);
        }
    }

    private static class SelectorArgumentConditionSetter
    implements ConditionSetter {
        private SelectorArgumentConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            if (triggerCp != 40) {
                ConditionSetterFactory.pseudoMustHaveArgumentError(index, name, triggerCp, handler);
                return null;
            }
            SelectorArgumentConditionImpl condition = new SelectorArgumentConditionImpl();
            condition.setName(name);
            return condition;
        }

        @Override
        public void setArgument(int index, Condition cond, CSSParser.SelectorTokenHandler handler) {
            SelectorArgumentConditionImpl argcond = (SelectorArgumentConditionImpl)cond;
            if (handler.buffer.length() != 0) {
                this.parseSelectorArgument(index, argcond, handler);
            } else {
                handler.unexpectedCharError(index, 41);
            }
        }

        void parseSelectorArgument(int index, SelectorArgumentConditionImpl argcond, CSSParser.SelectorTokenHandler handler) {
            try {
                argcond.arguments = ConditionSetterFactory.parseSelectorArgument(handler);
            }
            catch (CSSParseException e) {
                byte errCode = e.getClass() == CSSNamespaceParseException.class ? (byte)15 : 32;
                CSSParseException ex = handler.createException(index, errCode, e.getMessage());
                handler.handleError(ex);
                handler.stage = (byte)127;
            }
        }
    }

    private static class HasConditionSetter
    extends SelectorArgumentConditionSetter {
        private HasConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            if (handler.isInsideHas()) {
                handler.handleError(index, (byte)9, ":has() pseudo-classes cannot be nested.");
                return null;
            }
            AbstractCondition condition = super.create(index, triggerCp, name, handler);
            handler.hasHas = true;
            return condition;
        }

        @Override
        public void setArgument(int index, Condition cond, CSSParser.SelectorTokenHandler handler) {
            super.setArgument(index, cond, handler);
            handler.hasHas = false;
        }
    }

    private static class MaybeSelectorArgumentConditionSetter
    extends SelectorArgumentConditionSetter {
        private MaybeSelectorArgumentConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            AbstractNamedCondition condition = triggerCp == 40 ? new SelectorArgumentConditionImpl() : new PseudoConditionImpl(Condition.ConditionType.PSEUDO_CLASS);
            condition.setName(name);
            return condition;
        }

        @Override
        public void setArgument(int index, Condition cond, CSSParser.SelectorTokenHandler handler) {
            SelectorArgumentConditionImpl argcond = (SelectorArgumentConditionImpl)cond;
            if (handler.buffer.length() != 0) {
                this.parseSelectorArgument(index, argcond, handler);
            }
        }
    }

    private static class ArgumentPseudoClassConditionSetter
    extends PseudoConditionSetter {
        private ArgumentPseudoClassConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            PseudoConditionImpl cond;
            if (CSSUtil.isValidPseudoName(name)) {
                cond = new PseudoConditionImpl(Condition.ConditionType.PSEUDO_CLASS);
                cond.setName(name);
            } else {
                handler.handleError(index - name.length(), (byte)7, "Invalid pseudo-class: " + name);
                cond = null;
            }
            return cond;
        }

        @Override
        public void setArgument(int index, Condition cond, CSSParser.SelectorTokenHandler handler) {
            if (handler.buffer.length() != 0) {
                this.setNameArgument(index, (PseudoConditionImpl)cond, handler);
            } else {
                handler.handleError(index, (byte)4, "Pseudo-class " + ((PseudoConditionImpl)cond).getName() + " requires an argument.");
            }
        }
    }

    private static class SelectorArgumentPEConditionSetter
    extends SelectorArgumentConditionSetter {
        private SelectorArgumentPEConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            if (triggerCp != 40) {
                ConditionSetterFactory.pseudoMustHaveArgumentError(index, ':' + name, triggerCp, handler);
                return null;
            }
            if (handler.isInsideHas()) {
                handler.handleError(index, (byte)4, "For security reasons, pseudo-elements aren't allowed inside a has().");
            }
            SelectorArgumentPEConditionImpl condition = new SelectorArgumentPEConditionImpl();
            condition.setName(name);
            return condition;
        }
    }

    private static class ArgumentPseudoElementConditionSetter
    extends PseudoConditionSetter {
        private ArgumentPseudoElementConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            PseudoConditionImpl cond = null;
            if (!CSSUtil.isValidPseudoName(name)) {
                handler.handleError(index - name.length(), (byte)7, "Invalid pseudo-element: " + name);
            } else if (handler.isInsideHas()) {
                handler.handleError(index, (byte)4, "For security reasons, pseudo-elements aren't allowed inside a has().");
            } else {
                cond = new PseudoConditionImpl(Condition.ConditionType.PSEUDO_ELEMENT);
                cond.setName(name);
            }
            return cond;
        }

        @Override
        public void setArgument(int index, Condition cond, CSSParser.SelectorTokenHandler handler) {
            if (handler.buffer.length() != 0) {
                this.setNameArgument(index, (PseudoConditionImpl)cond, handler);
            } else {
                handler.handleError(index, (byte)4, "Pseudo-element " + ((PseudoConditionImpl)cond).getName() + " requires an argument.");
            }
        }
    }

    private static class NoArgumentPseudoElementConditionSetter
    extends NoArgumentConditionSetter {
        private NoArgumentPseudoElementConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            PseudoConditionImpl cond = null;
            if (!this.checkLeftParen(index, triggerCp, handler)) {
                if (handler.isInsideHas()) {
                    handler.handleError(index, (byte)4, "For security reasons, pseudo-elements aren't allowed inside a has().");
                } else {
                    cond = new PseudoConditionImpl(Condition.ConditionType.PSEUDO_ELEMENT);
                    cond.setName(name);
                }
            }
            return cond;
        }
    }

    static interface ConditionSetter {
        public AbstractCondition create(int var1, int var2, String var3, CSSParser.SelectorTokenHandler var4);

        public void setArgument(int var1, Condition var2, CSSParser.SelectorTokenHandler var3);
    }

    private static class PseudoClassConditionSetter
    extends PseudoConditionSetter {
        private PseudoClassConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            PseudoConditionImpl cond;
            if (CSSUtil.isValidPseudoName(name)) {
                cond = new PseudoConditionImpl(Condition.ConditionType.PSEUDO_CLASS);
                cond.setName(name);
            } else {
                handler.handleError(index - name.length(), (byte)7, "Invalid pseudo-class: " + name);
                cond = null;
            }
            return cond;
        }
    }

    private static class PseudoElementConditionSetter
    extends PseudoConditionSetter {
        private PseudoElementConditionSetter() {
        }

        @Override
        public AbstractCondition create(int index, int triggerCp, String name, CSSParser.SelectorTokenHandler handler) {
            PseudoConditionImpl cond = null;
            if (!CSSUtil.isValidPseudoName(name)) {
                handler.handleError(index - name.length(), (byte)7, "Invalid pseudo-element: " + name);
            } else if (handler.isInsideHas()) {
                handler.handleError(index, (byte)4, "For security reasons, pseudo-elements aren't allowed inside a has().");
            } else {
                cond = new PseudoConditionImpl(Condition.ConditionType.PSEUDO_ELEMENT);
                cond.setName(name);
            }
            return cond;
        }
    }

    private static abstract class PositionalArgumentConditionSetter
    implements ConditionSetter {
        private PositionalArgumentConditionSetter() {
        }

        @Override
        public void setArgument(int index, Condition cond, CSSParser.SelectorTokenHandler handler) {
            if (handler.buffer.length() != 0) {
                String arg = handler.rawBuffer();
                if (!ConditionSetterFactory.parsePositionalArgument((PositionalConditionImpl)cond, arg, handler)) {
                    handler.handleError(index, (byte)32, "Wrong subexpression: " + arg);
                }
            } else {
                handler.unexpectedCharError(index, 41);
            }
        }
    }

    private static abstract class PseudoConditionSetter
    implements ConditionSetter {
        private PseudoConditionSetter() {
        }

        @Override
        public void setArgument(int index, Condition cond, CSSParser.SelectorTokenHandler handler) {
            if (handler.buffer.length() != 0) {
                this.setNameArgument(index, (PseudoConditionImpl)cond, handler);
            } else {
                handler.handleError(index, (byte)4, "Pseudo-class " + ((PseudoConditionImpl)cond).getName() + " requires an argument.");
            }
        }

        void setNameArgument(int index, PseudoConditionImpl cond, CSSParser.SelectorTokenHandler handler) {
            String s = handler.unescapeBuffer(index);
            if (!this.isValidPseudoArg(s, cond)) {
                handler.handleWarning(index - s.length() - 1, (byte)9, "Unexpected functional argument: " + s);
            }
            cond.argument = s;
        }

        private boolean isValidPseudoArg(String s, PseudoConditionImpl cond) {
            char c;
            if (!CSSUtil.isValidPseudoName(s) && (c = s.charAt(0)) != '\"' && c != '\'' && cond.name.charAt(0) != '-') {
                if (s.indexOf(32) >= 0) {
                    StringTokenizer st = new StringTokenizer(s, " ");
                    while (st.hasMoreElements()) {
                        String ident = st.nextToken();
                        if (CSSUtil.isValidPseudoName(ident)) continue;
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
    }

    private static abstract class NoArgumentConditionSetter
    implements ConditionSetter {
        private NoArgumentConditionSetter() {
        }

        @Override
        public void setArgument(int index, Condition cond, CSSParser.SelectorTokenHandler handler) {
            if (handler.buffer.length() != 0) {
                handler.handleError(index - 2, (byte)9, "Unexpected functional argument: " + handler.buffer);
            }
        }

        boolean checkLeftParen(int index, int triggerCp, CSSParser.SelectorTokenHandler handler) {
            if (triggerCp == 40) {
                handler.handleError(index, (byte)4, "Pseudo-class cannot have argument");
                return true;
            }
            return false;
        }
    }
}

