/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.util.StringUtils;

public class ConstructionPanel
extends MigPanel
implements PropertyChangeListener {
    public static final String EVENT = Colony.ColonyChangeEvent.BUILD_QUEUE_CHANGE.toString();
    private final FreeColClient freeColClient;
    private final boolean openBuildQueue;
    private Colony colony;
    private StringTemplate defaultLabel = StringTemplate.key("constructionPanel.clickToBuild");

    public ConstructionPanel(FreeColClient freeColClient, Colony colony, boolean openBuildQueue) {
        super("ConstructionPanelUI", new MigLayout("fill, ins 0 0 0 0, gapy 0, wrap 2", "push[]10[center]push", "[center]"));
        this.freeColClient = freeColClient;
        this.colony = colony;
        this.openBuildQueue = openBuildQueue;
        this.setOpaque(false);
    }

    public void initialize() {
        if (this.colony != null) {
            this.colony.addPropertyChangeListener(EVENT, this);
            if (this.openBuildQueue) {
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        ConstructionPanel.this.freeColClient.getGUI().showBuildQueuePanel(ConstructionPanel.this.colony);
                    }
                });
            }
        }
        this.update();
    }

    public void cleanup() {
        if (this.colony != null) {
            this.colony.removePropertyChangeListener(EVENT, this);
        }
        for (MouseListener listener : this.getMouseListeners()) {
            this.removeMouseListener(listener);
        }
    }

    public void update() {
        this.update(this.colony == null ? null : this.colony.getCurrentlyBuilding());
    }

    public void update(BuildableType buildable) {
        this.removeAll();
        ImageLibrary lib = this.freeColClient.getGUI().getFixedImageLibrary();
        Font font = FontLibrary.getScaledFont("normal-plain-smaller", null);
        Font fontTitle = FontLibrary.getScaledFont("normal-plain-smaller", null);
        int maxFontSize = lib.scaleInt(17);
        if (font.getSize() > maxFontSize) {
            font = font.deriveFont((float)maxFontSize);
            fontTitle = fontTitle.deriveFont((float)maxFontSize);
        }
        if (buildable == null) {
            String clickToBuild = Messages.message(this.getDefaultLabel());
            int breakingPoint = StringUtils.getBreakingPoint(clickToBuild);
            if (breakingPoint > 0) {
                JLabel label0 = new JLabel(clickToBuild.substring(0, breakingPoint));
                label0.setFont(font);
                label0.setForeground(this.getForeground());
                this.add((Component)label0, "span, align center bottom");
                JLabel label1 = new JLabel(clickToBuild.substring(breakingPoint + 1));
                label1.setFont(font);
                label1.setForeground(this.getForeground());
                this.add((Component)label1, "span, align center top");
            } else {
                JLabel label = new JLabel(clickToBuild);
                label.setFont(font);
                label.setForeground(this.getForeground());
                this.add((Component)label, "span, align center");
            }
        } else {
            JPanel infoPanel = new JPanel(new MigLayout("wrap 1", "[center]"));
            infoPanel.setOpaque(false);
            BufferedImage image = lib.getSmallBuildableTypeImageWithWithSize(buildable, this.colony.getOwner(), new Dimension(lib.scaleInt(100), lib.scaleInt(96)));
            this.add((Component)new JLabel(new ImageIcon(image)), "spany");
            JLabel label0 = Utility.localizedLabel(buildable.getCurrentlyBuildingLabel());
            label0.setFont(fontTitle);
            label0.setForeground(this.getForeground());
            infoPanel.add(label0);
            for (AbstractGoods ag : buildable.getRequiredGoodsList()) {
                int amountNeeded = ag.getAmount();
                int amountAvailable = this.colony.getGoodsCount(ag.getType());
                int amountProduced = this.colony.getAdjustedNetProductionOf(ag.getType());
                infoPanel.add((Component)new FreeColProgressBar(this.freeColClient, ag.getType(), 0, amountNeeded, amountAvailable, amountProduced), "height 20:");
            }
            this.add(infoPanel);
        }
        this.revalidate();
        this.repaint();
    }

    private final StringTemplate getDefaultLabel() {
        return this.defaultLabel;
    }

    public final void setDefaultLabel(StringTemplate newDefaultLabel) {
        this.defaultLabel = newDefaultLabel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.update();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        g.setColor(new Color(0, 0, 0, 128));
        Dimension size = this.getSize();
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(oldColor);
    }
}

