untrusted comment: signature from openbsd 6.2 base secret key
RWRVWzAMgtyg7uoJN66uSPzSo7/oW0agmOqxK1GIwZsOorXnYm/WtOCWbMvFR7DeHs3+H972U5g93/cFpI77xq7tIIgkKqiQegg=

OpenBSD 6.2 errata 014, May 17, 2018:

After forwarding a malicious IPv6 packet and encrypting it with
IPsec, it could crash the kernel.

Apply by doing:
    signify -Vep /etc/signify/openbsd-62-base.pub -x 014_ipsecout.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet/ipsec_output.c
===================================================================
RCS file: /cvs/src/sys/netinet/ipsec_output.c,v
retrieving revision 1.68
diff -u -p -r1.68 ipsec_output.c
--- sys/netinet/ipsec_output.c	18 May 2017 10:56:45 -0000	1.68
+++ sys/netinet/ipsec_output.c	14 May 2018 16:26:35 -0000
@@ -321,7 +321,10 @@ ipsp_process_packet(struct mbuf *m, stru
 					 */
 					dstopt = 2;
 				}
-
+				if (m->m_pkthdr.len < hlen + sizeof(ip6e)) {
+					m_freem(m);
+					return EINVAL;
+				}
 				/* skip this header */
 				m_copydata(m, hlen, sizeof(ip6e),
 				    (caddr_t)&ip6e);
@@ -340,6 +343,11 @@ ipsp_process_packet(struct mbuf *m, stru
 	exitip6loop:;
 		break;
 #endif /* INET6 */
+	}
+
+	if (m->m_pkthdr.len < hlen) {
+		m_freem(m);
+		return EINVAL;
 	}
 
 	/* Non expansion policy for IPCOMP */
